export function QuerySelector(selector?: string): Function {
    return querySelectorFunc.bind(this, selector);
}

export function RefSelector(ref?: string): Function {
    return querySelectorFunc.bind(this, '[ref='+ref+']');
}

function querySelectorFunc(selector: string, classPrototype: any, methodOrAttributeName: string, index: number) {

    if (selector===null) {
        console.error('ag-Grid: QuerySelector selector should not be null');
        return;
    }
    if (typeof index === 'number') {
        console.error('ag-Grid: QuerySelector should be on an attribute');
        return;
    }

    // it's an attribute on the class
    let props = getOrCreateProps(classPrototype, classPrototype.constructor.name);
    if (!props.querySelectors) {
        props.querySelectors = [];
    }
    props.querySelectors.push({
        attributeName: methodOrAttributeName,
        querySelector: selector
    });
}

export function Listener(eventName?: string): Function {
    return listenerFunc.bind(this, eventName);
}

function listenerFunc(eventName: string, target: Object, methodName: string, descriptor: TypedPropertyDescriptor<any>) {

    if (eventName===null) {
        console.error('ag-Grid: EventListener eventName should not be null');
        return;
    }

    // it's an attribute on the class
    let props = getOrCreateProps(target, (<any>target.constructor).name);
    if (!props.listenerMethods) {
        props.listenerMethods = [];
    }
    props.listenerMethods.push({
        methodName: methodName,
        eventName: eventName
    });
}

function getOrCreateProps(target: any, instanceName:string): any {
    if (!target.__agComponentMetaData) {
        target.__agComponentMetaData = {};
    }

    if (!target.__agComponentMetaData[instanceName]){
        target.__agComponentMetaData[instanceName]={}
    }

    return target.__agComponentMetaData[instanceName];
}