<?php
header("Content-Type: text/html;charset=utf-8");
include('is_logged.php');
date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}

require '../config/db.php';
require '../config/conexion.php';
include '../helper/helper_validacion.php';

$fecharegistro = date("Y-m-d H:i:s");
$usuarioreg = $_SESSION['usuariosesion'];
$id_usuario = $_SESSION['id_usuario'];

//VALIDAR
$cboEstado= htmlspecialchars($_POST['cboEstado']);
$selectrows = htmlspecialchars($_POST['selectrows']);

$arraySelect = explode (',', $selectrows); 


if($cboEstado=='NSP'){
    //  
}else{
    

    if(!empty($arraySelect)){
        $resultadoventa=0;
        
        foreach ($arraySelect as $key => $value) {
        
            $queryVenta = "UPDATE tblsolicitudesDetalle s SET s.Estado=?, s.FechaHoraModificacion=?, s.UsuarioModifica=?  WHERE s.IdDetalleSolicitud = ?";
            
            try{
                $stmt = $con->prepare($queryVenta);
                $stmt->bind_param('ssis', $cboEstado, $fecharegistro, $id_usuario, $value);
                $stmt->execute();
                $resultadoventa += $stmt->affected_rows;
                $stmt->close();
            } catch (\Exception $e) {
                $resultadoventa = 'error';
            }          
            
        }

        if($resultadoventa>0){
            die(json_encode(array('respuesta' => 'exito', 'id_registro' => '')));  
        }else{
            die(json_encode(array('respuesta' => 'error')));
        }
    
    }else{
        die(json_encode(array('respuesta' => 'error')));
    }

    
}
