<?php
include('is_logged.php');
date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}

require '../config/db.php';
require '../config/conexion.php';

//include_once '../config/dbsec.php';
//include_once '../config/conexionsec.php';

$gestor=htmlspecialchars($_POST['gestor']);
//AGREGAR FUNCIONES LOG
include 'log/insertLog.php';
include 'log/insertLogAgenda.php';
include 'log/insertLogAgendaVenta.php';
include 'Correo/correoNotificacionAgenda.php';

$estadoventa=htmlspecialchars($_POST['lblestadoventa']);

$ncontrato=htmlspecialchars($_POST['lblncontrato']);

$comentarioagenda=htmlspecialchars($_POST['lblcomentarioagenda']);

$fecharegistroagenda = date("Y-m-d H:i:s");

$fecharegistroventa = date("Y-m-d H:i:s");


$matriculacomercial=htmlspecialchars($_POST['matriculacomercial']);
$cccomercial=htmlspecialchars($_POST['cccomercial']);
$matriculajefe=htmlspecialchars($_POST['matriculajefe']);
$tcgestor=htmlspecialchars($_POST['tcgestor']);


$idventa=htmlspecialchars($_POST['lblidventa']);
$idagenda=htmlspecialchars($_POST['lblidagenda']);
$idcliente=htmlspecialchars($_POST['lblidcliente']);

if ($_POST['FechaGestion'] == ''){
    $FechaGestion = NULL;
} else {
    $FechaGestion=htmlspecialchars($_POST['FechaGestion']);
}

if ($_POST['FechaAgendamiento'] == ''){
    $FechaAgendamiento = NULL;
} else {
    $FechaAgendamiento=htmlspecialchars($_POST['FechaAgendamiento']);
}

if ($_POST['FechaInstalacion'] == ''){
    $FechaInstalacion = NULL;
} else {
    $FechaInstalacion=htmlspecialchars($_POST['FechaInstalacion']);
}

if ($_POST['lblIdAgenRepor'] == ''){
    $lblIdAgenRepor = NULL;
} else {
    $lblIdAgenRepor=htmlspecialchars($_POST['lblIdAgenRepor']);
}

if ($_POST['FechaCancelada'] == ''){
    $FechaCancelada = NULL;
} else {
    $FechaCancelada=htmlspecialchars($_POST['FechaCancelada']);
}

if ($_POST['FechaInviable'] == ''){
    $FechaInviable = NULL;
} else {
    $FechaInviable=htmlspecialchars($_POST['FechaInviable']);
}

if ($_POST['FechaIlocalizable'] == ''){
    $FechaIlocalizable = NULL;
} else {
    $FechaIlocalizable=htmlspecialchars($_POST['FechaIlocalizable']);
}

//ARRAY QUE TRAE LOS DATOS DE AGENDA DE LA TABLA VENTA
$resultadoAgendaVenta = consultaAgendaVenta($idventa);

if(isset($ncontrato) && $ncontrato <> $resultadoAgendaVenta['NContrato']){
   if(validarNContrato($ncontrato) > 0){
        die('2');
    }
}

    /* CONSULTA PREPARADA N09 */
    $sqlventa = "UPDATE dbVENTAS.tblventa v SET v.EstadoVenta=?,v.NContrato=? WHERE v.IdVenta=?";
    
    try{
        $stmt = $con->prepare($sqlventa);
        $stmt->bind_param('ssi', $estadoventa, $ncontrato, $idventa);
        $stmt->execute();
        $respuesta = $stmt->affected_rows;
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    /* CONSULTA PREPARADA N09 */
    $sqlclientecontrato = "UPDATE dbVENTAS.tblcliente c SET c.NCliente=? WHERE c.IdCliente=?";
    
    try{
        $stmt = $con->prepare($sqlclientecontrato);
        $stmt->bind_param('si', $ncontrato, $idcliente);
        $stmt->execute();
        $respuesta2 = $stmt->affected_rows;
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 'error';
    }


//VALIDA QUE SE ACTUALIZARON DATOS DE AGENDA EN LA TABLA VENTA
$affectedrowAgendaVenta = $respuesta;

//ARRAY DE DATOS DE LA TABLA AGENDA
$resultadoAgenda = consultaAgendaAttec($idventa);
//$sqlagenda=  mysqli_query($con, "UPDATE dbVENTAS.tblagenda agen SET agen.Comentario='".$comentarioagenda."', agen.GestorAgenda='".$gestor."',agen.EstadoVenta='".$estadoventa."',agen.NContrato='".$ncontrato."' WHERE agen.IdVenta='$idventa'");   
//CAMPO RETIRADO 
/*agen.FechaHoraMODIF='".$fecharegistroagenda."',*/
//VALIDA QUE SE ACTUALIZARON DATOS DE AGENDA EN LA TABLA AGENDA
$affectedrowAgenda = actualizarAgenda($idventa);


$sqlagendahist2="INSERT INTO dbVENTAS.tblagendahist(IdAgenda, IdVenta,Comentario, FechaHoraREG,GestorAgenda,EstadoVenta,NContrato) VALUES (?, ?, ?, ?, ?, ?, ?)";

    try{
        $stmt = $con->prepare($sqlagendahist2);
        $stmt->bind_param('iissssi', $idagenda,$idventa,$comentarioagenda,$fecharegistroagenda,$gestor,$estadoventa,$ncontrato);
        $stmt->execute();
        $sqlagendahist = $con->insert_id;
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = array(
            'respuesta' => 'error'
        );
    }    

if ($affectedrowAgendaVenta > 0 || $affectedrowAgenda > 0){

            $REMOTE_ADDR=htmlspecialchars($_SERVER['REMOTE_ADDR']);
            $usuariosesion=htmlspecialchars($_SESSION['usuariosesion']);
            $REQUEST_URI=htmlspecialchars($_SERVER['REQUEST_URI'].'=>IdVenta='.$idventa);
            $Acceso='Modificar';
            $HTTP_USER_AGENT=htmlspecialchars($_SERVER['HTTP_USER_AGENT']);
            
            try {
                    
              $stmt = $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
              $stmt->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fecharegistroagenda, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
              $stmt->execute();
              $idLogSeg = $con->insert_id;
              $stmt->close();
              
            } catch (\Exception $e) {
              echo $e->getMessage();
            }

    if($affectedrowAgendaVenta > 0){
        insertLogAgendaVenta($idLogSeg, $resultadoAgendaVenta);
    }
    if($affectedrowAgenda > 0){
        insertLogAgendaAttec($idLogSeg, $resultadoAgenda);
        if(isset($comentarioagenda) && $comentarioagenda <> $resultadoAgenda['Comentario']){
        enviarNotifiacionCorreo_test($idventa,$comentarioagenda,$cccomercial);
        } 
    }

echo 1;

} else {
    echo 0;
}

function validarNContrato($val){
    global $con;
    
	$row_cnt=0;
	try{
	    $sql = "SELECT 1 FROM tblcliente WHERE NCliente = ?";
        $stmt = $con->prepare($sql);
        $stmt->bind_param('s', $val);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($num);
        $row_cnt = $stmt->num_rows;
        $stmt->fetch();
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }    
    
    
    return $row_cnt;
    
}

function actualizarAgenda($idventa){
    
    global $con;
    
    global $comentarioagenda;

    global $gestor;
    global $ncontrato;
    global $estadoventa;
    
    global $FechaGestion;
    global $FechaAgendamiento;
    global $FechaInstalacion;
    global $lblIdAgenRepor;
    global $FechaCancelada;
    global $FechaInviable;
    global $FechaIlocalizable;    
 
    if($estadoventa=='AgendadaTEC'){
        if ($FechaAgendamiento == ''){
            $FechaAgendamiento=date("Y-m-d H:i:s");
        }else{
            $FechaAgendamiento=$FechaAgendamiento;
            
        }
        
    }    
    if($estadoventa=='Instalada'){
        if ($FechaInstalacion == ''){
            $FechaInstalacion=date("Y-m-d H:i:s");
        }else{
            $FechaInstalacion=$FechaInstalacion;
            
        }
        
    }
    if($estadoventa=='Cancelada'){
        if ($FechaCancelada == ''){
            $FechaCancelada=date("Y-m-d H:i:s");
        }else{
            $FechaCancelada=$FechaCancelada;
            
        }
    }    
  
    

    if($lblIdAgenRepor>0){
        $actualiaragendareporte=actualizarAgendaReporte($lblIdAgenRepor,$FechaInstalacion,$FechaCancelada);
    }    

    
    try{
        
        $stmt = $con->prepare("UPDATE dbVENTAS.tblagenda SET Comentario=?, GestorAgenda=?, EstadoVenta=?,NContrato=?,FechaGestion=?,FechaAgendamiento=?,FechaInstalacion=? WHERE IdVenta=?");
        $stmt->bind_param('sssssssi', $comentarioagenda, $gestor, $estadoventa,$ncontrato,$FechaGestion,$FechaAgendamiento,$FechaInstalacion, $idventa);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();
        
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}

function actualizarAgendaReporte($idagendarorte,$FechaInstalacion,$FechaCancelada){
    
    global $con;

    // global $FechaGestion;
    // global $FechaAgendamiento;
    // global $FechaInstalacion;
    // global $fechagrabar;
    // global $horagrabar;

    //     if ($fechagrabar == '' || empty($fechagrabar)){
    //         $FechaProgramacion = NULL;
    //     } else {
    //         $FechaProgramacion=$fechagrabar.' '.$horagrabar;
    //     }
    
    try{
        
        $stmt = $con->prepare("UPDATE dbVENTAS.tblagendareporte SET FechaInstalada= ?,FechaCancelada=? WHERE IdAgenRepor=?");
        $stmt->bind_param('ssi', $FechaInstalacion,$FechaCancelada, $idagendarorte);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}

