<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';

$q=NULL;

if (isset($_GET['q'])) {
    $q=htmlspecialchars($_GET['q']);
}

$sql = "SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) Instalador FROM dbUSUARIO.tblusuario u  
WHERE u.LN=33 and u.Estado='Activo' and u.Matricula LIKE ?"; 

$json = [];


    	try{     
    	    $q = "%{$q}%";
            $stmt = $con->prepare($sql);
            $stmt->bind_param('s', $q);
            $stmt->execute();
            $stmt->store_result();
            $stmt->bind_result($Matricula,$Instalador);
            
            if($stmt->num_rows > 0){
                while($stmt->fetch()){
                    $json[] = array_map("utf8_encode",['id' => $Matricula, 'text'=> $Matricula." - ".$Instalador]); //array_map("utf8_encode",$data)  este codigo nos ayuda a muestrar caracteres diferentes
                }
            }
    
        } catch(PDOException $e) {
            echo "Error: " . $e->getMessage();
        }
        
        echo json_encode($json);

        $stmt->close();