<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';
require_once '../helper/helper_validacion.php';

$arreglo = NULL;

$url = sanitizaCampo($_POST['URL'], 'sanitizeurl|scapestring|htmlspecialchars', $con);

$query = "select t.TarjetaMarca,count(*) as 'Total' from tblmdp m join tbltransaccion t on m.IdMdp = t.IdMdp WHERE CodigoMDP = ? group by t.TarjetaMarca";

    	try{       
            $stmt = $con->prepare($query);
            $stmt->bind_param('s', $url);
            $stmt->execute();
            $stmt->store_result();
            $stmt->bind_result($TarjetaMarca, $Total);
            
            if($stmt->num_rows > 0){
                while($stmt->fetch()){
                    $arreglo[]=array_map("utf8_encode",['Total' => $Total]); //array_map("utf8_encode",$data)  este codigo nos ayuda a muestrar caracteres diferentes
                    unset($data);   
                }
            }
    
        } catch(PDOException $e) {
            echo "Error: " . $e->getMessage();
        }
 echo json_encode($arreglo);
?>