<?php

    function consultaVenta($id){
        global $con;
        $arrayactual = null;

  try{
        $stmt = $con->prepare( "SELECT
        v.IdUsuario,
        v.IdCliente,
        v.Matricula,
        v.Comercial,
        v.CC,
        v.JefeVenta,
        v.CategoriaVenta,
        v.TipoVenta,
        v.Segmento,
        v.NProspecto,
        v.PrecioKit, 
        v.TotalExtra, 
        v.IngresoKIT,
        v.IngresoExtras, 
        v.IngresoTotal, 
        v.EstadoVenta, 
        v.ExtraAutorizado, 
        v.MesesAutorizado,
        v.N590, 
        v.FormaPago, 
        v.PAI, 
        v.ResumenVenta, 
        v.EstadoVisita, 
        v.PrecioKITOriginal,
        v.TotalExtraOriginal, 
        v.ExtraAutorizadoOriginal, 
        v.MesesAutorizadoOriginal, 
        v.FormaPagoOriginal,
        v.PAIOriginal, 
        v.ResumenVentaOriginal, 
        v.ContactadoCO, 
        v.VTAConfirmadaCO, 
        v.ComentarioCO
        FROM tblventa v
        WHERE v.IdVenta= ?");
        $stmt->bind_param('i', $id);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($IdUsuario,
$IdCliente,
$Matricula,
$Comercial,
$CC,
$JefeVenta,
$CategoriaVenta,
$TipoVenta,
$Segmento,
$NProspecto,
$PrecioKit,
$TotalExtra,
$IngresoKIT,
$IngresoExtras,
$IngresoTotal,
$EstadoVenta,
$ExtraAutorizado,
$MesesAutorizado,
$N590,
$FormaPago,
$PAI,
$ResumenVenta,
$EstadoVisita,
$PrecioKITOriginal,
$TotalExtraOriginal,
$ExtraAutorizadoOriginal,
$MesesAutorizadoOriginal,
$FormaPagoOriginal,
$PAIOriginal,
$ResumenVentaOriginal,
$ContactadoCO,
$VTAConfirmadaCO,
$ComentarioCO
);
        while ($stmt->fetch()){
            $arrayactual = array(
            'IdUsuario'=>$IdUsuario,
            'IdCliente'=>$IdCliente,
            'Matricula'=>$Matricula,
            'Comercial'=>$Comercial,
            'CC'=>$CC,
            'JefeVenta'=>$JefeVenta,
            'CategoriaVenta'=>$CategoriaVenta,
            'TipoVenta'=>$TipoVenta,
            'Segmento'=>$Segmento,
            'NProspecto'=>$NProspecto,
            'PrecioKit'=>$PrecioKit,
            'TotalExtra'=>$TotalExtra,
            'IngresoKIT'=>$IngresoKIT,
            'IngresoExtras'=>$IngresoExtras,
            'IngresoTotal'=>$IngresoTotal,
            'EstadoVenta'=>$EstadoVenta,
            'ExtraAutorizado'=>$ExtraAutorizado,
            'MesesAutorizado'=>$MesesAutorizado,
            'N590'=>$N590,
            'FormaPago'=>$FormaPago,
            'PAI'=>$PAI,
            'ResumenVenta'=>$ResumenVenta,
            'EstadoVisita'=>$EstadoVisita,
            'PrecioKITOriginal'=>$PrecioKITOriginal,
            'TotalExtraOriginal'=>$TotalExtraOriginal,
            'ExtraAutorizadoOriginal'=>$ExtraAutorizadoOriginal,
            'MesesAutorizadoOriginal'=>$MesesAutorizadoOriginal,
            'FormaPagoOriginal'=>$FormaPagoOriginal,
            'PAIOriginal'=>$PAIOriginal,
            'ResumenVentaOriginal'=>$ResumenVentaOriginal,
            'ContactadoCO'=>$ContactadoCO,
            'VTAConfirmadaCO'=>$VTAConfirmadaCO,
            'ComentarioCO'=>$ComentarioCO
                );
	    }
	    
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }

        return $arrayactual;
    }
    
    function insertLogVenta_Antiguo($idLogSeg, $actual){
        
        global $con;
        
        global $idventa;
        
        global $idusuario;
        global $idcliente;
        global $matricula;
        global $nombcomercial;
        global $dc;
        global $jefeventa;
        global $categoria;
        global $tipoventa;
        global $preciokit;
        $preciokit = number_format($preciokit,2,'.','');
        global $totalextra;
        $totalextra = number_format($totalextra,2,'.','');
        global $ingresokit;
        $ingresokit = number_format($ingresokit,2,'.','');
        global $ingresoextras;
        $ingresoextras = number_format($ingresoextras,2,'.','');
        global $ingresototal;
        $ingresototal = number_format($ingresototal,2,'.','');
        global $estadoventa;
        global $extraautorizado;
        global $mesesautorizados;
        $mesesautorizados = number_format($mesesautorizados,2,'.','');
        global $n590;
        global $formadepago;
        global $PAI;
        global $resumenventa;
        global $estvisita;
        global $hidden_contactadoco;
        global $hidden_ventaconfirmadaco;
        global $comentarioco;
        
        $id_usuario = $_SESSION['id_usuario'];
        $fechaactual = date("Y-m-d H:i:s");
        
        $nuevo = array(
                'IdUsuario' => $idusuario,
                'IdCliente' => $idcliente,
                'Matricula' => $matricula,
                'Comercial' => $nombcomercial,
                'CC' => $dc,
                'JefeVenta' => $jefeventa,
                'CategoriaVenta' => $categoria,
                'TipoVenta' => $tipoventa,
                'PrecioKit' => $preciokit,
                'TotalExtra' => $totalextra,
                'IngresoKIT' => $ingresokit,
                'IngresoExtras' => $ingresoextras,
                'IngresoTotal' => $ingresototal,
                'EstadoVenta' => $estadoventa,
                'ExtraAutorizado' => $extraautorizado,
                'MesesAutorizado' => $mesesautorizados,
                'N590' => $n590,
                'FormaPago' => $formadepago,
                'PAI' => $PAI,
                'ResumenVenta' => $resumenventa,
                'EstadoVisita' => $estvisita,
                'PrecioKITOriginal' => $preciokit,
                'TotalExtraOriginal' => $totalextra,
                'ExtraAutorizadoOriginal' => $extraautorizado,
                'MesesAutorizadoOriginal' => $mesesautorizados,
                'FormaPagoOriginal' => $formadepago,
                'PAIOriginal' => $PAI,
                'ResumenVentaOriginal' => $resumenventa,
                'ContactadoCO' => $hidden_contactadoco,
                'VTAConfirmadaCO' => $hidden_ventaconfirmadaco,
                'ComentarioCO' => $comentarioco
            );
            
        $RegActual = array_diff_assoc($actual, $nuevo);
        $RegActual = json_encode($RegActual);
        $RegNuevo = array_diff_assoc($nuevo, $actual);
        $RegNuevo = json_encode($RegNuevo);
        
        $tabla = "tblventa";
        $url = "".$_SERVER['REQUEST_URI']."=>IdVenta='".$idventa."'";
        $usuariolog=$_SESSION['usuariosesion'];
        $accion = 'Modificar';
        
        //StmtInsertarLog($id_usuario, $idLogSeg, $tabla, $url, $RegActual, $RegNuevo, $fechaactual);
        
        StmtInsertarLogTransac($id_usuario, $usuariolog, $idLogSeg, $url, $idventa, $accion, $tabla, $RegActual, $RegNuevo, $fechaactual);
    }
    
    function consultaVentaI(){
        
        $arrayactual = array(
                'IdUsuario' => '',
                'IdCliente' => '',
                'Matricula' => '',
                'Comercial' => '',
                'CC' => '',
                'JefeVenta' => '',
                'CategoriaVenta' => '',
                'TipoVenta' => '',
                'Segmento' => '',
                'NProspecto' => '',
                'PrecioKit' => '',
                'TotalExtra' => '',
                'IngresoKIT' => '',
                'IngresoExtras' => '',
                'IngresoTotal' => '',
                'EstadoVenta' => '',
                'ExtraAutorizado' => '',
                'MesesAutorizado' => '',
                'N590' => '',
                'FormaPago' => '',
                'PAI' => '',
                'ResumenVenta' => '',
                'FechaHoraREG' => '',
                'GestorOrigen' => '',
                'CCOriginal' => '',
                'PrecioKITOriginal' => '',
                'TotalExtraOriginal' => '',
                'ExtraAutorizadoOriginal' => '',
                'MesesAutorizadoOriginal' => '',
                'FormaPagoOriginal' => '',
                'PAIOriginal' => '',
                'ResumenVentaOriginal' => ''
                );
            
            return $arrayactual;
    }
    
    function insertLogVentaI_ACTUAL($idLogSeg, $actual){
        
        global $con;
        
        global $idusuario;
        global $idCli;
        global $matricula;
        global $nombcomercial;
        global $dc;
        global $jefeventa;
        global $categoria;
        global $tipoventa;
        global $segmento;
        global $nprospecto;
        global $preciokit;
        global $totalextra;
        global $ingresokit;
        global $ingresoextras;
        global $ingresototal;
        global $estadoventa;
        global $extraautorizado;
        global $mesesautorizados;
        global $n590;
        global $formadepago;
        global $PAI;
        global $resumenventa;
        global $fecharegistroventa;
        global $matriculausuario;
        
        $id_usuario = $_SESSION['id_usuario'];
        $fechaactual = date("Y-m-d H:i:s");
        global $idVen;
        
        $nuevo = array(
                'IdUsuario' => $idusuario,
                'IdCliente' => $idCli,
                'Matricula' => $matricula,
                'Comercial' => $nombcomercial,
                'CC' => $dc,
                'JefeVenta' => $jefeventa,
                'CategoriaVenta' => $categoria,
                'TipoVenta' => $tipoventa,
                'Segmento' => $segmento,
                'NProspecto' => $nprospecto,
                'PrecioKit' => $preciokit,
                'TotalExtra' => $totalextra,
                'IngresoKIT' => $ingresokit,
                'IngresoExtras' => $ingresoextras,
                'IngresoTotal' => $ingresototal,
                'EstadoVenta' => $estadoventa,
                'ExtraAutorizado' => $extraautorizado,
                'MesesAutorizado' => $mesesautorizados,
                'N590' => $n590,
                'FormaPago' => $formadepago,
                'PAI' => $PAI,
                'ResumenVenta' => $resumenventa,
                'FechaHoraREG' => $fecharegistroventa,
                'GestorOrigen' => $matriculausuario,
                'CCOriginal' => $dc,
                'PrecioKITOriginal' => $preciokit,
                'TotalExtraOriginal' => $totalextra,
                'ExtraAutorizadoOriginal' => $extraautorizado,
                'MesesAutorizadoOriginal' => $mesesautorizados,
                'FormaPagoOriginal' => $formadepago,
                'PAIOriginal' => $PAI,
                'ResumenVentaOriginal' => $resumenventa    
            );
            
            $RegActual = array();
            $RegActual = json_encode($RegActual);
            $RegNuevo = array_diff_assoc($nuevo, $actual);
            $RegNuevo = json_encode($RegNuevo);
            
            $tabla = "tblventa";
            $url = "".$_SERVER['REQUEST_URI']."=>IdVenta='".$idventa."'";
            $usuariolog=$_SESSION['usuariosesion'];
            $accion = 'Modificar';
            
            //StmtInsertarLog($id_usuario, $idLogSeg, $tabla, $url, $RegActual, $RegNuevo, $fechaactual);
            
            StmtInsertarLogTransac($id_usuario, $usuariolog, $idLogSeg, $url, $idventa, $accion, $tabla, $RegActual, $RegNuevo, $fechaactual);

    }
    
    //PRUEBA + LOG ESTADOS
    
    function insertLogVenta($idLogSeg, $actual){
        
        global $con;
        
        global $idventa;
        
        global $idusuario;
        global $idcliente;
        global $matricula;
        global $nombcomercial;
        global $dc;
        global $jefeventa;
        global $categoria;
        global $tipoventa;
        global $segmento;
        global $nprospecto;
        global $preciokit;
        $preciokit = number_format($preciokit,2,'.','');
        global $totalextra;
        $totalextra = number_format($totalextra,2,'.','');
        global $ingresokit;
        $ingresokit = number_format($ingresokit,2,'.','');
        global $ingresoextras;
        $ingresoextras = number_format($ingresoextras,2,'.','');
        global $ingresototal;
        $ingresototal = number_format($ingresototal,2,'.','');
        global $estadoventa;
        global $extraautorizado;
        global $mesesautorizados;
        $mesesautorizados = number_format($mesesautorizados,2,'.','');
        global $n590;
        global $formadepago;
        global $PAI;
        global $resumenventa;
        global $estvisita;
        global $hidden_contactadoco;
        global $hidden_ventaconfirmadaco;
        global $comentarioco;
        
        $id_usuario = $_SESSION['id_usuario'];
        $fechaactual = date("Y-m-d H:i:s");
        
        $nuevo = array(
                'IdUsuario' => $idusuario,
                'IdCliente' => $idcliente,
                'Matricula' => $matricula,
                'Comercial' => $nombcomercial,
                'CC' => $dc,
                'JefeVenta' => $jefeventa,
                'CategoriaVenta' => $categoria,
                'TipoVenta' => $tipoventa,
                'Segmento' => $segmento,
                'NProspecto' => $nprospecto,
                'PrecioKit' => $preciokit,
                'TotalExtra' => $totalextra,
                'IngresoKIT' => $ingresokit,
                'IngresoExtras' => $ingresoextras,
                'IngresoTotal' => $ingresototal,
                'EstadoVenta' => $estadoventa,
                'ExtraAutorizado' => $extraautorizado,
                'MesesAutorizado' => $mesesautorizados,
                'N590' => $n590,
                'FormaPago' => $formadepago,
                'PAI' => $PAI,
                'ResumenVenta' => $resumenventa,
                'EstadoVisita' => $estvisita,
                'PrecioKITOriginal' => $preciokit,
                'TotalExtraOriginal' => $totalextra,
                'ExtraAutorizadoOriginal' => $extraautorizado,
                'MesesAutorizadoOriginal' => $mesesautorizados,
                'FormaPagoOriginal' => $formadepago,
                'PAIOriginal' => $PAI,
                'ResumenVentaOriginal' => $resumenventa,
                'ContactadoCO' => $hidden_contactadoco,
                'VTAConfirmadaCO' => $hidden_ventaconfirmadaco,
                'ComentarioCO' => $comentarioco
            );
            
        $RegActual = array_diff_assoc($actual, $nuevo);
        $RegActual = json_encode($RegActual);
        $RegNuevo = array_diff_assoc($nuevo, $actual);
        $RegNuevo = json_encode($RegNuevo);
        
        unset($actual);
        unset($nuevo);
        
        $tabla = "tblventa";
        $url = "".$_SERVER['REQUEST_URI']."=>IdVenta='".$idventa."'";
        $usuariolog=$_SESSION['usuariosesion'];
        $accion="Modificar";
        
        StmtInsertarLogTransac($id_usuario, $usuariolog, $idLogSeg, $url, $idventa, $accion, $tabla, $RegActual, $RegNuevo, $fechaactual);
        $IdLogTrans = $con->insert_id;
        
        $RegNuevo=json_decode($RegNuevo, true);
        
        if(array_key_exists('EstadoVenta', $RegNuevo)){
            $indentificador=$idventa;
            $nombestadoLog="EstadoVenta";
            $estadolog=$RegNuevo['EstadoVenta'];
            $matriculalog=$matricula;
            $cclog=$dc;
            $jefeventalog=$jefeventa;
        
            StmtInsertarLogStatus($IdLogTrans,$tabla,$indentificador,$nombestadoLog,$estadolog,$usuariolog,$fechaactual,$matriculalog,$cclog,$jefeventalog);
        
        }
        
        if(array_key_exists('EstadoVisita', $RegNuevo)){
            $indentificador=$idventa;
            $nombestadoLog="EstadoVisita";
            $estadolog=$RegNuevo['EstadoVisita'];
            $matriculalog=$matricula;
            $cclog=$dc;
            $jefeventalog=$jefeventa;
        
            StmtInsertarLogStatus($IdLogTrans,$tabla,$indentificador,$nombestadoLog,$estadolog,$usuariolog,$fechaactual,$matriculalog,$cclog,$jefeventalog);
        
        }
        
        unset($RegActual);
        unset($RegNuevo);
    }
    
    function insertLogVentaI($idLogSeg, $actual){
        
        global $con;
        
        global $idusuario;
        global $idCli;
        global $matricula;
        global $nombcomercial;
        global $dc;
        global $jefeventa;
        global $categoria;
        global $tipoventa;
        global $segmento;
        global $nprospecto;
        global $preciokit;
        global $totalextra;
        global $ingresokit;
        global $ingresoextras;
        global $ingresototal;
        global $estadoventa;
        global $extraautorizado;
        global $mesesautorizados;
        global $n590;
        global $formadepago;
        global $PAI;
        global $resumenventa;
        global $fecharegistroventa;
        global $matriculausuario;
        
        global $Comercial;
        global $JefeVenta;
        
        $id_usuario = $_SESSION['id_usuario'];
        $fechaactual = date("Y-m-d H:i:s");
        global $idVen;
        
        $nuevo = array(
                'IdUsuario' => $idusuario,
                'IdCliente' => $idCli,
                'Matricula' => $matricula,
                'Comercial' => $nombcomercial,
                'CC' => $dc,
                'JefeVenta' => $jefeventa,
                'CategoriaVenta' => $categoria,
                'TipoVenta' => $tipoventa,
                'Segmento' => $segmento,
                'NProspecto' => $nprospecto,
                'PrecioKit' => $preciokit,
                'TotalExtra' => $totalextra,
                'IngresoKIT' => $ingresokit,
                'IngresoExtras' => $ingresoextras,
                'IngresoTotal' => $ingresototal,
                'EstadoVenta' => $estadoventa,
                'ExtraAutorizado' => $extraautorizado,
                'MesesAutorizado' => $mesesautorizados,
                'N590' => $n590,
                'FormaPago' => $formadepago,
                'PAI' => $PAI,
                'ResumenVenta' => $resumenventa,
                'FechaHoraREG' => $fecharegistroventa,
                'GestorOrigen' => $matriculausuario,
                'CCOriginal' => $dc,
                'PrecioKITOriginal' => $preciokit,
                'TotalExtraOriginal' => $totalextra,
                'ExtraAutorizadoOriginal' => $extraautorizado,
                'MesesAutorizadoOriginal' => $mesesautorizados,
                'FormaPagoOriginal' => $formadepago,
                'PAIOriginal' => $PAI,
                'ResumenVentaOriginal' => $resumenventa    
            );
            
        $RegActual = array();
        $RegActual = json_encode($RegActual);
        $RegNuevo = array_diff_assoc($nuevo, $actual);
        $RegNuevo = json_encode($RegNuevo);
        
        $tabla = "tblventa";
        $url = "".$_SERVER['REQUEST_URI']."=>IdVenta='".$idVen."'";
        $usuariolog=$_SESSION['usuariosesion'];
        $accion = 'Registrar';
        
        //StmtInsertarLog($id_usuario, $idLogSeg, $tabla, $url, $RegActual, $RegNuevo, $fechaactual);
        
        StmtInsertarLogTransac($id_usuario, $usuariolog, $idLogSeg, $url, $idVen, $accion, $tabla, $RegActual, $RegNuevo, $fechaactual);

        $IdLogTrans = $con->insert_id;
        
        $RegNuevo=json_decode($RegNuevo, true);
        
        if(array_key_exists('EstadoVenta', $RegNuevo)){
            $identificador=$idVen;
            $nombestadoLog="EstadoVenta";
            $estadolog=$RegNuevo['EstadoVenta'];
            $matriculalog=$matricula;
            $cclog=$dc;
            $jefeventalog=$jefeventa;
        
            StmtInsertarLogStatus($IdLogTrans,$tabla,$identificador,$nombestadoLog,$estadolog,$usuariolog,$fechaactual,$matriculalog,$cclog,$jefeventalog);
        
        }
        
        unset($actual);
        unset($nuevo);

    }
    
    //Funciones para ConsultaVenta de los Comerciales
    function consultaVentaComercial($id){
         global $con;
        $arrayactual = null;

  try{
        $stmt = $con->prepare( "SELECT
        v.CategoriaVenta, 
        v.TipoVenta, 
        v.PrecioKit, 
        v.TotalExtra, 
        v.IngresoKIT,
        v.IngresoExtras, 
        v.IngresoTotal, 
        v.EstadoVenta, 
        v.ExtraAutorizado, 
        v.MesesAutorizado,
        v.N590, 
        v.FormaPago, 
        v.PAI, 
        v.ResumenVenta, 
        v.EstadoVisita, 
        v.PrecioKITOriginal,
        v.TotalExtraOriginal, 
        v.ExtraAutorizadoOriginal, 
        v.MesesAutorizadoOriginal, 
        v.FormaPagoOriginal,
        v.PAIOriginal, 
        v.ResumenVentaOriginal,
        v.HojaCertificacion,
        v.TipoKIT,
        v.CantidadExtras,
        v.ClosingPack,
        v.PrecioEspecial,
        v.ScoringRP
        FROM tblventa v
        WHERE v.IdVenta = ?");
        $stmt->bind_param('i', $id);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($CategoriaVenta,
$TipoVenta,
$PrecioKit,
$TotalExtra,
$IngresoKIT,
$IngresoExtras,
$IngresoTotal,
$EstadoVenta,
$ExtraAutorizado,
$MesesAutorizado,
$N590,
$FormaPago,
$PAI,
$ResumenVenta,
$EstadoVisita,
$PrecioKITOriginal,
$TotalExtraOriginal,
$ExtraAutorizadoOriginal,
$MesesAutorizadoOriginal,
$FormaPagoOriginal,
$PAIOriginal,
$ResumenVentaOriginal,
$HojaCertificacion,
$TipoKIT,
$CantidadExtras,
$ClosingPack,
$PrecioEspecial,
$ScoringRP
);
        while ($stmt->fetch()){
            $arrayactual = array(
'CategoriaVenta'=>$CategoriaVenta,
'TipoVenta'=>$TipoVenta,
'PrecioKit'=>$PrecioKit,
'TotalExtra'=>$TotalExtra,
'IngresoKIT'=>$IngresoKIT,
'IngresoExtras'=>$IngresoExtras,
'IngresoTotal'=>$IngresoTotal,
'EstadoVenta'=>$EstadoVenta,
'ExtraAutorizado'=>$ExtraAutorizado,
'MesesAutorizado'=>$MesesAutorizado,
'N590'=>$N590,
'FormaPago'=>$FormaPago,
'PAI'=>$PAI,
'ResumenVenta'=>$ResumenVenta,
'EstadoVisita'=>$EstadoVisita,
'PrecioKITOriginal'=>$PrecioKITOriginal,
'TotalExtraOriginal'=>$TotalExtraOriginal,
'ExtraAutorizadoOriginal'=>$ExtraAutorizadoOriginal,
'MesesAutorizadoOriginal'=>$MesesAutorizadoOriginal,
'FormaPagoOriginal'=>$FormaPagoOriginal,
'PAIOriginal'=>$PAIOriginal,
'ResumenVentaOriginal'=>$ResumenVentaOriginal,
'HojaCertificacion'=>$HojaCertificacion,
'TipoKIT'=>$TipoKIT,
'CantidadExtras'=>$CantidadExtras,
'ClosingPack'=>$ClosingPack,
'PrecioEspecial'=>$PrecioEspecial,
'ScoringRP'=>$ScoringRP
                );
	    }
	    
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
        return $arrayactual;
    }
    function insertLogVentaComercial($idLogSeg, $actual){
        
        global $con;
        
        global $idventa;
        
        global $idusuario;
        global $idcliente;
        global $matricula;
        global $nombcomercial;
        global $dc;
        global $jefeventa;
        global $categoria;
        global $tipoventa;
        global $preciokit;
        $preciokit = number_format($preciokit,2,'.','');
        global $totalextra;
        $totalextra = number_format($totalextra,2,'.','');
        global $ingresokit;
        $ingresokit = number_format($ingresokit,2,'.','');
        global $ingresoextras;
        $ingresoextras = number_format($ingresoextras,2,'.','');
        global $ingresototal;
        $ingresototal = number_format($ingresototal,2,'.','');
        global $estadoventa;
        global $extraautorizado;
        global $mesesautorizados;
        $mesesautorizados = number_format($mesesautorizados,2,'.','');
        global $n590;
        global $formadepago;
        global $PAI;
        global $resumenventa;
        global $estvisita;
        global $hidden_HCertificacion;
        
        global $lbltipokit;
        global $lblclosingpack;
        global $lblCantExtras;
        global $lblresultadoScoring;
        global $lblprecioEspecial;
        
        $id_usuario = $_SESSION['id_usuario'];
        $fechaactual = date("Y-m-d H:i:s");
        
        $nuevo = array(
                'CategoriaVenta' => $categoria,
                'TipoVenta' => $tipoventa,
                'PrecioKit' => $preciokit,
                'TotalExtra' => $totalextra,
                'IngresoKIT' => $ingresokit,
                'IngresoExtras' => $ingresoextras,
                'IngresoTotal' => $ingresototal,
                'EstadoVenta' => $estadoventa,
                'ExtraAutorizado' => $extraautorizado,
                'MesesAutorizado' => $mesesautorizados,
                'N590' => $n590,
                'FormaPago' => $formadepago,
                'PAI' => $PAI,
                'ResumenVenta' => $resumenventa,
                'EstadoVisita' => $estvisita,
                'PrecioKITOriginal' => $preciokit,
                'TotalExtraOriginal' => $totalextra,
                'ExtraAutorizadoOriginal' => $extraautorizado,
                'MesesAutorizadoOriginal' => $mesesautorizados,
                'FormaPagoOriginal' => $formadepago,
                'PAIOriginal' => $PAI,
                'ResumenVentaOriginal' => $resumenventa,
                'HojaCertificacion' => $hidden_HCertificacion,
                'TipoKIT' => $lbltipokit,
                'CantidadExtras' => $lblCantExtras,
                'ClosingPack' => $lblclosingpack,
                'PrecioEspecial' => $lblprecioEspecial,
                'ScoringRP' => $lblresultadoScoring
                
            );
            
        $RegActual = array_diff_assoc($actual, $nuevo);
        $RegActual = json_encode($RegActual);
        $RegNuevo = array_diff_assoc($nuevo, $actual);
        $RegNuevo = json_encode($RegNuevo);
        
        unset($actual);
        unset($nuevo);
        
        $tabla = "tblventa";
        $url = "".$_SERVER['REQUEST_URI']."=>IdVenta='".$idventa."'";
        $usuariolog=$_SESSION['usuariosesion'];
        $accion="Modificar";
        
        StmtInsertarLogTransac($id_usuario, $usuariolog, $idLogSeg, $url, $idventa, $accion, $tabla, $RegActual, $RegNuevo, $fechaactual);
        $IdLogTrans = $con->insert_id;
        
        $RegNuevo=json_decode($RegNuevo, true);
        
        
        if(array_key_exists('EstadoVisita', $RegNuevo)){
            $indentificador=$idventa;
            $nombestadoLog="EstadoVisita";
            $estadolog=$RegNuevo['EstadoVisita'];
            $matriculalog=$matricula;
            $cclog=$dc;
            $jefeventalog=$jefeventa;
        
            StmtInsertarLogStatus($IdLogTrans,$tabla,$indentificador,$nombestadoLog,$estadolog,$usuariolog,$fechaactual,$matriculalog,$cclog,$jefeventalog);
        
        }
                if(array_key_exists('EstadoVenta', $RegNuevo)){
            $indentificador=$idventa;
            $nombestadoLog="EstadoVenta";
            $estadolog=$RegNuevo['EstadoVenta'];
            $matriculalog=$matricula;
            $cclog=$dc;
            $jefeventalog=$jefeventa;
        
            StmtInsertarLogStatus($IdLogTrans,$tabla,$indentificador,$nombestadoLog,$estadolog,$usuariolog,$fechaactual,$matriculalog,$cclog,$jefeventalog);
        
        }
        
        unset($RegActual);
        unset($RegNuevo);
    }
    
    //Funciones para ProspectoRP de los Comerciales
    function consultaVentaIProspecto(){
        
        $arrayactual = array(
                'IdUsuario' => '',
                'IdCliente' => '',
                'Matricula' => '',
                'Comercial' => '',
                'CC' => '',
                'JefeVenta' => '',
                'CategoriaVenta' => '',
                'TipoVenta' => '',
                'Segmento' => '',
                'NProspecto' => '',
                'PrecioKit' => '',
                'TotalExtra' => '',
                'IngresoKIT' => '',
                'IngresoExtras' => '',
                'IngresoTotal' => '',
                'EstadoVenta' => '',
                'ExtraAutorizado' => '',
                'MesesAutorizado' => '',
                'N590' => '',
                'FormaPago' => '',
                'PAI' => '',
                'ResumenVenta' => '',
                'FechaHoraREG' => '',
                'GestorOrigen' => '',
                'CCOriginal' => '',
                'PrecioKITOriginal' => '',
                'TotalExtraOriginal' => '',
                'ExtraAutorizadoOriginal' => '',
                'MesesAutorizadoOriginal' => '',
                'FormaPagoOriginal' => '',
                'PAIOriginal' => '',
                'ResumenVentaOriginal' => '',
                'IdProspectoRP'=>'',
                'TipoKIT'=>'',
                'CantidadExtras'=>'',
                'ClosingPack'=>'',
                'ScoringRP'=>''
                );
            
            return $arrayactual;
    }
    function insertLogVentaIProspecto($idLogSeg, $actual){
        
        global $con;
        
        global $idusuario;
        global $idCli;
        global $matricula;
        global $nombcomercial;
        global $dc;
        global $jefeventa;
        global $categoria;
        global $tipoventa;
        global $segmento;
        global $nprospecto;
        global $preciokit;
        global $totalextra;
        global $ingresokit;
        global $ingresoextras;
        global $ingresototal;
        global $estadoventa;
        global $extraautorizado;
        global $mesesautorizados;
        global $n590;
        global $formadepago;
        global $PAI;
        global $resumenventa;
        global $fecharegistroventa;
        global $matriculausuario;
        
        global $Comercial;
        global $JefeVenta;
        
        global $idprospectorp;
        
        global $lbltipokit;
        global $lblclosingpack;
        global $lblCantExtras;
        global $lblresultadoScoring;
        
        $id_usuario = $_SESSION['id_usuario'];
        $fechaactual = date("Y-m-d H:i:s");
        global $idVen;
        
        $nuevo = array(
                'IdUsuario' => $idusuario,
                'IdCliente' => $idCli,
                'Matricula' => $matricula,
                'Comercial' => $nombcomercial,
                'CC' => $dc,
                'JefeVenta' => $jefeventa,
                'CategoriaVenta' => $categoria,
                'TipoVenta' => $tipoventa,
                'Segmento' => $segmento,
                'NProspecto' => $nprospecto,
                'PrecioKit' => $preciokit,
                'TotalExtra' => $totalextra,
                'IngresoKIT' => $ingresokit,
                'IngresoExtras' => $ingresoextras,
                'IngresoTotal' => $ingresototal,
                'EstadoVenta' => $estadoventa,
                'ExtraAutorizado' => $extraautorizado,
                'MesesAutorizado' => $mesesautorizados,
                'N590' => $n590,
                'FormaPago' => $formadepago,
                'PAI' => $PAI,
                'ResumenVenta' => $resumenventa,
                'FechaHoraREG' => $fecharegistroventa,
                'GestorOrigen' => $matriculausuario,
                'CCOriginal' => $dc,
                'PrecioKITOriginal' => $preciokit,
                'TotalExtraOriginal' => $totalextra,
                'ExtraAutorizadoOriginal' => $extraautorizado,
                'MesesAutorizadoOriginal' => $mesesautorizados,
                'FormaPagoOriginal' => $formadepago,
                'PAIOriginal' => $PAI,
                'ResumenVentaOriginal' => $resumenventa,
                'IdProspectoRP'=>$idprospectorp,
                'TipoKIT'=>$lbltipokit,
                'CantidadExtras'=>$lblCantExtras,
                'ClosingPack'=>$lblclosingpack,
                'ScoringRP'=>$lblresultadoScoring
            );
            
        $RegActual = array();
        $RegActual = json_encode($RegActual);
        $RegNuevo = array_diff_assoc($nuevo, $actual);
        $RegNuevo = json_encode($RegNuevo);
        
        $tabla = "tblventa";
        $url = "".$_SERVER['REQUEST_URI']."=>IdVenta='".$idVen."'";
        $usuariolog=$_SESSION['usuariosesion'];
        $accion = 'Registrar';
        
        //StmtInsertarLog($id_usuario, $idLogSeg, $tabla, $url, $RegActual, $RegNuevo, $fechaactual);
        
        StmtInsertarLogTransac($id_usuario, $usuariolog, $idLogSeg, $url, $idVen, $accion, $tabla, $RegActual, $RegNuevo, $fechaactual);

        $IdLogTrans = $con->insert_id;
        
        $RegNuevo=json_decode($RegNuevo, true);
        
        if(array_key_exists('EstadoVenta', $RegNuevo)){
            $identificador=$idVen;
            $nombestadoLog="EstadoVenta";
            $estadolog=$RegNuevo['EstadoVenta'];
            $matriculalog=$matricula;
            $cclog=$dc;
            $jefeventalog=$jefeventa;
        
            StmtInsertarLogStatus($IdLogTrans,$tabla,$identificador,$nombestadoLog,$estadolog,$usuariolog,$fechaactual,$matriculalog,$cclog,$jefeventalog);
        
        }
        
        unset($actual);
        unset($nuevo);

    }
    
    //Funciones para Venta de coordinadores y delegados
    
    function consultaVenta_General($id){
        
        //SIN DATOS DEL COMERCIAL
        
        global $con;
        $arrayactual = null;

  try{
        $stmt = $con->prepare( "SELECT
        v.CategoriaVenta, 
        v.TipoVenta,
        v.PrecioKit, 
        v.TotalExtra, 
        v.IngresoKIT,
        v.IngresoExtras, 
        v.IngresoTotal, 
        v.EstadoVenta, 
        v.ExtraAutorizado, 
        v.MesesAutorizado,
        v.N590, 
        v.FormaPago, 
        v.PAI, 
        v.ResumenVenta, 
        v.EstadoVisita, 
        v.PrecioKITOriginal,
        v.TotalExtraOriginal, 
        v.ExtraAutorizadoOriginal, 
        v.MesesAutorizadoOriginal, 
        v.FormaPagoOriginal,
        v.PAIOriginal, 
        v.ResumenVentaOriginal, 
        v.ContactadoCO, 
        v.VTAConfirmadaCO, 
        v.ComentarioCO
        FROM tblventa v
        WHERE v.IdVenta = ?");
        $stmt->bind_param('i', $id);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($CategoriaVenta,
$TipoVenta,
$PrecioKit,
$TotalExtra,
$IngresoKIT,
$IngresoExtras,
$IngresoTotal,
$EstadoVenta,
$ExtraAutorizado,
$MesesAutorizado,
$N590,
$FormaPago,
$PAI,
$ResumenVenta,
$EstadoVisita,
$PrecioKITOriginal,
$TotalExtraOriginal,
$ExtraAutorizadoOriginal,
$MesesAutorizadoOriginal,
$FormaPagoOriginal,
$PAIOriginal,
$ResumenVentaOriginal,
$ContactadoCO,
$VTAConfirmadaCO,
$ComentarioCO
);
        while ($stmt->fetch()){
            $arrayactual = array(
'CategoriaVenta'=>$CategoriaVenta,
'TipoVenta'=>$TipoVenta,
'PrecioKit'=>$PrecioKit,
'TotalExtra'=>$TotalExtra,
'IngresoKIT'=>$IngresoKIT,
'IngresoExtras'=>$IngresoExtras,
'IngresoTotal'=>$IngresoTotal,
'EstadoVenta'=>$EstadoVenta,
'ExtraAutorizado'=>$ExtraAutorizado,
'MesesAutorizado'=>$MesesAutorizado,
'N590'=>$N590,
'FormaPago'=>$FormaPago,
'PAI'=>$PAI,
'ResumenVenta'=>$ResumenVenta,
'EstadoVisita'=>$EstadoVisita,
'PrecioKITOriginal'=>$PrecioKITOriginal,
'TotalExtraOriginal'=>$TotalExtraOriginal,
'ExtraAutorizadoOriginal'=>$ExtraAutorizadoOriginal,
'MesesAutorizadoOriginal'=>$MesesAutorizadoOriginal,
'FormaPagoOriginal'=>$FormaPagoOriginal,
'PAIOriginal'=>$PAIOriginal,
'ResumenVentaOriginal'=>$ResumenVentaOriginal,
'ContactadoCO'=>$ContactadoCO,
'VTAConfirmadaCO'=>$VTAConfirmadaCO,
'ComentarioCO'=>$ComentarioCO
                );
	    }
	    
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
        
        return $arrayactual;
    }
    
    function insertLogVenta_General($idLogSeg, $actual){
        
        global $con;
        
        global $idventa;
        
        global $categoria;
        global $tipoventa;
        global $preciokit;
        $preciokit = number_format($preciokit,2,'.','');
        global $totalextra;
        $totalextra = number_format($totalextra,2,'.','');
        global $ingresokit;
        $ingresokit = number_format($ingresokit,2,'.','');
        global $ingresoextras;
        $ingresoextras = number_format($ingresoextras,2,'.','');
        global $ingresototal;
        $ingresototal = number_format($ingresototal,2,'.','');
        global $estadoventa;
        global $extraautorizado;
        global $mesesautorizados;
        $mesesautorizados = number_format($mesesautorizados,2,'.','');
        global $n590;
        global $formadepago;
        global $PAI;
        global $resumenventa;
        global $estvisita;
        global $hidden_contactadoco;
        global $hidden_ventaconfirmadaco;
        global $comentarioco;
        
        $id_usuario = $_SESSION['id_usuario'];
        $fechaactual = date("Y-m-d H:i:s");
        
        $nuevo = array(
                'CategoriaVenta' => $categoria,
                'TipoVenta' => $tipoventa,
                'PrecioKit' => $preciokit,
                'TotalExtra' => $totalextra,
                'IngresoKIT' => $ingresokit,
                'IngresoExtras' => $ingresoextras,
                'IngresoTotal' => $ingresototal,
                'EstadoVenta' => $estadoventa,
                'ExtraAutorizado' => $extraautorizado,
                'MesesAutorizado' => $mesesautorizados,
                'N590' => $n590,
                'FormaPago' => $formadepago,
                'PAI' => $PAI,
                'ResumenVenta' => $resumenventa,
                'EstadoVisita' => $estvisita,
                'PrecioKITOriginal' => $preciokit,
                'TotalExtraOriginal' => $totalextra,
                'ExtraAutorizadoOriginal' => $extraautorizado,
                'MesesAutorizadoOriginal' => $mesesautorizados,
                'FormaPagoOriginal' => $formadepago,
                'PAIOriginal' => $PAI,
                'ResumenVentaOriginal' => $resumenventa,
                'ContactadoCO' => $hidden_contactadoco,
                'VTAConfirmadaCO' => $hidden_ventaconfirmadaco,
                'ComentarioCO' => $comentarioco
            );
            
        $RegActual = array_diff_assoc($actual, $nuevo);
        $RegActual = json_encode($RegActual);
        $RegNuevo = array_diff_assoc($nuevo, $actual);
        $RegNuevo = json_encode($RegNuevo);
        
        unset($actual);
        unset($nuevo);
        
        $tabla = "tblventa";
        $url = "".$_SERVER['REQUEST_URI']."=>IdVenta='".$idventa."'";
        $usuariolog=$_SESSION['usuariosesion'];
        $accion="Modificar";
        
        StmtInsertarLogTransac($id_usuario, $usuariolog, $idLogSeg, $url, $idventa, $accion, $tabla, $RegActual, $RegNuevo, $fechaactual);
        $IdLogTrans = $con->insert_id;
        
        $RegNuevo=json_decode($RegNuevo, true);
        
        if(array_key_exists('EstadoVenta', $RegNuevo)){
            $indentificador=$idventa;
            $nombestadoLog="EstadoVenta";
            $estadolog=$RegNuevo['EstadoVenta'];
            $matriculalog=NULL;
            $cclog=NULL;
            $jefeventalog=NULL;
        
            StmtInsertarLogStatus($IdLogTrans,$tabla,$indentificador,$nombestadoLog,$estadolog,$usuariolog,$fechaactual,$matriculalog,$cclog,$jefeventalog);
        
        }
        
        if(array_key_exists('EstadoVisita', $RegNuevo)){
            $indentificador=$idventa;
            $nombestadoLog="EstadoVisita";
            $estadolog=$RegNuevo['EstadoVisita'];
            $matriculalog=NULL;
            $cclog=NULL;
            $jefeventalog=NULL;
        
            StmtInsertarLogStatus($IdLogTrans,$tabla,$indentificador,$nombestadoLog,$estadolog,$usuariolog,$fechaactual,$matriculalog,$cclog,$jefeventalog);
        
        }
        
        unset($RegActual);
        unset($RegNuevo);
    }
    
    //funciones para VentaCertificada
    
    function consultaVentaCertificada($id){
        
        //SIN DATOS DEL COMERCIAL
        
        global $con;
        $arrayactual = null;

  try{
        $stmt = $con->prepare( "SELECT
        v.CertificadoValidado
        FROM tblventa v
        WHERE v.IdVenta = ?");
        $stmt->bind_param('i', $id);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($CertificadoValidado);
        while ($stmt->fetch()){
            $arrayactual = array(
                     'CertificadoValidado' => $CertificadoValidado
                );
	    }
	    
        $stmt->close();

    } catch(PDOException $e) {
        return "Error: " . $e->getMessage();
    }
        return $arrayactual;
    }
    
    function insertLogVentaCertificada($idLogSeg, $actual){
        
        global $con;
        
        global $idventa;
        
        global $hidden_certificadovalidado;
        
        $id_usuario = $_SESSION['id_usuario'];
        $fechaactual = date("Y-m-d H:i:s");
        
        $nuevo = array(
                'CertificadoValidado' => $hidden_certificadovalidado
            );
            
        $RegActual = array_diff_assoc($actual, $nuevo);
        $RegActual = json_encode($RegActual);
        $RegNuevo = array_diff_assoc($nuevo, $actual);
        $RegNuevo = json_encode($RegNuevo);
        
        unset($actual);
        unset($nuevo);
        
        $tabla = "tblventa";
        $url = "".$_SERVER['REQUEST_URI']."=>IdVenta='".$idventa."'";
        $usuariolog=$_SESSION['usuariosesion'];
        $accion="Modificar";
        
        StmtInsertarLogTransac($id_usuario, $usuariolog, $idLogSeg, $url, $idventa, $accion, $tabla, $RegActual, $RegNuevo, $fechaactual);
        $IdLogTrans = $con->insert_id;
        
        $RegNuevo=json_decode($RegNuevo, true);
        
        unset($RegActual);
        unset($RegNuevo);
    }
    
?>