<?php

include('is_logged.php');

date_default_timezone_set('America/Lima');

require_once '../config/db.php';
require_once '../config/conexion.php';

include_once 'log/insertLog.php';
include_once 'log/insertLogCliente.php';
include 'log/insertLogVisita.php';

//GLOBALES
$FechaHoraREG = date("Y-m-d H:i:s");
$GestionOrigen = 'VENTA';

//PROCESO DE INSERCION EN TABLAS

//----///*** REGISTRO EN TABLA CLIENTES ***** /////-----

    $idCli = insertarCliente();
    
    if($idCli == 'error'){
        $resultado = [
            'respuesta' => 'error',
            'detalle' => 'insercion del cliente'
        ];
        
        die(json_encode($resultado));
    } 


//----///*** REGISTRO EN TABLA VENTA ***** ////
    $idVenta = insertarVisita($idCli);
    
    if($idVenta == 'error'){
        $resultado = [
            'respuesta' => 'error en la insercion de los datos de la visita',
            'detalle' => 'insercion de de los datos de la visita'
        ];
        
        die(json_encode($resultado));
    } else if ($idVenta == 'errorNprospecto'){
        $resultado = [
            'respuesta' => 'error en la insercion de los datos de la visita',
            'detalle' => 'Número de prospecto duplicado'
        ];
        
        die(json_encode($resultado));
    }
    
    //INSERT LOG DE SEGURIDAD
    
    
//----///*** REGISTRO EN TABLA AGENDA ***** ////
           try{
                $stmtAgenda = $con->prepare( "INSERT INTO dbVENTAS.tblagenda(IdVenta,FechaHoraREG, GestionOrigen) VALUES (?,?, ?)");
                $stmtAgenda->bind_param('iss', $idVenta,$FechaHoraREG,$GestionOrigen);
                $stmtAgenda->execute();
                $stmtAgenda->close();
        
            } catch(PDOException $e) {
                echo "Error: " . $e->getMessage();
            }             

//----///*** REGISTRO EN TABLA FACTURACION ***** ////
           try{
                $stmtFact = $con->prepare( "INSERT INTO dbVENTAS.tblfacturacion(IdVenta, FechaHoraREG, GestionOrigen) VALUES (?,?,?)");
                $stmtFact->bind_param('iss', $idVenta,$FechaHoraREG,$GestionOrigen);
                $stmtFact->execute();
                $stmtFact->close();
        
            } catch(PDOException $e) {
                echo "Error: " . $e->getMessage();
            } 

    
    $resultado = [
            'respuesta' => 'exito',
            'IdCliente' => $idCli,
            'IdVenta' => $idVenta
        ];


    echo json_encode($resultado);

//FIN DE PROCESO DE INSERCCION

//FUNCIONES

function insertarCliente(){
    global $con;
    global $FechaHoraREG;
    //----DATOS GENERALES DEL CIENTE --
    //RECIBE DATOS DE POST
    $nombcliente = $_POST['nombres'];
    $correo = $_POST['correo'];
    $telefonouno = $_POST['telefono'];
    $telefonodos = stringtonull($_POST['telefono2']);
    $direccion = $_POST['lbldireccion'];
    //IDGEOFRAFICO ENVIADO CON EL NOMBRE DE lbldisitrito
    $distrito = $_POST['lbldistrito'];
    
    $lbldireccionAprox = $_POST['lbldireccionAprox'];
    $lbltipoDireccion = $_POST['lbltipoDireccion'];
    $lblinterior = stringtonull($_POST['lblinterior']);
    $referencia = stringtonull($_POST['lblreferencia']);
    
    $tipovial = stringtonull($_POST['tipovial']);
    $npiso = stringtonull($_POST['npiso']);
    $tiposegmento = stringtonull($_POST['tiposegmento']);
    
    $segmento = $_POST['segmento'];
    
    $objGeofinder = $_POST['objGeofinder'];
    $IdDireccion = $_POST['IdDireccion'];
    //ZONIFICACION
    $idZonificacion = $_POST['idZonificacion'];
    $objZonificacionVerisure = $_POST['objZonificacionVerisure'];
    
    $telefonopantalla = $_POST['telefonopantalla'];
    if($telefonopantalla=="" || empty($telefonopantalla)){
        $telefonopantalla=NULL;
    }
    
    //OBTENER IDDOCUMENTO PARA EL REGISTRO DEL DNI
    $IdDocVisita = insertarDocumento();
    
    if($IdDocVisita == 'error'){
        $respuesta = 'error';
        
        return $respuesta;
    }
    
    $nuevo = array(
                'IdGeografico' => $distrito,
                'NombApellido' => $nombcliente,
                'Telefonouno' => $telefonouno,
                'Telefonodos' => $telefonodos,
                'Correo' => $correo,
                'Direccion' => $direccion,
                'Segmento' => $segmento,
                'DierccionAprox' => $lbldireccionAprox,
                'TipoDireccion' => $lbltipoDireccion,
                'Interior' => $lblinterior,
                'Referencia' => $referencia,
                'Segmento' => $segmento,
                'ObjGeofinder' => $objGeofinder,
                'IdDireccion' => $IdDireccion,
                'IdZonificacion' => $idZonificacion,
                'ObjZonificacion' => $objZonificacionVerisure,
                'IdDocVisita' => $IdDocVisita
            );
    
    try {
            
        $stmt = $con->prepare("INSERT INTO dbVENTAS.tblcliente(IdGeografico, NombApellido, Telefonouno, Telefonodos, Correo, Direccion, Segmento, IdDocVisita, objGeofinder, Referencia, Interior, DireccionAprox, TipoDireccion, IdDireccion, IdZonificacion, objZonificacion,NPiso,TipoSegmento,TipoVial,Telefonotres) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?) ");
        $stmt->bind_param('issssssisssssiisisss', $distrito, $nombcliente, $telefonouno, $telefonodos, $correo, $direccion,$segmento,$IdDocVisita, $objGeofinder, $referencia, $lblinterior, $lbldireccionAprox, $lbltipoDireccion, $IdDireccion, $idZonificacion, $objZonificacionVerisure,$npiso,$tiposegmento,$tipovial,$telefonopantalla);
        $stmt->execute();
        
        $respuesta = $con->insert_id;

        $stmt->close();
        
        //INSERT LOG DE CLIENTES
        $IdLogSeg = StmtInsertarLogSeguridad_General('Registrar', $FechaHoraREG, $respuesta, 'IdCliente');
        //INSERT LOG TRANSACCIONAL
        insertLogCliente_GenerarVisita($IdLogSeg, $respuesta, $nuevo);
        
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}

function insertarVisita($IdCliente){
    global $con;
    
    //IDUSUARIO DE ENZO MERE URBINA, SE UTILIZA POR DEFECTO PARA QUE SE PUEDA VISUALIZAR LA INFORMACION EN EL FORMULARIO DE EDITAR VISITA
    $IdUsuario = 687;
    
    $FechaHoraREG = date("Y-m-d H:i:s");
    
    $TipoVenta = $_POST['lbltipoventa'];
    $Segmento = $_POST['segmento'];
    $EstadoVenta = $_POST['lblestadoventa'];
    $EstadoVisita = $_POST['lblestadovisita'];
    
    $fvisita = $_POST['lblfvisita'];
    $fechaconvertfvisita=  myUrlEncode($fvisita);
    $fechagrabarfvisita=  format_date_Y_mm_dd(str_replace('/', '-', $fechaconvertfvisita));
    
    $hvisita = $_POST['lblhvisita'];
    $horaconvertvisita =  myUrlEncode($hvisita);
    $horagrabarvisita =  date("H:i", strtotime(str_replace("+"," ",$horaconvertvisita)));
    
    $lblfvencimiento = $_POST['lblfvencimiento'];
    $fvencimiento = format_date_Y_mm_dd(str_replace('/', '-', myUrlEncode($lblfvencimiento)));
    //$FVencimientoVisita = $_POST['']
    //GESTOR DE CALL CENTER QUE GENERA LA VISTA
    $GestorMKT = $_POST['gestorMKT'];
    
    $OrigenVisita = $_POST['origen'];
    $ComentarioVisita = $_POST['observaciones'];
    
    $NProspecto = htmlspecialchars($_POST['NProspecto']);
    
    $GrupoACD = $_POST['grupoACD'];
    
    $idResultadoScoring= $_POST['idResultadoScoring'];
    $lblaccion=$_POST['lblaccion'];
    $lblFechaHoraReg=$_POST['lblFechaHoraReg'];
    $lblperfilscoring=$_POST['lblperfilscoring'];
    
    /*
    if(validarNProspecto($NProspecto) > 0){
        return 'errorNprospecto';
    }
    */
    
    if ($NProspecto==''){
        $NProspecto=NULL;
    }else{
        if(validarNProspecto($NProspecto) > 0){
            return 'errorNprospecto';
        }        
    }
    
    if(isset($_POST['FObras'])){
        $fobras=$_POST['FObras'];
    } else {
        $fobras='NO';
    }
    
    if(isset($_POST['lblFVisitaReal'])){
        $fvisitaobras=$_POST['lblFVisitaReal'];
        
        if ($fvisitaobras==''){
            $fechagrabarfvisitaobras = NULL;    
        } else {
            $fechaconvertfvisitaobras = myUrlEncode($fvisitaobras);
            $fechagrabarfvisitaobras = format_date_Y_mm_dd(str_replace('/', '-', $fechaconvertfvisitaobras));
        }
        
    } else {
        $fvisitaobras= NULL;
        $fechagrabarfvisitaobras = NULL;
    }

    //GESTOR DE BACK OFFICE QUE ASIGNA LA VISTA
    //$GestorOrigen = $_POST['']
    $leadid = $_POST['leadid'];
    $IdLead = $_POST['IdLeadCC'];
    
    $detalleObservaciones = $_POST['detalleObservaciones'];

    $visePiso=$_POST['visePiso'];
    if($visePiso==""){
        $visePiso=null;
    }        
    $rubroNeg=$_POST['rubroNeg'];
    if($rubroNeg==""){
        $rubroNeg=null;
    }          
    $puertaCalle=$_POST['puertaCalle'];
    if($puertaCalle==""){
        $puertaCalle=null;
    }         
    $nobleParedes=$_POST['nobleParedes'];
    if($nobleParedes==""){
        $nobleParedes=null;
    }         
    $nobleTecho=$_POST['nobleTecho'];
    if($nobleTecho==""){
        $nobleTecho=null;
    }         
    $mcuadrados=$_POST['mcuadrados'];
    if($mcuadrados==""){
        $mcuadrados=null;
    }          
    $motivoInteres=$_POST['motivoInteres'];
    if($motivoInteres==""){
        $motivoInteres=null;
    }         
    $conSistema=$_POST['conSistema'];
    if($conSistema==""){
        $conSistema=null;
    }        
    $empresaSistema=$_POST['empresaSistema'];
    if($empresaSistema==""){
        $empresaSistema=null;
    }        
    $bancarizado=$_POST['bancarizado'];
    if($bancarizado==""){
        $bancarizado=null;
    }    
    
    
    
    
    
    
    $nuevo = array(
                    'IdUsuario' => $IdUsuario,
                    'IdCliente' => $IdCliente,
                    'TipoVenta'=> $TipoVenta,
                    'Segmento'=> $Segmento,
                    'NProspecto'=> $NProspecto,
                    'EstadoVenta'=> $EstadoVenta,
                    'EstadoVisita'=> $EstadoVisita,
                    'FechaVisita' => $fechagrabarfvisita,
                    'HoraVisita'=> $horagrabarvisita,
                    'FVencimientoVisita'=> $fvencimiento,
                    'GestorMKT'=> $GestorMKT,
                    'OrigenVisita'=> $OrigenVisita,
                    'ComentarioVisita'=> $ComentarioVisita,
                    'IdLead' => $IdLead,
                    'GrupoACD' => $GrupoACD,
                    'Accion' => $lblaccion,
                    'PerfilScoring' => $lblperfilscoring,
                    'IdConsultaScoring' => $idResultadoScoring,
                    'DetalleObservaciones' => $detalleObservaciones,
                    'LeadID'=> $leadid,
                    'FObras'=> $fobras,
                    'FVisitaObras'=> $fechagrabarfvisitaobras
                );
    
    try {
        $stmt = $con->prepare("INSERT INTO dbVENTAS.tblventa(IdUsuario, IdCliente, FechaHoraREG, TipoVenta, Segmento, EstadoVenta, EstadoVisita, FechaVisita, HoraVisita, GestorMKT, FObras, FVisitaObras, LeadID, OrigenVisita, ComentarioVisita, IdLead, NProspecto, GrupoACD, Accion, PerfilScoring, IdConsultaScoring, FVencimientoVisita, DetalleObservaciones,visePiso,rubroNeg,puertaCalle,nobleParedes,nobleTecho,metros,motivoInteres,conSistema,empresaSistema,bancarizado) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('iisssssssssssssissssisssssssdssss', $IdUsuario, $IdCliente, $FechaHoraREG, $TipoVenta, $Segmento, $EstadoVenta, $EstadoVisita, $fechagrabarfvisita, $horagrabarvisita, $GestorMKT, $fobras, $fechagrabarfvisitaobras, $leadid, $OrigenVisita, $ComentarioVisita, $IdLead, $NProspecto, $GrupoACD, $lblaccion, $lblperfilscoring, $idResultadoScoring, $fvencimiento, $detalleObservaciones,$visePiso,$rubroNeg,$puertaCalle,$nobleParedes,$nobleTecho,$mcuadrados,$motivoInteres,$conSistema,$empresaSistema,$bancarizado);
        $stmt->execute();
        $respuesta = $con->insert_id;
        $stmt->close();
        
        //Agregado el 7.01 LOG DE SEGURIDAD
        $IdLogSeg = StmtInsertarLogSeguridad_General('Registrar', $FechaHoraREG, $respuesta, 'IdVenta');
        insertarLogVisita_CC($IdLogSeg, $respuesta, $nuevo);
        
        
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
}

function validarNProspecto($nprospecto){
    global $con;

    $numrows=0;
    try{
        
        $stmt = $con->prepare( "SELECT 1 FROM dbVENTAS.tblventa v WHERE v.NProspecto= ?");
        $stmt->bind_param('s', $nprospecto);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($num);
        $numrows=$stmt->num_rows;
        $stmt->fetch();
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
    
    return $numrows;
}

function insertarDocumento(){
    global $con;
    
    $tipodoc = $_POST['lbltipodoc'];
    $documento = $_POST['ndocumento'];
    $fecharegistroventa = date("Y-m-d H:i:s");
    
    try {

        $stmt = $con->prepare("INSERT INTO dbVENTAS.tbldocumento(TipoDocumento, Documento, FechaHoraREG) VALUES(?, ?, ?)");
        $stmt->bind_param('sss', $tipodoc,$documento,$fecharegistroventa);
        $stmt->execute();
        $respuesta = $con->insert_id;
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 'error';
    }

    return $respuesta;

}

function stringtonull($val){
        
    if ($val == '' || empty($val)){
        $resultado = NULL;
    }
    else if(!isset($val)){
        $resultado = NULL;
    }
    else {
        $resultado = $val;
    }
    
    return $resultado;
}

//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date){
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date){
    return date('Y-m-d', strtotime($date));
}


    


?>