<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';
require_once '../helper/helper_validacion.php';

 if(isset($_POST["mdp_id"]))  
 {
     
        $mdp_id = sanitizaCampo($_POST['mdp_id'],'sanitizeint|scapestring|htmlspecialchars',$con);
        $mdp_id = htmlspecialchars($mdp_id);

    try{
        $stmt = $con->prepare( "SELECT m.IdMdp,m.URL,DATE_FORMAT(m.FechaVencimiento, '%d/%m/%Y') FechaVencimiento,m.EstadoURL,m.CodigoMDP,m.CantidadTransaccion,TIME_FORMAT(m.HoraVencimiento,'%r') HoraVencimiento,m.GestorOrigen,m.Area FROM dbVENTAS.tblmdp m WHERE m.IdMdp= ?");
        $stmt->bind_param('s', $mdp_id);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($IdMdp,
            $URL,
            $FechaVencimiento,
            $EstadoURL,
            $CodigoMDP,
            $CantidadTransaccion,
            $HoraVencimiento,
            $GestorOrigen,
            $Area);
        $json = [];        
        while ($stmt->fetch()){
        $json = array_map("utf8_encode",[
            'IdMdp'=>$IdMdp,
            'URL'=>$URL,
            'FechaVencimiento'=>$FechaVencimiento,
            'EstadoURL'=>$EstadoURL,
            'CodigoMDP'=>$CodigoMDP,
            'CantidadTransaccion'=>$CantidadTransaccion,
            'HoraVencimiento'=>$HoraVencimiento,
            'GestorOrigen'=>$GestorOrigen,
            'Area'=>$Area
            ]);         
	    }
	    
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }


    echo json_encode($json);

 } 
 
 
