<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';

//include_once '../config/dbsec.php';
//include_once '../config/conexionsec.php';


date_default_timezone_set('America/Lima');


  try{

        $stmtventa = $con->prepare( "SELECT h.IdHistorialGestion,
        a.FechaHoraREG,
        h.FechaHoraREG,
        v.CCOriginal,
        v.NProspecto,
        c.Telefonouno,
    	v.EstadoVisita,
    	DATE_FORMAT(v.FechaVisita,'%d/%m/%Y') FechaVisita,
    	v.GestorMKT,
    	CONCAT(mk.Nombres,' ',mk.Apellidos) Operador,
        h.MatriculaUsuario,
    	CONCAT(bo.Nombres,' ',bo.Apellidos) OperadorBO,
        h.errorGestion,
        h.Comentarios
        FROM dbVENTAS.tblhistorialerroresgestion h
        INNER JOIN dbVENTAS.tblagenda a on h.IdVenta = a.IdVenta
        INNER JOIN dbVENTAS.tblventa v ON v.IdVenta = h.IdVenta
        INNER JOIN dbUSUARIO.tblusuario u on v.IdUsuario=u.IdUsuario 
        INNER JOIN dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente
        INNER JOIN dbUSUARIO.tblusuario bo on h.MatriculaUsuario = bo.Matricula
        LEFT JOIN dbUSUARIO.tblusuario mk on mk.Matricula=v.GestorMKT");
        
        $stmtventa->execute();
        $stmtventa->store_result();
        $stmtventa->bind_result($IdHistorialGestion,
            $FechaRegistroVisita,
            $FechaRegistro,
            $CC,
            $NProspecto,
            $Telefonouno,
            $EstadoVisita,
            $FechaVisita,
            $GestorMKT,
            $Operador,
            $GestorOrigen,
            $OperadorBo,
            $ErrorGestion,
            $Comentarios);
        $venta = [];        
        while ($stmtventa->fetch()){
        $venta[] = array_map("utf8_encode",['IdHistorialGestion' => $IdHistorialGestion,
'FechaRegistroVisita' => $FechaRegistroVisita,
'FechaRegistro' => $FechaRegistro,
'GestorMKT'=>$GestorMKT,
'Operador'=>$Operador,
'GestorBo'=>$GestorOrigen,
'OperadorBO'=>$OperadorBo,
'FechaVisita'=>$FechaVisita,
'ErrorGestion'=>$ErrorGestion,
'Comentarios'=>$Comentarios,
'NProspecto'=>$NProspecto,
'Telefonouno'=>$Telefonouno,
'EstadoVisita'=>$EstadoVisita
]);            
	    }
	    
        $stmtventa->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename=ErroresGestion.csv');
$output = fopen('php://output', 'w');
fputcsv($output, array('IdHistorialGestion',
'FechaRegistroVisita',
'FechaRegistroError',
'GestorMKT',
'Operador',
'GestorBO',
'OperadorBO',
'FechaVisita',
'ErrorGestion',
'Comentarios',
'NProspecto',
'Telefono',
'EstadoVisita'
));

if (count($venta) > 0) {
    foreach ($venta as $row) {
        fputcsv($output, $row);
    }
}
