<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';
//LIBRERIA DE EXPORTACION
require_once 'libreria/Spout/Autoloader/autoload.php';

use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;

$fileName = 'CheckIN_RE.csv';

$writer = WriterEntityFactory::createCSVWriter();

$writer->openToBrowser($fileName);

$head = array(
    'IdVenta',
    'Matricula',
    'Comercial',
    'CC',
    'JefeVenta',
    'CategoriaVenta',
    'TipoVenta',
    'Segmento',
    'NProspecto',
    'NContrato',
    'EstadoVenta',
    'N590',
    'FechaHoraREG',
    'EstadoVisita',
    'FechaVisita',
    'HoraVisita',
    'MesVisita',
    'FVencimientoVisita',
    'GestorMKT',
    'OrigenVisita',
    'ComentarioVisita',
    'GestorOrigen',
    'NombApellido',
    'Direccion',
    'Distrito',
    'Provincia',
    'DireccionAprox',
    'Checkin',
    'InfoCheckIn',
    'objGeofinder',
    'objZonificacion',
    'Distancia',
    'FechaEnvio',
    'Tipo',
    'Matricula',
    'VisitaNoVisitable'
);
$rowFromValues = WriterEntityFactory::createRowFromArray($head);
$writer->addRow($rowFromValues);

date_default_timezone_set('America/Lima');

$fecharegistro=date("Y-m-d H:i:s");

$query="SELECT 
v.IdVenta,
v.Matricula,
v.Comercial,
v.CC,
v.JefeVenta,
v.CategoriaVenta,
v.TipoVenta,
v.Segmento,
v.NProspecto,
v.NContrato,
v.EstadoVenta,
v.N590,
v.FechaHoraREG,
v.EstadoVisita,
v.FechaVisita,
v.HoraVisita,
v.MesVisita,
v.FVencimientoVisita,
v.GestorMKT,
v.OrigenVisita,
v.ComentarioVisita,
v.GestorOrigen,
c.NombApellido,
c.Direccion,
g.Distrito,
g.Provincia,
c.DireccionAprox,
v.Checkin,
v.InfoCheckIn,
c.objGeofinder,
c.objZonificacion
FROM dbVENTAS.tblventa v INNER JOIN dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente
INNER JOIN dbVENTAS.tblagenda a ON a.IdVenta=v.IdVenta 
INNER JOIN dbVENTAS.tblgeografico g ON g.IdGeografico=c.IdGeografico
LEFT JOIN dbVENTAS.tbldocumento d ON c.IdDocVisita = d.IdDoc
WHERE v.TipoVenta='RE' AND CC IN (150, 151, 152, 153, 154, 155, 156, 157 ,158, 159) AND v.FechaHoraREG >= '2021-02-19'
";

$result = $con->query($query);
//Contador para reccorer cada fila del resultado.
$i=0;

while ($Venta = $result->fetch_assoc()){
    
    $arreglo[] = $Venta;

    if($Venta['InfoCheckIn'] != '' || $Venta['InfoCheckIn'] != null){
        $InfoCheckIn = json_decode($Venta['InfoCheckIn'], true);
        
        $Distancia = $InfoCheckIn['Distancia'];
        $FechaEnvio = $InfoCheckIn['FechaEnvio'];
        $Tipo = $InfoCheckIn['Tipo'];
        $Matricula =$InfoCheckIn['Matricula'];
        if($InfoCheckIn['VisitaNoVisitable'] == false){
            $VisitaNoVisitable = 'NO';
        } else {
            $VisitaNoVisitable = 'SI';
        }
        $arreglo[$i]['Distancia'] = $Distancia;
        $arreglo[$i]['FechaEnvio'] = $FechaEnvio;
        $arreglo[$i]['Tipo'] = $Tipo;
        $arreglo[$i]['MatriculaCheckIn'] = $Matricula;
        $arreglo[$i]['VisitaNoVisitable'] = $VisitaNoVisitable;
        
    }
    
    $i++;
}

for($i=0; $i<count($arreglo); $i++){
    $rowData = WriterEntityFactory::createRowFromArray($arreglo[$i]);
    $writer->addRow($rowData);
}

$result->close();

$writer->close();

$con->close();

?>
