<?php

class ConexionNotificaciones
{


	private $db;
	private $usuario;

	function __construct()
	{

		$this->db =  Database::connect();

		// $this->db = new mysqli('localhost','root','','prueba');

	}

	public function InformacionCorreoAgenda_TVTC($idventa){

        $query = $this->db->prepare("SELECT 
            v.IdVenta,
            u.IdUsuario,
            v.Matricula,
            v.Comercial,
            v.CC,
            (case when v.CC=511 || v.CC=512 then 'SI' when v.CC<>511 || v.CC=512 then 'NO' end ) Telecierre, 
            v.JefeVenta,
            CONCAT(m.Nombres,' ',m.Apellidos) NombJefeVenta,
            v.TCGestor,
            v.EstadoVenta,
            v.CategoriaVenta,
            v.TipoVenta,
            v.Segmento,
            v.MesesAutorizado,
            v.NProspecto,
            v.NContrato,
            v.IdCliente,
            c.NombApellido Cliente,
            c.Correo,
            c.Telefonouno,
            c.Telefonodos,
            c.Direccion,
            g.IdGeografico,
            g.Distrito,
            g.Provincia,
            v.PrecioKit,
            v.TotalExtra,
            v.ResumenVenta,
            v.ExtraAutorizado,
            v.FormaPago,
            v.N590,
            v.PAI,
            DATE_FORMAT(v.FechaHoraREG, '%d/%m/%Y %r') FechaHoraREG,
            agen.IdAgenda,
            agen.InstaladoX,
            agen.MatriculaTec,
            CONCAT(t.Nombres,' ',t.Apellidos) Instalador,
            DATE_FORMAT(agen.FechaInst, '%d/%m/%Y') FechaInst, 
            TIME_FORMAT(agen.HoraInst,'%r') HoraInst,
            agen.Comentario,
            agen.MotivoInviable,
            agen.MotivoCancelada,
            agen.Repercusion,
            c.Referencia,
            c.Interior,
            v.TipoKIT,
            v.ClosingPack,
            t.Correo as CorreoTecnico
            FROM dbVENTAS.tblventa v 
            INNER JOIN dbUSUARIO.tblusuario u on v.IdUsuario=u.IdUsuario 
            INNER JOIN dbUSUARIO.tblarea a on a.IdArea=u.IdArea 
            INNER JOIN dbUSUARIO.tblusuario m on m.Matricula=u.Manager
            INNER JOIN dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente
            INNER JOIN dbVENTAS.tblgeografico g on g.IdGeografico=c.IdGeografico
            INNER JOIN dbVENTAS.tblagenda agen on agen.IdVenta=v.IdVenta
            LEFT JOIN dbUSUARIO.tblusuario t on t.Matricula=agen.MatriculaTec
            WHERE v.IdVenta=?");
            
            $query->execute(array($idventa));
    		$retorno = [];
    		while ($fila = $query->fetch(PDO::FETCH_ASSOC)) {
    			$retorno[] = $fila;
    		}

		return $retorno;
			
	}
	

    
}