<?php

class ConexionLead
{


	private $db;
	private $usuario;

	function __construct()
	{

		$this->db =  Database::connect();

		// $this->db = new mysqli('localhost','root','','prueba');

	}
	

    /* LISTAR LEADS*/
	public function mostrarTodosLeadsRemarketing($function)
	{
        $new_total_rows = 0;
        $contador=1;
        $pagenum=$function->pagenum;
        $pagesize=$function->pagesize;
        
        $starts = $pagenum * $pagesize;
        


        $queryexec="SELECT 
                IdLeadCC,
                FechaHoraReg,
                Telefono,
                Gestion,
                LeadID,
                ResultadoGestion,
                Matricula,
                NombreGestor,
                Nombres,
                Apellidos,
                Campaña,
                Telefono2,
                Observaciones,
                Segmento,
                NombreCompleto,
                Vueltas,
                Origen,
                Departamento,
                Provincia,
                Distrito,
                Accion,
                FechaHoraCotizacion,
                Contacto,
                SubTipificacion,
                GestorUltimo,
                ultimoNombreGestor,
                Remarketing,
                FechaHoraRellamada,
                FechaUltimaGestion,
                Gestionable,
                Zonas,
                Canal,
                GestorRemarketing,
                NombreGestorRemarketing,
                FechaHoraRemarketing,
                Visibilidad,
                BaseRMKT
                FROM leadsremarketing";
        
        $query = $queryexec." LIMIT :starts,:pagesize";


        $where="";
        // filter data.
        if (isset($function->filterscount))
        {
        	$filterscount = $function->filterscount;
        			
        	if ($filterscount > 0)
        	{
        		$where = " WHERE (";
        		$tmpdatafield = "";
        		$tmpfilteroperator = "";
        		for ($i=0; $i < $filterscount; $i++)
        		{
        			// get the filter's value.
        			$filtervalue = $function->{"filtervalue".$i};
        			// get the filter's condition.
        			$filtercondition =$function->{"filtercondition".$i};
        			// get the filter's column.
        			$filterdatafield =$function->{"filterdatafield".$i};
        			// get the filter's operator.
        			$filteroperator =$function->{"filteroperator".$i};
        					
        			if ($tmpdatafield == "")
        			{
        				$tmpdatafield = $filterdatafield;			
        			}
        			else if ($tmpdatafield <> $filterdatafield)
        			{
        					if ($tmpfilteroperator == 2){
            					$where.= " OR ";
            				}else{ 
            				    $where.= ") AND (";
            				}
        			}
        			else if ($tmpdatafield == $filterdatafield)
        			{
        				    if ($tmpfilteroperator == 0){
            					$where.= " AND ";
            				}else{ 
            				    $where.= " OR ";
            				}	
        			}
        					
        			// build the "WHERE" clause depending on the filter's condition, value and datafield.
        			switch($filtercondition)
        			{
        				case "CONTAINS":
        					$where .= " " . $filterdatafield . " LIKE '%" . $filtervalue ."%'";
        					break;
        				case "DOES_NOT_CONTAIN":
        					$where .= " " . $filterdatafield . " NOT LIKE '%" . $filtervalue ."%'";
        					break;
        				case "EQUAL":
        					$where .= " " . $filterdatafield . " = '" . $filtervalue ."'";
        					break;
        				case "NOT_EQUAL":
        					$where .= " " . $filterdatafield . " <> '" . $filtervalue ."'";
        					break;
        				case "GREATER_THAN":
        					$where .= " " . $filterdatafield . " > '" . $filtervalue ."'";
        					break;
        				case "LESS_THAN":
        					$where .= " " . $filterdatafield . " < '" . $filtervalue ."'";
        					break;
        				case "GREATER_THAN_OR_EQUAL":
        					$where .= " " . $filterdatafield . " >= '" . $filtervalue ."'";
        					break;
        				case "LESS_THAN_OR_EQUAL":
        					$where .= " " . $filterdatafield . " <= '" . $filtervalue ."'";
        					break;
        				case "STARTS_WITH":
        					$where .= " " . $filterdatafield . " LIKE '" . $filtervalue ."%'";
        					break;
        				case "ENDS_WITH":
        					$where .= " " . $filterdatafield . " LIKE '%" . $filtervalue ."'";
        					break;
        				case "NULL":
        					$where .= " " . $filterdatafield . " IS NULL";
        					break;
        				case "NOT_NULL":
        					$where .= " " . $filterdatafield . " NOT NULL";
        					break;
        				case "GREATER_THAN_OR_EQUAL_TIME":
        					$where .= " " . $filterdatafield . " >= '" . $filtervalue ." 00:00:00'";
        					break;
        				case "LESS_THAN_OR_EQUAL_TIME":
        					$where .= " " . $filterdatafield . " <= '" . $filtervalue ." 23:59:59'";
        					break;
        					
        					
        			}
        									
        			if ($i == $filterscount - 1){
        				$where.= ")";
        			}
        					
        			$tmpfilteroperator = $filteroperator;
        			$tmpdatafield = $filterdatafield;			
        		}
        		$query = $queryexec." " .$where." LIMIT :starts,:pagesize";	
        		//var_dump($query);
        
        	}
        }
        if (isset($function->sortdatafield)){
        	$sortfield = $function->sortdatafield;
        	$sortorder = $function->sortorder;
        	$filterscount = $function->filterscount;
        	if ($sortorder != '')
        		{
        		if ($filterscount == 0)
        			{
        			if ($sortorder == "desc")
        				{
        				$query = $queryexec." ORDER BY" . " " . $sortfield . " DESC LIMIT :starts,:pagesize";
        				}
        			  else if ($sortorder == "asc")
        				{
        				$query = $queryexec." ORDER BY" . " " . $sortfield . " ASC LIMIT :starts,:pagesize";
        				}

        			}
        		else
        			{
        			if ($sortorder == "desc")
        				{
        				$filterquery.= " ORDER BY " . $sortfield . " DESC LIMIT :starts,:pagesize";
        				}
        			  else if ($sortorder == "asc")
        				{
        				$filterquery.= " ORDER BY " . $sortfield . " ASC LIMIT :starts,:pagesize";
        				}
        			$query = $queryexec." " .$where.$filterquery;
        			}
        		}
        }



		$result = $this->db->prepare($query); 
        $result->bindParam(':starts', $starts, PDO::PARAM_INT);
        $result->bindParam(':pagesize',$pagesize, PDO::PARAM_INT);		
		$result->execute(); 
		

        $orders = [];
        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            $orders[] = array(

'IdLeadCC' => $row['IdLeadCC'],
'FechaHoraReg' => $row['FechaHoraReg'],
'Telefono' => $row['Telefono'],
'Gestion' => $row['Gestion'],
'LeadID' => $row['LeadID'],
'ResultadoGestion' => $row['ResultadoGestion'],
'Matricula' => $row['Matricula'],
'NombreGestor'=>$row['NombreGestor'],
'Nombres' => $row['Nombres'],
'Apellidos' => $row['Apellidos'],
'Campaña' => $row['Campaña'],
'Telefono2' => $row['Telefono2'],
'Observaciones' => $row['Observaciones'],
'Segmento' => $row['Segmento'],
'NombreCompleto' => $row['NombreCompleto'],
'Vueltas' => (int) $row['Vueltas'],
'Origen' => $row['Origen'],
'Departamento' => $row['Departamento'],
'Provincia' => $row['Provincia'],
'Distrito' => $row['Distrito'],
'Accion' => $row['Accion'],
'FechaHoraCotizacion' => $row['FechaHoraCotizacion'],
'Contacto' => $row['Contacto'],
'SubTipificacion' => $row['SubTipificacion'],
'GestorUltimo' => $row['GestorUltimo'],
'ultimoNombreGestor'=>$row['ultimoNombreGestor'],
'Remarketing' =>$row['Remarketing'],
'FechaHoraRellamada'=>$row['FechaHoraRellamada'],
'FechaUltimaGestion'=>$row['FechaUltimaGestion'],
'Linea'=>$contador,
'Gestionable'=>$row['Gestionable'],
'Zonas'=>$row['Zonas'],
'Canal'=>$row['Canal'],
'GestorRemarketing'=>$row['GestorRemarketing'],
'NombreGestorRemarketing' =>$row['NombreGestorRemarketing'],
'FechaHoraRemarketing'=>$row['FechaHoraRemarketing'],
'Visibilidad'=>$row['Visibilidad'],
'BaseRMKT'=>$row['BaseRMKT']
                	);
$contador++;                	
            
        }
        
	    $query = "SELECT COUNT(*) AS found_rows FROM leadsremarketing".$where;
		$result =  $this->db->prepare($query);
		$result->execute();
		$rows=$result->fetch(PDO::FETCH_ASSOC); 
		$total_rows = $rows['found_rows'];
        if ($new_total_rows > 0) $total_rows = $new_total_rows;	        

        if ($total_rows > 0){
            $data[] = array(
            	'TotalRows' => $total_rows,
            	'Rows' => array_map(null,$orders),
            	'mensaje' => '',
            	'tipo' =>1
            );
            
        } else {
            $data[] = array(
        	'TotalRows' => 0,
        	'Rows' => null,
        	'mensaje' => '<div class="callout bg-gray">
                            <h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>
                       <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>
                        <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>
                        <br>
            </div>',
        	'tipo' =>0
        	);
        }
        
        
        return $data;


	}

	public function mostrarTodosLeads($function)
	{
        $new_total_rows = 0;
        $contador=1;
        $pagenum=$function->pagenum;
        $pagesize=$function->pagesize;
        
        $starts = $pagenum * $pagesize;
        


        $queryexec="SELECT 
                IdLeadCC,
                FechaHoraReg,
                Telefono,
                Gestion,
                LeadID,
                ResultadoGestion,
                Matricula,
                NombreGestor,
                Nombres,
                Apellidos,
                Campaña,
                Telefono2,
                Observaciones,
                Segmento,
                NombreCompleto,
                Vueltas,
                Origen,
                Departamento,
                Provincia,
                Distrito,
                Accion,
                FechaHoraCotizacion,
                Contacto,
                SubTipificacion,
                GestorUltimo,
                ultimoNombreGestor,
                Remarketing,
                FechaHoraRellamada,
                FechaUltimaGestion,
                Gestionable,
                Zonas,
                Canal,
                GestorRemarketing,
                NombreGestorRemarketing,
                FechaHoraRemarketing,
                Equipo,
                LeadRecovery,
                Categoria
                FROM leads";
        
        $query = $queryexec." LIMIT :starts,:pagesize";

        $filterquery = "";
        $where = "";
        // filter data.
        if (isset($function->filterscount))
        {
        	$filterscount = $function->filterscount;
        			
        	if ($filterscount > 0)
        	{
        		$where = " WHERE (";
        		$tmpdatafield = "";
        		$tmpfilteroperator = "";
        		for ($i=0; $i < $filterscount; $i++)
        		{
        			// get the filter's value.
        			$filtervalue = $function->{"filtervalue".$i};
        			// get the filter's condition.
        			$filtercondition =$function->{"filtercondition".$i};
        			// get the filter's column.
        			$filterdatafield =$function->{"filterdatafield".$i};
        			// get the filter's operator.
        			$filteroperator =$function->{"filteroperator".$i};
        					
        			if ($tmpdatafield == "")
        			{
        				$tmpdatafield = $filterdatafield;			
        			}
        			else if ($tmpdatafield <> $filterdatafield)
        			{
        					if ($tmpfilteroperator == 2){
            					$where.= " OR ";
            				}else{ 
            				    $where.= ") AND (";
            				}
        			}
        			else if ($tmpdatafield == $filterdatafield)
        			{
        				    if ($tmpfilteroperator == 0){
            					$where.= " AND ";
            				}else{ 
            				    $where.= " OR ";
            				}	
        			}
        					
        			// build the "WHERE" clause depending on the filter's condition, value and datafield.
        			switch($filtercondition)
        			{
        				case "CONTAINS":
        					$where .= " " . $filterdatafield . " LIKE '%" . $filtervalue ."%'";
        					break;
        				case "DOES_NOT_CONTAIN":
        					$where .= " " . $filterdatafield . " NOT LIKE '%" . $filtervalue ."%'";
        					break;
        				case "EQUAL":
        					$where .= " " . $filterdatafield . " = '" . $filtervalue ."'";
        					break;
        				case "NOT_EQUAL":
        					$where .= " " . $filterdatafield . " <> '" . $filtervalue ."'";
        					break;
        				case "GREATER_THAN":
        					$where .= " " . $filterdatafield . " > '" . $filtervalue ."'";
        					break;
        				case "LESS_THAN":
        					$where .= " " . $filterdatafield . " < '" . $filtervalue ."'";
        					break;
        				case "GREATER_THAN_OR_EQUAL":
        					$where .= " " . $filterdatafield . " >= '" . $filtervalue ."'";
        					break;
        				case "LESS_THAN_OR_EQUAL":
        					$where .= " " . $filterdatafield . " <= '" . $filtervalue ."'";
        					break;
        				case "STARTS_WITH":
        					$where .= " " . $filterdatafield . " LIKE '" . $filtervalue ."%'";
        					break;
        				case "ENDS_WITH":
        					$where .= " " . $filterdatafield . " LIKE '%" . $filtervalue ."'";
        					break;
        				case "NULL":
        					$where .= " " . $filterdatafield . " IS NULL";
        					break;
        				case "NOT_NULL":
        					$where .= " " . $filterdatafield . " NOT NULL";
        					break;
        				case "GREATER_THAN_OR_EQUAL_TIME":
        					$where .= " " . $filterdatafield . " >= '" . $filtervalue ." 00:00:00'";
        					break;
        				case "LESS_THAN_OR_EQUAL_TIME":
        					$where .= " " . $filterdatafield . " <= '" . $filtervalue ." 23:59:59'";
        					break;
        					
        					
        			}
        									
        			if ($i == $filterscount - 1){
        				$where.= ")";
        			}
        					
        			$tmpfilteroperator = $filteroperator;
        			$tmpdatafield = $filterdatafield;			
        		}
        		$query = $queryexec." " .$where." LIMIT :starts,:pagesize";	
        		//var_dump($query);
        
        	}
        }

        if (isset($function->sortdatafield)){
        	$sortfield = $function->sortdatafield;
        	$sortorder = $function->sortorder;
        	$filterscount = $function->filterscount;
        	if ($sortorder != '')
        		{
        		if ($filterscount == 0)
        			{
        			if ($sortorder == "desc")
        				{
        				$query = $queryexec." ORDER BY" . " " . $sortfield . " DESC LIMIT :starts,:pagesize";
        				}
        			  else if ($sortorder == "asc")
        				{
        				$query = $queryexec." ORDER BY" . " " . $sortfield . " ASC LIMIT :starts,:pagesize";
        				}

        			}
        		else
        			{
        			if ($sortorder == "desc")
        				{
        				$filterquery.= " ORDER BY " . $sortfield . " DESC LIMIT :starts,:pagesize";
        				}
        			  else if ($sortorder == "asc")
        				{
        				$filterquery.= " ORDER BY " . $sortfield . " ASC LIMIT :starts,:pagesize";
        				}
        			$query = $queryexec." " .$where.$filterquery;
        			}
        		}
        }


		$result = $this->db->prepare($query); 
        $result->bindParam(':starts', $starts, PDO::PARAM_INT);
        $result->bindParam(':pagesize',$pagesize, PDO::PARAM_INT);		
		$result->execute(); 
		

        $orders = [];
        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            $orders[] = array(

'IdLeadCC' => $row['IdLeadCC'],
'FechaHoraReg' => $row['FechaHoraReg'],
'Telefono' => $row['Telefono'],
'Gestion' => $row['Gestion'],
'LeadID' => $row['LeadID'],
'ResultadoGestion' => $row['ResultadoGestion'],
'Matricula' => $row['Matricula'],
'NombreGestor'=>$row['NombreGestor'],
'Nombres' => $row['Nombres'],
'Apellidos' => $row['Apellidos'],
'Campaña' => $row['Campaña'],
'Telefono2' => $row['Telefono2'],
'Observaciones' => $row['Observaciones'],
'Segmento' => $row['Segmento'],
'NombreCompleto' => $row['NombreCompleto'],
'Vueltas' => (int) $row['Vueltas'],
'Origen' => $row['Origen'],
'Departamento' => $row['Departamento'],
'Provincia' => $row['Provincia'],
'Distrito' => $row['Distrito'],
'Accion' => $row['Accion'],
'FechaHoraCotizacion' => $row['FechaHoraCotizacion'],
'Contacto' => $row['Contacto'],
'SubTipificacion' => $row['SubTipificacion'],
'GestorUltimo' => $row['GestorUltimo'],
'ultimoNombreGestor'=>$row['ultimoNombreGestor'],
'Remarketing' =>$row['Remarketing'],
'FechaHoraRellamada'=>$row['FechaHoraRellamada'],
'FechaUltimaGestion'=>$row['FechaUltimaGestion'],
'Linea'=>$contador,
'Gestionable'=>$row['Gestionable'],
'Zonas'=>$row['Zonas'],
'Canal'=>$row['Canal'],
'GestorRemarketing'=>$row['GestorRemarketing'],
'NombreGestorRemarketing' =>$row['NombreGestorRemarketing'],
'FechaHoraRemarketing'=>$row['FechaHoraRemarketing'],
'Equipo'=>$row['Equipo'],
'LeadRecovery'=>$row['LeadRecovery'],
'Categoria'=>$row['Categoria']
                	);
$contador++;            
        }
        
	    $query = "SELECT COUNT(IdLeadCC) AS found_rows FROM leads".$where;
		$result =  $this->db->prepare($query);
		$result->execute();
		$rows=$result->fetch(PDO::FETCH_ASSOC); 
		$total_rows = $rows['found_rows'];
        if ($new_total_rows > 0) $total_rows = $new_total_rows;	        

        if ($total_rows > 0){
            $data[] = array(
            	'TotalRows' => $total_rows,
            	'Rows' => array_map(null,$orders),
            	'mensaje' => '',
            	'tipo' =>1
            );
            
        } else {
            $data[] = array(
        	'TotalRows' => 0,
        	'Rows' => null,
        	'mensaje' => '<div class="callout bg-gray">
                            <h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>
                       <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>
                        <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>
                        <br>
            </div>',
        	'tipo' =>0
        	);
        }
        
        
        return $data;


	}

	public function mostrarTodosLeadsAux($function)	
	{
        $new_total_rows = 0;
        $contador=1;
        $pagenum=$function->pagenum;
        $pagesize=$function->pagesize;
        
        $starts = $pagenum * $pagesize;
        


        $queryexec="SELECT 
                IdLeadCC,
                FechaHoraReg,
                Telefono,
                Gestion,
                LeadID,
                ResultadoGestion,
                Matricula,
                NombreGestor,
                Nombres,
                Apellidos,
                Campaña,
                Telefono2,
                Observaciones,
                Segmento,
                NombreCompleto,
                Vueltas,
                Origen,
                Departamento,
                Provincia,
                Distrito,
                Accion,
                FechaHoraCotizacion,
                Contacto,
                SubTipificacion,
                GestorUltimo,
                ultimoNombreGestor,
                Remarketing,
                FechaHoraRellamada,
                FechaUltimaGestion,
                Gestionable,
                Zonas,
                Canal,
                GestorRemarketing,
                NombreGestorRemarketing,
                FechaHoraRemarketing,
                Equipo,
                LeadRecovery,
                Categoria
                FROM leadsaux";
        
        $query = $queryexec." LIMIT :starts,:pagesize";

        $filterquery = "";
        $where = "";
        // filter data.
        if (isset($function->filterscount))
        {
        	$filterscount = $function->filterscount;
        			
        	if ($filterscount > 0)
        	{
        		$where = " WHERE (";
        		$tmpdatafield = "";
        		$tmpfilteroperator = "";
        		for ($i=0; $i < $filterscount; $i++)
        		{
        			// get the filter's value.
        			$filtervalue = $function->{"filtervalue".$i};
        			// get the filter's condition.
        			$filtercondition =$function->{"filtercondition".$i};
        			// get the filter's column.
        			$filterdatafield =$function->{"filterdatafield".$i};
        			// get the filter's operator.
        			$filteroperator =$function->{"filteroperator".$i};
        					
        			if ($tmpdatafield == "")
        			{
        				$tmpdatafield = $filterdatafield;			
        			}
        			else if ($tmpdatafield <> $filterdatafield)
        			{
        					if ($tmpfilteroperator == 2){
            					$where.= " OR ";
            				}else{ 
            				    $where.= ") AND (";
            				}
        			}
        			else if ($tmpdatafield == $filterdatafield)
        			{
        				    if ($tmpfilteroperator == 0){
            					$where.= " AND ";
            				}else{ 
            				    $where.= " OR ";
            				}	
        			}
        					
        			// build the "WHERE" clause depending on the filter's condition, value and datafield.
        			switch($filtercondition)
        			{
        				case "CONTAINS":
        					$where .= " " . $filterdatafield . " LIKE '%" . $filtervalue ."%'";
        					break;
        				case "DOES_NOT_CONTAIN":
        					$where .= " " . $filterdatafield . " NOT LIKE '%" . $filtervalue ."%'";
        					break;
        				case "EQUAL":
        					$where .= " " . $filterdatafield . " = '" . $filtervalue ."'";
        					break;
        				case "NOT_EQUAL":
        					$where .= " " . $filterdatafield . " <> '" . $filtervalue ."'";
        					break;
        				case "GREATER_THAN":
        					$where .= " " . $filterdatafield . " > '" . $filtervalue ."'";
        					break;
        				case "LESS_THAN":
        					$where .= " " . $filterdatafield . " < '" . $filtervalue ."'";
        					break;
        				case "GREATER_THAN_OR_EQUAL":
        					$where .= " " . $filterdatafield . " >= '" . $filtervalue ."'";
        					break;
        				case "LESS_THAN_OR_EQUAL":
        					$where .= " " . $filterdatafield . " <= '" . $filtervalue ."'";
        					break;
        				case "STARTS_WITH":
        					$where .= " " . $filterdatafield . " LIKE '" . $filtervalue ."%'";
        					break;
        				case "ENDS_WITH":
        					$where .= " " . $filterdatafield . " LIKE '%" . $filtervalue ."'";
        					break;
        				case "NULL":
        					$where .= " " . $filterdatafield . " IS NULL";
        					break;
        				case "NOT_NULL":
        					$where .= " " . $filterdatafield . " NOT NULL";
        					break;
        				case "GREATER_THAN_OR_EQUAL_TIME":
        					$where .= " " . $filterdatafield . " >= '" . $filtervalue ." 00:00:00'";
        					break;
        				case "LESS_THAN_OR_EQUAL_TIME":
        					$where .= " " . $filterdatafield . " <= '" . $filtervalue ." 23:59:59'";
        					break;
        					
        					
        			}
        									
        			if ($i == $filterscount - 1){
        				$where.= ")";
        			}
        					
        			$tmpfilteroperator = $filteroperator;
        			$tmpdatafield = $filterdatafield;			
        		}
        		$query = $queryexec." " .$where." LIMIT :starts,:pagesize";	
        		//var_dump($query);
        
        	}
        }

        if (isset($function->sortdatafield)){
        	$sortfield = $function->sortdatafield;
        	$sortorder = $function->sortorder;
        	$filterscount = $function->filterscount;
        	if ($sortorder != '')
        		{
        		if ($filterscount == 0)
        			{
        			if ($sortorder == "desc")
        				{
        				$query = $queryexec." ORDER BY" . " " . $sortfield . " DESC LIMIT :starts,:pagesize";
        				}
        			  else if ($sortorder == "asc")
        				{
        				$query = $queryexec." ORDER BY" . " " . $sortfield . " ASC LIMIT :starts,:pagesize";
        				}

        			}
        		else
        			{
        			if ($sortorder == "desc")
        				{
        				$filterquery.= " ORDER BY " . $sortfield . " DESC LIMIT :starts,:pagesize";
        				}
        			  else if ($sortorder == "asc")
        				{
        				$filterquery.= " ORDER BY " . $sortfield . " ASC LIMIT :starts,:pagesize";
        				}
        			$query = $queryexec." " .$where.$filterquery;
        			}
        		}
        }


		$result = $this->db->prepare($query); 
        $result->bindParam(':starts', $starts, PDO::PARAM_INT);
        $result->bindParam(':pagesize',$pagesize, PDO::PARAM_INT);		
		$result->execute(); 
		

        $orders = [];
        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            $orders[] = array(

'IdLeadCC' => $row['IdLeadCC'],
'FechaHoraReg' => $row['FechaHoraReg'],
'Telefono' => $row['Telefono'],
'Gestion' => $row['Gestion'],
'LeadID' => $row['LeadID'],
'ResultadoGestion' => $row['ResultadoGestion'],
'Matricula' => $row['Matricula'],
'NombreGestor'=>$row['NombreGestor'],
'Nombres' => $row['Nombres'],
'Apellidos' => $row['Apellidos'],
'Campaña' => $row['Campaña'],
'Telefono2' => $row['Telefono2'],
'Observaciones' => $row['Observaciones'],
'Segmento' => $row['Segmento'],
'NombreCompleto' => $row['NombreCompleto'],
'Vueltas' => (int) $row['Vueltas'],
'Origen' => $row['Origen'],
'Departamento' => $row['Departamento'],
'Provincia' => $row['Provincia'],
'Distrito' => $row['Distrito'],
'Accion' => $row['Accion'],
'FechaHoraCotizacion' => $row['FechaHoraCotizacion'],
'Contacto' => $row['Contacto'],
'SubTipificacion' => $row['SubTipificacion'],
'GestorUltimo' => $row['GestorUltimo'],
'ultimoNombreGestor'=>$row['ultimoNombreGestor'],
'Remarketing' =>$row['Remarketing'],
'FechaHoraRellamada'=>$row['FechaHoraRellamada'],
'FechaUltimaGestion'=>$row['FechaUltimaGestion'],
'Linea'=>$contador,
'Gestionable'=>$row['Gestionable'],
'Zonas'=>$row['Zonas'],
'Canal'=>$row['Canal'],
'GestorRemarketing'=>$row['GestorRemarketing'],
'NombreGestorRemarketing' =>$row['NombreGestorRemarketing'],
'FechaHoraRemarketing'=>$row['FechaHoraRemarketing'],
'Equipo'=>$row['Equipo'],
'LeadRecovery'=>$row['LeadRecovery'],
'Categoria'=>$row['Categoria']
                	);
$contador++;            
        }
        
	    $query = "SELECT COUNT(IdLeadCC) AS found_rows FROM leadsaux".$where;
		$result =  $this->db->prepare($query);
		$result->execute();
		$rows=$result->fetch(PDO::FETCH_ASSOC); 
		$total_rows = $rows['found_rows'];
        if ($new_total_rows > 0) $total_rows = $new_total_rows;	        

        if ($total_rows > 0){
            $data[] = array(
            	'TotalRows' => $total_rows,
            	'Rows' => array_map(null,$orders),
            	'mensaje' => '',
            	'tipo' =>1
            );
            
        } else {
            $data[] = array(
        	'TotalRows' => 0,
        	'Rows' => null,
        	'mensaje' => '<div class="callout bg-gray">
                            <h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>
                       <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>
                        <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>
                        <br>
            </div>',
        	'tipo' =>0
        	);
        }
        
        
        return $data;


	}

    public function mostarGestorCC()
    {
        $query = $this->db->prepare("SELECT u.IdUsuario,u.Matricula,u.Nombres,u.Apellidos,u.RMKT,u.Push,u.Pull,u.Equipo FROM dbUSUARIO.tblusuario u WHERE u.Estado='Activo' and u.IdPerfil=55");
        
        $query->execute();

		while ($fila = $query->fetch(PDO::FETCH_ASSOC)) {
			$retorno[] = $fila;
		}
		return $retorno;		
    }

    public function listarOrigenesMKT($q)
    {
        
        $q = "%{$q}%";
        $query = $this->db->prepare("SELECT Origen,Canal FROM tblorigen WHERE Origen like ? LIMIT 0,25");
        
        $query->execute(array($q));

		while ($fila = $query->fetch(PDO::FETCH_ASSOC)) {
			$retorno[] = array(
			    'id'=>$fila['Origen'],
			    'text'=>$fila['Origen'],
			    'value'=>$fila['Origen'],
			    'origen'=>$fila['Origen'],
			    'categoria'=>$fila['Canal']
			    );
		}
		return $retorno;
    }    
    
    
	public function UpdateGestorRMKT($idUsuario,$checked)
	{
		
		$query = $this->db->prepare("UPDATE dbUSUARIO.tblusuario SET RMKT=? WHERE IdUsuario=?");
        $query->execute(array($checked,$idUsuario));
        $retorno = $query->rowCount();	

		return $retorno;

	}
	
	public function UpdateGestorPUSH($idUsuario,$checked)
	{
		
		$query = $this->db->prepare("UPDATE dbUSUARIO.tblusuario SET Push=? WHERE IdUsuario=?");
        $query->execute(array($checked,$idUsuario));
        $retorno = $query->rowCount();	

		return $retorno;

	}
	
	public function UpdateEquipo($idUsuario,$equipo)
	{
		
		$query = $this->db->prepare("UPDATE dbUSUARIO.tblusuario SET Equipo=? WHERE IdUsuario=?");
        $query->execute(array($equipo,$idUsuario));
        $retorno = $query->rowCount();	

		return $retorno;

	}	


	
	public function UpdateGestorPULL($idUsuario,$checked)
	{
		
		$query = $this->db->prepare("UPDATE dbUSUARIO.tblusuario SET Pull=? WHERE IdUsuario=?");
        $query->execute(array($checked,$idUsuario));
        $retorno = $query->rowCount();	

		return $retorno;

	}	

    function obtenerIdUsuario($matriculaAgente){
       
        $query = $this->db->prepare("SELECT IdUsuario FROM dbUSUARIO.tblusuario WHERE Matricula = ?");
        $query->execute(array($matriculaAgente));
        
		$retorno = NULL;
		$fila = $query->fetch(PDO::FETCH_ASSOC);
		
		$retorno=$fila['IdUsuario'];
		
		return $retorno;
        
    }


	public function insertarLeadReferido($idUsuario=NULL, $fecharegistro, $gestion, $nombres, $apellidos, $telefono, $origen, $leadid=NULL, $observaciones, $segmento,$IdLeadCC=NULL,$campana){
		try {

			$query = $this->db->prepare("INSERT INTO tblLeadCC(IdUsuario, FechaHoraReg, Gestion, Nombres, Apellidos, Telefono, Origen, LeadID,Observaciones, Segmento, FechaHoraCotizacion,IdLeadCCREF,Campaña) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?)");
			$query->execute(array($idUsuario, $fecharegistro, $gestion, $nombres, $apellidos, $telefono, $origen, $leadid, $observaciones, $segmento,$fecharegistro,$IdLeadCC,$campana));
			
			$idLead = $this->db->lastInsertId(); 

			$respuesta = array(
                'respuesta' => 'exito',
                'idlead' => $idLead
            );
		
		} catch (\Exception $e) {
			$respuesta = array(
                'respuesta' => 'error'
            );
        }

		return $respuesta;
	}
	
	public function mostrarTodosLeadsReferidos($function)
	{
        $new_total_rows = 0;
        $contador=1;
        $pagenum=$function->pagenum;
        $pagesize=$function->pagesize;
        
        $starts = $pagenum * $pagesize;
        


        $queryexec="SELECT 
                IdLeadCC,
                FechaHoraReg,
                Telefono,
                Gestion,
                LeadID,
                ResultadoGestion,
                Matricula,
                NombreGestor,
                Nombres,
                Apellidos,
                Campaña,
                Telefono2,
                Observaciones,
                Segmento,
                NombreCompleto,
                Vueltas,
                Origen,
                Departamento,
                Provincia,
                Distrito,
                Accion,
                FechaHoraCotizacion,
                Contacto,
                SubTipificacion,
                GestorUltimo,
                ultimoNombreGestor,
                Remarketing,
                FechaHoraRellamada,
                FechaUltimaGestion,
                Gestionable,
                Zonas,
                Canal,
                GestorRemarketing,
                NombreGestorRemarketing,
                FechaHoraRemarketing
                FROM leadsreferidos";
        
        $query = $queryexec." LIMIT :starts,:pagesize";

        $filterquery = "";
        $where = "";
        // filter data.
        if (isset($function->filterscount))
        {
        	$filterscount = $function->filterscount;
        			
        	if ($filterscount > 0)
        	{
        		$where = " WHERE (";
        		$tmpdatafield = "";
        		$tmpfilteroperator = "";
        		for ($i=0; $i < $filterscount; $i++)
        		{
        			// get the filter's value.
        			$filtervalue = $function->{"filtervalue".$i};
        			// get the filter's condition.
        			$filtercondition =$function->{"filtercondition".$i};
        			// get the filter's column.
        			$filterdatafield =$function->{"filterdatafield".$i};
        			// get the filter's operator.
        			$filteroperator =$function->{"filteroperator".$i};
        					
        			if ($tmpdatafield == "")
        			{
        				$tmpdatafield = $filterdatafield;			
        			}
        			else if ($tmpdatafield <> $filterdatafield)
        			{
        					if ($tmpfilteroperator == 2){
            					$where.= " OR ";
            				}else{ 
            				    $where.= ") AND (";
            				}
        			}
        			else if ($tmpdatafield == $filterdatafield)
        			{
        				    if ($tmpfilteroperator == 0){
            					$where.= " AND ";
            				}else{ 
            				    $where.= " OR ";
            				}	
        			}
        					
        			// build the "WHERE" clause depending on the filter's condition, value and datafield.
        			switch($filtercondition)
        			{
        				case "CONTAINS":
        					$where .= " " . $filterdatafield . " LIKE '%" . $filtervalue ."%'";
        					break;
        				case "DOES_NOT_CONTAIN":
        					$where .= " " . $filterdatafield . " NOT LIKE '%" . $filtervalue ."%'";
        					break;
        				case "EQUAL":
        					$where .= " " . $filterdatafield . " = '" . $filtervalue ."'";
        					break;
        				case "NOT_EQUAL":
        					$where .= " " . $filterdatafield . " <> '" . $filtervalue ."'";
        					break;
        				case "GREATER_THAN":
        					$where .= " " . $filterdatafield . " > '" . $filtervalue ."'";
        					break;
        				case "LESS_THAN":
        					$where .= " " . $filterdatafield . " < '" . $filtervalue ."'";
        					break;
        				case "GREATER_THAN_OR_EQUAL":
        					$where .= " " . $filterdatafield . " >= '" . $filtervalue ."'";
        					break;
        				case "LESS_THAN_OR_EQUAL":
        					$where .= " " . $filterdatafield . " <= '" . $filtervalue ."'";
        					break;
        				case "STARTS_WITH":
        					$where .= " " . $filterdatafield . " LIKE '" . $filtervalue ."%'";
        					break;
        				case "ENDS_WITH":
        					$where .= " " . $filterdatafield . " LIKE '%" . $filtervalue ."'";
        					break;
        				case "NULL":
        					$where .= " " . $filterdatafield . " IS NULL";
        					break;
        				case "NOT_NULL":
        					$where .= " " . $filterdatafield . " NOT NULL";
        					break;
        				case "GREATER_THAN_OR_EQUAL_TIME":
        					$where .= " " . $filterdatafield . " >= '" . $filtervalue ." 00:00:00'";
        					break;
        				case "LESS_THAN_OR_EQUAL_TIME":
        					$where .= " " . $filterdatafield . " <= '" . $filtervalue ." 23:59:59'";
        					break;
        					
        					
        			}
        									
        			if ($i == $filterscount - 1){
        				$where.= ")";
        			}
        					
        			$tmpfilteroperator = $filteroperator;
        			$tmpdatafield = $filterdatafield;			
        		}
        		$query = $queryexec." " .$where." LIMIT :starts,:pagesize";	
        		//var_dump($query);
        
        	}
        }

        if (isset($function->sortdatafield)){
        	$sortfield = $function->sortdatafield;
        	$sortorder = $function->sortorder;
        	$filterscount = $function->filterscount;
        	if ($sortorder != '')
        		{
        		if ($filterscount == 0)
        			{
        			if ($sortorder == "desc")
        				{
        				$query = $queryexec." ORDER BY" . " " . $sortfield . " DESC LIMIT :starts,:pagesize";
        				}
        			  else if ($sortorder == "asc")
        				{
        				$query = $queryexec." ORDER BY" . " " . $sortfield . " ASC LIMIT :starts,:pagesize";
        				}

        			}
        		else
        			{
        			if ($sortorder == "desc")
        				{
        				$filterquery.= " ORDER BY " . $sortfield . " DESC LIMIT :starts,:pagesize";
        				}
        			  else if ($sortorder == "asc")
        				{
        				$filterquery.= " ORDER BY " . $sortfield . " ASC LIMIT :starts,:pagesize";
        				}
        			$query = $queryexec." " .$where.$filterquery;
        			}
        		}
        }


		$result = $this->db->prepare($query); 
        $result->bindParam(':starts', $starts, PDO::PARAM_INT);
        $result->bindParam(':pagesize',$pagesize, PDO::PARAM_INT);		
		$result->execute(); 
		

        $orders = [];
        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            $orders[] = array(

'IdLeadCC' => $row['IdLeadCC'],
'FechaHoraReg' => $row['FechaHoraReg'],
'Telefono' => $row['Telefono'],
'Gestion' => $row['Gestion'],
'LeadID' => $row['LeadID'],
'ResultadoGestion' => $row['ResultadoGestion'],
'Matricula' => $row['Matricula'],
'NombreGestor'=>$row['NombreGestor'],
'Nombres' => $row['Nombres'],
'Apellidos' => $row['Apellidos'],
'Campaña' => $row['Campaña'],
'Telefono2' => $row['Telefono2'],
'Observaciones' => $row['Observaciones'],
'Segmento' => $row['Segmento'],
'NombreCompleto' => $row['NombreCompleto'],
'Vueltas' => (int) $row['Vueltas'],
'Origen' => $row['Origen'],
'Departamento' => $row['Departamento'],
'Provincia' => $row['Provincia'],
'Distrito' => $row['Distrito'],
'Accion' => $row['Accion'],
'FechaHoraCotizacion' => $row['FechaHoraCotizacion'],
'Contacto' => $row['Contacto'],
'SubTipificacion' => $row['SubTipificacion'],
'GestorUltimo' => $row['GestorUltimo'],
'ultimoNombreGestor'=>$row['ultimoNombreGestor'],
'Remarketing' =>$row['Remarketing'],
'FechaHoraRellamada'=>$row['FechaHoraRellamada'],
'FechaUltimaGestion'=>$row['FechaUltimaGestion'],
'Linea'=>$contador,
'Gestionable'=>$row['Gestionable'],
'Zonas'=>$row['Zonas'],
'Canal'=>$row['Canal'],
'GestorRemarketing'=>$row['GestorRemarketing'],
'NombreGestorRemarketing' =>$row['NombreGestorRemarketing'],
'FechaHoraRemarketing'=>$row['FechaHoraRemarketing']
                	);
$contador++;            
        }
        
	    $query = "SELECT COUNT(IdLeadCC) AS found_rows FROM leadsreferidos".$where;
		$result =  $this->db->prepare($query);
		$result->execute();
		$rows=$result->fetch(PDO::FETCH_ASSOC); 
		$total_rows = $rows['found_rows'];
        if ($new_total_rows > 0) $total_rows = $new_total_rows;	        

        if ($total_rows > 0){
            $data[] = array(
            	'TotalRows' => $total_rows,
            	'Rows' => array_map(null,$orders),
            	'mensaje' => '',
            	'tipo' =>1
            );
            
        } else {
            $data[] = array(
        	'TotalRows' => 0,
        	'Rows' => null,
        	'mensaje' => '<div class="callout bg-gray">
                            <h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>
                       <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>
                        <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>
                        <br>
            </div>',
        	'tipo' =>0
        	);
        }
        
        
        return $data;


	}	
	
    
}