<?php

class ConexionGuiaDavid
{


	private $db;
	private $usuario;

	function __construct()
	{

		$this->db =  Database::connect();

	}

//

	public function ListarGuiaAnulacion($function)
	{
        $new_total_rows = 0;
        $contador=1;
        
        $pagenum=htmlspecialchars(filter_var($function->pagenum, FILTER_SANITIZE_NUMBER_INT));
        $pagesize=htmlspecialchars(filter_var($function->pagesize, FILTER_SANITIZE_NUMBER_INT));
        
        $starts = $pagenum * $pagesize;
        

        $queryexec="SELECT id, fechasolicitud, matriculasolicitante, nguia, motivoanulacion, contrato, estado FROM dbGUIAREMISION.anulacion";
        
        $query = $queryexec." LIMIT :starts,:pagesize";


        $where="";
        // filter data.
        if (isset($function->filterscount))
        {
        	$filterscount = htmlspecialchars($function->filterscount);
        			
        	if ($filterscount > 0)
        	{
        		$where = " WHERE (";
        		$tmpdatafield = "";
        		$tmpfilteroperator = "";
        		for ($i=0; $i < $filterscount; $i++)
        		{
        			// get the filter's value.
        			$filtervalue = htmlspecialchars($function->{"filtervalue".$i});
        			// get the filter's condition.
        			$filtercondition =htmlspecialchars($function->{"filtercondition".$i});
        			// get the filter's column.
        			$filterdatafield =htmlspecialchars($function->{"filterdatafield".$i});
        			// get the filter's operator.
        			$filteroperator =htmlspecialchars($function->{"filteroperator".$i});
        					
        			if ($tmpdatafield == "")
        			{
        				$tmpdatafield = $filterdatafield;			
        			}
        			else if ($tmpdatafield <> $filterdatafield)
        			{
        					if ($tmpfilteroperator == 2){
            					$where.= " OR ";
            				}else{ 
            				    $where.= ") AND (";
            				}
        			}
        			else if ($tmpdatafield == $filterdatafield)
        			{
        				    if ($tmpfilteroperator == 0){
            					$where.= " AND ";
            				}else{ 
            				    $where.= " OR ";
            				}	
        			}
        					
        			// build the "WHERE" clause depending on the filter's condition, value and datafield.
        			switch($filtercondition)
        			{
        				case "CONTAINS":
        					$where .= " " . $filterdatafield . " LIKE '%" . $filtervalue ."%'";
        					break;
        				case "DOES_NOT_CONTAIN":
        					$where .= " " . $filterdatafield . " NOT LIKE '%" . $filtervalue ."%'";
        					break;
        				case "EQUAL":
        					$where .= " " . $filterdatafield . " = '" . $filtervalue ."'";
        					break;
        				case "NOT_EQUAL":
        					$where .= " " . $filterdatafield . " <> '" . $filtervalue ."'";
        					break;
        				case "GREATER_THAN":
        					$where .= " " . $filterdatafield . " > '" . $filtervalue ."'";
        					break;
        				case "LESS_THAN":
        					$where .= " " . $filterdatafield . " < '" . $filtervalue ."'";
        					break;
        				case "GREATER_THAN_OR_EQUAL":
        					$where .= " " . $filterdatafield . " >= '" . $filtervalue ."'";
        					break;
        				case "LESS_THAN_OR_EQUAL":
        					$where .= " " . $filterdatafield . " <= '" . $filtervalue ."'";
        					break;
        				case "STARTS_WITH":
        					$where .= " " . $filterdatafield . " LIKE '" . $filtervalue ."%'";
        					break;
        				case "ENDS_WITH":
        					$where .= " " . $filterdatafield . " LIKE '%" . $filtervalue ."'";
        					break;
        				case "NULL":
        					$where .= " " . $filterdatafield . " IS NULL";
        					break;
        				case "NOT_NULL":
        					$where .= " " . $filterdatafield . " NOT NULL";
        					break;
        				case "GREATER_THAN_OR_EQUAL_TIME":
        					$where .= " " . $filterdatafield . " >= '" . $filtervalue ." 00:00:00'";
        					break;
        				case "LESS_THAN_OR_EQUAL_TIME":
        					$where .= " " . $filterdatafield . " <= '" . $filtervalue ." 23:59:59'";
        					break;
        					
        					
        			}
        									
        			if ($i == $filterscount - 1){
        				$where.= ")";
        			}
        					
        			$tmpfilteroperator = $filteroperator;
        			$tmpdatafield = $filterdatafield;			
        		}
        		$query = $queryexec." " .$where." LIMIT :starts,:pagesize";	
        		//var_dump($query);
        
        	}
        }
        if (isset($function->sortdatafield)){
        	$sortfield = htmlspecialchars($function->sortdatafield);
        	$sortorder = htmlspecialchars($function->sortorder);
        	$filterscount = htmlspecialchars($function->filterscount);
        	if ($sortorder != '')
        		{
        		if ($filterscount == 0)
        			{
        			if ($sortorder == "desc")
        				{
        				$query = $queryexec." ORDER BY" . " " . $sortfield . " DESC LIMIT :starts,:pagesize";
        				}
        			  else if ($sortorder == "asc")
        				{
        				$query = $queryexec." ORDER BY" . " " . $sortfield . " ASC LIMIT :starts,:pagesize";
        				}

        			}
        		else
        			{
        			if ($sortorder == "desc")
        				{
        				$filterquery.= " ORDER BY " . $sortfield . " DESC LIMIT :starts,:pagesize";
        				}
        			  else if ($sortorder == "asc")
        				{
        				$filterquery.= " ORDER BY " . $sortfield . " ASC LIMIT :starts,:pagesize";
        				}
        			$query = $queryexec." " .$where.$filterquery;
        			}
        		}
        }



		$result = $this->db->prepare($query); 
        $result->bindParam(':starts', $starts, PDO::PARAM_INT);
        $result->bindParam(':pagesize',$pagesize, PDO::PARAM_INT);		
		$result->execute(); 
		

        $orders = [];
        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            $orders[] = array(
            'id' => $row['id'],
            'fechasolicitud' => $row['fechasolicitud'],
            'matriculasolicitante' => $row['matriculasolicitante'],
            'nguia' => $row['nguia'],
            'motivoanulacion' => $row['motivoanulacion'],
            'contrato' => $row['contrato'],
            'estado' => $row['estado']
                	);
            $contador++;                	
            
        }

	    $query = "SELECT COUNT(*) AS found_rows FROM dbGUIAREMISION.anulacion ".$where;
		$result =  $this->db->prepare($query);
		$result->execute();
		$rows=$result->fetch(PDO::FETCH_ASSOC); 
		$total_rows = $rows['found_rows'];
        if ($new_total_rows > 0) $total_rows = $new_total_rows;	        

        if ($total_rows > 0){
            $data[] = array(
            	'TotalRows' => $total_rows,
            	'Rows' => array_map(null,$orders),
            	'mensaje' => '',
            	'tipo' =>1
            );
            
        } else {
            $data[] = array(
        	'TotalRows' => 0,
        	'Rows' => null,
        	'mensaje' => '<div class="callout bg-gray">
                            <h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>
                       <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>
                        <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>
                        <br>
            </div>',
        	'tipo' =>0
        	);
        }
        
        
        return $data;


	} 

    public function insertarGuia($fechasolicitud, $matriculasolicitante=null, $nguia=null, $motivoanulacion, $contrato=null, $estado){
    
        $query = $this->db->prepare("INSERT INTO dbGUIAREMISION.anulacion(fechasolicitud, matriculasolicitante, nguia, motivoanulacion, contrato, estado) VALUES (?,?,?,?,?,?)");
        $query->execute(array($fechasolicitud, $matriculasolicitante, $nguia, $motivoanulacion, $contrato, $estado));
        $respuesta = $this->db->lastInsertId(); 
        return $respuesta;
    }	

    public function actualizarGuiaMasiva($id,$estado){
        
        $query = $this->db->prepare("UPDATE dbGUIAREMISION.anulacion SET estado=? WHERE id=?");
        $query->execute(array($estado,$id));
        $respuesta = $query->rowCount();
        
        return $respuesta;
    }

//

	public function getDatosClientesVentas($contrato)
	{


        $query = $this->db->prepare("SELECT 
        v.NContrato,
        c.NombApellido Cliente,
        sc.Nombres as NombresScoring,
        sc.ApellidoPaterno as ApellidoPaternoScoring,
        sc.ApellidoMaterno as ApellidoMaternoScoring,
        sc.TipoDocumento as TipoDocumentoScoring,
        sc.NumeroDocumento as DocumentoScoring
        FROM dbVENTAS.tblventa v 
        INNER JOIN dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente
        INNER JOIN dbVENTAS.tbltmpscoring sc on sc.IdConsultaScoring=v.IdConsultaScoringRP
        WHERE v.NContrato= ?");
        $query->execute(array($contrato));
        
		$retorno = [];
		while ($fila = $query->fetch(PDO::FETCH_ASSOC)) {
			$retorno[] = $fila;
		}
		return $retorno;

	}


	public function getAfiliacionVisa_MasterCard($contrato)
	{


        $query = $this->db->prepare("SELECT status,ACTION_DESCRIPTION,dataMap FROM dbREFERIDO.tblafiliacion where beneficiaryId= ?");
        $query->execute(array($contrato));
        
		$retorno = [];
		while ($fila = $query->fetch(PDO::FETCH_ASSOC)) {
			$retorno[] = $fila;
		}
		return $retorno;

	}
	
	public function getAfiliacionOtros($contrato)
	{
		

        $query = $this->db->prepare("SELECT id,status,motivo,numero,tipo,correo FROM dbREFERIDO.tblmdpafiliacion where ncontrato= ?");
        $query->execute(array($contrato));
        
		$retorno = [];
		while ($fila = $query->fetch(PDO::FETCH_ASSOC)) {
			$retorno[] = $fila;
		}

		return $retorno;

	}
	
    public function actualizarAfiliacion($idafiliacion,$lblstatusafiliacion,$lblmotivoafiliacion,$fechahoramod){
    
        $query = $this->db->prepare("UPDATE dbREFERIDO.tblmdpafiliacion SET status=?,motivo=?,fechahoramod=? WHERE id = ?");
        $query->execute(array($lblstatusafiliacion,$lblmotivoafiliacion,$fechahoramod,$idafiliacion));
        $respuesta = $query->rowCount();
        
        return $respuesta;
    }

    public function actualizarAfiliacionOtros($idafiliacionotros,$lblstatusafiliacion){
    
        $query = $this->db->prepare("UPDATE dbREFERIDO.tblafiliacionotros SET status=? WHERE id = ?");
        $query->execute(array($lblstatusafiliacion,$idafiliacionotros));
        $respuesta = $query->rowCount();
        
        return $respuesta;
    }
    public function findAfiliacionOtros($ncontrato){
    
        $query = $this->db->prepare("SELECT id FROM dbREFERIDO.tblafiliacionotros WHERE contrato=? order by 1 desc limit 1");
        $query->execute(array($ncontrato));
        
        $row = $query->fetch(PDO::FETCH_ASSOC);
        if(count($row)>0){
            $retorno=$row['id'];
        }else{
            $retorno=0;
        }
        
		return $retorno;
    }
    
    public function SeleccionarItem($coditem)
	{
		

        $query = $this->db->prepare("SELECT coditem FROM dbGUIAREMISION.item where coditem= ?");
        $query->execute(array($coditem));
        
		$retorno = [];
		while ($fila = $query->fetch(PDO::FETCH_ASSOC)) {
			$retorno[] = $fila;
		}

		return $retorno;

	}
	
	public function validaMatricula($matricula)
	{

        $query = $this->db->prepare("SELECT CC, CONCAT(Nombres, ' ', Apellidos) AS NombreTecnico FROM dbUSUARIO.tblusuario where Matricula= ?");
        $query->execute(array($matricula));
        
		$retorno = [];
		while ($fila = $query->fetch(PDO::FETCH_ASSOC)) {
			$retorno[] = $fila;
		}

		return $retorno;

	}

  

}
