<?php

class ConexionFacturacion
{


	private $db;
	private $usuario;

	function __construct()
	{

		$this->db =  Database::connect();

		// $this->db = new mysqli('localhost','root','','prueba');

	}

    /* LISTAR Facturacion*/
	public function mostrarTodosFacturacion($function)
	{
        $new_total_rows = 0;
        $contador=1;
        
        $pagenum=htmlspecialchars(filter_var($function->pagenum, FILTER_SANITIZE_NUMBER_INT));
        $pagesize=htmlspecialchars(filter_var($function->pagesize, FILTER_SANITIZE_NUMBER_INT));
        
        $starts = $pagenum * $pagesize;
        

        $queryexec="SELECT
IdVenta,
EstadoVenta,
TipoVenta,
DC,
IdUsuario,
Matricula,
Comercial,
TCGestor,
Segmento,
NProspecto,
NContrato,
Cliente,
CategoriaVenta,
PrecioKit,
TotalExtra,
ExtraAutorizado,
N590,
InstaladoX,
FechaInst,
HoraInst,
FechaFacturacion,
FechaRecepcionDOC,
MotivoIncidencia
FROM factgeneral";
        $query = $queryexec." LIMIT :starts,:pagesize";


        $where="";
        // filter data.
        if (isset($function->filterscount))
        {
        	$filterscount = htmlspecialchars($function->filterscount);
        			
        	if ($filterscount > 0)
        	{
        		$where = " WHERE (";
        		$tmpdatafield = "";
        		$tmpfilteroperator = "";
        		for ($i=0; $i < $filterscount; $i++)
        		{
        			// get the filter's value.
        			$filtervalue = htmlspecialchars($function->{"filtervalue".$i});
        			// get the filter's condition.
        			$filtercondition =htmlspecialchars($function->{"filtercondition".$i});
        			// get the filter's column.
        			$filterdatafield =htmlspecialchars($function->{"filterdatafield".$i});
        			// get the filter's operator.
        			$filteroperator =htmlspecialchars($function->{"filteroperator".$i});
        					
        			if ($tmpdatafield == "")
        			{
        				$tmpdatafield = $filterdatafield;			
        			}
        			else if ($tmpdatafield <> $filterdatafield)
        			{
        					if ($tmpfilteroperator == 2){
            					$where.= " OR ";
            				}else{ 
            				    $where.= ") AND (";
            				}
        			}
        			else if ($tmpdatafield == $filterdatafield)
        			{
        				    if ($tmpfilteroperator == 0){
            					$where.= " AND ";
            				}else{ 
            				    $where.= " OR ";
            				}	
        			}
        					
        			// build the "WHERE" clause depending on the filter's condition, value and datafield.
        			switch($filtercondition)
        			{
        				case "CONTAINS":
        					$where .= " " . $filterdatafield . " LIKE '%" . $filtervalue ."%'";
        					break;
        				case "DOES_NOT_CONTAIN":
        					$where .= " " . $filterdatafield . " NOT LIKE '%" . $filtervalue ."%'";
        					break;
        				case "EQUAL":
        					$where .= " " . $filterdatafield . " = '" . $filtervalue ."'";
        					break;
        				case "NOT_EQUAL":
        					$where .= " " . $filterdatafield . " <> '" . $filtervalue ."'";
        					break;
        				case "GREATER_THAN":
        					$where .= " " . $filterdatafield . " > '" . $filtervalue ."'";
        					break;
        				case "LESS_THAN":
        					$where .= " " . $filterdatafield . " < '" . $filtervalue ."'";
        					break;
        				case "GREATER_THAN_OR_EQUAL":
        					$where .= " " . $filterdatafield . " >= '" . $filtervalue ."'";
        					break;
        				case "LESS_THAN_OR_EQUAL":
        					$where .= " " . $filterdatafield . " <= '" . $filtervalue ."'";
        					break;
        				case "STARTS_WITH":
        					$where .= " " . $filterdatafield . " LIKE '" . $filtervalue ."%'";
        					break;
        				case "ENDS_WITH":
        					$where .= " " . $filterdatafield . " LIKE '%" . $filtervalue ."'";
        					break;
        				case "NULL":
        					$where .= " " . $filterdatafield . " IS NULL";
        					break;
        				case "NOT_NULL":
        					$where .= " " . $filterdatafield . " NOT NULL";
        					break;
        				case "GREATER_THAN_OR_EQUAL_TIME":
        					$where .= " " . $filterdatafield . " >= '" . $filtervalue ." 00:00:00'";
        					break;
        				case "LESS_THAN_OR_EQUAL_TIME":
        					$where .= " " . $filterdatafield . " <= '" . $filtervalue ." 23:59:59'";
        					break;
        					
        					
        			}
        									
        			if ($i == $filterscount - 1){
        				$where.= ")";
        			}
        					
        			$tmpfilteroperator = $filteroperator;
        			$tmpdatafield = $filterdatafield;			
        		}
        		$query = $queryexec." " .$where." LIMIT :starts,:pagesize";	
        		//var_dump($query);
        
        	}
        }
        if (isset($function->sortdatafield)){
        	$sortfield = htmlspecialchars($function->sortdatafield);
        	$sortorder = htmlspecialchars($function->sortorder);
        	$filterscount = htmlspecialchars($function->filterscount);
        	if ($sortorder != '')
        		{
        		if ($filterscount == 0)
        			{
        			if ($sortorder == "desc")
        				{
        				$query = $queryexec." ORDER BY" . " " . $sortfield . " DESC LIMIT :starts,:pagesize";
        				}
        			  else
        				{
        				$query = $queryexec." ORDER BY" . " " . $sortfield . " ASC LIMIT :starts,:pagesize";
        				}

        			}
        		else
        			{
        			if ($sortorder == "desc")
        				{
        				$filterquery.= " ORDER BY " . $sortfield . " DESC LIMIT :starts,:pagesize";
        				}
        			  else
        				{
        				$filterquery.= " ORDER BY " . $sortfield . " ASC LIMIT :starts,:pagesize";
        				}
        			$query = $queryexec." " .$where.$filterquery;
        			}
        		}
        }



		$result = $this->db->prepare($query); 
        $result->bindParam(':starts', $starts, PDO::PARAM_INT);
        $result->bindParam(':pagesize',$pagesize, PDO::PARAM_INT);		
		$result->execute(); 
		

        $orders = [];
        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            $orders[] = array(

'IdVenta' => $row['IdVenta'],
'EstadoVenta' => $row['EstadoVenta'],
'TipoVenta' => $row['TipoVenta'],
'DC' => $row['DC'],
'IdUsuario' => $row['IdUsuario'],
'Matricula' => $row['Matricula'],
'Comercial' => $row['Comercial'],
'TCGestor' => $row['TCGestor'],
'Segmento' => $row['Segmento'],
'NProspecto' => $row['NProspecto'],
'NContrato' => $row['NContrato'],
'Cliente' => $row['Cliente'],
'CategoriaVenta' => $row['CategoriaVenta'],
'PrecioKit' => $row['PrecioKit'],
'TotalExtra' => $row['TotalExtra'],
'ExtraAutorizado' => $row['ExtraAutorizado'],
'N590' => $row['N590'],
'InstaladoX' => $row['InstaladoX'],
'FechaInst' => $row['FechaInst'],
'HoraInst' => $row['HoraInst'],
'FechaFacturacion' => $row['FechaFacturacion'],
'FechaRecepcionDOC' => $row['FechaRecepcionDOC'],
'MotivoIncidencia' => $row['MotivoIncidencia'],
                	);
$contador++;                	
            
        }
        
	    $query = "SELECT COUNT(*) AS found_rows FROM factgeneral ".$where;
		$result =  $this->db->prepare($query);
		$result->execute();
		$rows=$result->fetch(PDO::FETCH_ASSOC); 
		$total_rows = $rows['found_rows'];
        if ($new_total_rows > 0) $total_rows = $new_total_rows;	        

        if ($total_rows > 0){
            $data[] = array(
            	'TotalRows' => $total_rows,
            	'Rows' => array_map(null,$orders),
            	'mensaje' => '',
            	'tipo' =>1
            );
            
        } else {
            $data[] = array(
        	'TotalRows' => 0,
        	'Rows' => null,
        	'mensaje' => '<div class="callout bg-gray">
                            <h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>
                       <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>
                        <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>
                        <br>
            </div>',
        	'tipo' =>0
        	);
        }
        
        
        return $data;


	} 


}
