<?php

    session_start();

    date_default_timezone_set('America/Lima');
    
    include '../config/db.php';
    include '../config/conexion.php';

    if (!isset($_SESSION['user_login_status'])) {
        header("location: ../login/index.php");
		exit;
    }

?>
<!DOCTYPE html>
<html>
<html lang="en">
<head>
      <meta charset="UTF-8">
      <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <meta http-equiv="X-UA-Compatible" content="ie=edge">
      <title>Geofinder Unity - Widget</title>

	  <!-- Estilos 1 -->
      <link rel="stylesheet" href="./css/geofinderjs.css"/>
      <link rel="stylesheet" href="./css/gfmain.css">
      <link rel="stylesheet" href="./css/gfpersonalizado.css"/>
      <link rel="stylesheet" href="./css/gfpanelbusqueda.css">
      <link rel="stylesheet" href="./css/gfautocomplete.css">
      <link rel="stylesheet" href="./css/gflayout.css">
      <link rel="stylesheet" href="./css/custom.css">
      <link rel="stylesheet" href="./css/bootstrap.min.css">
      <link rel="stylesheet" type="text/css" href="css/gfstyle.css"/>
      <link rel="stylesheet" type="text/css" href="css/styles.css"/>
      <link rel="stylesheet" type="text/css" href="css/nav.css"/>
      <link   rel="stylesheet" href="css/MarkerCluster.Default.css">
      <link   rel="stylesheet" href="css/MarkerCluster.css">

      <!-- JavaScript 1 -->
      <script type="text/javascript" src="./js/geofinderjs.js"></script>
      <script type="text/javascript" src="./js/jquery.min.js"></script>
      <script type="text/javascript" src="./js/bootstrap.min.js"></script>
      <script type="text/javascript" src="./js/jquery-ui.min.js"></script>
      <script type="text/javascript" src="./js/panels-controller.js"></script>
      <script type="text/javascript" src="./js/gf-autocomplete.js"></script>
      <script type="text/javascript" src="./js/L.Control.Locate.js" ></script>
      <script type="text/javascript" src="./js/leaflet.markercluster.js" ></script>
      <script type="text/javascript" src="./js/logeoApigee.js" ></script>
	  <!-- Estilos 2 -->
      <link   href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css"
	          rel= "stylesheet">
      <link   rel="stylesheet" href="css/styles.css">
      <link   rel="stylesheet" href="css/modal_style.css">






	  <!-- Estilos 3 -->
      <style type="text/css">
      .leaflet-control-locate {
         a {
          font-size: 1.4em;
          color: #444;
          cursor: pointer;
          top: 80px;
        }
          &.active {
          a {
          color: #2074B6;
            }

          &.following {
          a {
          color: #FC8428;
			}
          }
        }
      }



      </style>


</head>
 <body>

		<!-- Búsqueda Estructurada - Inicio -->
        <nav class="nav" style="position: absolute; top: 50px;">
          <div id="formcont" style="text-align: center;">
            <div id="form">
              </div>
            </div>
          </nav>

        <nav class="nav_background" style="position: absolute; top: 51px;"></nav>
		<!-- Búsqueda Estructurada - Fin -->

		<!-- Contenedor usado por la librería css/modal_style.css - Inicio -->
          <div class="md-overlay"></div>
		<!-- Contenedor usado por la librería css/modal_style.css - Fin -->

		<!-- Div que contiene los controles para la búsqueda intuitiva - Inicio -->
           <div class="container-fluid">
              <div class="row">
                <div class="col-md-12 gf_map">
				  <!-- Logo Geofinder -->
                  <div class="logo_container">
                    <svg xmlns="http://www.w3.org/2000/svg" id="Capa_1" data-name="Capa 1" viewBox="0 0 389.41 113.88"><defs><style>.cls-1{fill:#4b8b33;}.cls-1,.cls-4{fill-rule:evenodd;}.cls-2,.cls-3{font-size:38.1px;}.cls-2,.cls-3,.cls-4{fill:#1d1d1b;}.cls-2{font-family:OpenSans-Bold, Open Sans;font-weight:700;}.cls-3{font-family:OpenSans-Light, Open Sans;font-weight:300;}.cls-4{opacity:0.6;}</style></defs><path class="cls-1" d="M94.32,52.37h0a21.32,21.32,0,1,1,21.32,21.32A21.33,21.33,0,0,1,94.32,52.37Z"/><text class="cls-2" transform="translate(141.69 67.93)">Geo</text><text class="cls-3" transform="translate(215.38 67.93)">ﬁnder</text><path class="cls-4" d="M115.86,23.87h0m0,0a35.39,35.39,0,0,1-13.7,26.33L82.32,65.61a29.52,29.52,0,0,1-4.56-3.35l6.69-6.7a1.35,1.35,0,0,0,0-1.82,1.29,1.29,0,0,0-1.77,0L76,60.45A30.05,30.05,0,0,1,72.72,56L89,36a35.48,35.48,0,0,1,25.26-13.09l1.18-.08a.48.48,0,0,1,.32.12.59.59,0,0,1,.12.31ZM98.26,61.43a18.86,18.86,0,0,1-5.54,13.44l-5.44,5.44-.74-14.74,11.72-9.11ZM77.21,67.26c-.63.56-1.34,1.11-2,1.62A14.15,14.15,0,0,1,72,66.44a14.72,14.72,0,0,1-2.36-3.2L72.37,60A33.77,33.77,0,0,0,75,63.17a37,37,0,0,0,3.51,3C78.11,66.52,77.64,66.87,77.21,67.26ZM58.12,51.1l5.43-5.44A18.84,18.84,0,0,1,77,40.11l5.28.15L72.84,51.85Zm59.43-29.95a3,3,0,0,0-2.24-.87l-1.18.08a38.11,38.11,0,0,0-27.08,14l-2.8,3.43L77,37.58h0a21.48,21.48,0,0,0-15.23,6.31L54.3,51.34A1.4,1.4,0,0,0,54,52.68a1.35,1.35,0,0,0,1.15.83l15.7.79-.63.78a1.35,1.35,0,0,0-.16,1.42c.28.44.51.91.79,1.34l-3.74,4.42A1.37,1.37,0,0,0,67,63.64a16.39,16.39,0,0,0,3.23,4.57,15.75,15.75,0,0,0,4.69,3.31,1.08,1.08,0,0,0,1.33-.16C77,70.73,78,70,78.82,69.2c.67-.52,1.3-1.07,1.93-1.58a9.82,9.82,0,0,0,1.1.63,1.12,1.12,0,0,0,.59.16,1.2,1.2,0,0,0,.79-.28l.87-.67.78,15.85a1.35,1.35,0,0,0,.83,1.1,1.93,1.93,0,0,0,.47.08,1.25,1.25,0,0,0,.87-.35l7.44-7.45a21.57,21.57,0,0,0,6.29-15.26V54.49l3-2.28A38.12,38.12,0,0,0,118.42,24v-.63A2.85,2.85,0,0,0,117.55,21.15Z"/></svg>
                  </div>

				  <!-- Logo País -->
                  <div class="dropdown">
                    <img src="css/images/pe-flag-round.png" id="currentCountry" class="dropbtn" style="width: 30px; height: 30px;">
                      <div class="dropdown-content">
                    </div>
                  </div>

                <div id="searchBox" class="searchBox__top">
                  <div class="searchBox__container" >
                    <div class="input-group">
                      <div class="btn-group" id="srch_add_btn_group">

                          <!-- Botón de Despliegue de Búsqueda Avanzada búsqueda -->
                          <div class="nav-toggle" style="z-index:15;">
                            <div class="nav-toggle-bar" style="z-index: 15;"> </div>
                          </div>

                          <!-- Control de entrada de texto para búsqueda -->
                          <div class="gf-autocomplete search-control-center">
                            <input class="field__input" id="gf-search" type="text" name="busqueda" placeholder="Ciudad, calle, dirección, código postal, etc." autocomplete="off"  autocorrect="off" autocapitalize="off"
                             style="border: 1px solid #a2a8ad; background-color: rgba(255, 255, 255, 0.8);" >
                            <span  id="searchclear" class="glyphicon glyphicon-remove-circle" style="display: none;"></span>
                          </div>

                       </div>
                      </div>
                    </div>
                  </div>
                          <!-- Termina bloque de Panel de Búsqueda Avanzada -->
                  <div class="top_search_bar">

                  </div>
                </div>
              </div>
            </div>
		<!-- Div que contiene los controles para la búsqueda intuitiva - Fin -->

		<!-- Div que contiene el control donde se cargará el mapa - Inicio -->
                <div id="mapcontainer">
                  <div id="map" style="z-index: 1; position: absolute; top: 0px; left: 0px;"></div>
                </div>
		<!-- Div que contiene el control donde se cargará el mapa - Fin -->

    <!-- SweetAlert -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@8"></script>
	  <!-- Javascript 2 -->
      <script type="text/javascript">
        returnToken();
        returnTokennyg();
		// Seteo de País
        var country = "pe";

		// Token autorizado para poder navegar con el widget
        var token = "ENTER_KEY_HERE";

		// Servicio de consulta de direcciones
        var amspath = "https://api.latam.equifax.com/geoapi/autocomplete/pe";
        var nygpath = "https://api.latam.equifax.com/geoapi/nyg/pe";


		// Función utilizada para la búsqueda intuitiva
        gfAutocomplete(document.getElementById("gf-search"),token,country);

          //Array que contiene las zonas relacionadas al token; ejemplo: cliente_zona_country, cliente_secciones_country, cliente_puntos_country;
        //Este array pinta las capas personalizadas en el mapa.
        var capas = Array();
        direccion = {};

        //funcion javascript de control el cual puede ser enviado como parametro//
        var controler =  function (parametro) {
        }

		// Función que hace las llamadas al mapa
        geofinderjs.visualizar("map","form",token,true,false,capas,direccion,controler,country);

		// Función que envía el resultado de la búsqueda con el botón confirmar
		// a la consola del navegador
            function confirmar() {
            
            let respuesta = geofinderjs.resultado;
            let ObjGeofinder = JSON.stringify(respuesta);
            
            console.log(ObjGeofinder);
            
            //ObjGeofinder = mysql_real_escape_string(ObjGeofinder);
            
            ObjGeofinder = ObjGeofinder.replaceAll("UNION", "U/N/I/O/N");
            
            console.log(ObjGeofinder);
            
            ObjGeofinderRegular = ObjGeofinder.replaceAll("U/N/I/O/N", "UNION");
            
            console.log(ObjGeofinderRegular);
            
            //ObjGeofinder = sql_escape_String(ObjGeofinder);
            
            //console.log(ObjGeofinder);
            
            //return;
            
            
            $.ajax({
                url: '../ajax/insertLogGeofinder.php',
                method:"POST",
                data: {ObjGeofinder: ObjGeofinder},
                dataType:"json",
                success:function(data){
                    console.log(data);
                }
            })
            
            Swal.fire(
              'Good job!',
              ObjGeofinder,
              'success'
            )
            
            

        }



        //Visualizacion de los Puntos/Marcadores
        /*
        Las variables ModeView y levelZoom, ayudan a la visualizacion de los
        puntos/marcadores asociados al cliente
        Para la variable ModeView los Valores aceptables son:
        ZOOM -> No muestra marcadores hasta llegar a un determinado nivel de zomm,
                luego de lo cual mostrara todos los marcadores/puntos
        GROUP -> Agrupa los marcadores segun la cercania, los marcadores se podran visualizar
                desde la carga del mapa y no se necesita configurar la variable LevelZoom

        Para la variable LevelZoom los valores posibles van desde 5 hasta 18,
        siendo estos el nivel de zoom
        */
        var ModeView = 'GROUP'
        var LevelZoom = 18

      </script>
    <script>
        function mysql_real_escape_string (str) {
            return str.replace(/[\0\x08\x09\x1a\n\r"'\\\%]/g, function (char) {
                switch (char) {
                    case "\0":
                        return "\\0";
                    case "\x08":
                        return "\\b";
                    case "\x09":
                        return "\\t";
                    case "\x1a":
                        return "\\z";
                    case "\n":
                        return "\\n";
                    case "\r":
                        return "\\r";
                    case "\"":
                    case "'":
                    case "\\":
                    case "%":
                        return "\\"+char; // prepends a backslash to backslash, percent,
                                          // and double/single quotes
                    default:
                        return char;
                }
            });
        }
        
        /*
        function sql_escape_String(str){
            return str.replace('union', 'uni-on');
        }
        */
    </script>

	  <!-- Javascript 3 -->
      <script  src="js/index.js"></script>
      <script  src="js/nav.js"></script>
      <link rel="stylesheet" href="css/imagelayers.css">
</body>
</html>