<?php
require dirname(__DIR__).'/ajax/is_logged.php';
require dirname(__DIR__).'/Connection/Conection.php';
require dirname(__DIR__).'/Model/ConexionTVReferidos.php';

date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date){
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date){
    return date('Y-m-d', strtotime($date));
}


if (isset($_POST['function']) && !empty($_POST['function'])) {

    $function = json_decode($_POST['function']);

    switch ($function->array) {
        case 'array1':
            $consulta = new TVReferidos;
            $consulta->ObtenerIdReferido();
            break;
        case 'array2':
            $consulta = new TVReferidos;
            $consulta->InsertarReferidoVenta();
            break;
        case 'array3':
            $consulta = new TVReferidos;
            $consulta->ListarReferidos();
            break;
        case 'array4':
            $consulta = new TVReferidos;
            $consulta->ObtenerTelefono();
            break;            
        case 'array5':
            $consulta = new TVReferidos;
            $consulta->ObtenerDatosUsuario();
            break;
        case 'array6':
            $consulta = new TVReferidos;
            $consulta->ActualizarClienteProspecto();
            break;
        case 'array7':
            $consulta = new TVReferidos;
            $consulta->ListarGestores();
            break;            
        default:
            echo "Error no se encontro la data";
            break;
    }

}



class TVReferidos
{

    public function ObtenerIdReferido()
    {
        $function = json_decode($_POST['function']);
        $id=htmlspecialchars($function->id);
        
        $conexion = new ConexionTVReferidos();

		$datos = $conexion->getReferido($id);
		
        print_r(json_encode($datos));
        
    }

    public function ObtenerDatosUsuario()
    {
        $function = json_decode($_POST['function']);
        $matricula=htmlspecialchars($function->matricula);
        
        $conexion = new ConexionTVReferidos();

		$datos = $conexion->getUsuario($matricula);
		
        print_r(json_encode($datos));
        
    }

    public function ObtenerTelefono()
    {
        $function = json_decode($_POST['function']);
        $telefono=htmlspecialchars($function->telefono);
        
        $conexion = new ConexionTVReferidos();

		$datosBuscar=$conexion->getTelefonoReferido($telefono);
		   if(!empty($datosBuscar)){
		    $datos[] = array(
            	'TotalRows' => count($datosBuscar),
            	'Rows' => array_map(null,$datosBuscar),
            	'mensaje' => '',
            	'tipo' =>1
            );	
		   }else{
		    $datos[] = array(
            	'TotalRows' => 0,
            	'Rows' => null,
            	'mensaje' => '<div class="callout bg-gray">
                                <h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>
                           <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>
                            <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>
                            <br>
                </div>',
            	'tipo' =>0
            );		       
		   }
	   
        print_r(json_encode($datos));
        
    }
    
    public function InsertarReferidoVenta()
    {
        $function = json_decode($_POST['function']);
       
        $ingresokit=0;
        $ingresoextras=0;
        $ingresototal=0;
        
        
        $matriculausuario=$function->gestorbackoffice;
        $categoria=NULL;

        $TCTipoVenta=($function->lbldcz==512 ? 'Televenta':'Telecierre');
        
        $tipotvz=$function->lbltipotvz;
        
        $matricula=$function->lblmatriculaz;
        $nombcomercial=$function->lblnombcomercialz;
        $dc=$function->lbldcz;
        $jefeventa=$function->lbljefeventaz;
        $tipoventa=$function->lbltipoventaz;
        $asignado=$function->lblasignadoz;
        $segmento=$function->lblsegmentoz;
        $estadoventa=NULL;
        $direccion=NULL;
        $distrito=$function->lbldistritoz;
        //$nprospecto=$function->lblnprospectoz;
        $nprospecto=NULL;
        $mesesautorizados=0;
        $preciokit=0;
        $totalextra=0;
        $extraautorizado=NULL;
        $formadepago=NULL;
        $n590=NULL;
        $PAI=NULL;
        $leadid=$function->lblleadidz;
        
        $estadotelecierre=NULL;
        
        $fecharegistroagenda = date("Y-m-d H:i:s");
        $fecharegistrofacturacion = date("Y-m-d H:i:s");
        $fecharegistroventa = date("Y-m-d H:i:s");
        
        $GestionOrigen = 'VENTA';
        
        $nombcliente=$function->lblnombclientez;
        $telefonouno=$function->lblmovilz;
        $telefonodos=$function->lblfijoz;
        $correo=NULL;
        $idusuario=$function->lblidusuarioz;
        $resumenventa=NULL;
        
        $mesteleventa=$function->lbl590z;
        
        $prioridad= "Alta";
        $HabilitadoTV = "SI";
        
        $idreferido=$function->lblidreferido;
        $origen=($function->lbldcz==512 ? 'REFERIDO TELEVENTA':'REFERIDO TELECIERRE');
        
        
        $conexion = new ConexionTVReferidos();
        
        
        $idCli=$conexion->insertCliente($distrito,$nombcliente,$telefonouno,$correo,$direccion,$segmento);

		if($idCli>0){
		    $idVen=$conexion->insertVenta($idusuario,$idCli,$matricula,$nombcomercial,$dc,$jefeventa,$categoria,$tipoventa,$segmento,$nprospecto,$preciokit,$totalextra,$ingresokit,$ingresoextras,$ingresototal,$estadoventa,$extraautorizado,$mesesautorizados,$n590,$formadepago,$PAI,$resumenventa,$fecharegistroventa,$matriculausuario,$TCTipoVenta,$estadotelecierre,$tipotvz,$asignado,$mesteleventa,$leadid,$prioridad,$HabilitadoTV,$origen);
		    if($idVen>0){
		        $sqlagenda=$conexion->insertAgenda($idVen,$fecharegistroagenda,$GestionOrigen);
                $sqlfacturacion=$conexion->insertFacturacion($idVen,$fecharegistrofacturacion,$GestionOrigen);
                $sqlreferido=$conexion->updateReferidoTCTV($idreferido,$matriculausuario,$fecharegistroventa,$idVen);
                
                $datos=array(
                "ID"=>$idVen,
                "resultado"=>'exito'
                );
		    }else{
    		    $datos=array(
                 "ID"=>null,
                 "resultado"=>'errorVenta'
                 );		        
		    }
		    
		}else{
		  $datos=array(
                "ID"=>null,
                "resultado"=>'errorCliente'
                );
		}

        print_r(json_encode($datos));
        


    }
    
    public function ListarReferidos()
    {
        $function = json_decode($_POST['function']);

        $conexion = new ConexionTVReferidos();
        
        $datos=$conexion->mostrarTodosReferido($function);

        print_r(json_encode($datos));
        
    }
    public function ActualizarClienteProspecto()
    {
        $function = json_decode($_POST['function']);

        $conexion = new ConexionTVReferidos();
        
        // $datos=$conexion->mostrarTodosReferido($function);
        //Nuevo prospecto
        $lblnprospectoz=$function->lblnprospectoz;
        //Antiguo prospecto
        $lblnprospecto=$function->lblnprospecto;
        
        $lblnombclientez=$function->lblnombclientez;
        $lblcorreoz=$function->lblcorreoz;
        $lbldireccionz=$function->lbldireccionz;
        $lbldistritoz=$function->lbldistritoz;
        $lblfijoz=$function->lblfijoz;
        $lblidcliente=$function->lblidcliente;
        $lblidventa=$function->lblidventa;
        

        $afectacionprospecto=0;
        if($lblnprospectoz!=$lblnprospecto){
            if($lblnprospectoz=="" || empty($lblnprospectoz)){
                $afectacionprospecto=0;
            }else{
                $num_rows_prospecto=$conexion->findProspecto($lblnprospectoz);
                if($num_rows_prospecto>0){
                    $afectacionprospecto=-1;
                }else{
                    $afectacionprospecto=$conexion->updateVentaProspecto($lblidventa,$lblnprospectoz);
                }

            }
            
        }
        
        if($afectacionprospecto==-1){
            $datos=array(
                "respuesta"=>'duplicado'
                );
            
        }else{
            $afectacioncliente=$conexion->updateCliente($lblidcliente,$lbldistritoz,$lblnombclientez,$lblfijoz,$lblcorreoz,$lbldireccionz);
            
            if($afectacioncliente>0){
                $datos=array(
                "respuesta"=>'exito'
                );
            }
            else{
                $datos=array(
                "respuesta"=>'sincambios'
                );
            }

        }
        
        print_r(json_encode($datos));
        
    }    
        public function ListarGestores()
    {
        $function = json_decode($_POST['function']);
        
        $q=htmlspecialchars($function->term);
              
        $conexion = new ConexionTVReferidos();
        
        $datos=$conexion->listarGestoresMatricula($q);

        print_r(json_encode($datos));
        
    }
        

}


?>