<?php
// SESSION
require dirname(__DIR__).'/ajax/is_logged.php';

require dirname(__DIR__).'/Connection/Conection.php';
require dirname(__DIR__).'/Model/ConexionAgenda.php';


date_default_timezone_set('America/Lima');

if (isset($_POST['function']) && !empty($_POST['function'])) {

    $function = json_decode($_POST['function']);

    switch ($function->array) {
        case 'array1':
            $consulta = new Agenda;
            $consulta->MostrarTecnicos();
            break; 
        case 'array2':
            $consulta = new Agenda;
            $consulta->AsignarTecnicos();
            break; 
        case 'array3':
            $consulta = new Agenda;
            $consulta->ListarTecnicos();                      
            break;
        case 'array4':
            $consulta = new Agenda;
            $consulta->ListarTecnicosAsignados();                      
            break;
        case 'array5':
            $consulta = new Agenda;
            $consulta->CambiarEstadoTecnico();                      
            break;  
        case 'array6':
            $consulta = new Agenda;
            $consulta->AsignarArrayTecnicos();
            break;
        case 'array7':
            $consulta = new Agenda;
            $consulta->AsignarArrayDepartamentos();
            break; 
        case 'array9':
            $consulta = new Agenda;
            $consulta->ListarTecnicosTotal();
            break;
        case 'array10':
            $consulta = new Agenda;
            $consulta->CambiarEstadoZona();                      
            break;
        case 'array11':
            $consulta = new Agenda;
            $consulta->BusquedaDuplicidadAgendamiento();                      
            break;              
        default:
            echo "Error no se encontro la data";
            break;
    }

}

//CONFIGURACION ADICIONAL SELECT2
if (isset($_POST['json']) && !empty($_POST['json'])) {

    $function = json_decode($_POST['json']);

    switch ($function->array) {
        case 'array10':
            $consulta = new Agenda;
            $consulta->ListarSoloTecnicos();
            break;               
        default:
            echo "Error no se encontro la data";
            break;
    }

}



class Agenda
{

    public function MostrarTecnicos()
    {

        $conexion = new ConexionAgenda();

		$funcion = json_decode($_POST['function']);

		$matricula = $funcion->matricula; 

		$datos = $conexion->MostrarTecnicos($matricula);

        print_r(json_encode($datos));

    }

    public function AsignarTecnicos()
    {   
        $funcion = json_decode($_POST['function']);
        $conexion = new ConexionAgenda();
        $arrayMatricula = $funcion->arrayMatricula; 
        // foreach ($arrayMatricula as $key => $value) {
            // var_dump($value);
            $datos = $conexion->AsignacionTecnicos($arrayMatricula);
        // }
        // var_dump($arrayMatricula);
     
        print_r(json_encode($datos));

    }

    public function ListarTecnicos()
    {
        $conexion = new ConexionAgenda();

        $datos = $conexion->ListarTecnicos();
            
        print_r(json_encode($datos));
    }

    public function ListarTecnicosAsignados()
    {
        $conexion = new ConexionAgenda();
        
        // $idDepartamentoAsignado = $funcion->idDepartamentoAsignado; 
        
        
        // $proc_id_provedor =  ($id_provedor != "")? "AND id=$id_provedor":"";
        
        // $transacIdDepartamento = $idDepartamentoAsignado == " " ? '' :'AND aste.id_departamental = $idDepartamentoAsignado' ;

        $datos = $conexion->ListaTecnicosAsignados();
        

        print_r(json_encode($datos));

    }

    public function CambiarEstadoTecnico()
    {   
        $funcion = json_decode($_POST['function']);
        $conexion = new ConexionAgenda();
        $IdUsuario = $funcion->employee_id;
        $checked = $funcion->checked;
        $idestado=$funcion->idestado;

        $datos = $conexion->CambiarEstadoTecnico($IdUsuario,$idestado,$checked);
     
        print_r(json_encode($datos));

    }

    public function CambiarEstadoZona()
    {   
        $funcion = json_decode($_POST['function']);
        $conexion = new ConexionAgenda();
        $IdUsuario = $funcion->employee_id;
        $iddepartamental = $funcion->iddepartamental;
        $idestado=$funcion->idestado;

        $datos = $conexion->CambiarZonaTecnico($IdUsuario,$idestado,$iddepartamental);
     
        print_r(json_encode($datos));

    }    


    

    public function AsignarArrayTecnicos()
    {   
        $funcion = json_decode($_POST['function']);
        $conexion = new ConexionAgenda();
        $arrayMatricula = $funcion->arrayMatricula; 
        $idDepartamento = $funcion->idDepartamento; 
        foreach ($arrayMatricula as $key => $value) {
            // var_dump($value);
            $datos = $conexion->AsignacionTecnicos($value,$idDepartamento);
        }
        // var_dump($arrayMatricula);
     
        print_r(json_encode($datos));

    }

    public function AsignarArrayDepartamentos()
    {   
        $funcion = json_decode($_POST['function']);
        
        $conexion = new ConexionAgenda();

        $datos = $conexion->AsignacionDepartamentos();
     
        print_r(json_encode($datos));

    }
    


    public function ListarTecnicosTotal()
    {
        $function = json_decode($_POST['function']);

        $conexion = new ConexionAgenda();
        
        $datos=$conexion->MostrarTecnicosTotal($function);

        print_r(json_encode($datos));
        
    }
    
        public function ListarSoloTecnicos()
    {
        $function = json_decode($_POST['json']);

        $conexion = new ConexionAgenda();
        
        $q=NULL;
        
        if (isset($function->search)) {
            $q=$function->search;
        }        
        
        $datos=$conexion->MostrarTecnicosSelect2($q);

        print_r(json_encode($datos));
        
    }
    

        public function BusquedaDuplicidadAgendamiento()
    {

       $function = json_decode($_POST['function']);

        $conexion = new ConexionAgenda();

        $lbltecnico = $function->lbltecnico; 
        $fechainst = $function->fechainst;
        $horainst=$function->horainst;
        

        if ($fechainst == '' || empty($fechainst)){
            $fechainst = NULL;
        } else {
            $fechainst=  myUrlEncode($fechainst);
            $fechainst=  format_date_Y_mm_dd(str_replace('/', '-', $fechainst));
        }
        
        if ($horainst == '' || empty($horainst)){
            $horainst = NULL;
        } else {
            $horainst=  myUrlEncode($horainst);
            $horainst=  date("H:i:s", strtotime(str_replace("+"," ",$horainst)));
        }        
        $datos=[];
        if(!empty($fechainst)){

        	$fechaInicioConcatenada = date("Y-m-d H:i:s",strtotime($fechainst.' '.$horainst));
            $fechaAuxiliarConcatenada  = strtotime ( "3 hours" , strtotime ( $fechaInicioConcatenada) ) ;  
            $fechaFinConcatenada   = date ('Y-m-d H:i:s' , $fechaAuxiliarConcatenada );
            
            
            $datosTecnicoAgenda=$conexion->MostrarAgendaTecnicoporFecha($fechainst,$lbltecnico);
            // print_r($datosTecnicoAgenda);
            foreach($datosTecnicoAgenda as $valor){

                if(strtotime($fechaInicioConcatenada)>=strtotime($valor['FechaInsthoras']) && strtotime($fechaInicioConcatenada)<strtotime($valor['FechaInst3horas'])){
                    $datos[]=array(
                            'MatriculaTec'=>$valor['MatriculaTec'],
                            'FechaInsthoras'=>$valor['FechaInsthoras'],
                            'FechaInst3horas'=>$valor['FechaInst3horas']
                        );
                    
                }else if(strtotime($fechaFinConcatenada)>strtotime($valor['FechaInsthoras']) && strtotime($fechaFinConcatenada)<strtotime($valor['FechaInst3horas'])){
                    $datos[]=array(
                            'MatriculaTec'=>$valor['MatriculaTec'],
                            'FechaInsthoras'=>$valor['FechaInsthoras'],
                            'FechaInst3horas'=>$valor['FechaInst3horas']
                        );                    
                }

            }
            // $datos=$datosTecnicoAgenda;
            
            
        }
        
        print_r(json_encode($datos));
        
    }
    
    
    
    

}

function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}


?>