<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- Main content -->

<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
		<!-- start page title -->
    		<div class="row">
    			<div class="col-12">
    				<div class="page-title-box d-sm-flex align-items-center justify-content-between">
    					<h4 class="mb-sm-0"><?= $breadcrumb_alias ?></h4>
    
    					<div class="page-title-right">
    						<ol class="breadcrumb m-0">
    							<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
    							<li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
    						</ol>
    					</div>
    
    				</div>
    			</div>
    		</div>
    		<!-- end page title -->
    		<div class="row">
    			<div class="col-12">
    				<div class="card">
    					<div class="card-header align-items-center d-flex bg-red-verisure color-white">
    						<h4 class="card-title mb-0 flex-grow-1 color-white"><?= $breadcrumb_alias ?></h4>
    						<div class="d-flex">
    						    <?php
								if (in_array("IMPOCO", $permisos)) 
								{
								?>
    							<button type="button" class="btn fondoAzulCorporativo d-flex mx-1 color-white" data-bs-toggle="modal" data-bs-target="#modal-importar-oc" id="btnImportarOC">
    								<i class="mdi mdi-database-import-outline me-1" style="font-size: 14px;"></i> Importar
    							</button>
    							<?php
    							}
    							
								if (in_array("EXPOCO", $permisos)) 
								{
								?>
    							<button type="button" class="btn bg-warning d-flex mx-1 color-white" data-bs-toggle="modal" data-bs-target="#modal-exportar-oc">
    								<i class="mdi mdi-file-download me-1" style="font-size: 14px;"></i> Exportar
    							</button>
    							<?php
    							}
    							
								if (in_array("ADDOCO", $permisos)) 
								{
								?>
								<a href="<?= $baseUrl ?>/nueva-orden-compra" role="button" class="btn bg-info d-flex mx-1 color-white">
                                        <i class="mdi mdi-plus-circle me-1" style="font-size: 14px;"></i> Nuevo
                                </a>
    							<?php
								}
								?>
    						</div>
    					</div>
    					<!-- /.card-header -->
    					<div class="card-body">
    						<div class="">
    							<table id="tblOrdenesCompra" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
    								
    							</table>
    						</div>
    					</div>
    					<!-- /.card-body -->
    				</div>
    				<!-- /.card -->
    			</div>
    			<!-- /.col -->
    		</div>
    		<!-- end row-->
    	</div>
		<span class="respuesta_global"></span>
    	<!-- container-fluid -->
    </div>
    <!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://www.verisure.pe/">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- /.content -->
<?= $this->section('js'); ?>
<script>
	$(function () {
		/***SERVERSIDE ORDEN DE COMPRA***/
		assetListVM = {
			dt: null,
			init: function () {
				dt = $('#tblOrdenesCompra').DataTable({
					"serverSide": true,
					"processing": true,
					"ajax": {
						"url": baseUrl + "/ordenCompraServerside",
						type: 'GET'
					},
					"columns": [
						{"title": "# OC", "data": "oc", "class": "text-center", "searchable": true },
						{"title": "Fecha de Emisión", "data": "emision", "class": "text-center", "searchable": true },
						{"title": "Concepto", "data": "concepto", "class": "text-center", "searchable": true },
						{"title": "Proveedor", "data": "proveedor", "class": "text-center", "searchable": true },
						{"title": "Monto Total", "data": "total", "class": "text-center", "searchable": true },
						{"title": "Comprobantes", "data": "comprobantes", "class": "text-center", "searchable": true, "orderable": false },
						{"title": "Acciones", "data": "acciones", "class": "text-center", "searchable": false, "orderable": false },
					],

					"lengthMenu": [[10, 25, 50], [10, 25, 50]],
					responsive: true,
					autoWidth: false,
					"pageLength": 10,
					"paging": true,
					"aaSorting": [[0, 'desc']],
				});
			}
		}

		assetListVM.init();
		/****FIN SERVERSIDE PROVEEDORES****/
	});
</script>
<?php $this->endSection(); ?>

<!-- Modal Adjuntar Validación -->
<div class="modal fade zoomIn" id="adjuntarFacturasOC" data-bs-backdrop="static" role="dialog" aria-labelledby="exampleadjuntarFacturasOC" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleadjuntarFacturasOC">Adjuntar Factura</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formAdjuntarFacturaOC" class="formularioAdjuntarFacturaOC" action="<?= $baseUrl ?>/adjuntar-factura-orden-compra" method="POST" enctype="multipart/form-data" autocomplete="off" accept-charset="utf-8">
				
				<div class="row modal-body">
				    <input type="hidden" id="txtIDOrdenCompra_rfoc" name="txtIDOrdenCompra_rfoc">
					<!--<h3 class="mb-3">Orden de Compra</h3>-->
    			    <!--<div class="row m-0 mb-3">-->
    					<div class="col-xxl-8 col-md-12 col-12 mb-3">
    						<div>
    							<label for="txtNroOrdenCompra" class="form-label" style="color: #0A497B;">Nro Orden de Compra</label>
    							<input type="text" class="form-control" style="color: #0A497B; border-color: #0A497B;" id="txtNroOrdenCompra" name="txtNroOrdenCompra" disabled>
    						</div>
    					</div>
    					<div class="col-xxl-12 col-md-12 col-12 mb-3">
    						<div>
    							<label for="txtConceptoOrdenCompra" class="form-label">Concepto</label>
    							<input type="text" class="form-control" id="txtConceptoOrdenCompra" name="txtConceptoOrdenCompra" disabled>
    						</div>
    					</div>
    					<div class="col-xxl-12 col-md-12 col-12 mb-3">
    						<div>
    							<label for="txtProveedorOrdenCompra" class="form-label">Proveedor</label>
    							<input type="text" class="form-control" id="txtProveedorOrdenCompra" name="txtProveedorOrdenCompra" disabled>
    						</div>
    					</div>
    					<div class="col-xxl-6 col-md-12 col-12 mb-3">
    						<div>
    							<label for="txtFechaEmisionOrdenCompra" class="form-label">Fecha Emisión</label>
    							<input type="date" class="form-control" id="txtFechaEmisionOrdenCompra" name="txtFechaEmisionOrdenCompra" disabled>
    						</div>
    					</div>
    					<div class="col-xxl-6 col-md-12 col-12 mb-3">
    					    <label for="txtMontoTotalOrdenCompra" class="form-label">Monto Total</label>
    						<div class="input-group">
                                <span class="input-group-text" id="spnSimboloMontoOrdenCompra">S/</span>
                                <input type="number" step="0.01" class="form-control" placeholder="Monto Total" id="txtMontoTotalOrdenCompra" name="txtMontoTotalOrdenCompra" aria-label="Monto Total" aria-describedby="basic-addon1" disabled>
                            </div>
    					</div>
    				<!--</div>-->
    				<hr>
    				<h3 class="mb-3">Comprobantes</h3>
    				<div class="col-xxl-6 col-lg-6">
                        <div class="card card-height-100 border-sistema-2px px-3">
                            <div class="card-header align-items-center d-flex">
                                <h4 class="card-title mb-0 flex-grow-1 text-center">XML</h4>
                            </div><!-- end card header -->
                            <hr class="m-0 p-0">
                            <div class="card-body p-0 m-0 pt-3 d-flex justify-content-center">
                                <div class="col-12 m-0 p-0">
        					        <input type="file" id="txtXMLOC_poc" class="filepond" name="txtXMLOC_poc" data-max-file-size="100MB" data-max-files="1" />
        					    </div>
                            </div><!-- end cardbody -->
                        </div><!-- end card -->
                    </div>
    				<div class="col-xxl-6 col-lg-6">
                        <div class="card card-height-100 border-sistema-2px px-3">
                            <div class="card-header align-items-center d-flex">
                                <h4 class="card-title mb-0 flex-grow-1 text-center">PDF</h4>
                            </div><!-- end card header -->
                            <hr class="m-0 p-0">
                            <div class="card-body p-0 m-0 pt-3 d-flex justify-content-center">
                                <div class="col-12 m-0 p-0">
        					        <input type="file" id="txtPDFOC_poc" class="filepond" name="txtPDFOC_poc" data-max-file-size="100MB" data-max-files="1" />
        					    </div>
                            </div><!-- end cardbody -->
                        </div><!-- end card -->
                    </div>
    				<hr class="m-0">
    				<span class="row col-12 m-0 py-2 justify-content-center respuesta"></span>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger d-flex justify-content-end align-items-center color-white" data-bs-dismiss="modal"><span class="mdi mdi-close-thick me-2" style="font-size: 14px;"></span>Cerrar</button>
					<button type="submit" class="btn bg-success d-flex justify-content-end align-items-center color-white"><i class="mdi mdi-file-upload me-2 color-white" style="font-size: 14px;"></i>Importar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<?= $this->section('js'); ?>
<script>
	$(function () {
		pondXMLProveedor = FilePond.create(
            document.querySelector("#txtXMLOC_poc"), {
                labelIdle: 'Arrastre y suelte el XML asociado a la OC o <span class="filepond--label-action">explore</span>',
                allowMultiple: false,
                instantUpload: false,
                allowProcess: false,
                acceptedFileTypes: ['text/xml', 'application/xml'],
                onaddfile: (file) => {
                    // Validacin manual por extensin
                    const allowedExtensions = /(\.xml)$/i;
                    if (!allowedExtensions.exec(file.name)) {
                        Swal.fire({
                            text: "El formato del archivo debe ser XML.",
                            icon: 'warning',
                            showCancelButton: false,
                            cancelButtonText: 'No',
                            confirmButtonColor: '#282e38',
                            confirmButtonText: 'OK'
                        });
                        // Remover el archivo
                        pondXMLProveedor.removeFile(file.id);
                        return false; // Detener el envo del archivo
                    }
                    return true; // Permitir el archivo
                }
            }
        );
		pondPDFProveedor = FilePond.create(
            document.querySelector("#txtPDFOC_poc"), {
                labelIdle: 'Arrastre y suelte el PDF asociado a la OC o <span class="filepond--label-action">explore</span>',
                allowMultiple: false,
                instantUpload: false,
                allowProcess: false,
                acceptedFileTypes: ['application/pdf'],
                onaddfile: (file) => {
                    // Validacin manual por extensin
                    const allowedExtensions = /(\.pdf)$/i;
                    if (!allowedExtensions.exec(file.name)) {
                        Swal.fire({
                            text: "El formato del archivo debe ser PDF.",
                            icon: 'warning',
                            showCancelButton: false,
                            cancelButtonText: 'No',
                            confirmButtonColor: '#282e38',
                            confirmButtonText: 'OK'
                        });
                        // Remover el archivo
                        pondPDFProveedor.removeFile(file.id);
                        return false; // Detener el envo del archivo
                    }
                    return true; // Permitir el archivo
                }
            }
        );
	});
</script>
<?php $this->endSection(); ?>


<?php $this->endSection(); ?>