<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $elementoSeleccionadoModulo ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $subtitulo ?></h5>
                            <div class="d-flex">
								<?php
								if (in_array("ACOCPR", $permisos) && ($pdfValidacion === false || $xmlValidacion === false)) 
								{
								    //ACOCPR: Adjuntar Comprobante OC PRoveedor
								?>
                                <button type="button" class="btn bg-warning color-white px-2 py-1 mx-1 adjuntar-facturas-oc" data-bs-target="#adjuntarFacturasOC" data-oc="<?= $ordenCompra['IDOrdenCompra']?>">
                    				<i class="mdi mdi-upload me-1" style="font-size: 14px;"></i>Adjuntar
                    			</button>
								<?php
								}
								?>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblComprobantesOrdenCompra" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								<thead>
									<tr>
										<th class="text-center align-middle">Nombre</th>
										<th class="text-center align-middle">Usuario Registra</th>
										<th class="text-center align-middle">Fecha Registra</th>
										<th class="text-center align-middle">Validación</th>
										<th class="text-center align-middle">Descarga</th>
									</tr>
								</thead>
								<tbody>
									<?php 
									foreach($comprobantes as $items)
									{ 
									    $fechaCreacion = ($items['FechaCrea'] != '' && $items['FechaCrea'] != null ? $items['FechaCrea'] : $items['FechaCreaProveedor'] );
									?>
									<tr>
										<td class="text-center align-middle"><?= $items['Nombre'].'.'.$items['Extension'] ?></td>
										<td class="text-center align-middle"><?= $items['Creador'] ?></td>
										<td class="text-center align-middle"><span class="d-none"><?= date("YmdHis", strtotime($fechaCreacion)) ?></span><?= date("Y-m-d", strtotime($fechaCreacion)) ?></td>
										<td class="text-center align-middle">
										    <?php 
										    if($items['ComprobanteValido'] == "Y")
										    {
										    ?>
										    <span class="btn bg-success color-white px-2 py-1 mx-1 observacion-comprobante-oc" data-comprobante="<?= $items["IDComprobanteOC"] ?>">
                                				<i class="mdi mdi-check-bold me-1" style="font-size: 14px;"></i>Válido
                                			</span>
										    <?php
										    }
										    else if($items['ComprobanteValido'] == "N")
										    {
										    ?>
										    <span class="btn bg-danger color-white px-2 py-1 mx-1 observacion-comprobante-oc" data-comprobante="<?= $items["IDComprobanteOC"] ?>">
                                				<i class="mdi mdi-minus-thick me-1" style="font-size: 14px;"></i>No Válido
                                			</span>
										    <?php
										    }
										    else
										    {
										    ?>
										    <span class="btn bg-warning color-white px-2 py-1 mx-1 adjuntar-facturas-oc" style="cursor: default;">
                                				<i class="mdi mdi-clock-outline me-1" style="font-size: 14px;"></i>Pendiente
                                			</span>
										    <?php
										    }
										    ?>
										</td>
										<td class="text-center align-middle">
										    <a class='btn bg-secondary border-0 px-2 py-1 mx-1 texto-indicador' style="color: #FFF" href='<?= base_url().'/public/files/OrdenCompra/Comprobantes/'.date("Y", strtotime($fechaCreacion)).'/'.date("m", strtotime($fechaCreacion)).'/OC'.$items["IDOrdenCompra"].'-'.$items["IDComprobanteOC"].'.'.$items["Extension"] ?>' download='<?= $items["Nombre"].".".$items["Extension"] ?>'>
										        <i class="mdi mdi-tray-arrow-down me-1" style="font-size: 14px;"></i><?= $items["Nombre"] ?>
										    </a>
										</td>
									</tr>
									<?php } ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->
<!-- Modal Adjuntar Validación -->
<div class="modal fade zoomIn" id="adjuntarFacturasOC" data-bs-backdrop="static" role="dialog" aria-labelledby="exampleadjuntarFacturasOC" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-md" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleadjuntarFacturasOC">Adjuntar Factura</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formAdjuntarFacturaOC" class="formularioAdjuntarFacturaOC" action="<?= $baseUrl ?>/adjuntar-factura-orden-compra" method="POST" enctype="multipart/form-data" autocomplete="off" accept-charset="utf-8">
				
				<div class="row modal-body">
				    <input type="hidden" id="txtIDOrdenCompra_rfoc" name="txtIDOrdenCompra_rfoc">
					<!--<h3 class="mb-3">Orden de Compra</h3>-->
    			    <!--<div class="row m-0 mb-3">-->
    					<div class="col-xxl-8 col-md-12 col-12 mb-3">
    						<div>
    							<label for="txtNroOrdenCompra" class="form-label" style="color: #0A497B;">Nro Orden de Compra</label>
    							<input type="text" class="form-control" style="color: #0A497B; border-color: #0A497B;" id="txtNroOrdenCompra" name="txtNroOrdenCompra" disabled>
    						</div>
    					</div>
    					<div class="col-xxl-12 col-md-12 col-12 mb-3">
    						<div>
    							<label for="txtConceptoOrdenCompra" class="form-label">Concepto</label>
    							<input type="text" class="form-control" id="txtConceptoOrdenCompra" name="txtConceptoOrdenCompra" disabled>
    						</div>
    					</div>
    					<div class="col-xxl-12 col-md-12 col-12 mb-3">
    						<div>
    							<label for="txtProveedorOrdenCompra" class="form-label">Proveedor</label>
    							<input type="text" class="form-control" id="txtProveedorOrdenCompra" name="txtProveedorOrdenCompra" disabled>
    						</div>
    					</div>
    					<div class="col-xxl-6 col-md-12 col-12 mb-3">
    						<div>
    							<label for="txtFechaEmisionOrdenCompra" class="form-label">Fecha Emisión</label>
    							<input type="date" class="form-control" id="txtFechaEmisionOrdenCompra" name="txtFechaEmisionOrdenCompra" disabled>
    						</div>
    					</div>
    					<div class="col-xxl-6 col-md-12 col-12 mb-3">
    					    <label for="txtMontoTotalOrdenCompra" class="form-label">Monto Total</label>
    						<div class="input-group">
                                <span class="input-group-text" id="spnSimboloMontoOrdenCompra">S/</span>
                                <input type="number" step="0.01" class="form-control" placeholder="Monto Total" id="txtMontoTotalOrdenCompra" name="txtMontoTotalOrdenCompra" aria-label="Monto Total" aria-describedby="basic-addon1" disabled>
                            </div>
    					</div>
    				<!--</div>-->
    				<hr>
    				<h3 class="mb-3">Comprobantes</h3>
					<div class="col-12 mb-0 d-flex justify-content-center">
					    <div class="col-12 m-0 p-0">
					        <input type="file" id="txtFacturaOC_poc" class="filepond" name="txtFacturaOC_poc" data-max-file-size="100MB" data-max-files="2" />
					    </div>
					</div>
    				<hr class="m-0">
    				<span class="row col-12 m-0 py-2 justify-content-center respuesta"></span>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger d-flex justify-content-end align-items-center color-white" data-bs-dismiss="modal"><span class="mdi mdi-close-thick me-2" style="font-size: 14px;"></span>Cerrar</button>
					<button type="submit" class="btn bg-success d-flex justify-content-end align-items-center color-white"><i class="mdi mdi-file-upload me-2 color-white" style="font-size: 14px;"></i>Importar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<?= $this->section('js'); ?>
<script>
	$(function () {
		pondFacturaProveedor = FilePond.create(
            document.querySelector("#txtFacturaOC_poc"), {
                labelIdle: 'Arrastre y suelte los archivos asociados a la OC o <span class="filepond--label-action">explore</span>',
                allowMultiple: true,
                instantUpload: false,
                allowProcess: false,
                // acceptedFileTypes: [
                //   'application/vnd.ms-outlook',   // Common MIME type for .msg files
                //   'application/octet-stream',       // Generic MIME type for binary files
                //   'application/x-msg'               // Alternative MIME type
                // ]
            }
        );
	});
</script>
<?php $this->endSection(); ?>

<?php $this->endSection(); ?>