<?php
namespace App\Models;
use CodeIgniter\Model;

class EstructuraAreaResponsableModel extends Model
{
    protected $DBGroup      = 'baseT';
    protected $table        = 'estructura_area_responsable';
    protected $primaryKey   = 'IDArea';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDArea', 'IDResponsable', 'Principal', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function listadoResponsablesArea($idArea)
    {
        $this->select('
            estructura_area_responsable.IDArea,
            estructura_area_responsable.IDResponsable,
            estructura_area_responsable.Principal,
            CONCAT(tblusuario.Nombres, " ", tblusuario.Apellidos) AS "NombreResponsable",
            tblusuario.Matricula AS "MatriculaResponsable",
            tblusuario.Usuario AS "UsuarioResponsable",
            tblusuario.Correo AS "CorreoResponsable",
            cargos.Cargo AS "CargoResponsable"');
        $this->join('tblusuario', 'estructura_area_responsable.IDResponsable = tblusuario.IdUsuario', 'left');
        $this->join('cargos', 'tblusuario.IDCargo = cargos.IDCargo', 'left');
        $this->where('estructura_area_responsable.IDArea', $idArea);
        $datos = $this->findAll();
        return $datos;
    }
    
}