<?php
namespace App\Models;
use CodeIgniter\Model;

class CuentaContableCategoriaModel extends Model
{
    protected $table      = 'cuentacontable_categorias';
    protected $primaryKey = 'IDCategoriaCC';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDCuentaContable', 'Categoria', 'Observacion','UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function listadoCategorias($array)
    {
        $this->select('
            cuentacontable_categorias.IDCategoriaCC,
            cuentacontable_categorias.IDCuentaContable,
            cuentacontable_categorias.Categoria,
            cuentacontable_categorias.Observacion,
            cuentacontable_categorias.Estado,
            cuentacontable.CodigoCuentaContable,
            cuentacontable.CuentaContable');
        $this->join('cuentacontable', 'cuentacontable_categorias.IDCuentaContable = cuentacontable.IDCuentaContable', 'left');
        
        if(isset($array['Estado']) && $array['Estado'] != '')
        {
            $this->where('cuentacontable_categorias.Estado', $array['Estado']);
        }
        
        if(isset($array['IDCuentaContable']) && $array['IDCuentaContable'] != '')
        {
            $this->where('cuentacontable_categorias.IDCuentaContable', $array['IDCuentaContable']);
        }
        
        $datos = $this->findAll();
        return $datos;
    }
    
    public function listadoCategoriasCuentaContable($idCuentaContable = '')
    {
        $this->select('
            cuentacontable_categorias.IDCategoriaCC,
            cuentacontable_categorias.IDCuentaContable,
            cuentacontable_categorias.Categoria,
            cuentacontable_categorias.Observacion,
            cuentacontable_categorias.Estado,
            cuentacontable.CodigoCuentaContable,
            cuentacontable.CuentaContable');
        $this->join('cuentacontable', 'cuentacontable_categorias.IDCuentaContable = cuentacontable.IDCuentaContable', 'left');
        
        if($idCuentaContable != '')
        {
            $this->where('cuentacontable_categorias.IDCuentaContable', $idCuentaContable);
        }
        
        $datos = $this->findAll();
        return $datos;
    }
    
    public function obtenerCategoria($idCategoria)
    {
        $this->select('
            cuentacontable_categorias.IDCategoriaCC,
            cuentacontable_categorias.IDCuentaContable,
            cuentacontable_categorias.Categoria,
            cuentacontable_categorias.Observacion,
            cuentacontable_categorias.Estado,
            cuentacontable.CodigoCuentaContable,
            cuentacontable.CuentaContable');
        $this->join('cuentacontable', 'cuentacontable_categorias.IDCuentaContable = cuentacontable.IDCuentaContable', 'left');
        $this->where('cuentacontable_categorias.IDCategoriaCC', $idCategoria);
        
        $datos = $this->first();
        return $datos;
    }
    
}