<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;

use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;

class Proveedor extends BaseController
{
	public function __construct(){
	    
        $this->pdf = new Pdf();

	    $this->auditoria    = new \App\Models\AuditoriaModel();
	    
 		$this->usuariosVerisure = new \App\Models\UsuarioVerisureModel();
 		
        $this->estructuraSubareaDelegaciones= new \App\Models\EstructuraSubareaDelegacionesModel();
        $this->estructuraSubareas           = new \App\Models\EstructuraSubareaModel();
        $this->estructuraAreas              = new \App\Models\EstructuraAreaModel();
        $this->estructuraDirecciones        = new \App\Models\EstructuraDireccionModel();
        $this->estructuraDelegaciones       = new \App\Models\EstructuraDelegacionModel();
        
 		$this->regionPais           = new \App\Models\RegionPaisModel();
        $this->regionDepartamento   = new \App\Models\RegionDepartamentoModel();
        $this->regionProvincia      = new \App\Models\RegionProvinciaModel();
        $this->regionDistrito       = new \App\Models\RegionDistritoModel();
        
        $this->usuarioProveedor = new \App\Models\UsuarioProveedorModel();
        $this->usuarioExterno   = new \App\Models\UsuarioModel();

        $this->ordenCompra              = new \App\Models\OrdenCompraModel();
        $this->ordenCompraDetalle       = new \App\Models\OrdenCompraDetalleModel();
        $this->ordenCompraResponsable   = new \App\Models\OrdenCompraResponsablesModel();
        $this->ordenCompraAdjuntos      = new \App\Models\OrdenCompraAdjuntosModel();
        // $this->ordenCompraComprobantes  = new \App\Models\OrdenCompraComprobantesModel();
        
        $this->comprobantesPago         = new \App\Models\ComprobantesPagoModel();
        $this->comprobantesPagoDetalle  = new \App\Models\ComprobantesPagoDetalleModel();
        
	}

    /***************************** ORDEN DE COMPRA ****************************/
    
	public function listarOrdenesCompra()
	{
    	if (isset($this->items['idUsuarioSession'])) 
    	{
            $data = array (
				'session'               => 'on',
				'titulo'                => 'Órdenes de Compra | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Órdenes de Compra'
			);
			
            $data = array_merge($data, $this->items);

            return view('proveedor/listar_ordenes_compra', $data);
        } else {
            return view('errors/500');
        }
	}
	
	public function ordenCompraServerside()
	{
	    $moneda = $this->globales->monedas();
	    
        $listadoProveedores = $this->usuarioProveedor->where("IDExterno", $this->items['idUsuarioSession'])->findAll();
        
        $adicionales = array(
            "IDPerfil"      => $this->items['idPerfilSession'],
            "IDUsuario"     => $this->items['idUsuarioSession'],
            "Proveedores"   => array_column($listadoProveedores,"IDProveedor")
        );
        
        /* LISTAR ORDEN DE COMPRA */
        $dataServerside = $this->ordenCompra->listaGeneralOrdenCompra($this->request->getGet(), $adicionales);
        $recordsTotal = !empty($dataServerside) ? count($dataServerside) : 0;
        $recordsFiltered = $this->ordenCompra->countAll();
        
        foreach($dataServerside as $key=>$value)
        {
            
            $dataServerside[$key]['total'] = $moneda[$value['TipoMoneda']]['SIMBOLO'].' '.$value['total'];
            
            if($value['TotalComprobantes'] === "0")
            {
                $dataServerside[$key]['comprobantes'] = '<button type="button" class="btn bg-warning color-white px-2 py-1 mx-1 adjuntar-facturas-oc" data-bs-target="#adjuntarFacturasOC" data-oc="'.$value['oc'].'">
    				<i class="mdi mdi-upload me-1" style="font-size: 14px;"></i>Adjuntar
    			</button>';
            }
            else
            {
    //             $dataServerside[$key]['comprobantes'] = '<button type="button" class="btn bg-secondary color-white px-2 py-1 mx-1 adjuntar-facturas-oc" data-bs-target="#adjuntarFacturasOC" data-oc="'.$value['oc'].'">
    // 				<i class="mdi mdi-format-list-bulleted-square me-1" style="font-size: 14px;"></i>Comprobantes
    // 			</button>';
    			$dataServerside[$key]['comprobantes'] = '<a href="'.base_url().'/comprobantes-orden-compra/'.$value['oc'].'" class="btn bg-secondary color-white px-2 py-1 mx-1">
    			    <i class="mdi mdi-format-list-bulleted-square me-1" style="font-size: 14px;"></i>Comprobantes
    			</a>';
            }
			
            $dataServerside[$key]['acciones'] = '<button type="button" class="btn bg-info color-white px-2 py-1" onclick=\'imprimir_oc("'.$value['oc'].'")\'>
				<i class="mdi mdi-eye" style="font-size: 14px;"></i>
			</button>';
        }
        
        $datos = [
                // 'draw' => $this->request->getGet('draw'),
            'data'              => $dataServerside,
            'recordsTotal'      => $recordsTotal,
            'recordsFiltered'   => (int) $recordsFiltered
        ];
        
        echo json_encode($datos, JSON_NUMERIC_CHECK);
	}
	
    public function ordenCompraPDF($idOrdenCompra)
    {
        $idOrdenCompra = htmlspecialchars($idOrdenCompra, ENT_QUOTES,'UTF-8');
        
	    if (isset($this->items['idUsuarioSession'])){

            $oc = $this->ordenCompra->obtenerOrdenCompra($idOrdenCompra);
            
    	    if(isset($oc['IDDistrito']) && !empty($oc['IDDistrito']) && $oc['IDDistrito'] != null)
    	    {
        	    $distrito       = $this->regionDistrito->where("IDDistrito", $oc['IDDistrito'])->first();
        	    $provincia      = $this->regionProvincia->where("IDProvincia", $distrito['IDProvincia'])->first();
        	    $departamento   = $this->regionDepartamento->where("IDDepartamento", $provincia['IDDepartamento'])->first();
        	    $pais           = $this->regionPais->where("IDPais", $departamento['IDPais'])->first();
        	    
        	    $oc['Distrito']             = $distrito['Distrito'];
        	    $oc['Provincia']            = $provincia['Provincia'];
        	    $oc['Departamento']         = $departamento['Departamento'];
        	    $oc['Pais']                 = $pais['Pais'];
    	    }
    	    else
    	    {
    	        $oc['Distrito']             = "";
        	    $oc['Provincia']            = "";
        	    $oc['Departamento']         = "";
        	    $oc['Pais']                 = "";
    	    }
    	    
    	    if(isset($oc['IDSubarea']) && !empty($oc['IDSubarea']) && $oc['IDSubarea'] != null)
    	    {
    	        $subarea        = $this->estructuraSubareas->where("IDSubarea", $oc['IDSubarea'])->first();
        	    $area           = $this->estructuraAreas->where("IDArea", $subarea['IDArea'])->first();
        	    
    	        $oc['IDArea']       = $subarea['IDArea'];
    	        $oc['IDDireccion']  = $area['IDDireccion'];
    	    }
    	    else
    	    {
    	        $oc['IDArea']               = "";
    	        $oc['IDDireccion']          = "";
    	    }
    	    
    	    if(isset($oc['UsuarioComprador']) && !empty($oc['UsuarioComprador']) && $oc['UsuarioComprador'] != null)
    	    {
    	        $comprador      = $this->usuariosVerisure->where("IdUsuario ", $oc['UsuarioComprador'])->first();
    	    
        	    $oc['IDComprador']          = $oc['UsuarioComprador'];
        	    $oc['UsuarioComprador']     = ucwords(mb_strtolower($comprador['Nombres'].' '.$comprador['Apellidos']));
        	    $oc['MatriculaComprador']   = $comprador['Matricula'];
        	    
    	    }
    	    else
    	    {
    	        $oc['IDComprador']          = "";
        	    $oc['UsuarioComprador']     = "";
        	    $oc['MatriculaComprador']   = "";
    	    }
    	    
            
    	    $solicitante    = $this->usuariosVerisure->where("IdUsuario ", $oc['UsuarioSolicitante'])->first();
    	    
    	    $responsable01 = $this->usuariosVerisure->where("IdUsuario ", $oc['UsuarioFirma1'])->first();
    	    $responsable02 = $this->usuariosVerisure->where("IdUsuario ", $oc['UsuarioFirma2'])->first();
    	    $responsable03 = $this->usuariosVerisure->where("IdUsuario ", $oc['UsuarioFirma3'])->first();
    	    
    	    $oc['IDSolicitante']        = $oc['UsuarioSolicitante'];
    	    $oc['UsuarioSolicitante']   = ucwords(mb_strtolower($solicitante['Nombres'].' '.$solicitante['Apellidos']));
    	    $oc['CorreoSolicitante']    = $solicitante['Correo'];
    	    
    	    $oc['UsuarioAprobador01']   = ucwords(mb_strtolower($responsable01['Nombres'].' '.$responsable01['Apellidos']));
    	    $oc['CorreoAprobador01']    = $responsable01['Correo'];
    	    $oc['MatriculaAprobador01'] = $responsable01['Matricula'];
    	    $oc['IDAprobador01']        = $oc['UsuarioFirma1'];
    	    
    	    $oc['UsuarioAprobador02']   = ucwords(mb_strtolower($responsable02['Nombres'].' '.$responsable02['Apellidos']));
    	    $oc['CorreoAprobador02']    = $responsable02['Correo'];
    	    $oc['MatriculaAprobador02'] = $responsable02['Matricula'];
    	    
    	    $oc['UsuarioAprobador03']   = ucwords(mb_strtolower($responsable03['Nombres'].' '.$responsable03['Apellidos']));
    	    $oc['CorreoAprobador03']    = $responsable03['Correo'];
    	    $oc['MatriculaAprobador03'] = $responsable03['Matricula'];
    	    
    	    $estados = $this->auditoria->listarAuditoriaEstadosOrdenCompra($idOrdenCompra);
    	    
    	    $fechaF1 = "";
    	    $uf1 = "";
    	    $nombref1 = "";
    	    $fechaF2 = "";
    	    $uf2 = "";
    	    $nombref2 = "";
    	    $fechaF3 = "";
    	    $uf3 = "";
    	    $nombref3 = "";
    	   // var_dump($estados);exit;
    	    foreach($estados as $estado)
    	    {
    	        echo $estado['EstadoPrevio']."<br>";
    	        if($estado['Estado'] == "PendienteFirma1")
    	        {
    	            break;
    	        }
    	        
    	        if($estado['EstadoPrevio'] == "PendienteFirma1")
    	        {
    	            $fechaF1 = $estado['Fecha'];
    	            $uf1 = $estado['UsuarioModifica'];
    	        }
    	        
    	        if($estado['EstadoPrevio'] == "PendienteFirma2")
    	        {
    	            $fechaF2 = $estado['Fecha'];
    	            $uf2 = $estado['UsuarioModifica'];
    	        }
    	        
    	        if($estado['EstadoPrevio'] == "PendienteFirma3")
    	        {
    	            $fechaF3 = $estado['Fecha'];
    	            $uf3 = $estado['UsuarioModifica'];
    	        }
    	    }
    	    
    	    if($uf1 != "")
    	    {
    	        $firma01 = $this->usuariosVerisure->where("IdUsuario ", $uf1)->first();
    	        $nombref1 = mb_strtoupper($firma01['Nombres'].' '.$firma01['Apellidos']);
    	    }
    	    
    	    if($uf2 != "")
    	    {
    	        $firma02 = $this->usuariosVerisure->where("IdUsuario ", $uf2)->first();
    	        $nombref2 = mb_strtoupper($firma02['Nombres'].' '.$firma02['Apellidos']);
    	    }
    	    
    	    if($uf3 != "")
    	    {
    	        $firma03 = $this->usuariosVerisure->where("IdUsuario ", $uf3)->first();
    	        $nombref3 = mb_strtoupper($firma03['Nombres'].' '.$firma03['Apellidos']);
    	    }
    	    
            $colorBudget = "";
            switch ($oc['Estado']) {
                case "PendienteAprobacion":
                case "PendienteFirma1":
                case "PendienteFirma2":
                case "PendienteFirma3":
                case "PendientePago":
                    $colorBudget = "pendiente";
                    break;
                case "Aprobado":
                    $colorBudget = "aprobado";
                    break;
                case "Rechazado":
                case "Anulado":
                    $colorBudget = "anulado";
                    break;
            }
            
            $whereDetalle = array(
                "IDOrdenCompra" => $idOrdenCompra,
                "Estado"        => "A"
            );
            
            $detalleoc = $this->ordenCompraDetalle->where($whereDetalle)->findAll();
            
            $moneda = $this->globales->monedas();
                
			$anio = date('Y');
						
            $html = "<!DOCTYPE html>
    			<html lang='en'>
    			<head>
    			<meta http-equiv='Content-Type' content='text/html; charset=utf-8'/>
    			<meta name='viewport' content='width=device-width, initial-scale=1.0'>
    			<title>Orden de compra Nro ".$oc['IDOrdenCompra']."</title>
    			<link rel='preconnect' href='https://fonts.gstatic.com' crossorigin>
    			<link href='https://fonts.googleapis.com/css2?family=Fira+Sans:ital@0;1&display=swap' rel='stylesheet'>
    			<style type='text/css'>
        			body {
        				font-family: 'Fira Sans', sans-serif;
        			}
        			table {
        				vertical-align: top;
        				text-align: left;
        				font-family: 'Fira Sans', sans-serif;
        			}
        			tr    { vertical-align: top; }
        			td    { vertical-align: top; }
        			.midnight-blue{
        				background:#ed002f;
        				padding: 4px 4px 4px;
        				color:white;
        				font-weight:bold;
        				font-size:12px;
        			}
        			.midnight-black{
        				background:#aca397;
        				padding: 4px 4px 4px;
        				color:white;
        				font-weight:bold;
        				font-size:10px;
        			}
        			.midnight-tabladetalle{
        				padding: 4px 4px 4px;
        				font-size:10px;
        			}
        			.silver{
        				background:white;
        				padding: 3px 4px 3px;
        			}
        			.clouds{
        				background:#dcd5cc;
        				padding: 3px 4px 3px;
        			}
        			.border-top{
        				border-top: solid 1px #bdc3c7;
        
        			}
        			.border-left{
        				border-left: solid 1px #bdc3c7;
        			}
        			.border-right{
        				border-right: solid 1px #bdc3c7;
        			}
        			.border-bottom{
        				border-bottom: solid 1px #bdc3c7;
        			}
        			.budget{
                          font-weight: bold;
                          color: #fff;
        			}
        			.aprobado{
        			    background-color: #00a37d;
        			}
        			.anulado{
        			    background-color: #dc3545;
        			}
        			.pendiente{
        			    background-color: #ffc632;
        			}
        			table.page_footer {width: 100%; border: none; background-color: white; padding: 2mm;border-collapse:collapse; border: none;}
    			</style>	
    			<body>
			    <div style='position:relative'>
 				   <page_footer style='position: absolute;bottom: 0px;width:100%;'>
						<table class='page_footer'>
							<tr>
				
								<td style='width: 50%; text-align: left'>
								
								</td>
								<td style='width:50%; text-align: right'>
									&copy; " . $anio . "  Verisure Perú.
									
								</td>
							</tr>
						</table>
					</page_footer>
					<table cellspacing='0' style='width: 100%; font-size: 10px;'>
						<tr>
							<td rowspan='2' style='width:14%;text-align:center'><img src='" . $this->items['baseUrl'] . "/public/images/LOGO-VERISURE-FULL.png' width='150' height='96.9' style='margin-left: 20px;' alt='Logo'><br></td>
							<td rowspan='2' style='width:53%;text-align: center;border-left-width: thin; border-bottom-width: thin; border-right-width: thin; border-top-width: thin; border-left-style: none; border-bottom-style: none; border-right-style: none; border-top-style: none; font-size: 10px;'><p>&nbsp;</p>
								<p style='margin-top:0px;'><span style='font-size:12px;font-weight:bold;'>VERISURE PERÚ S.A.C - 20549068201</span> <br>
									Av. Primavera Nro. 1050 Int. 501 - Santiago de Surco - Lima <br>
									(01) 514-7300<br>
									www.verisure.pe</p>
								<p>&nbsp;</p></td>
							<td class='midnight-tabladetalle' style='width:15%;font-size: 10px; text-align: center'>Fecha de Emision: </td>
							<td class='midnight-tabladetalle' style='width:28%;font-size: 10px;'>".$oc['FechaCrea']."</td>
						</tr>
						<tr>
							<td  colspan='2' style='text-align: center; font-weight: bold; font-size: 18px;'><strong>ORDEN DE COMPRA</strong>
								<br>Nº ".$oc['IDOrdenCompra']."</td>
						</tr>
				
					</table>

					<table cellspacing='0' style='width: 100%; text-align: left; font-size: 10px;border: 1px solid #ddd;' bordercolor='#ddd'>
						<tr>
							<td colspan='4' class='midnight-blue' style='width: 100%;'> DATOS DEL PROVEEDOR - RUC ".$oc['RUC']."</td>
						</tr>

						<tr>
							<td style='width:18%;' class='midnight-tabladetalle'><strong>Señores:</strong></td>
							<td colspan='3' class='midnight-tabladetalle' style='border-bottom: 2px solid #ddd;'>".strtoupper($oc['Proveedor'])."</td>
						</tr>
						<tr>
							<td class='midnight-tabladetalle' ><strong>Dirección:</strong></td>
							<td style='width:32%;border-bottom: 2px solid #ddd;' class='midnight-tabladetalle'>".strtoupper($oc['Direccion'])."</td>
							<td style='text-align: center;' class='midnight-tabladetalle'><strong>Distrito:</strong></td>
							<td style='width:32%;border-bottom: 2px solid #ddd;'>".strtoupper($oc['Distrito'])."</td>
						</tr>
						<tr>
							<td class='midnight-tabladetalle'><strong>Provincia:</strong></td>
							<td class='midnight-tabladetalle' style='border-bottom: 2px solid #ddd;'>".strtoupper($oc['Provincia'])."</td>
							<td class='midnight-tabladetalle' style='text-align: center;'><strong>Teléfono:</strong></td>
							<td class='midnight-tabladetalle' style='border-bottom: 2px solid #ddd;'>".strtoupper($oc['Telefono01'])."</td>
						</tr>
						<tr>
							<td class='midnight-tabladetalle'><strong>Contacto</strong></td>
							<td class='midnight-tabladetalle' style='border-bottom: 2px solid #ddd;'>".strtoupper($oc['Contacto'])."</td>
							<td class='midnight-tabladetalle' style=' text-align: center;'><strong>E-mail:</strong></td>
							<td class='midnight-tabladetalle' style='border-bottom: 2px solid #ddd;'>".strtoupper($oc['Email'])."</td>
						</tr>
						<tr>
							<td class='midnight-tabladetalle'><strong>Plazo Pago:</strong></td>
							<td style='border-bottom: 2px solid #ddd;'>".strtoupper($oc['descripcionModalidadPago'])."</td>
							<td class='midnight-tabladetalle' style='text-align: center;'><strong>Detracción:</strong></td>
							<td class='midnight-tabladetalle' style='border-bottom: 2px solid #ddd;'>".strtoupper(((!empty($oc['CuentaDetraccion']) || $oc['CuentaDetraccion'] !== '') ? 'Si' : 'No'))."</td>
						</tr>
						<tr>
							<td class='midnight-tabladetalle'><strong>F.Pago:</strong></td>
							<td class='midnight-tabladetalle' style='border-bottom: 2px solid #ddd;'>".strtoupper($oc['descripcionFormaPago'])."</td>
							<td class='midnight-tabladetalle' style=' text-align: center;'><strong>CC:</strong></td>
							<td class='midnight-tabladetalle' style='border-bottom: 2px solid #ddd;'>".strtoupper($oc['CC'])."</td>
						</tr>
						<tr>
							<td class='midnight-tabladetalle'><strong>Concepto Gral.:</strong></td>
							<td class='midnight-tabladetalle' style='border-bottom: 2px solid #ddd;'>".strtoupper($oc['Concepto'])."</td>
							<td class='midnight-tabladetalle' style=' text-align: center;'><strong>LN:</strong></td>
							<td class='midnight-tabladetalle' style='border-bottom: 2px solid #ddd;'>".strtoupper($oc['LN'])."</td>
						</tr>
					</table>

					<br>";
					
			//CONDICIONES SI CUENTA TRANSFERENCIA Y DEPOSITO
            $html .= "<table cellspacing='0' style='width: 100%; text-align: center; font-size: 10px; border: 1px solid #ddd;' bordercolor='#ddd'>
                        <tr>
                            <td style='width:19%;font-weight:bold;border-right: 2px solid #ddd;' class='midnight-blue'>FECHA PEDIDO</td>
                            <td style='width:19%;font-weight:bold;border-right: 2px solid #ddd;' class='midnight-blue'>ESTADO</td>
                            <td style='width:19%;font-weight:bold;border-right: 2px solid #ddd;' class='midnight-blue'>PAGO</td>";
            
            if ($oc['ModalidadPago'] == 'TransferenciaBancaria' || $oc['ModalidadPago'] == 'DepositoBancario') {
                $html .= "<td style='width:19%;font-weight:bold;border-right: 2px solid #ddd;' class='midnight-blue'>BANCO</td>
                          <td style='width:24%;font-weight:bold;' class='midnight-blue'>N°CUENTA</td>";
            }
            
            $html .= "</tr>
                      <tr>
                          <td style='width:19%;border-right: 2px solid #ddd;padding-top:5px; padding-bottom:5px;'>" . $oc['FechaPedido'] . " </td>
                          <td class='budget " . $colorBudget . "' style='width:19%;border-right: 2px solid #ddd;padding-top:5px; padding-bottom:5px;' >" . strtoupper($oc['Estado']) . "</td>
                          <td style='width:19%;border-right: 2px solid #ddd;padding-top:5px; padding-bottom:5px;'>" . strtoupper($oc['descripcionModalidadPago']) . "</td>";
            
            if ($oc['ModalidadPago'] == 'TransferenciaBancaria' || $oc['ModalidadPago'] == 'DepositoBancario') {
                $html .= "<td style='width:19%;border-right: 2px solid #ddd;padding-top:5px; padding-bottom:5px;'>" . strtoupper($oc['descripcionBanco']) . "</td>
                          <td style='width:24%;padding-top:5px; padding-bottom:5px;'>" . $oc['CuentaBancaria'] . "</td>";
            }

            $html .= "</tr>
                    </table>";
            //ITEM						
			$html .= "<br>
					<table cellspacing='0' style='width: 100%; text-align: left; font-size: 10px;border: 2px solid #ddd;' border='0' bordercolor='#ddd'>
						<tr>
							<th style='width: 10%;text-align:center;width:19%;border-right: 2px solid #ddd;' class='midnight-black'>CANT.</th>
							<th style='width: 60%;width:19%;border-right: 2px solid #ddd;' class='midnight-black'>DESCRIPCION</th>
							<th style='width: 15%;text-align: right;width:19%;border-right: 2px solid #ddd;' class='midnight-black'>PRECIO UNIT.</th>
							<th style='width: 15%;text-align: right' class='midnight-black'>PRECIO TOTAL</th>
						</tr>";
            //DETALLE DE ITEM

            foreach($detalleoc as $key=>$item)
            {
                $preciounitario= number_format(round($item['PrecioUnitario'], 2), 2, '.', '');
                $preciototal   = number_format(round($item['Cantidad']*$item['PrecioUnitario'], 2), 2, '.', '');
                
                
			    $html .= "  <tr>
							<td class='clouds' style='width: 5%; text-align: center;border-right: 2px solid #ddd;border-bottom: 2px solid #ddd;' >".(string) $item['Cantidad']."</td>
							<td class='clouds' style='width: 60%; text-align: left;border-right: 2px solid #ddd;border-bottom: 2px solid #ddd;'>".(string) strtoupper($item['Descripcion'])."</td>
							<td class='clouds' style='width: 15%; text-align: right;border-right: 2px solid #ddd;border-bottom: 2px solid #ddd;'>".(string) $preciounitario."</td>
							<td class='clouds' style='width: 20%; text-align: right;border-bottom: 2px solid #ddd;'>".(string) $preciototal."</td>
						</tr>";
            }
            
			//TOTALES Y SUBTOTALES CON SU RESPECTIVO SIMBOLO, ADICIONAL CONSIDERAR CONDICIONES DE IGV (AFECTA/NOAFECTA)
			$html .= "  <tr>
							<td colspan='3' style='width: 85%; text-align: right;border-right: 2px solid #ddd;border-bottom: 2px solid #ddd;'>SUBTOTAL ".$moneda[$oc['TipoMoneda']]['SIMBOLO']."</td>
							<td style='width: 15%; text-align: right;border-bottom: 2px solid #ddd;'>".(string) $oc['Subtotal']."</td>
						</tr>
						<tr>
							<td colspan='3' style='width: 85%; text-align: right;border-right: 2px solid #ddd;border-bottom: 2px solid #ddd;'>IGV(18)% ".$moneda[$oc['TipoMoneda']]['SIMBOLO']."</td>
							<td style='width: 15%; text-align: right;border-bottom: 2px solid #ddd;'>".(string) $oc['IGV']."</td>
						</tr><tr>
							<td colspan='3' style='width: 85%; text-align: right;border-right: 2px solid #ddd;'>TOTAL ".$moneda[$oc['TipoMoneda']]['SIMBOLO']."</td>
							<td style='width: 15%; text-align: right;'>".(string) $oc['Total']."</td>
						</tr>
					</table>";
					
                    $a1 = false;
                    $a2 = false;
                    $a3 = false;
                                    
					$vBudget = $oc['Budget'];
                    $vtotaloc = $oc['Total'];
                    $valorCambio = $oc['MontoCambio'];
                    
                    if($vBudget == 'SI')
                    { 
                	    if( ($vtotaloc*$valorCambio) > 0 && ($vtotaloc*$valorCambio) <= 10000 )
                	    {
                	        //SOLO EL PRIMER APROBADOR
                	        $a1 = true;
                	    
                	        $anchoSolicitante = "50%";
                	        $ancho1 = "50%";
                	    }
                	    else
                	    {
                	        //PRIMER Y SEGUNDO APROBADOR
                            $a1 = true;
                            $a2 = true;
                            
                            $anchoSolicitante = "33%";
                            $ancho1 = "34%";
                            $ancho2 = "33%";
                	    }
                	} 
                	else 
                	{ 
                	    if( ($vtotaloc*$valorCambio) > 0 && ($vtotaloc*$valorCambio) <= 10000 )
                	    { 
                	        //PRIMER Y SEGUNDO APROBADOR
                            $a1 = true;
                            $a2 = true;
                            
                            $anchoSolicitante = "33%";
                            $ancho1 = "34%";
                            $ancho2 = "33%";
                	    } 
                	    else 
                	    {
                	        //TODOS LOS APROBADORES
                	        $a1 = true;
                            $a2 = true;
                            $a3 = true;
                            
                            $anchoSolicitante = "25%";
                            $ancho1 = "25%";
                            $ancho2 = "25%";
                            $ancho3 = "25%";
                	    }
                	}
                	
            $html .= "<br>
					<table cellspacing='0' style='text-align: center; width: 100%;border: 2px solid #ddd;' border='0'  align='center'>
							<tr>
								<td style='width: ".$anchoSolicitante.";font-size:12px;text-align:center; border-right: 2px solid #ddd;'>
									<br>
									".strtoupper($oc['UsuarioSolicitante'])." 
									<br>
									<p></p>
								</td>";
								if($a1)
								{
								$html .= "<td style='width: ".$ancho1.";font-size:12px;text-align:center; border-right: 2px solid #ddd;'>
									<br>";
									if($uf1 == $oc['UsuarioFirma1'])
									{
									    $html .= strtoupper($oc['UsuarioAprobador01'])."<br>".date("Y-m-d", strtotime($fechaF1));
									}
									else if($uf1!='')
									{
									    $html .= strtoupper($oc['UsuarioAprobador01'])."<br>".date("Y-m-d", strtotime($fechaF1));
									}
									$html .= "<br>
									<p></p>
								</td>";
								}
								
								if($a2)
								{
								$html .= "<td style='width: ".$ancho2.";font-size:12px;text-align:center; border-right: 2px solid #ddd;'>
									<br>";
									if($uf2 == $oc['UsuarioFirma2'])
									{
									    $html .= strtoupper($oc['UsuarioAprobador02'])."<br>".date("Y-m-d", strtotime($fechaF2));
									}
									else if($uf2!='')
									{
									    $html .= strtoupper($oc['UsuarioAprobador02'])."<br>".date("Y-m-d", strtotime($fechaF2));
									}
									$html .= "<br>
									<p></p>
								</td>";
								}
								
								if($a3)
								{
								$html .= "<td style='width: ".$ancho3.";font-size:12px;text-align:center; '>
									<br>";
									if($uf3 == $oc['UsuarioFirma3'])
									{
									    $html .= strtoupper($oc['UsuarioAprobador03'])."<br>".date("Y-m-d", strtotime($fechaF3));
									}
									else if($uf3!='')
									{
									    $html .= strtoupper($oc['UsuarioAprobador03'])."<br>".date("Y-m-d", strtotime($fechaF3));
									}
									$html .= "<br>
									<p></p>
								</td>";
								}
							$html .= "</tr>   
						<tr>
							<td  style='width:".$anchoSolicitante.";text-align:center;font-weight:bold; border-right: 2px solid #ddd;' class='midnight-black'>Solicitante</td>";
							if($a1)
							{
							$html .= "<td  style='width:".$ancho1.";text-align:center;font-weight:bold; border-right: 2px solid #ddd;' class='midnight-black'>Autorizante</td>";
							}
							if($a2)
							{
							$html .= "<td  style='width:".$ancho2.";text-align:center;font-weight:bold; border-right: 2px solid #ddd;' class='midnight-black'>Autorizante</td>";
							}
							if($a3)
							{
							$html .= "<td  style='width:".$ancho3.";text-align:center;font-weight:bold' class='midnight-black'>Autorizante</td>";
							}
						$html .= "</tr>

					</table>
					<br>
					<table cellspacing='0' style='width: 100%;border: 1px solid #ddd;'>
						<tr>
							<td  style='width:100%;text-align:left;font-weight:bold' class='midnight-blue'>Observaciones</td>
						</tr>   
						<tr>
							<td style='width: 100%;font-size:12px;text-align:left'>".strtoupper($oc['Observacion'])."</td>
						</tr>
					</table>
					<table class='div_footer' cellspacing='0' style='width: 100%;border: 1px solid #ddd;' align='left'>
						<tr>
							<td style='width: 100%;font-size:8px;text-align:left'>
								Condiciones Generales:
							</td>
						</tr>   
						<tr>
							<td  style='width:100%;text-align:left;font-size:8px;'>
								1.- Solo se Cursarán para pago, las facturas que adjunten fotocopia de esta orden de compra y guías de despacho firmadas y timbradas por Verisure Perú S.A.C.
							</td>

						</tr>
						<tr>
							<td  style='width:100%;text-align:left;font-size:8px;'>
								2.-Toda Factura debe Indicar el Nº de esta orden de compra.
							</td>
						</tr>
						<tr>
							<td  style='width:100%;text-align:left;font-size:8px;'>
								3.- Se debe enviar a recepcion.comprobante@verisure.pe esta OC, factura en formato pdf, factura en formato xlm y guia de remisión firmada.
							</td>
						</tr>
						<tr>
							<td  style='width:100%;text-align:left;font-size:8px;'>
								4.- La presente órden de compra es válida para efectos legales y contractuales.
							</td>
						</tr>
					</table>
				</div>
			</body>
			</html>";
		

			$filename = 'OC' . $oc['IDOrdenCompra'] . ' ' . strtoupper($oc['Proveedor']) . ' - ' .strtoupper($oc['Concepto']);
			$html2 = $this->pdf->generar($html, $filename, $stream = TRUE, $paper = 'A4', $orientation = "portrait");
			
			exit();
	        
	    }else {
            exit();
        }   
    }
    
    public function adjuntarFacturaOrdenCompra()
    {
        // $adjuntos       = $this->request->getFiles("fileAutorizacion");
        // var_dump($this->request->getFiles());exit;
        
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError       = TRUE;
        $idOrdenCompra  = $this->request->getPost('txtIDOrdenCompra_rfoc');
	    $xml            = $this->request->getFile("itemsXML"); 
	    $pdf            = $this->request->getFile("itemsPDF"); 
	    
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idOrdenCompra, 'required|trim|numeric', 'Nro Orden de Compra');
        
        if(empty($xml))
	    {
	        $error .= "<li>No se encuentra el XML adjunto. [CAMPO] <small>XML</small></li>";
	    }
	    
        if(empty($pdf))
	    {
	        $error .= "<li>No se encuentra el PDF adjunto. [CAMPO] <small>PDF</small></li>";
	    }
	    
        if ($error != '') {
            
            $message = sprintf($this->mensajeError->msg201, $error);
    	    $resultado = '<div class="col-xxl-12 col-md-12 col-12 m-0">
                <div class="alert alert-warning" role="alert">'.$message.'</div>
            </div>';
            
            // echo $this->alertas->alertaError($message);
            // EXIT;
            echo $resultado;
			EXIT;
        }
        
	    /*
        * ----------------------------
        * VALIDAR XML Y OBTENER INFORMACIÓN FACTURA XML
        * ----------------------------
        */
        
        if ($xml->isValid() && ! $xml->hasMoved()) 
        {
            $numeroFactura = NULL;
            $fechaEmision = NULL;
            $montoFactura = NULL;
            
            if($xml->getClientExtension() != null)
            {
                $extensionDocXML = strtolower($xml->getClientExtension());
            }
            else if($xml->guessExtension() != null)
            {
                $extensionDocXML = strtolower($xml->guessExtension());
            }
            else
            {
                $extensionDocXML = strtolower(pathinfo($xml->getClientName(), PATHINFO_EXTENSION));
            }

            $nombreArchivoXML = pathinfo($xml->getClientName(), PATHINFO_FILENAME);
            
    	    /*
            * ----------------------------
            * OBTENER DATOS DE XML
            * ----------------------------
            */
            try 
            {
                $xmlVal = simplexml_load_file($xml);
                // Registrar los namespaces del XML
                $namespaces = $xmlVal->getNamespaces(true);
                
                if (isset($namespaces['cbc'])) 
                {
                    // Obtener los elementos cbc del namespace
                    $cbc = $xmlVal->children($namespaces['cbc']);
                     
                    // Extraer el número de factura (cbc:ID)
                    $numeroFactura = (string) $cbc->ID;
                    
                    //Agrega 0 despues del guión para completar 8 digitos
                    $bloques = explode("-", $numeroFactura);
                    $numeroFactura = $bloques[0].'-'.str_pad($bloques[1], 8, "0", STR_PAD_LEFT);
                     
                    // Extraer la fecha de emisión (cbc:IssueDate)
                    $fechaEmision = (string) $cbc->IssueDate;
                    
                    // Extraer el monto de factura (cbc:BaseAmount)
                    $montoFactura = (string) $xmlVal->xpath('//cac:LegalMonetaryTotal/cbc:PayableAmount')[0];
                }
                else
                {
                    $error = "<li>Es un archivo XML no válido. [CAMPO] <small>XML</small></li>";
                    $message = sprintf($this->mensajeError->msg201, $error);
            	    $resultado = '<div class="col-xxl-12 col-md-12 col-12 m-0">
                        <div class="alert alert-warning" role="alert">'.$message.'</div>
                    </div>';
                    
                    echo $resultado;
        			EXIT;
                }
                // Mostrar resultados
                // echo "Número de factura: " . $numeroFactura . PHP_EOL;
                // echo "Fecha de emisión: " . $fechaEmision . PHP_EOL;
                
            } 
            catch (Exception $e) {
                $numeroFactura = NULL;
                $fechaEmision = NULL;
                $montoFactura = NULL;
                
                $result = "No se encontró comprobante XML válido para guardar.<br>Inténtelo luego.";
                $clase = "alert-danger";
    	        $refresh = "";
    	        $submit = "<script>clickOne(false);</script>";
    	        
                $message = sprintf($this->mensajeError->msg201, $result);
        	    $resultado = '<div class="col-xxl-12 col-md-12 col-12 m-0">
                    <div class="alert '.$clase.'" role="alert">'.$message.$submit.'</div>
                </div>';
                
                echo $resultado;
        		EXIT;
            }
        }
        else
        {
			$result = "No se encontró comprobante XML válido para guardar.<br>Inténtelo luego.";
            $clase = "alert-danger";
	        $refresh = "";
	        $submit = "<script>clickOne(false);</script>";
        }
        
	    /*
        * ----------------------------
        * VALIDAR PDF 
        * ----------------------------
        */
        
        if ($pdf->isValid() && ! $pdf->hasMoved()) 
        {
            if($pdf->getClientExtension() != null)
            {
                $extensionDocPDF = $pdf->getClientExtension();
            }
            else if($pdf->guessExtension() != null)
            {
                $extensionDocPDF = $pdf->guessExtension();
            }
            else
            {
                $extensionDocPDF = pathinfo($pdf->getClientName(), PATHINFO_EXTENSION);
            }

            $nombreArchivoPDF = pathinfo($pdf->getClientName(), PATHINFO_FILENAME);
        }
        else
        {
            $result = "No se encontró comprobante PDF válido para guardar.<br>Inténtelo luego.";
            $clase = "alert-danger";
	        $refresh = "";
	        $submit = "<script>clickOne(false);</script>";
	        
            $message = sprintf($this->mensajeError->msg201, $result);
    	    $resultado = '<div class="col-xxl-12 col-md-12 col-12 m-0">
                <div class="alert '.$clase.'" role="alert">'.$message.$submit.'</div>
            </div>';
            
            echo $resultado;
    		EXIT;
        }
        
        /*
        * ----------------------------
        * OBTENER INFORMACIÓN DE LA OC
        * ----------------------------
        */
        
        $datosOrdenCompra   = $this->ordenCompra->obtenerOrdenCompra($idOrdenCompra);
        
        if($montoFactura != '' && $montoFactura != NULL)
        {
            if( !(( ($datosOrdenCompra['Total'] + 1 ) >= $montoFactura ) && ( ($datosOrdenCompra['Total'] - 1) <= $montoFactura )) )
            {
                $result = "El monto registrado en el XML (".$montoFactura.") no es compatible con el monto de la OC (".$datosOrdenCompra['Total']."). Verifique el archivo e inténtelo nuevamente.";
                $clase = "alert-danger";
    	        $refresh = "";
    	        $submit = "<script>clickOne(false);</script>";
    	        
                $message = sprintf($this->mensajeError->msg201, $result);
        	    $resultado = '<div class="col-xxl-12 col-md-12 col-12 m-0">
                    <div class="alert '.$clase.'" role="alert">'.$message.$submit.'</div>
                </div>';
                
                echo $resultado;
        		EXIT;
            }
        }
        else
        {
            $result = "No se encontró monto válido en el xml. Inténtelo luego.";
            $clase = "alert-danger";
	        $refresh = "";
	        $submit = "<script>clickOne(false);</script>";
	            
            $message = sprintf($this->mensajeError->msg201, $result);
    	    $resultado = '<div class="col-xxl-12 col-md-12 col-12 m-0">
                <div class="alert '.$clase.'" role="alert">'.$message.$submit.'</div>
            </div>';
            
            echo $resultado;
    		EXIT;
        }
        
	    /*
        * ----------------------------
        * INSERTAR INFORMACIÓN COMPROBANTE
        * ----------------------------
        */
        
        $data = array (
            'TipoComprobante'       => "1",
            'Origen'                => "OC",
            'IDOrigen'              => $idOrdenCompra,
            'Observacion'           => "Subida de factura - proveedor.",
            'NroFactura'            => $numeroFactura,
            'FechaEmisionFactura'   => $fechaEmision != NULL ? date("Y-m-d", strtotime($fechaEmision)) : NULL,
            'MontoFactura'          => $montoFactura,
            'UsuarioCreaProveedor'  => $this->items['idUsuarioSession'],
            'FechaCreaProveedor'    => $fechaActual,
            'Localhost'             => $this->request->getIPAddress()
        );

        $lastId = $this->comprobantesPago->insert($data, TRUE);
        
        if($lastId !== FALSE){
            $idComprobante = $lastId;
        }
        else
        {
            $error = "<li>No se pudo adjuntar la factura. Inténtelo luego.</li>";
            $message = sprintf($this->mensajeError->msg201, $error);
    	    $resultado = '<div class="col-xxl-12 col-md-12 col-12 m-0">
                <div class="alert alert-danger" role="alert">'.$message.'</div>
            </div>';
            
            echo $resultado;
			EXIT;
        }
        
	    /*
        * ----------------------------
        * INSERTAR ADJUNTO XML
        * ----------------------------
        */
        
        $pathxml = "1";
        $idxml = "2";
        $pathpdf = "3";
        
        if ($xml->isValid() && ! $xml->hasMoved()) 
        {
            /*
            * ----------------------------
            * GUARDAR ARCHIVO ADJUNTO
            * ----------------------------
            */
            $dataAdjunto = array (
                'IDComprobante'         => $idComprobante, 
                'Nombre'                => $nombreArchivoXML,
                'Extension'             => $extensionDocXML,
                'Token'                 => $this->complementos->generar_string_aleatorio(5),
                'ComprobanteValido'     => "Y",
                'UsuarioValidacion'     => "5321",
                'FechaValidacion'       => $fechaActual,
                'ObservacionValidacion' => 'Comprobante validado por sistema verisure.',
                'UsuarioCreaProveedor'  => $this->items['idUsuarioSession'],
                'FechaCreaProveedor'    => $fechaActual,
                'Localhost'             => $this->request->getIPAddress()
            );
            
            $lastIdAdjunto = $this->comprobantesPagoDetalle->insert($dataAdjunto, TRUE);
            
            if($lastIdAdjunto !== FALSE)
            {
                /*
                * ----------------------------
                * GUARDAR ARCHIVO ADJUNTO
                * ----------------------------
                */
                $ruta = "public/files/Comprobantes/".date("Y", strtotime($fechaActual))."/".date("m", strtotime($fechaActual))."/";
                
                if(!file_exists($ruta))
                {
                    @mkdir($ruta, 0777, true);
                }
        
        		# si exsite la carpeta o se ha creado
        		if (file_exists($ruta) || @mkdir($ruta)) 
                {
                    $nuevonombre = $idComprobante.'-'.$lastIdAdjunto.'.'.$extensionDocXML;
                    
                    $pathxml = $ruta.$nuevonombre;
                    $idxml = $lastIdAdjunto;
                    
                    $estadoMove = $xml->move($ruta, $nuevonombre);
                    
                    if (!$estadoMove) {
                        
                        $this->comprobantesPagoDetalle->delete(["IDDetalleComprobante", $lastIdAdjunto]);
                        
                        $result = "No se pudo guardar el comprobante [".$nombreArchivo."].<br>Inténtelo luego[3].";
                        $clase = "alert-danger";
            	        $refresh = "";
            	        $submit = "<script>clickOne(false);</script>";
                    }
                }
                else
                {
                    $this->comprobantesPagoDetalle->delete(["IDDetalleComprobante", $lastIdAdjunto]);
                    
                    $result = "No se pudo guardar el comprobante [".$nombreArchivo."].<br>Inténtelo luego[2].";
                    $clase = "alert-danger";
        	        $refresh = "";
        	        $submit = "<script>clickOne(false);</script>";
                }
            }
            else
            {
                $result = "No se pudo guardar el comprobante [".$nombreArchivo."].<br>Inténtelo luego[1].";
                $clase = "alert-danger";
    	        $refresh = "";
    	        $submit = "<script>clickOne(false);</script>";
            }
        }
        else
        {
			$result = "No se encontró comprobante XML válido para guardar.<br>Inténtelo luego.";
            $clase = "alert-danger";
	        $refresh = "";
	        $submit = "<script>clickOne(false);</script>";
        }
        // var_dump($xml); exit;
        // exit;
	    /*
        * ----------------------------
        * INSERTAR ADJUNTO PDF
        * ----------------------------
        */
        
        if ($pdf->isValid() && ! $pdf->hasMoved()) 
        {            /*
            * ----------------------------
            * GUARDAR ARCHIVO ADJUNTO
            * ----------------------------
            */
            $dataAdjuntoPDF = array (
                'IDComprobante'         => $idComprobante,
                'Nombre'                => $nombreArchivoPDF,
                'Extension'             => $extensionDocPDF,
                'Token'                 => $this->complementos->generar_string_aleatorio(5),
                'UsuarioCreaProveedor'  => $this->items['idUsuarioSession'],
                'FechaCreaProveedor'    => $fechaActual,
                'Localhost'             => $this->request->getIPAddress()
            );
            
            $lastIdAdjuntoPDF = $this->comprobantesPagoDetalle->insert($dataAdjuntoPDF, TRUE);
            
            if($lastIdAdjuntoPDF !== FALSE)
            {
                /*
                * ----------------------------
                * GUARDAR ARCHIVO ADJUNTO
                * ----------------------------
                */
                $ruta = "public/files/Comprobantes/".date("Y", strtotime($fechaActual))."/".date("m", strtotime($fechaActual))."/";
                
                if(!file_exists($ruta))
                {
                    @mkdir($ruta, 0777, true);
                }
        
        		# si exsite la carpeta o se ha creado
        		if (file_exists($ruta) || @mkdir($ruta)) 
                {
                    $nuevonombre = $idComprobante.'-'.$lastIdAdjuntoPDF.'.'.$extensionDocPDF;
                    
                    $estadoMove = $pdf->move($ruta, $nuevonombre);
                    
                    if (!$estadoMove) {
                        $this->comprobantesPagoDetalle->delete(["IDDetalleComprobante", $lastIdAdjuntoPDF]);
                        
                        $this->comprobantesPagoDetalle->delete(["IDDetalleComprobante", $idxml]);
                        unlink($pathxml);
                        
                        $result = "No se pudieron guardar los comprobantes.<br>Inténtelo luego[3].";
                        $clase = "alert-danger";
            	        $refresh = "";
            	        $submit = "<script>clickOne(false);</script>";
                    }
                    else
                    {
                        $result = "Los comprobantes fueron guardados exitosamente.";
                        $clase = "alert-success";
            	        $refresh = $this->alertas->refrescar(1);
            	        $submit = "";
                    }
                }
                else
                {
                    $this->comprobantesPagoDetalle->delete(["IDDetalleComprobante", $lastIdAdjunto]);
                    
                    $this->comprobantesPagoDetalle->delete(["IDDetalleComprobante", $idxml]);
                    unlink($pathxml);
                    
                    $result = "No se pudieron guardar los comprobantes.<br>Inténtelo luego[2].";
                    $clase = "alert-danger";
        	        $refresh = "";
        	        $submit = "<script>clickOne(false);</script>";
                }
            }
            else
            {
                $this->comprobantesPagoDetalle->delete(["IDDetalleComprobante", $lastIdAdjunto]);
                
                $this->comprobantesPagoDetalle->delete(["IDDetalleComprobante", $idxml]);
                unlink($pathxml);
                
                $result = "No se pudieron guardar los comprobantes.<br>Inténtelo luego[1].";
                $clase = "alert-danger";
    	        $refresh = "";
    	        $submit = "<script>clickOne(false);</script>";
            }
        }
        else
        {
            $this->comprobantesPagoDetalle->delete(["IDDetalleComprobante", $idxml]);
            unlink($pathxml);
            
            $result = "No se encontró comprobante PDF válido para guardar.<br>Inténtelo luego.";
            $clase = "alert-danger";
	        $refresh = "";
	        $submit = "<script>clickOne(false);</script>";
        }
        
	    $resultado = '<div class="col-xxl-12 col-md-12 col-12 m-0">
            <div class="alert '.$clase.'" role="alert">'.$result.$refresh.$submit.'</div>
        </div>';
        
        echo $resultado;
    }
    
	public function obtenerDatosOrdenCompra()
	{
	    /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idOrdenCompra = $this->request->getPost('idOrdenCompra');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idOrdenCompra, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		$moneda = $this->globales->monedas();
                
		$datosOrdenCompra = $this->ordenCompra->obtenerOrdenCompra($idOrdenCompra);
		
		if($datosOrdenCompra['IDSubarea'] != '' && $datosOrdenCompra['IDSubarea'] != null)
		{
		    $subarea        = $this->estructuraSubareas->where("IDSubarea", $datosOrdenCompra['IDSubarea'])->first();
		    $area           = $this->estructuraAreas->where("IDArea", $subarea['IDArea'])->first();
		    
    	    $datosOrdenCompra['IDArea']               = $subarea['IDArea'];
    	    $datosOrdenCompra['IDDireccion']          = $area['IDDireccion'];
		}
	    else
	    {
	        $datosOrdenCompra['IDArea']         = "";
    	    $datosOrdenCompra['IDDireccion']    = "";
	    }
	    
		if($datosOrdenCompra['UsuarioFirma1'] != '' && $datosOrdenCompra['UsuarioFirma1'] != null)
		{
		    $responsable01 = $this->usuariosVerisure->where("IdUsuario ", $datosOrdenCompra['UsuarioFirma1'])->first();
		    
		    $datosOrdenCompra['UsuarioAprobador01']   = ucwords(mb_strtolower($responsable01['Nombres'].' '.$responsable01['Apellidos']));
    	    $datosOrdenCompra['CorreoAprobador01']    = $responsable01['Correo'];
    	    $datosOrdenCompra['MatriculaAprobador01'] = $responsable01['Matricula'];
    	    $datosOrdenCompra['IDAprobador01']        = $datosOrdenCompra['UsuarioFirma1'];
		}
	    else
	    {
	        $datosOrdenCompra['UsuarioAprobador01']   = "";
    	    $datosOrdenCompra['CorreoAprobador01']    = "";
    	    $datosOrdenCompra['MatriculaAprobador01'] = "";
    	    $datosOrdenCompra['IDAprobador01']        = "";
	    }
	    
		if($datosOrdenCompra['UsuarioFirma2'] != '' && $datosOrdenCompra['UsuarioFirma2'] != null)
		{
		    $responsable02 = $this->usuariosVerisure->where("IdUsuario ", $datosOrdenCompra['UsuarioFirma2'])->first();
		    
		    $datosOrdenCompra['UsuarioAprobador02']   = ucwords(mb_strtolower($responsable02['Nombres'].' '.$responsable02['Apellidos']));
    	    $datosOrdenCompra['CorreoAprobador02']    = $responsable02['Correo'];
    	    $datosOrdenCompra['MatriculaAprobador02'] = $responsable02['Matricula'];
    	    
		}
	    else
	    {
	        $datosOrdenCompra['UsuarioAprobador02']   = "";
    	    $datosOrdenCompra['CorreoAprobador02']    = "";
    	    $datosOrdenCompra['MatriculaAprobador02'] = "";
	    }
	    
		if($datosOrdenCompra['UsuarioFirma3'] != '' && $datosOrdenCompra['UsuarioFirma3'] != null)
		{
		    $responsable03 = $this->usuariosVerisure->where("IdUsuario ", $datosOrdenCompra['UsuarioFirma3'])->first();
		    
		    $datosOrdenCompra['UsuarioAprobador03']   = ucwords(mb_strtolower($responsable03['Nombres'].' '.$responsable03['Apellidos']));
    	    $datosOrdenCompra['CorreoAprobador03']    = $responsable03['Correo'];
    	    $datosOrdenCompra['MatriculaAprobador03'] = $responsable03['Matricula'];
    	    
		}
	    else
	    {
	        $datosOrdenCompra['UsuarioAprobador03']   = "";
    	    $datosOrdenCompra['CorreoAprobador03']    = "";
    	    $datosOrdenCompra['MatriculaAprobador03'] = "";
	    }
	    
		if(!empty($datosOrdenCompra)){
		   
			$resultado = array(
				'idordencompra' => (string) $idOrdenCompra,
				'concepto'      => (string) $datosOrdenCompra['Concepto'],
				'proveedor'     => (string) $datosOrdenCompra['Proveedor'],
				'fechaemision'  => (string) date("Y-m-d", strtotime($datosOrdenCompra['FechaCrea'])),
				'montototal'    => (string) $datosOrdenCompra['Total'],
				'simbolo'       => (string) $moneda[$datosOrdenCompra['TipoMoneda']]['SIMBOLO'],
				'iddelegacion'  => (string) $datosOrdenCompra['IDDelegacion'],
				'cc'            => (string) $datosOrdenCompra['CC'],
				'ln'            => (string) $datosOrdenCompra['LN'],
				'idsubarea'     => (string) $datosOrdenCompra['IDSubarea'],
				'idarea'        => (string) $datosOrdenCompra['IDArea'],
				'iddireccion'   => (string) $datosOrdenCompra['IDDireccion'],
				'idfirma01'     => (string) $datosOrdenCompra['UsuarioFirma1'],
				'nombrefirma01' => (string) $datosOrdenCompra['UsuarioAprobador01'],
				'matriculafirma01' => (string) $datosOrdenCompra['MatriculaAprobador01'],
				'idfirma02'     => (string) $datosOrdenCompra['UsuarioFirma2'],
				'nombrefirma02' => (string) $datosOrdenCompra['UsuarioAprobador02'],
				'matriculafirma02' => (string) $datosOrdenCompra['MatriculaAprobador02'],
				'idfirma03'     => (string) $datosOrdenCompra['UsuarioFirma3'],
				'nombrefirma03' => (string) $datosOrdenCompra['UsuarioAprobador03'],
				'matriculafirma03' => (string) $datosOrdenCompra['MatriculaAprobador03']
			);
			
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        //  var_dump($resultado);exit;
		echo json_encode($resultado);		
	}
	
	public function comprobantesOrdenCompra($idOrdenCompra)
	{
	    $moneda = $this->globales->monedas();
	    
	    if (isset($this->items['idUsuarioSession'])) 
    	{
    	    $whereComprobantes = array(
    	        'Origen'    => "OC",
    	        'IDOrigen'  => $idOrdenCompra,
    	        'TipoComprobante'   => "1"
    	    );
    	    
            $datosOrdenCompra = $this->ordenCompra->obtenerOrdenCompra($idOrdenCompra);
            $listadoComprobantes = $this->comprobantesPagoDetalle->listadoDetalleComprobantesPago($whereComprobantes);
            
            $pdfVal = false;
            $xmlVal = false;
            
            foreach($listadoComprobantes as $key=>$item)
            {
                if($item['UsuarioCrea'] != '' && $item['UsuarioCrea'] != null)
                {
                    $creador = $this->usuariosVerisure->where("IdUsuario", $item['UsuarioCrea'])->first();
                    
                    $listadoComprobantes[$key]['Creador'] = ucwords(mb_strtolower($creador['Nombres'].' '.$creador['Apellidos']));
                }
                else if($item['UsuarioCreaProveedor'] != '' && $item['UsuarioCreaProveedor'] != null)
                {
                    $creador = $this->usuarioExterno->where("IDExterno", $item['UsuarioCreaProveedor'])->first();
                    
                    $listadoComprobantes[$key]['Creador'] = ucwords(mb_strtolower($creador['Nombres'].' '.$creador['Apellidos']));
                }
                else
                {
                    $listadoComprobantes[$key]['Creador'] = "Sin información";
                }
                
                if($item['UsuarioValidacion'] != '' && $item['UsuarioValidacion'] != null)
                {
                    $validador = $this->usuariosVerisure->where("IdUsuario", $item['UsuarioValidacion'])->first();
                    
                    $listadoComprobantes[$key]['Validador'] = ucwords(mb_strtolower($validador['Nombres'].' '.$validador['Apellidos']));
                }
                else
                {
                    $listadoComprobantes[$key]['Validador'] = "Sin información";
                }
                
                if($item['Extension'] == "pdf" && $item['ComprobanteValido'] == "Y")
                {
                    $pdfVal = true;
                }
                
                if($item['Extension'] == "xml" && $item['ComprobanteValido'] == "Y")
                {
                    $xmlVal = true;
                }
            }
            
            $data = array (
				'session'                       => 'on',
				'titulo'                        => 'Comprobantes de Orden de Compra | Verisure',
				'breadcrumb'                    => $this->items['modulo'],
				// 'breadcrumb_alias'      => 'Comprobantes de Orden de Compra',
				'elementoSeleccionadoModulo'    => 'Orden de Compra Nro: '.$datosOrdenCompra['IDOrdenCompra'],
				'subtitulo'                     => "Comprobantes de Orden de Compra",
				'previo'                        => "listar-ordenes-compra",
				'ordenCompra'                   => $datosOrdenCompra,
				'comprobantes'                  => $listadoComprobantes,
				'moneda'                        => $moneda,
				'pdfValidacion'                 => $pdfVal,
				'xmlValidacion'                 => $xmlVal
			);
			
            $data = array_merge($data, $this->items);

            return view('proveedor/comprobantes_orden_compra', $data);
        } else {
            return view('errors/500');
        }
	}
	
// 	public function obtenerDatosComprobanteOrdenCompra()
// 	{
// 		$moneda = $this->globales->monedas();
                
// 	    /*
//         * ----------------------------
//         * DATOS DE AJAX PRE PROCESADOS
//         * ----------------------------
// 		*/

// 		$msjError = TRUE;
// 		$idComprobanteOC = $this->request->getPost('idComprobanteOC');

// 		/*
//         * ----------------------------
//         * VALIDACIÓN DE REQUERIMIENTOS
//         * ----------------------------
//         */

// 		$error = '';
// 		$error .= $this->complementos->validaCampo($idComprobanteOC, 'trim', 'ID');

// 		if ($error != '') {
// 			$message = sprintf($this->mensajeError->msg201, $error);
// 			echo $this->alertas->alertaError($message);
// 			exit;
// 		}

// 		/*
//         * -------------
//         * BASE DE DATOS
//         * -------------
//         */
        
// 		$datosComprobante = $this->ordenCompraComprobantes->obtenerComprobanteOrdenCompra($idComprobanteOC);
		
// 		if(!empty($datosComprobante)){
// 			$fechaCrea = ($datosComprobante['FechaCrea'] != '' && $datosComprobante['FechaCrea'] != null ? $datosComprobante['FechaCrea'] : $datosComprobante['FechaCreaProveedor'] );
			
// 			$resultado = array(
// 				'idcomprobante' => (string) $idComprobanteOC,
// 				'idordencompra' => (string) $datosComprobante['IDOrdenCompra'],
// 				'nombre'        => (string) $datosComprobante['NombreComprobante'],
// 				'observacionvalido' => (string) $datosComprobante['ObservacionValidacion'],
// 				'fechacrea'     => (string) $fechaCrea,
// 				'nombrefichero' => (string) $datosComprobante['NombreComprobante'].'.'.$datosComprobante['Extension'],
// 				'concepto'      => (string) $datosComprobante['Concepto'],
// 				'proveedor'     => (string) $datosComprobante['Proveedor'],
// 				'fechaemision'  => (string) date("Y-m-d", strtotime($datosComprobante['FechaEmision'])),
// 				'montototal'    => (string) $datosComprobante['Total'],
// 				'simbolo'       => (string) $moneda[$datosComprobante['TipoMoneda']]['SIMBOLO'],
// 			);
			
// 		} else {
// 			$resultado = array(
// 				'descripcion' => 0
// 			);
// 		}

// 		/*
//          * ----------------------------
//          * DATOS DE AJAX PRE PROCESADOS
//          * ----------------------------
//          */
         
// 		echo json_encode($resultado);		
// 	}
	
	public function reemplazarComprobanteOrdenCompra()
	{
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError       = TRUE;
        $idDetalleComprobante  = $this->request->getPost('txtIDComprobanteOC_rfoc');
	    $item           = $this->request->getFile("items"); 
	    
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idDetalleComprobante, 'required|trim|numeric', 'ID Comprobante');
        
        if(empty($item))
	    {
	        $error .= "<li>No se encuentra el archivo adjunto. [CAMPO] <small>XML</small></li>";
	    }
	    
        if ($error != '') {
            
            $message = sprintf($this->mensajeError->msg201, $error);
    	    $resultado = '<div class="col-xxl-12 col-md-12 col-12 m-0">
                <div class="alert alert-warning" role="alert">'.$message.'</div>
            </div>';
            
            // echo $this->alertas->alertaError($message);
            // EXIT;
            echo $resultado;
			EXIT;
        }
        
	    /*
        * ----------------------------
        * OBTENER DATOS COMPROBANTE
        * ----------------------------
        */
        
	    $datosComprobante = $this->comprobantesPagoDetalle->obtenerDetalleComprobantePago($idDetalleComprobante);
	    
	    if(!empty($datosComprobante) && $datosComprobante['Extension'] == "xml")
	    {
    	    /*
            * ----------------------------
            * OBTENER DATOS DE XML
            * ----------------------------
            */
            try 
            {
                $xmlVal = simplexml_load_file($item);
                // Registrar los namespaces del XML
                $namespaces = $xmlVal->getNamespaces(true);
                
                if (isset($namespaces['cbc'])) 
                {
                    // Obtener los elementos cbc del namespace
                    $cbc = $xmlVal->children($namespaces['cbc']);
                     
                    // Extraer el número de factura (cbc:ID)
                    $numeroFactura = (string) $cbc->ID;
                    
                    //Agrega 0 despues del guión para completar 8 digitos
                    $bloques = explode("-", $numeroFactura);
                    $numeroFactura = $bloques[0].'-'.str_pad($bloques[1], 8, "0", STR_PAD_LEFT);
                     
                    // Extraer la fecha de emisión (cbc:IssueDate)
                    $fechaEmision = (string) $cbc->IssueDate;
                    
                    // Extraer el monto de factura (cbc:BaseAmount)
                    $montoFactura = (string) $cbc->BaseAmount;
                }
                else
                {
                    $result = "Es un archivo XML no válido.";
                    $clase = "alert-warning";
        	        $refresh = "";
        	        $submit = "<script>clickOne(false);</script>";
        	        
            	    $resultado = '<div class="col-xxl-12 col-md-12 col-12 m-0">
                        <div class="alert '.$clase.'" role="alert">'.$result.$refresh.$submit.'</div>
                    </div>';
                    
                    echo $resultado;
                    
        			EXIT;
                }
                // Mostrar resultados
                // echo "Número de factura: " . $numeroFactura . PHP_EOL;
                // echo "Fecha de emisión: " . $fechaEmision . PHP_EOL;
                
            } 
            catch (Exception $e) {
                $numeroFactura = NULL;
                $fechaEmision = NULL;
                $montoFactura = NULL;
            }
            
    	    /*
            * ----------------------------
            * INSERTAR ADJUNTO XML
            * ----------------------------
            */
            
            if ($item->isValid() && ! $item->hasMoved()) 
            {
                if($item->getClientExtension() != null)
                {
                    $extensionDoc = strtolower($item->getClientExtension());
                }
                else if($item->guessExtension() != null)
                {
                    $extensionDoc = strtolower($item->guessExtension());
                }
                else
                {
                    $extensionDoc = strtolower(pathinfo($item->getClientName(), PATHINFO_EXTENSION));
                }
    
                $nombreArchivo = pathinfo($item->getClientName(), PATHINFO_FILENAME);
                
                if($datosComprobante['Extension'] == $extensionDoc)
                {
                    /*
                    * ----------------------------
                    * GUARDAR ARCHIVO ADJUNTO
                    * ----------------------------
                    */
                    $dataAdjunto = array (
                        'Nombre'                    => $nombreArchivo,
                        'Extension'                 => $extensionDoc,
                        'Token'                     => $this->complementos->generar_string_aleatorio(5),
                        'ComprobanteValido'         => NULL,
                        'UsuarioValidacion'         => NULL,
                        'FechaValidacion'           => NULL,
                        'ObservacionValidacion'     => NULL,
                        'UsuarioModificaProveedor'  => $this->items['idUsuarioSession'],
                        'FechaModificaProveedor'    => $fechaActual,
                        'Localhost'                 => $this->request->getIPAddress()
                    );
                    
                    $lastIdAdjunto = $this->comprobantesPagoDetalle->update([$idDetalleComprobante], $dataAdjunto);
                    
                    if($lastIdAdjunto !== FALSE)
                    {
                        /*
                        * ----------------------------
                        * GUARDAR ARCHIVO ADJUNTO
                        * ----------------------------
                        */
                        $ruta = "public/files/Comprobantes/".date("Y", strtotime($datosComprobante['FechaCreaProveedor']))."/".date("m", strtotime($datosComprobante['FechaCreaProveedor']))."/";
                        
                        if(!file_exists($ruta))
                        {
                            @mkdir($ruta, 0777, true);
                        }
                
                		# si exsite la carpeta o se ha creado
                		if (file_exists($ruta) || @mkdir($ruta)) 
                        {
                            $nuevonombre = $datosComprobante['IDComprobante'].'-'.$idDetalleComprobante.'.'.$extensionDoc;
                            
                            $estadoMove = $item->move($ruta, $nuevonombre);
                            
                            if (!$estadoMove) {
                                
                                $result = "No se pudo reemplazar el comprobante [".$nombreArchivo."].<br>Inténtelo luego[3].";
                                $clase = "alert-danger";
                    	        $refresh = "";
                    	        $submit = "<script>clickOne(false);</script>";
                            }
                            else
                            {
                                
                                /*
                                * ----------------------------
                                * ACTUALIZAR INFORMACIÓN FACTURA
                                * ----------------------------
                                */
                                
                                $dataComp = array (
                                    'NroFactura'                => $numeroFactura,
                                    'FechaEmisionFactura'       => date("Y-m-d", strtotime($fechaEmision)),
                                    'MontoFactura'              => $montoFactura,
                                    'UsuarioModificaProveedor'  => $this->items['idUsuarioSession'],
                                    'FechaModificaProveedor'    => $fechaActual,
                                    'Localhost'                 => $this->request->getIPAddress()
                                );
                                
                                $lastIdComp = $this->comprobantesPago->update([$datosComprobante['IDComprobante']], $dataComp);
                                
                                $result = "El comprobante fue reemplazado exitosamente.";
                                $clase = "alert-success";
                    	        $refresh = $this->alertas->refrescar(1);
                    	        $submit = "";
                            }
                        }
                        else
                        {
                            $result = "No se pudo reemplazar el comprobante [".$nombreArchivo."].<br>Inténtelo luego[2].";
                            $clase = "alert-danger";
                	        $refresh = "";
                	        $submit = "<script>clickOne(false);</script>";
                        }
                    }
                    else
                    {
                        $result = "No se pudo reemplazar el comprobante [".$nombreArchivo."].<br>Inténtelo luego[1].";
                        $clase = "alert-danger";
            	        $refresh = "";
            	        $submit = "<script>clickOne(false);</script>";
                    }
                }
                else
                {
                    $result = "El comprobante no es un archivo XML [".$nombreArchivo."].<br>Inténtelo luego[1].";
                    $clase = "alert-danger";
        	        $refresh = "";
        	        $submit = "<script>clickOne(false);</script>";
                }
            }
            else
            {
    			$result = "No se encontró comprobante XML válido para guardar.<br>Inténtelo luego.";
                $clase = "alert-danger";
    	        $refresh = "";
    	        $submit = "<script>clickOne(false);</script>";
            }
	    }
	    else if(!empty($datosComprobante) && $datosComprobante['Extension'] == "pdf")
	    {
    	    /*
            * ----------------------------
            * INSERTAR ADJUNTO PDF
            * ----------------------------
            */
            
            if ($item->isValid() && ! $item->hasMoved()) 
            {
                if($item->getClientExtension() != null)
                {
                    $extensionDoc = $item->getClientExtension();
                }
                else if($item->guessExtension() != null)
                {
                    $extensionDoc = $item->guessExtension();
                }
                else
                {
                    $extensionDoc = pathinfo($item->getClientName(), PATHINFO_EXTENSION);
                }
    
                $nombreArchivo = pathinfo($item->getClientName(), PATHINFO_FILENAME);
                
                if($datosComprobante['Extension'] == $extensionDoc)
                {
                    /*
                    * ----------------------------
                    * GUARDAR ARCHIVO ADJUNTO
                    * ----------------------------
                    */
                    $dataAdjunto = array (
                        'Nombre'                    => $nombreArchivo,
                        'Extension'                 => $extensionDoc,
                        'Token'                     => $this->complementos->generar_string_aleatorio(5),
                        'ComprobanteValido'         => NULL,
                        'UsuarioValidacion'         => NULL,
                        'FechaValidacion'           => NULL,
                        'ObservacionValidacion'     => NULL,
                        'UsuarioModificaProveedor'  => $this->items['idUsuarioSession'],
                        'FechaModificaProveedor'    => $fechaActual,
                        'Localhost'                 => $this->request->getIPAddress()
                    );
                    
                    $lastIdAdjunto = $this->comprobantesPagoDetalle->update([$idDetalleComprobante], $dataAdjunto);
                    
                    if($lastIdAdjunto !== FALSE)
                    {
                        /*
                        * ----------------------------
                        * GUARDAR ARCHIVO ADJUNTO
                        * ----------------------------
                        */
                        $ruta = "public/files/Comprobantes/".date("Y", strtotime($datosComprobante['FechaCreaProveedor']))."/".date("m", strtotime($datosComprobante['FechaCreaProveedor']))."/";
                        
                        if(!file_exists($ruta))
                        {
                            @mkdir($ruta, 0777, true);
                        }
                
                		# si exsite la carpeta o se ha creado
                		if (file_exists($ruta) || @mkdir($ruta)) 
                        {
                            $nuevonombre = $datosComprobante['IDComprobante'].'-'.$idDetalleComprobante.'.'.$extensionDoc;
                            
                            $estadoMove = $item->move($ruta, $nuevonombre);
                            
                            if (!$estadoMove) {
                                $result = "No se pudo reemplazar el comprobante [".$nombreArchivo."].<br>Inténtelo luego[3].";
                                $clase = "alert-danger";
                    	        $refresh = "";
                    	        $submit = "<script>clickOne(false);</script>";
                            }
                            else
                            {
                                $result = "El comprobante fue reemplazado exitosamente.";
                                $clase = "alert-success";
                    	        $refresh = $this->alertas->refrescar(1);
                    	        $submit = "";
                            }
                        }
                        else
                        {
                            $result = "No se pudo reemplazar el comprobante [".$nombreArchivo."].<br>Inténtelo luego[2].";
                            $clase = "alert-danger";
                	        $refresh = "";
                	        $submit = "<script>clickOne(false);</script>";
                        }
                    }
                    else
                    {
                        $result = "No se pudo reemplazar el comprobante [".$nombreArchivo."].<br>Inténtelo luego[1].";
                        $clase = "alert-danger";
            	        $refresh = "";
            	        $submit = "<script>clickOne(false);</script>";
                    }
            }
                else
                {
                    $result = "El comprobante no es un archivo PDF [".$nombreArchivo."].<br>Inténtelo luego[1].";
                    $clase = "alert-danger";
        	        $refresh = "";
        	        $submit = "<script>clickOne(false);</script>";
                }
            }
            else
            {
                $result = "No se encontró comprobante PDF válido para guardar.<br>Inténtelo luego.";
                $clase = "alert-danger";
    	        $refresh = "";
    	        $submit = "<script>clickOne(false);</script>";
            }
	    }
	    else
	    {
	        $result = "No se encontró registro del comprobante.<br>Inténtelo luego.";
            $clase = "alert-danger";
	        $refresh = "";
	        $submit = "<script>clickOne(false);</script>";
	    }
	    
	    $resultado = '<div class="col-xxl-12 col-md-12 col-12 m-0">
            <div class="alert '.$clase.'" role="alert">'.$result.$refresh.$submit.'</div>
        </div>';
        
        echo $resultado;
	}
	/**************************************************************************/
	
	public function nuevaOrdenCompra()
	{
	    if (isset($this->items['idUsuarioSession'])) 
    	{
            $data = array (
				'session'               => 'on',
				'titulo'                => 'Nueva Orden de Compra | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Nueva Orden de Compra'
			);
			
            $data = array_merge($data, $this->items);

            return view('proveedor/nueva_orden_compra', $data);
        } else {
            return view('errors/500');
        }
	}
	
	public function registrarOrdenCompra()
	{
	    $fechaActual = date("Y-m-d H:i:s");
        
        $resultado = array(
			'ejecucion'  => (string) false,
			'mensaje1'  => (string) "",
			'mensaje2'  => (string) ""
		);
		
        $moneda = $this->globales->monedas();
            
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $concepto_oc    = htmlspecialchars(trim($this->request->getPost('conceptoOC')), ENT_QUOTES,'UTF-8');
		$fechapedido    = $this->request->getPost('txtFechaPedidoOC');
		$comprador      = $this->request->getPost('cboCompradorOC');
		$envioFactura   = $this->request->getPost('cboEnvioFacturaOC');
		$budget         = $this->request->getPost('cboBudgetOC');
		$condicionesIgv = $this->request->getPost('cboIGVOC');
		$subcategoria   = $this->request->getPost('cboSubcategoriaOC');
		$delegacion     = $this->request->getPost('cboDelegacionOC');
		$cc             = $this->request->getPost('txtCCOC');
		$ln             = $this->request->getPost('txtLNOC');
		$subarea        = $this->request->getPost('cboSubareaOC');
		$observaciones  = htmlspecialchars(trim($this->request->getPost('observaciones')), ENT_QUOTES,'UTF-8');
	    $idProveedor    = $this->request->getPost('cboProveedorOC');
		$formapago      = $this->request->getPost('cboFormaPagoOC');
		$modalidadPago  = $this->request->getPost('cboModalidadPagoOC');
		$banco          = $this->request->getPost('cboBancoOC');
		$tipomoneda     = $this->request->getPost('cboMonedaOC');
		
		$subtotal       = htmlspecialchars(trim($this->request->getPost('subtotaldetalleoc')), ENT_QUOTES,'UTF-8');
		$igvOc          = htmlspecialchars(trim($this->request->getPost('igvdetalleoc')), ENT_QUOTES,'UTF-8');
		$totalOC        = htmlspecialchars(trim($this->request->getPost('totaldetalleoc')), ENT_QUOTES,'UTF-8');
		
		$cuentabancaria = htmlspecialchars($this->request->getPost('txtCuentaOC'), ENT_QUOTES,'UTF-8');
		$cuentainterbancaria    = $this->request->getPost('txtCCIOC');
		
		$centralizada   = $this->request->getPost('chkCompraCentralizadaOC');
		
		$items          = $this->request->getPost('correlativo');
		$descripcionitem= $this->request->getPost('descripcionitemoc');
		$cantidaditem   = $this->request->getPost('cantidaditemoc');
		$precioitem     = $this->request->getPost('precioitemoc');
		
        $estado_OC = "PendienteFirma1";
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
		$error = '';
		$error .= $this->complementos->validaCampo($concepto_oc, 'required|trim|minlength[1]|maxlength[255]', 'Concepto');
		$error .= $this->complementos->validaCampo($fechapedido, 'required|trim|dateDos|minlength[1]|maxlength[60]', 'Fecha Pedido');
		$error .= $this->complementos->validaCampo($comprador, 'required|trim|numeric', 'Comprador');
		$error .= $this->complementos->validaCampo($envioFactura, 'required|trim|alpha|minlength[1]|maxlength[2]', 'Envio Factura');
		$error .= $this->complementos->validaCampo($budget, 'required|trim|alpha|minlength[1]|maxlength[2]', 'Budget');
		$error .= $this->complementos->validaCampo($condicionesIgv, 'trim|alpha|minlength[1]|maxlength[10]', 'Condiciones IGV');
		$error .= $this->complementos->validaCampo($subcategoria, 'required|trim|numeric', 'Subcategoría');
		$error .= $this->complementos->validaCampo($delegacion, 'required|trim|numeric', 'Delegación');
		$error .= $this->complementos->validaCampo($cc, 'required|trim|numeric', 'CC');
		$error .= $this->complementos->validaCampo($ln, 'required|trim|numeric', 'LN');
		$error .= $this->complementos->validaCampo($subarea, 'required|trim|numeric', 'Subárea');
		$error .= $this->complementos->validaCampo($observaciones, 'trim', 'Observaciones');
		$error .= $this->complementos->validaCampo($idProveedor, 'required|trim|numeric', 'Id Proveedor');
		$error .= $this->complementos->validaCampo($formapago, 'required|trim|alphanumeric|minlength[1]|maxlength[30]', 'Forma de Pago');
		$error .= $this->complementos->validaCampo($modalidadPago, 'required|trim|alphanumeric|minlength[1]|maxlength[30]', 'Modalidad Pago');
		$error .= $this->complementos->validaCampo($banco, 'required|trim|minlength[1]|maxlength[200]', 'Banco');
		$error .= $this->complementos->validaCampo($tipomoneda, 'required|trim|alpha|minlength[1]|maxlength[5]', 'Tipo Moneda');
		
		$error .= $this->complementos->validaCampo($subtotal, 'required|trim|float', 'Sub Total');
		$error .= $this->complementos->validaCampo($igvOc, 'required|trim|float', 'Igv');
		$error .= $this->complementos->validaCampo($totalOC, 'required|trim|float', 'Total');
		
		$error .= $this->complementos->validaCampo($cuentabancaria, 'trim|minlength[1]|maxlength[100]', 'Cuenta Bancaria');
		$error .= $this->complementos->validaCampo($cuentainterbancaria, 'trim|minlength[1]|maxlength[100]', 'CCI');
		
        if(empty($items))
        {
            $error .= "<li>No hay items agregados a la orden de compra.</li>";
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            
            $resultado = array(
    			'ejecucion'  => false,
    			'popup' => false,
    			'mensaje1'  => (string) $this->alertas->alertaError($message),
    			'mensaje2'  => (string) ""
    		);
    		
			echo json_encode($resultado);
			EXIT;
        }
        
        $centralizada = ($centralizada == '' ? 0 : 1);
        
        /*
        * ----------------------------
        * VALIDACIÓN DE RESPONSABLES
        * ----------------------------
        */
        
        if($centralizada == 1)
        {
            //SI LA COMPRA ES CENTRALIZADA, SE SETEA DE FORMA AUTOMÁTICA LA SUBÁREA Y ÁREA LOGISTICA Y COMPRAS DE LA DIRECCIÓN FINANZAS (SUBÁREA 11)
            $informacionSubarea = $this->estructuraSubareas->obtenerSubarea(11);
        }
        else
        {
            $informacionSubarea = $this->estructuraSubareas->obtenerSubarea($subarea);
        }
        
        if($informacionSubarea['Responsable_Subarea'] == '' || $informacionSubarea['Responsable_Subarea'] == null || $informacionSubarea['Responsable_Area'] == '' || $informacionSubarea['Responsable_Area'] == null || $informacionSubarea['Responsable_Direccion'] == '' || $informacionSubarea['Responsable_Direccion'] == null)
        {
            $resultado = array(
    			'ejecucion' => false,
    			'popup' => true,
    			'mensaje1'  => (string) "No se encontró usuarios responsables de firma para esta subárea. Por favor, seleccionar otra subárea o póngase en contacto con Soporte IT.",
    			'mensaje2'  => (string) ""
    		);
    		
			echo json_encode($resultado);
			EXIT;
        }
        
        /*
        * ----------------------------
        * CREACIÓN DE ORDEN DE COMPRA
        * ----------------------------
        */

        $data = array (
            'Concepto'              => $concepto_oc,
            'IDProveedor'           => $idProveedor,
            'FormaPago'             => $formapago,
            'Observacion'           => $observaciones,
            'Subtotal'              => $subtotal,
            'IGV'                   => $igvOc,
            'Total'                 => $totalOC,
            'FechaPedido'           => $fechapedido,
            'CondicionesIGV'        => $condicionesIgv,
            'ModalidadPago'         => $modalidadPago,
            'Banco'                 => $banco,
            'CuentaBancaria'        => $cuentabancaria,
            'CuentaInterbancaria'   => $cuentainterbancaria,
            'TipoMoneda'            => $tipomoneda,
            'MontoCambio'           => (isset($moneda[$tipomoneda]) ? $moneda[$tipomoneda]['CAMBIO'] : 1),
            'Budget'                => $budget,
            'UsuarioSolicitante'    => $this->items['idUsuarioSession'],
            'IDDelegacion'          => $delegacion,
            'CC'                    => $cc,
            'LN'                    => $ln,
            'IDSubarea'             => $subarea,
            'CompraCentralizada'    => $centralizada,
            'EnvioFactura'          => $envioFactura,
            'IDSubcategoria'        => $subcategoria,
            'UsuarioComprador'      => $comprador,
            'UsuarioCrea'           => $this->items['idUsuarioSession'],
            'FechaCrea'             => $fechaActual,    
            'Localhost'             => $this->request->getIPAddress(),
            'UsuarioEstado'         => $this->items['idUsuarioSession'],
            'FechaEstado'           => $fechaActual,    
            'MotivoEstado'          => $observaciones,    
            'Estado'                => $estado_OC
        );

        $lastId = $this->ordenCompra->insert($data, TRUE);
        
        if($lastId !== FALSE){
            $idOrdenCompra = $lastId;
        }
        else
        {
			$resultado = array(
    			'ejecucion'  => false,
    			'popup' => true,
    			'mensaje1'  => (string) "Hubo un problema al registrar la Orden de Compra. Inténtelo luego.",
    			'mensaje2'  => (string) ""
    		);
    		
			echo json_encode($resultado);
            EXIT;
        }
        
        /*
        * ----------------------------
        * CREACIÓN DEL DETALLE DE LA ORDEN DE COMPRA
        * ----------------------------
        */

        $dataDetalle = array();

        foreach($items as $key)
        {
            $dataDetalle[] = array (
                'IDOrdenCompra'     => $idOrdenCompra, 
                'Descripcion'       => $descripcionitem[$key],  
                'Cantidad'          => $cantidaditem[$key], 
                'PrecioUnitario'    => $precioitem[$key], 
                'UsuarioCrea'       => $this->items['idUsuarioSession'],
                'FechaCrea'         => $fechaActual,    
                'Localhost'         => $this->request->getIPAddress(),
                'UsuarioEstado'     => $this->items['idUsuarioSession'],
                'FechaEstado'       => $fechaActual,    
                'MotivoEstado'      => "Creación de detalle OC",    
                'Estado'            => "A"
            );
        }
        
        $lastIdDetalle = $this->ordenCompraDetalle->insertBatch($dataDetalle);
        
        if($lastIdDetalle === FALSE){
            
			$resultado = array(
    			'ejecucion'  => true,
    			'popup' => true,
    			'mensaje1'  => (string) "Hubo un problema al registrar el detalle de la Orden de Compra. Registrelos luego.",
    			'mensaje2'  => (string) ""
    		);
    		
			echo json_encode($resultado);
            EXIT;
        }
        
        /*
        * ----------------------------
        * REGISTRAR USUARIOS RESPONSABLES DE LA FIRMA DE LA ORDEN DE COMPRA
        * ----------------------------
        */
        
        // SI DELEGACION USUARIO LOGUEADO = $delegacion 
        if($centralizada == 0)
        {
            if($this->items['idDelegacionLog'] == $delegacion && $informacionSubarea['Responsable_Subarea'] == $this->items['idUsuarioSession'])
            {
                $informacionSubarea['Responsable_Subarea'] = $informacionSubarea['Responsable_Area'];
                $informacionSubarea['Responsable_Area'] = $informacionSubarea['Responsable_Direccion'];
            }
            else if($this->items['idDelegacionLog'] == $delegacion && $informacionSubarea['Responsable_Area'] == $this->items['idUsuarioSession'])
            {
                $informacionSubarea['Responsable_Subarea'] = $informacionSubarea['Responsable_Direccion'];
                $informacionSubarea['Responsable_Area'] = $informacionSubarea['Responsable_Direccion'];
            }
        }
        
        $dataResponsables = array (
            'IDOrdenCompra' => $idOrdenCompra,
            'UsuarioFirma1' => $informacionSubarea['Responsable_Subarea'],
            'UsuarioFirma2' => $informacionSubarea['Responsable_Area'],
            'UsuarioFirma3' => $informacionSubarea['Responsable_Direccion'],
            'UsuarioCrea'   => $this->items['idUsuarioSession'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress(),
            'UsuarioEstado' => $this->items['idUsuarioSession'],
            'FechaEstado'   => $fechaActual,    
            'MotivoEstado'  => "Habilitar usuarios responsables firma OC.",    
            'Estado'        => "A"
        );

        $lastIdResponsable = $this->ordenCompraResponsable->insert($dataResponsables, TRUE);
		    
        if($lastIdResponsable !== FALSE)
        {
            $informacionOC = $this->ordenCompra->obtenerOrdenCompra($idOrdenCompra);
            
    	    $solicitante    = $this->usuarios->where("IdUsuario ", $informacionOC['UsuarioSolicitante'])->first();
    	    
    	    $responsable01 = $this->usuarios->where("IdUsuario ", $informacionOC['UsuarioFirma1'])->first();
    	    $responsable02 = $this->usuarios->where("IdUsuario ", $informacionOC['UsuarioFirma2'])->first();
    	    $responsable03 = $this->usuarios->where("IdUsuario ", $informacionOC['UsuarioFirma3'])->first();
    	    
    	    $informacionOC['IDSolicitante']        = $informacionOC['UsuarioSolicitante'];
    	    $informacionOC['UsuarioSolicitante']   = ucwords(mb_strtolower($solicitante['Nombres'].' '.$solicitante['Apellidos']));
    	    $informacionOC['CorreoSolicitante']    = $solicitante['Correo'];
    	    
    	    $informacionOC['UsuarioAprobador01']   = ucwords(mb_strtolower($responsable01['Nombres'].' '.$responsable01['Apellidos']));
    	    $informacionOC['CorreoAprobador01']    = $responsable01['Correo'];
    	    $informacionOC['MatriculaAprobador01'] = $responsable01['Matricula'];
    	    $informacionOC['IDAprobador01']        = $informacionOC['UsuarioFirma1'];
    	    
    	    $informacionOC['UsuarioAprobador02']   = ucwords(mb_strtolower($responsable02['Nombres'].' '.$responsable02['Apellidos']));
    	    $informacionOC['CorreoAprobador02']    = $responsable02['Correo'];
    	    $informacionOC['MatriculaAprobador02'] = $responsable02['Matricula'];
    	    
    	    $informacionOC['UsuarioAprobador03']   = ucwords(mb_strtolower($responsable03['Nombres'].' '.$responsable03['Apellidos']));
    	    $informacionOC['CorreoAprobador03']    = $responsable03['Correo'];
    	    $informacionOC['MatriculaAprobador03'] = $responsable03['Matricula'];
    	    
            $estadoCorreo = $this->complementos->enviarCorreoOrdenCompraPrimeraFirma($informacionOC,$idOrdenCompra);

            $dataCorreo = array(
                "IDOrdenCompra" => $idOrdenCompra,
                "Momento"       => "REGISTRO",
                "Response"      => $estadoCorreo['RESPUESTA'],
                "Error"         => $estadoCorreo['ERROR'],
                'UsuarioCrea'   => $this->items['idUsuarioSession'],
                'FechaCrea'     => $fechaActual,    
                'Localhost'     => $this->request->getIPAddress()
            );

            $this->correoStatusOrdenCompra->insert($dataCorreo, TRUE);
            
            $message = sprintf($this->mensajeError->msg502, $concepto_oc);
		
    		$resultado = array(
    			'ejecucion'  => true,
    			'popup' => false,
    			'mensaje1'  => (string) $this->alertas->alertaExito($message).$this->alertas->reDireccion(base_url()."/listar-ordenes-compra/", 1),
    			'mensaje2'  => (string) ""
    		);
        }
        else
        {
			$resultado = array(
    			'ejecucion'  => true,
    			'popup' => true,
    			'mensaje1'  => (string) "Hubo un problema al asociar a los responsables de la firma de la Orden de Compra. Asócielos luego.",
    			'mensaje2'  => (string) ""
    		);
        }
        
        echo json_encode($resultado);
	}
	
    public function editarOrdenCompra($idOrdenCompra)
    {
        $idOrdenCompra    = htmlspecialchars($idOrdenCompra, ENT_QUOTES,'UTF-8');
    	if (isset($this->items['idUsuarioSession'])) 
    	{
    	    $oc = $this->ordenCompra->obtenerOrdenCompra($idOrdenCompra);
    	    
    	    $solicitante    = $this->usuarios->where("IdUsuario ", $oc['UsuarioSolicitante'])->first();
    	    
    	    if(isset($oc['IDDistrito']) && !empty($oc['IDDistrito']) && $oc['IDDistrito'] != null)
    	    {
        	    $distrito       = $this->regionDistrito->where("IDDistrito", $oc['IDDistrito'])->first();
        	    $provincia      = $this->regionProvincia->where("IDProvincia", $distrito['IDProvincia'])->first();
        	    $departamento   = $this->regionDepartamento->where("IDDepartamento", $provincia['IDDepartamento'])->first();
        	    $pais           = $this->regionPais->where("IDPais", $departamento['IDPais'])->first();
        	    
        	    $oc['Distrito']             = $distrito['Distrito'];
        	    $oc['Provincia']            = $provincia['Provincia'];
        	    $oc['Departamento']         = $departamento['Departamento'];
        	    $oc['Pais']                 = $pais['Pais'];
    	    }
    	    else
    	    {
    	        $oc['Distrito']             = "";
        	    $oc['Provincia']            = "";
        	    $oc['Departamento']         = "";
        	    $oc['Pais']                 = "";
    	    }
    	    
    	    if(isset($oc['IDSubarea']) && !empty($oc['IDSubarea']) && $oc['IDSubarea'] != null)
    	    {
    	        $subarea        = $this->estructuraSubareas->where("IDSubarea", $oc['IDSubarea'])->first();
        	    $area           = $this->estructuraAreas->where("IDArea", $subarea['IDArea'])->first();
        	   // $direccion      = $this->estructuraDirecciones->where("IDDireccion", $oc['IDDireccion'])->first();
    	        $oc['IDArea']       = $subarea['IDArea'];
    	        $oc['IDDireccion']  = $area['IDDireccion'];
    	    }
    	    else
    	    {
    	        $oc['IDArea']               = "";
    	        $oc['IDDireccion']          = "";
    	    }
    	    
    	    if(isset($oc['UsuarioComprador']) && !empty($oc['UsuarioComprador']) && $oc['UsuarioComprador'] != null)
    	    {
    	        $comprador      = $this->usuarios->where("IdUsuario ", $oc['UsuarioComprador'])->first();
    	    
        	    $oc['IDComprador']          = $oc['UsuarioComprador'];
        	    $oc['UsuarioComprador']     = ucwords(mb_strtolower($comprador['Nombres'].' '.$comprador['Apellidos']));
        	    $oc['MatriculaComprador']   = $comprador['Matricula'];
        	    
    	    }
    	    else
    	    {
    	        $oc['IDComprador']          = "";
        	    $oc['UsuarioComprador']     = "";
        	    $oc['MatriculaComprador']   = "";
    	    }
    	    
    	    
    	    $responsable01 = $this->usuarios->where("IdUsuario ", $oc['UsuarioFirma1'])->first();
    	    $responsable02 = $this->usuarios->where("IdUsuario ", $oc['UsuarioFirma2'])->first();
    	    $responsable03 = $this->usuarios->where("IdUsuario ", $oc['UsuarioFirma3'])->first();
    	    
    	    $oc['IDSolicitante']        = $oc['UsuarioSolicitante'];
    	    $oc['UsuarioSolicitante']   = ucwords(mb_strtolower($solicitante['Nombres'].' '.$solicitante['Apellidos']));
    	    $oc['CorreoSolicitante']    = $solicitante['Correo'];
    	    
    	    $oc['UsuarioAprobador01']   = ucwords(mb_strtolower($responsable01['Nombres'].' '.$responsable01['Apellidos']));
    	    $oc['CorreoAprobador01']    = $responsable01['Correo'];
    	    $oc['MatriculaAprobador01'] = $responsable01['Matricula'];
    	    $oc['IDAprobador01']        = $oc['UsuarioFirma1'];
    	    
    	    $oc['UsuarioAprobador02']   = ucwords(mb_strtolower($responsable02['Nombres'].' '.$responsable02['Apellidos']));
    	    $oc['CorreoAprobador02']    = $responsable02['Correo'];
    	    $oc['MatriculaAprobador02'] = $responsable02['Matricula'];
    	    
    	    $oc['UsuarioAprobador03']   = ucwords(mb_strtolower($responsable03['Nombres'].' '.$responsable03['Apellidos']));
    	    $oc['CorreoAprobador03']    = $responsable03['Correo'];
    	    $oc['MatriculaAprobador03'] = $responsable03['Matricula'];
    	    
    	    $monedas = $this->globales->monedas();
    	    
    	    $estados = $this->auditoria->listarAuditoriaEstadosOrdenCompra($idOrdenCompra);
    	    
            $data = array (
				'session'           => 'on',
				'titulo'            => 'Editar Orden de Compra | Verisure',
				'breadcrumb'        => $this->items['modulo'],
				'breadcrumb_alias'  => 'Editar Orden de Compra',
                'previo'            => 'listar-ordenes-compra',
				'informacionOC'     => $oc,
				'idOrdenCompra'     => $idOrdenCompra,
				'monedas'           => $monedas,
				'estados'           => $estados
			);
			
            $data = array_merge($data, $this->items);

            return view('proveedor/editar_orden_compra', $data);
        } else {
            return view('errors/500');
        }
    }
    
	public function modificarOrdenCompra($idOrdenCompra)
	{
	    $oc = $this->ordenCompra->obtenerOrdenCompra($idOrdenCompra);
	    
        $moneda = $this->globales->monedas();
            
	    $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $concepto_oc    = htmlspecialchars(trim($this->request->getPost('concepto_eoc')), ENT_QUOTES,'UTF-8');
		$fechapedido    = $this->request->getPost('fecha_pedido_eoc');
		$comprador      = $this->request->getPost('comprador_eoc');
		$envioFactura   = $this->request->getPost('envio_factura_eoc');
// 		$budget         = $this->request->getPost('budget_eoc');
		$condicionesIgv = $this->request->getPost('igv_eoc');
		$subcategoria   = $this->request->getPost('subcategoria_eoc');
// 		$delegacion     = $this->request->getPost('delegacion_eoc');
// 		$cc             = $this->request->getPost('cc_eoc');
// 		$ln             = $this->request->getPost('ln_eoc');
// 		$subarea        = $this->request->getPost('subarea_eoc');
		$observaciones  = htmlspecialchars(trim($this->request->getPost('observaciones_eoc')), ENT_QUOTES,'UTF-8');
	    $idProveedor    = $this->request->getPost('proveedor_eoc');
		$formapago      = $this->request->getPost('formapago_eoc');
		$modalidadPago  = $this->request->getPost('modalidadpago_eoc');
		$banco          = $this->request->getPost('banco_eoc');
		$tipomoneda     = $this->request->getPost('moneda_eoc');
		
		$cuentabancaria = $this->request->getPost('cuentabancaria_eoc');
		$cuentainterbancaria    = $this->request->getPost('cuentainterbancaria_eoc');
		
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
		$error = '';
		$error .= $this->complementos->validaCampo($concepto_oc, 'required|trim|minlength[1]|maxlength[255]', 'Concepto');
		$error .= $this->complementos->validaCampo($fechapedido, 'required|trim|dateDos|minlength[1]|maxlength[60]', 'Fecha Pedido');
		$error .= $this->complementos->validaCampo($comprador, 'required|trim|numeric', 'Comprador');
		$error .= $this->complementos->validaCampo($envioFactura, 'required|trim|alpha|minlength[1]|maxlength[2]', 'Envio Factura');
// 		$error .= $this->complementos->validaCampo($budget, 'required|trim|alpha|minlength[1]|maxlength[2]', 'Budget');
		$error .= $this->complementos->validaCampo($condicionesIgv, 'trim|alpha|minlength[1]|maxlength[10]', 'Condiciones IGV');
		$error .= $this->complementos->validaCampo($subcategoria, 'required|trim|numeric', 'Subcategoría');
// 		$error .= $this->complementos->validaCampo($delegacion, 'required|trim|numeric', 'Delegación');
// 		$error .= $this->complementos->validaCampo($cc, 'required|trim|numeric', 'CC');
// 		$error .= $this->complementos->validaCampo($ln, 'required|trim|numeric', 'LN');
// 		$error .= $this->complementos->validaCampo($subarea, 'required|trim|numeric', 'Subárea');
		$error .= $this->complementos->validaCampo($observaciones, 'trim', 'Observaciones');
		$error .= $this->complementos->validaCampo($idProveedor, 'required|trim|numeric', 'Id Proveedor');
		$error .= $this->complementos->validaCampo($formapago, 'required|trim|alphanumeric|minlength[1]|maxlength[30]', 'Forma de Pago');
		$error .= $this->complementos->validaCampo($modalidadPago, 'required|trim|alphanumeric|minlength[1]|maxlength[30]', 'Modalidad Pago');
		$error .= $this->complementos->validaCampo($banco, 'required|trim|minlength[1]|maxlength[200]', 'Banco');
		$error .= $this->complementos->validaCampo($tipomoneda, 'required|trim|alpha|minlength[1]|maxlength[5]', 'Tipo Moneda');
		
		$error .= $this->complementos->validaCampo($cuentabancaria, 'trim|minlength[1]|maxlength[100]', 'Cuenta Bancaria');
		$error .= $this->complementos->validaCampo($cuentainterbancaria, 'trim|minlength[1]|maxlength[100]', 'CCI');
		
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * ARMADO DE ARRAY DE ACTUALIZACIÓN
        * ----------------------------
        */

        $data = array (
            'Concepto'              => $concepto_oc,
            'IDProveedor'           => $idProveedor,
            'FormaPago'             => $formapago,
            'Observacion'           => $observaciones,
            'FechaPedido'           => $fechapedido,
            'CondicionesIGV'        => $condicionesIgv,
            'ModalidadPago'         => $modalidadPago,
            'Banco'                 => $banco,
            'CuentaBancaria'        => $cuentabancaria,
            'CuentaInterbancaria'   => $cuentainterbancaria,
            'TipoMoneda'            => $tipomoneda,
            'MontoCambio'           => (isset($moneda[$tipomoneda]) ? $moneda[$tipomoneda]['CAMBIO'] : 1),
            // 'Budget'                => $budget,
            // 'IDDelegacion'          => $delegacion,
            // 'CC'                    => $cc,
            // 'LN'                    => $ln,
            // 'IDSubarea'             => $subarea,
            // 'CompraCentralizada'    => $centralizada,
            'EnvioFactura'          => $envioFactura,
            'IDSubcategoria'        => $subcategoria,
            'UsuarioComprador'      => $comprador,
            'UsuarioModifica'       => $this->items['idUsuarioSession'],
            'FechaModifica'         => $fechaActual,    
            'Localhost'             => $this->request->getIPAddress()
        );

        /*
        * ----------------------------
        * ACTUALIZACIÓN DE ORDEN DE COMPRA
        * ----------------------------
        */

        $lastId = $this->ordenCompra->update([$idOrdenCompra], $data);
        
        if($lastId === FALSE)
        {
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al actualizar la Orden de Compra. Inténtelo luego.</li>");
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * ACTUALIZAR MONTOS TOTALES SI ES REQUERIDO
        * ----------------------------
        */
        
        $this->actualizarMontosCabeceraOrdenCompra($idOrdenCompra);
        
        /*
        * ----------------------------
        * MENSAJE DE ÉXITO
        * ----------------------------
        */
        $message = sprintf($this->mensajeError->msg201, "<li>Se actualizó la Orden de Compra correctamente.</li>");
        echo $this->alertas->alertaExito($message);
        echo $this->alertas->refrescar(1);
        EXIT;
	}
	
    public function validarCambioEstadoOrdenCompra()
    {
        $resultado = array(
			'ejecucion'  => (string) false,
			'mensaje1'  => (string) "",
			'mensaje2'  => (string) ""
		);
		
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idOrdenCompra  = $this->request->getPost('idOrdenCompra');
		$estado         = $this->request->getPost('estado');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idOrdenCompra, 'trim', 'ID');
		$error .= $this->complementos->validaCampo($estado, 'trim', 'Estado');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);

            $resultado = array(
    			'ejecucion' => false,
    			'popup'     => false,
    			'mensaje1'  => (string) $this->alertas->alertaError($message),
    			'mensaje2'  => (string) ""
    		);
    		
			echo json_encode($resultado);
			EXIT;
		}
		
		/*
        * -------------
        * OBTENER INFORMACIÓN DE TABLA
        * -------------
        */
		
        $datosOrdenCompra = $this->ordenCompra->obtenerOrdenCompra($idOrdenCompra);
        
		/*
        * -------------
        * VALIDAR USUARIO ACCESO
        * -------------
        */
        
        $responsable = ($datosOrdenCompra['Estado'] == "PendienteFirma1" ? $datosOrdenCompra['UsuarioFirma1'] : ($datosOrdenCompra['Estado'] == "PendienteFirma2" ? $datosOrdenCompra['UsuarioFirma2'] : $datosOrdenCompra['UsuarioFirma3']));
		
		if($this->items['idUsuarioSession'] == $responsable)
		{
		    //SI USUARIO LOGEADO == RESPONSABLE FIRMA
		    
		    $html = '';
		    
		    $textMensaje = in_array($estado, array("Aprobado", "PendienteFirma1", "PendienteFirma2", "PendienteFirma3")) ? "APROBAR" : ($estado == "Rechazado" ? "RECHAZAR" : "ANULAR");
		    
		    $html .= '<form id="formCambioEstadoOrdenCompra" class="formularioCambioEstadoOrdenCompra" autocomplete="off" action="'.$this->items['baseUrl'].'/cambiar-estado-orden-compra" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
			    <div class="modal-body d-flex justify-content-center">
			        <span class="respuesta"></span>
			        <input type="hidden" id="txtIDOrdenCompra_ceoc" name="txtIDOrdenCompra_ceoc" value="'.$idOrdenCompra.'">
			        <input type="hidden" id="txtEstadoOrdenCompra_ceoc" name="txtEstadoOrdenCompra_ceoc" value="'.$estado.'">
			        <input type="hidden" id="txtAutorizadoOC_ceoc" name="txtAutorizadoOC_ceoc" value="SI">
			        <div class="alert border-0 alert-success w-auto text-center" role="alert">
                        ¿Estas seguro que deseas <strong>'.$textMensaje.'</strong> la orden de compra?
                    </div>
    			</div>
    			<div class="modal-footer justify-content-center">
    				<button type="submit" class="btn bg-success color-white"><i class="mdi mdi-check-all mx-1" style="font-size: 14px;"></i> Confirmar</button>
    				<button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i> Cerrar</button>
    			</div>
    		</form>';
		    
		    $resultado = array(
    			'ejecucion' => false,
    			'popup'     => false,
    			'mensaje1'  => (string) $html,
    			'mensaje2'  => (string) ""
    		);
		}
		else if(in_array($this->items['idPerfilSession'], array(1,2)))
		{
		    $html = '';
		    
		    $textMensaje = in_array($estado, array("Aprobado", "PendienteFirma1", "PendienteFirma2", "PendienteFirma3")) ? "APROBAR" : ($estado == "Rechazado" ? "RECHAZAR" : "ANULAR");
		    
		    $html .= '<form id="formCambioEstadoOrdenCompra" class="formularioCambioEstadoOrdenCompra" autocomplete="off" action="'.$this->items['baseUrl'].'/cambiar-estado-orden-compra" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
			    <div class="row modal-body d-flex justify-content-center m-0">
			        <span class="respuesta"></span>
			        <input type="hidden" id="txtIDOrdenCompra_ceoc" name="txtIDOrdenCompra_ceoc" value="'.$idOrdenCompra.'">
			        <input type="hidden" id="txtEstadoOrdenCompra_ceoc" name="txtEstadoOrdenCompra_ceoc" value="'.$estado.'">
			        <input type="hidden" id="txtAutorizadoOC_ceoc" name="txtAutorizadoOC_ceoc" value="NO">
			        <div class="alert border-0 alert-success w-auto text-center mb-3" role="alert">
			            Usted no es el usuario autorizado para <strong>'.$textMensaje.'</strong> la orden de compra.<br>
                        ¿Estas seguro que deseas <strong>'.$textMensaje.'</strong> la orden de compra?<br>
                        Adjunte la autorización enviada.<br>
                    </div>
					<div class="col-xxl-12 col-md-12 col-12 mb-3">
						<div>
							<label for="txtObservacionCambioEstadoOC_ceoc" class="form-label">Observación</label>
							<textarea class="form-control" id="txtObservacionCambioEstadoOC_ceoc" name="txtObservacionCambioEstadoOC_ceoc" rows="4"></textarea>
						</div>
					</div>
					<div class="col-xxl-12 col-md-12 col-12 m-0">
						<input type="file" id="txtAdjuntoCambioEstadoOC_ceoc" class="filepond" name="txtAdjuntoCambioEstadoOC_ceoc" multiple data-max-file-size="100MB" data-max-files="3" />
					</div>
					<script>
					    $(function () {
					        pondAutorizacionOC = FilePond.create(
                                document.querySelector("#txtAdjuntoCambioEstadoOC_ceoc"), {
                                    labelIdle: \'Arrastra y suelta tus archivos o <span class="filepond--label-action">explora</span>\',
                                    allowMultiple: true,
                                    instantUpload: false,
                                    allowProcess: false
                                }
                            );
					    });
					</script>
    			</div>
    			<div class="modal-footer justify-content-center">
    				<button type="submit" class="btn bg-success color-white"><i class="mdi mdi-check-all mx-1" style="font-size: 14px;"></i> Confirmar</button>
    				<button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i> Cerrar</button>
    			</div>
    		</form>';
		    
		    $resultado = array(
    			'ejecucion' => false,
    			'popup'     => false,
    			'mensaje1'  => (string) $html,
    			'mensaje2'  => (string) ""
    		);
		}
		else
		{
		    //SI USUARIO NO ES NINGUNO DE LOS ANTERIORES
		    
		    $html = '';
		    
		    $textMensaje = in_array($estado, array("Aprobado", "PendienteFirma1", "PendienteFirma2", "PendienteFirma3")) ? "APROBAR" : ($estado == "Rechazado" ? "RECHAZAR" : "ANULAR");
		    
		    $html .= '<div class="modal-body d-flex justify-content-center">
		        <span class="respuesta"></span>
		        <div class="alert border-0 alert-danger w-auto text-center" role="alert">
		            Usted no está autorizado a realizar cambio alguno en la OC.
		            Pongase en contacto con Soporte IT Perú si considera es un error.
                </div>
			</div>
			<div class="modal-footer justify-content-center">
				<button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i> Cerrar</button>
			</div>';
		    
		    $resultado = array(
    			'ejecucion' => false,
    			'popup'     => false,
    			'mensaje1'  => (string) $html,
    			'mensaje2'  => (string) ""
    		);
		}
		
		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);	
    }
    
    public function modificarEstadoOrdenCompra()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idOrdenCompra  = $this->request->getPost('txtIDOrdenCompra_ceoc');
        $estado         = $this->request->getPost('txtEstadoOrdenCompra_ceoc');
        $motivo         = htmlspecialchars($this->request->getPost('txtObservacionCambioEstadoOC_ceoc'), ENT_QUOTES,'UTF-8');
        $autorizado     = $this->request->getPost('txtAutorizadoOC_ceoc');
        
        $adjuntos       = $this->request->getFiles("fileAutorizacion"); 
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idOrdenCompra, 'required|trim|numeric', 'ID Orden de Compra');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|minlength[1]|maxlength[30]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'trim', 'Motivo');
        $error .= $this->complementos->validaCampo($autorizado, 'required|trim|minlength[2]|maxlength[2]', 'Autorización');

        /*
        * ----------------------------
        * VALIDACIÓN DE AUTORIZACIÓN
        * ----------------------------
        */
        
        if($autorizado == "NO")
        {
            if(empty($adjuntos))
    	    {
    	        $error .= "<li>No hay archivos adjuntos. [CAMPO] <small>ARCHIVOS ADJUNTOS</small></li>";
    	    }
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */
        
        $datosOrdenCompra = $this->ordenCompra->obtenerOrdenCompra($idOrdenCompra);
        
        if($autorizado == "NO")
        {
            $nonecesarios = array("-", ":", " ");
            $textFechaActual = str_replace($nonecesarios, "", $fechaActual);
            
            $adjuntosGuardados = 0;
            $adjuntosNoGuardados = 0;
            $idAdjuntos = array();
            $nombreAdjuntos = array();
            
            $ruta = "public/files/OrdenCompra/Autorizacion/".date("Y", strtotime($fechaActual))."/".date("m", strtotime($fechaActual))."/";
            
            foreach ($adjuntos['fileAutorizacion'] as $key => $value) 
	        {
	           // echo $key."<br>";
                if ($value->isValid() && ! $value->hasMoved()) 
                {
                    if($value->guessExtension() != null)
                    {
                        $extensionDoc = $value->guessExtension();
                    }
                    else
                    {
                        $nombre_original = $value->getBasename();
                        $fileNameCmps = explode(".", $nombre_original);
                        $extensionDoc = strtolower(end($fileNameCmps));
                    }
                    
                    $nombreArchivo = $idOrdenCompra."-".$textFechaActual."-".$key;
                    
                    $nombreAdjuntos[] = $nombreArchivo.'.'.$extensionDoc;
                    
                    /*
                    * ----------------------------
                    * GUARDAR ARCHIVO ADJUNTO
                    * ----------------------------
                    */
                    $dataAdjunto = array (
                        'IDOrdenCompra'         => $idOrdenCompra, 
                        'Nombre'                => $nombreArchivo,
                        'Extension'             => $extensionDoc, 
                        'Observacion'           => "Autorización para el cambio de estado de la OC", 
                        'EstadoAsociado'        => $datosOrdenCompra['Estado'], 
                        'UsuarioCrea'           => $this->items['idUsuarioSession'],
                        'FechaCrea'             => $fechaActual,
                        'Localhost'             => $this->request->getIPAddress()
                    );
                    
                    $lastIdAdjunto = $this->ordenCompraAdjuntos->insert($dataAdjunto, TRUE);
                    
                    if($lastIdAdjunto !== FALSE)
	                {
	                    $idAdjuntos[] = $lastIdAdjunto;
                        /*
                        * ----------------------------
                        * GUARDAR ARCHIVO ADJUNTO
                        * ----------------------------
                        */
                        if(!file_exists($ruta))
                        {
                            @mkdir($ruta, 0777, true);
                        }
                
                		# si exsite la carpeta o se ha creado
                		if (file_exists($ruta) || @mkdir($ruta)) 
                        {
                            
                            $estadoMove = $value->move($ruta, $nombreArchivo.'.'.$extensionDoc);
                            
                            if (!$estadoMove) {
                                $adjuntosNoGuardados++;
                            }
                            else
                            {
                                $adjuntosGuardados++;
                            }
                        }
                        else
                        {
                            $adjuntosNoGuardados++;
                        }
	                }
                    else
                    {
                        $adjuntosNoGuardados++;
                    }
                }
                else
                {
                    $adjuntosNoGuardados++;
                }
            }
            
    //         if($adjuntosNoGuardados == 0 && $adjuntosGuardados > 0)
    //         {
    //             $message = sprintf($this->mensajeError->msg201, "Se guardaron todos los archivos");
    // 			echo $this->alertas->alertaExito($message);
    // exit;
    //         }
    //         else 
            if($adjuntosNoGuardados > 0 && $adjuntosGuardados == 0)
            {
                if(!empty($idAdjuntos))
                {
                    $this->ordenCompraAdjuntos->whereIn("IDAdjuntoOC", $idAdjuntos)->delete();
                }
                
                $message = sprintf($this->mensajeError->msg201, "No se guardó ningún archivo. Inténtelo luego.");
    			echo $this->alertas->alertaError($message);
    			EXIT;
            }
            else if($adjuntosNoGuardados > 0 && $adjuntosGuardados > 0)
            {
                if(!empty($idAdjuntos))
                {
                    $this->ordenCompraAdjuntos->whereIn("IDAdjuntoOC", $idAdjuntos)->delete();
                    
                    foreach($nombreAdjuntos as $file)
                    {
                        unlink($ruta.$file);
                    }
                    
                }
                
                $message = sprintf($this->mensajeError->msg201, "No se guardó ningún archivo. Inténtelo luego.");
    			echo $this->alertas->alertaExito($message);
    			EXIT;
            }
        }
        
        $data = array (
            'UsuarioModifica'   => $this->items['idUsuarioSession'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['idUsuarioSession'],
            'FechaEstado'       => $fechaActual,
            'MotivoEstado'      => ($motivo == "" || $motivo == null ? ( $estado == "Rechazado" ? "OC Rechazada" : ($estado == "Anulado" ? "OC Anulada" : "OC Aprobada" ) ) : $motivo),
            'Estado'            => $estado
        );
        
        $lastId = $this->ordenCompra->update([$idOrdenCompra], $data);

		if($lastId !== FALSE){
		    
			$message = sprintf($this->mensajeError->msg503, $idOrdenCompra);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function recargarTablaDetalleOrdenCompra()
    {
        $resultado['data'] = array();
        
        $idOrdenCompra = htmlspecialchars($this->request->getPost("idOrdenCompra"), ENT_QUOTES,'UTF-8');
        
        $whereDetalle = array(
            "IDOrdenCompra" => $idOrdenCompra,
            "Estado"        => "A"
        );
        
        $oc = $this->ordenCompra->obtenerOrdenCompra($idOrdenCompra);
        $detalleoc = $this->ordenCompraDetalle->where($whereDetalle)->findAll();
        
        $moneda = $this->globales->monedas();
            
        foreach($detalleoc as $key=>$item)
        {
            $preciototal = number_format(round($item['Cantidad']*$item['PrecioUnitario'], 2), 2, '.', '');
            
            $resultado['data'][$key] = array(
                'perfillogueado'        => (string) $this->items['idPerfilSession'],
				'idordencompra'         => (string) $idOrdenCompra,
				'iddetalleoc'           => (string) $item['IDDetalleOC'],
				'estado'                => (string) $item['Estado'],
				'estadooc'              => (string) $oc['Estado'],
				'afectaigv'             => (string) $oc['CondicionesIGV'],
				'correlativo'           => (string) ($key+1),
				'descripcion'           => (string) $item['Descripcion'],
				'cantidad'              => (string) $item['Cantidad'],
				'moneda'                => (string) $moneda[$oc['TipoMoneda']]['SIMBOLO'],
				'preciounitario'        => (string) $item['PrecioUnitario'],
				'preciototal'           => (string) $preciototal,
				'acciones'              => (string) ""
			);
        }
        
		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);
    }
    
	public function registrarDetalleOrdenCompra()
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        $resultado = array(
			'ejecucion'  => (string) false,
			'mensaje1'  => (string) "",
			'mensaje2'  => (string) ""
		);
		
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $oc         = htmlspecialchars($this->request->getPost('txtIDOrdenCompra_eoc'), ENT_QUOTES,'UTF-8');
        $descripcion= htmlspecialchars($this->request->getPost('descripcionItem_eoc'), ENT_QUOTES,'UTF-8');
        $cantidad   = htmlspecialchars($this->request->getPost('cantidadItem_eoc'), ENT_QUOTES,'UTF-8');
        $precio     = htmlspecialchars($this->request->getPost('precioItem_eoc'), ENT_QUOTES,'UTF-8');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($oc, 'required|trim|numeric', 'ID Orden Compra');
        $error .= $this->complementos->validaCampo($descripcion, 'required|trim|alphaspecial|minlength[1]|maxlength[200]', 'Descripción');
        $error .= $this->complementos->validaCampo($cantidad, 'required|trim|numeric', 'Cantidad');
        $error .= $this->complementos->validaCampo($precio, 'required|trim|decimal', 'Precio Unitario');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            
            $resultado = array(
    			'ejecucion'  => false,
    			'popup' => false,
    			'mensaje1'  => (string) $this->alertas->alertaError($message),
    			'mensaje2'  => (string) ""
    		);
    		
			echo json_encode($resultado);
			EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            'IDOrdenCompra'     => $oc,
            'Descripcion'       => $descripcion,
            'Cantidad'          => $cantidad,
            'PrecioUnitario'    => $precio,
            'UsuarioCrea'       => $this->items['idUsuarioSession'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['idUsuarioSession'],
            'FechaEstado'       => $fechaActual,    
            'MotivoEstado'      => "Creación de Detalle OC",    
            'Estado'            => "A"
        );

        $lastId = $this->ordenCompraDetalle->insert($data, TRUE);

        if($lastId !== FALSE){
            $this->actualizarMontosCabeceraOrdenCompra($oc);
            
            $message = sprintf($this->mensajeError->msg502, $oc);
            $resultado = array(
    			'ejecucion'  => true,
    			'popup' => false,
    			'mensaje1'  => (string) $this->alertas->alertaExito($message),
    			'mensaje2'  => (string) ""
    		);
        }
        else
        {
			$resultado = array(
    			'ejecucion'  => false,
    			'popup' => true,
    			'mensaje1'  => (string) "Hubo un problema al registrar el detalle de la OC. Inténtelo luego.",
    			'mensaje2'  => (string) ""
    		);
        }
        
        echo json_encode($resultado);
	}
	
	public function obtenerDatosDetalleOrdenCompra()
	{
	    /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idDetalle = $this->request->getPost('idDetalleOC');
// var_dump($idDetalle);exit;
		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idDetalle, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosDetalle = $this->ordenCompraDetalle->where("IDDetalleOC", $idDetalle)->first();

		if(!empty($datosDetalle)){
			$resultado = array(
				'iddetalle'     => (string) $idDetalle,
				'idordencompra' => (string) $datosDetalle['IDOrdenCompra'],
				'descripcion'   => (string) $datosDetalle['Descripcion'],
				'cantidad'      => (string) $datosDetalle['Cantidad'],
				'precio'        => (string) $datosDetalle['PrecioUnitario']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);		
	}
	
	public function modificarDetalleOrdenCompra($idDetalle)
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        $resultado = array(
			'ejecucion'  => (string) false,
			'mensaje1'  => (string) "",
			'mensaje2'  => (string) ""
		);
		
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $descripcion= htmlspecialchars($this->request->getPost('descripcionItem_eoc'), ENT_QUOTES,'UTF-8');
        $cantidad   = htmlspecialchars($this->request->getPost('cantidadItem_eoc'), ENT_QUOTES,'UTF-8');
        $precio     = htmlspecialchars($this->request->getPost('precioItem_eoc'), ENT_QUOTES,'UTF-8');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($descripcion, 'required|trim|alphaspecial|minlength[1]|maxlength[200]', 'Descripción');
        $error .= $this->complementos->validaCampo($cantidad, 'required|trim|numeric', 'Cantidad');
        $error .= $this->complementos->validaCampo($precio, 'required|trim|decimal', 'Precio Unitario');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            
            $resultado = array(
    			'ejecucion'  => false,
    			'popup' => false,
    			'mensaje1'  => (string) $this->alertas->alertaError($message),
    			'mensaje2'  => (string) ""
    		);
    		
			echo json_encode($resultado);
			EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */
        
        $infoOC = $this->ordenCompraDetalle->where("IDDetalleOC", $idDetalle)->first();
		
        $data = array (
            'Descripcion'       => $descripcion,
            'Cantidad'          => $cantidad,
            'PrecioUnitario'    => $precio,
            'UsuarioModifica'   => $this->items['idUsuarioSession'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->ordenCompraDetalle->update([$idDetalle], $data);

        if($lastId !== FALSE){
            
            $this->actualizarMontosCabeceraOrdenCompra($infoOC['IDOrdenCompra']);
            
            $message = sprintf($this->mensajeError->msg503, $idDetalle);
            $resultado = array(
    			'ejecucion'  => true,
    			'popup' => false,
    			'mensaje1'  => (string) $this->alertas->alertaExito($message),
    			'mensaje2'  => (string) ""
    		);
        }
        else
        {
			$resultado = array(
    			'ejecucion'  => false,
    			'popup' => true,
    			'mensaje1'  => (string) "Hubo un problema al actualizar el detalle de la OC. Inténtelo luego.",
    			'mensaje2'  => (string) ""
    		);
        }
        
        echo json_encode($resultado);
	}
	
    public function modificarEstadoDetalleOrdenCompra()
    {
        $fechaActual = date("Y-m-d H:i:s");

        $resultado = array(
			'ejecucion'  => (string) false,
			'mensaje1'  => (string) "",
			'mensaje2'  => (string) ""
		);
		
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idDetalle  = $this->request->getPost('idDetalle');
        $idOC       = $this->request->getPost('idOrdenCompra');
        $estado     = htmlspecialchars($this->request->getPost('estado'), ENT_QUOTES,'UTF-8');
        $motivo     = htmlspecialchars($this->request->getPost('motivo'), ENT_QUOTES,'UTF-8');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idDetalle, 'required|trim|numeric', 'ID Detalle');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * VALIDACIÓN DE CANTIDAD DE ELEMENTOS
        * ----------------------------
        */
        
        if($estado == "I")
        {
            $whereDetalle = array(
                "IDOrdenCompra" => $idOC,
                "Estado"        => "A"
            );
            
            $detalleOC = $this->ordenCompraDetalle->where($whereDetalle)->findAll();
            
            if(count($detalleOC) == 1)
            {
                $message = sprintf($this->mensajeError->msg201, "La OC debe tener mínimo un detalle. Debe registrar un nuevo registro para eliminar el actual.");
            
                $resultado = array(
        			'ejecucion'  => false,
        			'popup' => true,
        			'mensaje1'  => (string) $this->alertas->alertaError($message),
        			'mensaje2'  => (string) ""
        		);
        		
    			echo json_encode($resultado);
    			EXIT;
            }
            
        }
        /*
        * ----------------------------
        * ACTUALIZACIÓN DE INFORMACIÓN
        * ----------------------------
        */
        
        $infoOC = $this->ordenCompraDetalle->where("IDDetalleOC", $idDetalle)->first();
        
        $data = array (
            'UsuarioModifica'   => $this->items['idUsuarioSession'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['idUsuarioSession'],
            'FechaEstado'       => $fechaActual,
            'MotivoEstado'      => $motivo,
            'Estado'            => $estado
        );
        
        $lastId = $this->ordenCompraDetalle->update([$idDetalle], $data);

        if($lastId !== FALSE){
            $this->actualizarMontosCabeceraOrdenCompra($infoOC['IDOrdenCompra']);
            
            $message = sprintf($this->mensajeError->msg504, $idDetalle);
            $resultado = array(
    			'ejecucion'  => true,
    			'popup' => false,
    			'mensaje1'  => (string) $this->alertas->alertaExito($message),
    			'mensaje2'  => (string) ""
    		);
        }
        else
        {
			$resultado = array(
    			'ejecucion'  => false,
    			'popup' => true,
    			'mensaje1'  => (string) "Hubo un problema al eliminar el detalle de la OC. Inténtelo luego.",
    			'mensaje2'  => (string) ""
    		);
        }
        
        echo json_encode($resultado);
    }
    
	public function modificarResponsablesFirmaOrdenCompra()
	{
	    $fechaActual = date("Y-m-d H:i:s");
	    
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $idOrdenCompra  = htmlspecialchars($this->request->getPost('idoc_roc'), ENT_QUOTES,'UTF-8');
        $delegacion     = htmlspecialchars($this->request->getPost('cboDelegacionOC_roc'), ENT_QUOTES,'UTF-8');
        $cc             = htmlspecialchars($this->request->getPost('cc_roc'), ENT_QUOTES,'UTF-8');
        $ln             = htmlspecialchars($this->request->getPost('ln_roc'), ENT_QUOTES,'UTF-8');
        $subarea        = htmlspecialchars($this->request->getPost('cboSubareaOC_roc'), ENT_QUOTES,'UTF-8');
        $firma01        = htmlspecialchars($this->request->getPost('cboResponsableFirma01OC_roc'), ENT_QUOTES,'UTF-8');
        $firma02        = htmlspecialchars($this->request->getPost('cboResponsableFirma02OC_roc'), ENT_QUOTES,'UTF-8');
        $firma03        = htmlspecialchars($this->request->getPost('cboResponsableFirma03OC_roc'), ENT_QUOTES,'UTF-8');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idOrdenCompra, 'required|trim|numeric', 'ID Orden de Compra');
        $error .= $this->complementos->validaCampo($delegacion, 'required|trim|numeric', 'Delegación');
        $error .= $this->complementos->validaCampo($cc, 'required|trim|numeric', 'CC');
        $error .= $this->complementos->validaCampo($ln, 'required|trim|numeric', 'LN');
        $error .= $this->complementos->validaCampo($subarea, 'required|trim|numeric', 'Subárea');
        $error .= $this->complementos->validaCampo($firma01, 'required|trim|numeric', 'Firma 01');
        $error .= $this->complementos->validaCampo($firma02, 'required|trim|numeric', 'Firma 02');
        $error .= $this->complementos->validaCampo($firma03, 'required|trim|numeric', 'Firma 03');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * -------------
        * ACTUALIZACIÓN DE DELEGACIÓN, SUBÁREA, CC Y LN
        * -------------
        */            
		
        $data = array (
            'IDDelegacion'      => $delegacion,
            'CC'                => $cc,
            'LN'                => $ln,
            'IDSubarea'         => $subarea,
            'UsuarioModifica'   => $this->items['idUsuarioSession'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'Estado'            => "PendienteFirma1",
            'UsuarioEstado'     => $this->items['idUsuarioSession'],
            'FechaEstado'       => $fechaActual,
            'MotivoEstado'      => "Estado modificado por cambio de Subárea."
        );

        $lastId = $this->ordenCompra->update([$idOrdenCompra], $data);

        if($lastId === FALSE){
            $message = sprintf($this->mensajeError->msg201, "<li>No se pudo actualizar la delegación/subárea. Inténtelo luego.</li>");
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }
        
        /*
        * -------------
        * ACTUALIZACIÓN DE RESPONSABLES DE FIRMA
        * -------------
        */
		
        // $whereUpdate = array(
            
        // );
        
        $updatePrincipal = array (
            'IDOrdenCompra'     => $idOrdenCompra,
            'UsuarioFirma1'     => $firma01,
            'UsuarioFirma2'     => $firma02,
            'UsuarioFirma3'     => $firma03,
            'UsuarioModifica'   => $this->items['idUsuarioSession'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        // $lastIdResp = $this->ordenCompraResponsable->where($whereUpdate)->set($updatePrincipal)->update();
        $lastIdResp = $this->ordenCompraResponsable->replace($updatePrincipal);
    		    

        if($lastIdResp !== FALSE){
            $message = sprintf($this->mensajeError->msg503, $idOrdenCompra);
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }
        
	}
    
	public function obtenerDatosGraficaCompra()
	{
		/* DATOS ORDEN DE COMPRA */

		$perfil = $this->items['idPerfilSession'];
		$idUsuario = $this->items['idUsuarioSession'];
		
		$whereTotal = array(
		    "solicitante"   => $idUsuario,
		    "idperfil"      => $perfil,
		    "responsable"   => $idUsuario
		);
		
		$wherePF1 = array(
		    "solicitante"   => $idUsuario,
		    "idperfil"      => $perfil,
		    "estado"        => "PendienteFirma1",
		    "responsable"   => $idUsuario
		);
		
		$wherePF2 = array(
		    "solicitante"   => $idUsuario,
		    "idperfil"      => $perfil,
		    "estado"        => "PendienteFirma2",
		    "responsable"   => $idUsuario
		);
		
		$wherePF3 = array(
		    "solicitante"   => $idUsuario,
		    "idperfil"      => $perfil,
		    "estado"        => "PendienteFirma3",
		    "responsable"   => $idUsuario
		);
		
		$whereAprobado = array(
		    "solicitante"   => $idUsuario,
		    "idperfil"      => $perfil,
		    "estado"        => "Aprobado",
		    "responsable"   => $idUsuario
		);
		
		$whereRechazado = array(
		    "solicitante"   => $idUsuario,
		    "idperfil"      => $perfil,
		    "estado"        => "Rechazado",
		    "responsable"   => $idUsuario
		);
		
		$whereAnulado = array(
		    "solicitante"   => $idUsuario,
		    "idperfil"      => $perfil,
		    "estado"        => "Anulado",
		    "responsable"   => $idUsuario
		);
		
// 		var_dump($this->ordenCompra->obtenerCantidadOrdenCompra($whereTotal));exit;
		$totalOC            = count($this->ordenCompra->obtenerCantidadOrdenCompra($whereTotal));
		$pendiente_firma1   = count($this->ordenCompra->obtenerCantidadOrdenCompra($wherePF1));
		$pendiente_firma2   = count($this->ordenCompra->obtenerCantidadOrdenCompra($wherePF2));
		$pendiente_firma3   = count($this->ordenCompra->obtenerCantidadOrdenCompra($wherePF3));
		$aprobadoOC         = count($this->ordenCompra->obtenerCantidadOrdenCompra($whereAprobado));
		$rechazadoOC        = count($this->ordenCompra->obtenerCantidadOrdenCompra($whereRechazado));
		$anuladoOC          = count($this->ordenCompra->obtenerCantidadOrdenCompra($whereAnulado));
		
		$porcentaje_firma1      = ($totalOC == 0 ? 0 : (($pendiente_firma1 * 100) / $totalOC));
        $porcentaje_firma2      = ($totalOC == 0 ? 0 : (($pendiente_firma2 * 100) / $totalOC));
        $porcentaje_firma3      = ($totalOC == 0 ? 0 : (($pendiente_firma3 * 100) / $totalOC));
        $porcentaje_aprobado    = ($totalOC == 0 ? 0 : (($aprobadoOC * 100) / $totalOC));
        $porcentaje_rechazado   = ($totalOC == 0 ? 0 : (($rechazadoOC * 100) / $totalOC));
        $porcentaje_anulado     = ($totalOC == 0 ? 0 : (($anuladoOC * 100) / $totalOC));
        
        $porcentaje_firma1 = round($porcentaje_firma1);
		$porcentaje_firma2 = round($porcentaje_firma2);
		$porcentaje_firma3 = round($porcentaje_firma3);
		$porcentaje_aprobado = round($porcentaje_aprobado);
		$porcentaje_rechazado = round($porcentaje_rechazado);
		$porcentaje_anulado = round($porcentaje_anulado);

		$resultado[] = array(
			'pendiente_firma1'      => (string) $pendiente_firma1,
			'pendiente_firma2'      => (string) $pendiente_firma2,
			'pendiente_firma3'      => (string) $pendiente_firma3,
			'aprobado'              => (string) $aprobadoOC,
			'rechazado'             => (string) $rechazadoOC,
			'anulado'               => (string) $anuladoOC,
			'porcentaje_firma1'     => (string) $porcentaje_firma1,
			'porcentaje_firma2'     => (string) $porcentaje_firma2,
			'porcentaje_firma3'     => (string) $porcentaje_firma3,
			'porcentaje_aprobado'   => (string) $porcentaje_aprobado,
			'porcentaje_rechazado'  => (string) $porcentaje_rechazado,
			'porcentaje_anulado'    => (string) $porcentaje_anulado,
			'totaloc'               => (string) $totalOC

		);

		echo json_encode($resultado, JSON_NUMERIC_CHECK);
        
// 		$usuariosesion = $this->items['usuarioSession'];
// 		$idArea = $this->items['idArea'];

// 		if ($perfil == 2) {

// 			if ($idArea == 2) {

// 				$sql = $this->ordenCompraModelo
// 					->select(['Estado', 'COUNT(*) as Cantidad'])
// 					->groupBy('Estado')
// 					->findAll();
// 			} else {
// 				$whereOc = array(
// 					'oc.Id_U' => $idUsuario
// 				);

// 				$sql = $this->ordenCompraModelo
// 					->select(['Estado', 'COUNT(*) as Cantidad'])
// 					->where($whereOc)
// 					->groupBy('Estado')
// 					->findAll();
// 			}
// 		}
// 		//PERFIL DE SUPERVISOR
// 		else if ($perfil == 3) {

// 			if ($idArea == 2) {
// 				$sql = $this->ordenCompraModelo
// 					->select(['Estado', 'COUNT(*) as Cantidad'])
// 					->groupBy('Estado')
// 					->findAll();
// 			} else {
// 				$whereOc = array(
// 					'area.Responsable' => $usuariosesion
// 				);

// 				$sql = $this->areaModelo
// 					->select(['oc.Estado', 'COUNT(*) as Cantidad'])
// 					->join('oc', 'oc.CC_OC = area.CC and oc.LN_OC=area.LN')
// 					->where($whereOc)
// 					->groupBy('oc.Estado')
// 					->findAll();
// 			}
// 		}
// 		//PERFIL APROBADOR
// 		else if ($perfil == 10) {

// 			$whereOc = array(
// 				'area.Director' => $usuariosesion
// 			);

// 			$OrwhereOc = array(
// 				'area.DirectorFinal' => $usuariosesion
// 			);

// 			$sql = $this->areaModelo
// 				->select(['oc.Estado', 'COUNT(*) as Cantidad'])
// 				->join('oc', 'oc.CC_OC = area.CC and oc.LN_OC=area.LN')
// 				->join('proveedor', 'proveedor.Id_Pro = oc.Id_Pro')
// 				->join('usuario', 'usuario.Id_U = oc.Id_U')
// 				->where($whereOc)
// 				->orWhere($OrwhereOc)
// 				->groupBy('oc.Estado')
// 				->findAll();
// 		} else if ($perfil == 1) {
// 			//PERFIL ADMINISTRADOR

// 			$sql = $this->ordenCompraModelo
// 				->select(['Estado', 'COUNT(*) as Cantidad'])
// 				->groupBy('Estado')
// 				->findAll();
// 			// $sql = "SELECT oc.Estado,COUNT(*) as Cantidad from oc GROUP by oc.Estado";
// 		} else {
// 			//NO TIENE ASIGNADO PERFIL
// 			$sql = "";
// 		}
/*
       $sql = $this->ordenCompra
					->select(['Estado', 'COUNT(*) as Cantidad'])
					->groupBy('Estado')
					->findAll();
					
		$pendiente_firma1 = 0;
		$pendiente_firma2 = 0;
		$pendiente_firma3 = 0;
		$aprobado = 0;
		$rechazado = 0;
		$anulado = 0;
		
		if (!empty($sql)) {

			foreach ($sql as $key => $value) {

				// while ($sql = mysqli_fetch_assoc($conestado)) {
				$porestado = $value['Estado'];
				$porcantidadestado = $value['Cantidad'];
				if ($porestado == 'PendienteFirma1') {
					$pendiente_firma1 = $porcantidadestado;
				}
				if ($porestado == 'PendienteFirma2') {
					$pendiente_firma2 = $porcantidadestado;
				}
				if ($porestado == 'PendienteFirma3') {
					$pendiente_firma3 = $porcantidadestado;
				}
				if ($porestado == 'Aprobado') {
					$aprobado = $porcantidadestado;
				}
				if ($porestado == "Rechazado") {
					$rechazado = $porcantidadestado;
				}
				if ($porestado == "Anulado") {
					$anulado = $porcantidadestado;
				}
				// }
			}
		}

		$totaloc = ($pendiente_firma1 + $pendiente_firma2 + $pendiente_firma3 + $aprobado + $anulado + $rechazado);
		if (empty($totaloc)) {
			$porcentaje_firma1 = 0;
			$porcentaje_firma2 = 0;
			$porcentaje_firma3 = 0;
			$porcentaje_aprobado = 0;
			$porcentaje_rechazado = 0;
			$porcentaje_anulado = 0;
		} else {
			if (empty($pendiente_firma1) || !isset($pendiente_firma1) || $pendiente_firma1 == 0) {
				$porcentaje_firma1 = 0;
			} else {
				$porcentaje_firma1 = ($pendiente_firma1 * 100) / $totaloc;
			}
			if (empty($pendiente_firma2) || !isset($pendiente_firma2) || $pendiente_firma2 == 0) {
				$porcentaje_firma2 = 0;
			} else {
				$porcentaje_firma2 = ($pendiente_firma2 * 100) / $totaloc;
			}
			if (empty($pendiente_firma3) || !isset($pendiente_firma3) || $pendiente_firma3 == 0) {
				$porcentaje_firma3 = 0;
			} else {
				$porcentaje_firma3 = ($pendiente_firma3 * 100) / $totaloc;
			}
			if (empty($aprobado) || !isset($aprobado) || $aprobado == 0) {
				$porcentaje_aprobado = 0;
			} else {
				$porcentaje_aprobado = ($aprobado * 100) / $totaloc;
			}
			if (empty($rechazado) || !isset($rechazado) || $rechazado == 0) {
				$porcentaje_rechazado = 0;
			} else {
				$porcentaje_rechazado = ($rechazado * 100) / $totaloc;
			}
			if (empty($anulado) || !isset($anulado) || $anulado == 0) {
				$porcentaje_anulado = 0;
			} else {
				$porcentaje_anulado = ($anulado * 100) / $totaloc;
			}

			$porcentaje_firma1 = round($porcentaje_firma1);
			$porcentaje_firma2 = round($porcentaje_firma2);
			$porcentaje_firma3 = round($porcentaje_firma3);
			$porcentaje_aprobado = round($porcentaje_aprobado);
			$porcentaje_rechazado = round($porcentaje_rechazado);
			$porcentaje_anulado = round($porcentaje_anulado);
		}


		$resultado[] = array(
			'pendiente_firma1' => (string) $pendiente_firma1,
			'pendiente_firma2' => (string) $pendiente_firma2,
			'pendiente_firma3' => (string) $pendiente_firma3,
			'aprobado' => (string) $aprobado,
			'rechazado' => (string) $rechazado,
			'anulado' => (string) $anulado,
			'porcentaje_firma1' => (string) $porcentaje_firma1,
			'porcentaje_firma2' => (string) $porcentaje_firma2,
			'porcentaje_firma3' => (string) $porcentaje_firma3,
			'porcentaje_aprobado' => (string) $porcentaje_aprobado,
			'porcentaje_rechazado' => (string) $porcentaje_rechazado,
			'porcentaje_anulado' => (string) $porcentaje_anulado,
			'totaloc' => (string) $totaloc

		);

		echo json_encode($resultado, JSON_NUMERIC_CHECK);*/
	}

	/**************************************************************************/
	
	public function importarCSVOrdenCompra()
	{
	    $fechaActual = date("Y-m-d H:i:s");
	    
	   // var_dump($this->request->getFiles());exit;
		$UsuarioComprador = $this->items['idUsuarioSession'];
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        
		* ----------------------------
        * DECLARAR Y ASIGNAR VARIABLE A ARCHIVO OBTENIDO
        * ----------------------------
        */
        
        $csv = $this->request->getFile("itemsFile");

		/*
		* ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
         if (! $csv->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $csv->getErrorString().'-'.$csv->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }

		/* ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'itemsFile' => [
                'mime_in[itemsFile,text/csv,text/plain,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,application/msexcel,application/xls,application/x-xls]',
                'ext_in[itemsFile,csv]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

		/*
        * ----------------------------
        * VALIDAR SEPARADOR CSV
        * ----------------------------
        */
		$numeroColumnas = 20; //numero de columnas en el archivo
		$separadorCSV = $this->complementos->validarSeparadorCSV($csv, $numeroColumnas);
        
        if (!$separadorCSV) {
            $message = sprintf($this->mensajeError->msg201, "No se encontró separador de CSV autorizado. Debe usar coma (,) o punto y coma (;) y eliminar celdas vacías a la derecha de la última columna.");
			echo $this->alertas->alertaError($message);
			exit;
        }

		/*
        * ----------------------------
        * RECORRER ARCHIVO Y VALIDAR DATOS CORRECTOS
        * ----------------------------
        */
        
        //Declaramos variables
        $fila = 0;
        $filasError = array();
        $ejecutarInsert = true;
        //Abrimos el archivo
        $handle = fopen($csv, "r");

        //Recorremos las filas del CSV
        // while (($data = fgetcsv($handle, 0, ",", ";")) !== FALSE)

        while (($data = fgetcsv($handle, 0, $separadorCSV)) !== FALSE)
        {
            $fila++;

            if($fila>1)
            {
                $data = array_map("utf8_encode", $data);
                //Asignamos valores de CSV a variables locales

				$rucProveedor   = (int) trim($data[0]," \t\n\r\0\x0B\xc2\xa0"); 
				$direccion      = trim($data[1]," \t\n\r\0\x0B\xc2\xa0"); 
				$area           = trim($data[2]," \t\n\r\0\x0B\xc2\xa0"); 
				$subarea        = trim($data[3]," \t\n\r\0\x0B\xc2\xa0"); 
				$cc             = trim($data[4]," \t\n\r\0\x0B\xc2\xa0"); 
				$ln             = trim($data[5]," \t\n\r\0\x0B\xc2\xa0"); 
				$solicitante    = trim($data[6]," \t\n\r\0\x0B\xc2\xa0");
                $fechaPedido    = trim($data[7]," \t\n\r\0\x0B\xc2\xa0");
                $categoria      = trim($data[8]," \t\n\r\0\x0B\xc2\xa0");
				$subCategoria   = trim($data[9]," \t\n\r\0\x0B\xc2\xa0");
				$concepto       = trim($data[10]," \t\n\r\0\x0B\xc2\xa0");
				$budget         = trim($data[11]," \t\n\r\0\x0B\xc2\xa0");
				$tipoMoneda     = trim($data[12]," \t\n\r\0\x0B\xc2\xa0");
				$formaPago      = trim($data[13]," \t\n\r\0\x0B\xc2\xa0");
				$condicionesIgv = trim($data[14]," \t\n\r\0\x0B\xc2\xa0");
				$observacion    = trim($data[15]," \t\n\r\0\x0B\xc2\xa0");
				$descripcion    = trim($data[16]," \t\n\r\0\x0B\xc2\xa0");
				$cantidad       = (int) trim($data[17]," \t\n\r\0\x0B\xc2\xa0");
				$costoUnitario  = trim($data[18]," \t\n\r\0\x0B\xc2\xa0");
				$centralizado   = trim($data[19]," \t\n\r\0\x0B\xc2\xa0");

                //Validamos existencia de PROVEEDOR:

                if(empty($rucProveedor) || !is_numeric($rucProveedor))
                {
                    $filasError[$fila]['RUC'] = "EL RUC ES OBLIGATORIO";
                    $ejecutarInsert = false;
                }
                else
                {
                    
                    $whereExistencia = array(
                        "RUC" => $rucProveedor
                    );
                    
            		$dataProveedor = $this->proveedor->where($whereExistencia)->first();
        
                    if(!empty($dataProveedor))
                    { 
                        $whereModalidad = array(
                            "IDProveedor"   => $dataProveedor['IDProveedor'],
                            "Estado"        => "A"
                        );
						
						$dataProveedorPago = $this->proveedorPago->where($whereModalidad)->orderBy("Prioridad", "ASC")->first();
						
						if(empty($dataProveedorPago['ModalidadPago']) || empty($dataProveedorPago['Banco']) || empty($dataProveedorPago['CuentaBancaria']) || empty($dataProveedorPago['Moneda']))
						{
							$filasError[$fila]['RUC'] = "NO SE ENCUENTRA MODALIDAD DE PAGO ASOCIADO AL PROVEEDOR.";
                        	$ejecutarInsert = false;
						}					
                    }
                    else
                    {
                        $filasError[$fila]['RUC'] = "EL PROVEEDOR NO SE ENCUENTRA REGISTRADO.";
                        $ejecutarInsert = false;
                    }
                }
				
                //Validamos existencia de CC y LN:
                
                if(empty($cc))
                {
                    $filasError[$fila]['CC'] = "EL CC ES OBLIGATORIO";
                    $ejecutarInsert = false;
                }
                
                if(empty($ln))
                {
                    $filasError[$fila]['LN'] = "LA LN ES OBLIGATORIO";
                    $ejecutarInsert = false;
                }
                
                if(!empty($cc) && !empty($ln)) 
                {
					$whereDelegacion = array(
						'CC' => $cc,
						'LN' => $ln
					);

					$dataDelegacion = $this->estructuraDelegaciones->where($whereDelegacion)->findAll();
                 
                    if(empty($dataDelegacion))
                    {
                        $filasError[$fila]['CC - LN'] = "CC NO ASOCIADO CON LN";
                        $ejecutarInsert = false;
                    }
				}

                //Validamos existencia de Dirección, área y subárea:
                
                if(empty($direccion))
                {
                    $filasError[$fila]['DIRECCIÓN'] = "LA DIRECCIÓN ES OBLIGATORIO";
                    $ejecutarInsert = false;
                }
                
                if(empty($area))
                {
                    $filasError[$fila]['ÁREA'] = "EL ÁREA ES OBLIGATORIO";
                    $ejecutarInsert = false;
                }
                
                if(empty($subarea))
                {
                    $filasError[$fila]['SUBÁREA'] = "LA SUBÁREA ES OBLIGATORIO";
                    $ejecutarInsert = false;
                }
                
                if(!empty($direccion) && !empty($area) && !empty($subarea)) 
                {
                    $datosSubarea = $this->estructuraSubareas->obtenerSubareaXNombres($subarea, $area, $direccion);
                    if(empty($datosSubarea))
                    {
                        $filasError[$fila]['SUBAREA'] = "NO EXISTE LA SUBÁREA INGRESADA";
                        $ejecutarInsert = false;
                    }
                    
                    if($datosSubarea['Responsable_Subarea'] == '' || $datosSubarea['Responsable_Subarea'] == null || $datosSubarea['Responsable_Area'] == '' || $datosSubarea['Responsable_Area'] == null || $datosSubarea['Responsable_Direccion'] == '' || $datosSubarea['Responsable_Direccion'] == null)
                    {
                        $filasError[$fila]['SUBAREA'] = "NO HAY RESPONSABLES DE FIRMA PARA DICHA SUBÁREA.";
                        $ejecutarInsert = false;
                    }
                }
                
                //Validamos existencia de SOLICITANTE:
                
                if(empty($solicitante)  || !is_string($solicitante))
                {
                    $filasError[$fila]['SOLICITANTE'] = "USUARIO SOLICITANTE ES OBLIGATORIO";
                    $ejecutarInsert = false;
                }
                else
                {
                    //**USUARIO***/
					$whereUsuario = array (
						'Usuario' => $solicitante
					);
					
					$dataUsuarioOC = $this->usuarios->where($whereUsuario)->first();
					
					if (empty($dataUsuarioOC))
					{
					    $filasError[$fila]['SOLICITANTE'] = "EL SOLICITANTE NO EXISTE EN LA BASE DE DATOS";
                    	$ejecutarInsert = false;
					}
                }

				//Validamos existencia de Fecha Pedido:

				if(empty($fechaPedido)){
                    $filasError[$fila]['FECHA PEDIDO'] = "LA FECHA DE PEDIDO ES OBLIGATORIA";
                    $ejecutarInsert = false;
                }

				//Validamos existencia Categoría y Subcategoria:

                if(empty($categoria))
                {
                    $filasError[$fila]['CATEGORÍA'] = "LA CATEGORÍA ES OBLIGATORIO";
                    $ejecutarInsert = false;
                }
                
                if(empty($subCategoria))
                {
                    $filasError[$fila]['SUBCATEGORÍA'] = "LA SUBCATEGORÍA ES OBLIGATORIO";
                    $ejecutarInsert = false;
                }
                

				if(!empty($categoria) && !empty($subCategoria)) 
                {
                    $datosSubcategoria = $this->cuentaContableSubcategorias->obtenerSubcategoriaXDefinicion($subCategoria, $categoria);
                    if(empty($datosSubcategoria))
                    {
                        $filasError[$fila]['SUBCATEGORÍA'] = "LA SUBCATEGORÍA NO EXISTE";
                        $ejecutarInsert = false;
                    }
                }

				//Validamos existencia Concepto:

				if(empty($concepto))
                {
                    $filasError[$fila]['CONCEPTO'] = "EL CONCEPTO ES OBLIGATORIO";
                    $ejecutarInsert = false;
                }

				//Validamos existencia BUDGET:

				if(empty($budget))
                {
                    $filasError[$fila]['BUDGET'] = "EL BUDGET ES OBLIGATORIO";
                    $ejecutarInsert = false;
                }
                else if(!in_array($budget, array("SI", "NO")))
                {
                    $filasError[$fila]['BUDGET'] = "EL BUDGET SOLO ACEPTA ['SI','NO'] COMO INFORMACIÓN";
                    $ejecutarInsert = false;
                }

				//Validamos existencia TIPO MONEDA:

				if(empty($tipoMoneda))
                {
                    $filasError[$fila]['TIPO MONEDA'] = "EL TIPO DE MONEDA ES OBLIGATORIO";
                    $ejecutarInsert = false;
                }
                else if(!in_array($tipoMoneda, ["PEN", "USD", "EUR"])) {
					$filasError[$fila]['TIPO MONEDA'] = "EL TIPO DE MONEDA SOLO ACEPTA ['PEN', 'EUR', 'USD'] COMO INFORMACIÓN";
					$ejecutarInsert = false;
				}
				
				//Validamos existencia FORMA PAGO:

				if(empty($formaPago))
                {
                    $filasError[$fila]['FORMA PAGO'] = "LA FORMA DE PAGO ES OBLIGATORIA";
                    $ejecutarInsert = false;
                }
                else
                {
                    $whereFormaPago = array (
						'Codigo' => $formaPago
					);
					
                    $datosFormaPago = $this->formasPago->where($whereFormaPago)->findAll();
                    
                    if (empty($datosFormaPago))
					{
					    $filasError[$fila]['FORMA PAGO'] = "LA FORMA DE PAGO NO EXISTE EN LA BASE DE DATOS";
                    	$ejecutarInsert = false;
					}
                }

				//Validamos existencia CONDICION IGV:

				if(empty($condicionesIgv))
                {
                    $filasError[$fila]['CONDICIÓN IGV'] = "LA CONDICIÓN IGV ES OBLIGATORIO";
                    $ejecutarInsert = false;
                }
                else if(!in_array($condicionesIgv, ["Noafecta", "Afecta"])) 
                {
                    $filasError[$fila]['CONDICIÓN IGV'] = "LA CONDICIÓN IGV SOLO ACEPTA ['Noafecta', 'Afecta'] COMO INFORMACIÓN";
                    $ejecutarInsert = false;
                }
				
				//Validamos existencia OBSERVACIÓN:
				
				if(empty($observacion))
                {
                    $filasError[$fila]['OBSERVACIÓN'] = "LA OBSERVACIÓN ES OBLIGATORIO";
                    $ejecutarInsert = false;
                }
                
				//Validamos existencia DESCRIPÇIÓN ITEM:
				
				if(empty($descripcion) || !is_string($descripcion))
                {
                    $filasError[$fila]['DESCRIPCIÓN ITEM'] = "LA DESCRIPCION ITEM ES OBLIGATORIA";
                    $ejecutarInsert = false;
                }

				//Validamos existencia de CANTIDAD:
                
                if (empty($cantidad)) 
                {
                    $filasError[$fila]['CANTIDAD'] = "LA CANTIDAD ES OBLIGATORIA";
                    $ejecutarInsert = false;
                }
                else if(!is_numeric($cantidad) || $cantidad <= 0)
                {
                    $filasError[$fila]['CANTIDAD'] = "LA CANTIDAD TIENE INFORMACIÓN NO VÁLIDA (SOLO NÚMEROS ENTEROS MAYORES A 0)";
                    $ejecutarInsert = false;
                }

				//Validamos existencia de PRECIO UNITARIO:
                
				if(empty($costoUnitario))
                {
                    $filasError[$fila]['PRECIO UNITARIO'] = "EL PRECIO UNITARIO ES OBLIGATORIO";
                    $ejecutarInsert = false;
                }
                else if(!is_numeric($costoUnitario))
                {
                    $filasError[$fila]['PRECIO UNITARIO'] = "EL PRECIO UNITARIO TIENE INFORMACIÓN NO VÁLIDA (SOLO NÚMEROS POSITIVOS CON 4 DECIMALES COMO MÁXIMO. SOLO USAR (.) COMO SEPARADOR DE DECIMALES Y ENTEROS)";
                    $ejecutarInsert = false;
                }

				// //Validamos existencia de PRECIO UNITARIO:
                
				// if(empty($centralizado) || !is_string($centralizado))
    //             {
    //                 $filasError[$fila]['centralizado'] = "CENTRALIZADO NO EXISTENTE";
    //                 $ejecutarInsert = false;
    //             }

            }
        } 

        fclose($handle);

        if(!$ejecutarInsert)
        {
            $raiz = 'public/';
            $nombre = 'error.txt';
            $file = 'public/error.txt';
            
            if (file_exists($file)) {
                unlink($file);
            }
            
            $txt= fopen($file, 'a') or die ('Problemas al crear el archivo');
            #  Se establecen los datos que va a conterner el archivo
            foreach($filasError as $key=>$value)
            {
                fwrite($txt, "FILA: ".$key."\n");
                foreach($value as $celda=>$error)
                {
                    fwrite($txt, $celda.": ".$error."\n");
                }
            }
            #  Se hace el ciere para no sobre escribir datos 
            fclose($txt);

            $message = sprintf($this->mensajeError->msg201, "Se detectaron diversas inconsistencias.");
            $salida1 = $this->alertas->alertaError($message);
            $salida2 = $this->alertas->descargaArchivoTXT($nombre);
			echo $salida1.$salida2;
			//echo $salida1;
            
			exit;
        }

		/*
        * ----------------------------
        * RECORRER ARCHIVO Y EJECUTAR INSERTS
        * ----------------------------
        */ 
		

        $filainsert = 0;
        //Abrimos el archivo
        $handleItems = fopen($csv, "r"); 
		$resultado = [];
        //Recorremos las filas del CSV
        // while (($data = fgetcsv($handle, 0, ",", ";")) !== FALSE) 
		$arrayOrdenCompra = array();
		$arrayDetalle=array();
        while (($data = fgetcsv($handleItems, 0, $separadorCSV)) !== FALSE)
        { 
            $data = array_map("utf8_encode", $data);
            $filainsert++;
            if($filainsert > 1)
            {
				$rucProveedor   = (int) trim($data[0]," \t\n\r\0\x0B\xc2\xa0"); 
				$direccion      = trim($data[1]," \t\n\r\0\x0B\xc2\xa0"); 
				$area           = trim($data[2]," \t\n\r\0\x0B\xc2\xa0"); 
				$subarea        = trim($data[3]," \t\n\r\0\x0B\xc2\xa0"); 
				$cc             = trim($data[4]," \t\n\r\0\x0B\xc2\xa0"); 
				$ln             = trim($data[5]," \t\n\r\0\x0B\xc2\xa0"); 
				$solicitante    = trim($data[6]," \t\n\r\0\x0B\xc2\xa0");
                $fechaPedido    = trim($data[7]," \t\n\r\0\x0B\xc2\xa0");
                $categoria      = trim($data[8]," \t\n\r\0\x0B\xc2\xa0");
				$subCategoria   = trim($data[9]," \t\n\r\0\x0B\xc2\xa0");
				$concepto       = trim($data[10]," \t\n\r\0\x0B\xc2\xa0");
				$budget         = trim($data[11]," \t\n\r\0\x0B\xc2\xa0");
				$tipoMoneda     = trim($data[12]," \t\n\r\0\x0B\xc2\xa0");
				$formaPago      = trim($data[13]," \t\n\r\0\x0B\xc2\xa0");
				$condicionesIgv = trim($data[14]," \t\n\r\0\x0B\xc2\xa0");
				$observacion    = trim($data[15]," \t\n\r\0\x0B\xc2\xa0");
				$descripcion    = trim($data[16]," \t\n\r\0\x0B\xc2\xa0");
				$cantidad       = (int) trim($data[17]," \t\n\r\0\x0B\xc2\xa0");
				$costoUnitario  = trim($data[18]," \t\n\r\0\x0B\xc2\xa0");
				$centralizado   = trim($data[19]," \t\n\r\0\x0B\xc2\xa0");
				
				$envioFactura = 'SI';

                // if(!array_key_exists($usuario, $arrayOrdenCompra)) 
                // {
                //     $arrayAsig[$usuario] = array(
                //         "TIPO"          => $tipoAsignado,
                //         "OBSERVACION"   => $obsAsignado,
                //         "FECHA"         => $fechaAsignado);
                // }
                
                $moneda = $this->globales->monedas();
                
                if(empty($arrayOrdenCompra[$rucProveedor.'-'.$cc.'-'.$ln.'-'.$solicitante.'-'.$subCategoria][$concepto]))
                {
                    
                    /*** PROVEEDOR ***/
                    
                    $whereUsuario = array (
    					'Usuario' => $solicitante
    				);
    				
    				$datosSolicitante = $this->usuarios->where($whereUsuario)->first();
    				
                	/******************/
                	
                    /*** PROVEEDOR ***/
                    
    				$whereProveedor = array(
                        "RUC" => $rucProveedor
                    );
                        
                	$datosProveedor = $this->proveedor->where($whereProveedor)->first();
                	
                	/******************/
                	
                    /*** PROVEEDOR ***/
                    
                	$whereModalidad = array(
                        "IDProveedor"   => $datosProveedor['IDProveedor'],
                        "Estado"        => "A"
                    );
                    
                    $datosProveedorPago = $this->proveedorPago->where($whereModalidad)->orderBy("Prioridad", "ASC")->first();
    				
                	/******************/
                	
                	/** FECHA DE PEDIDO **/
                	
                    $detectaFormatoFP = strpos($fechaPedido, "/");
                    
                    if(!empty($fechaPedido))
                    {
                        if($detectaFormatoFP === false)
                        {
                            $fechaPedido = date("Y-m-d", strtotime($fechaPedido));
                        }
                        else
                        {
                            $fechaPedido_e = $this->complementos->myUrlEncode($fechaPedido);
                            $fechaPedido = date('Y-m-d', strtotime(str_replace('/', '-', $fechaPedido_e)));
                        }
                    }
                    else
                    {
                        $fechaPedido = date("Y-m-d", strtotime($fechaActual));
                    }
                	/******************/
                	
                	/** DELEGACIÓN **/
                	
                	$whereDelegacion = array(
    					'CC' => $cc,
    					'LN' => $ln
    				);
    
    				$datosDelegacion = $this->estructuraDelegaciones->where($whereDelegacion)->first();
                    
                	/******************/
                	
                	/** SUBÁREA **/
                	
                    $datosSubarea = $this->estructuraSubareas->obtenerSubareaXNombres($subarea, $area, $direccion);
                
                	/******************/
                	
                	/** SUBCATEGORÍA **/
                	
                	$datosSubcategoria = $this->cuentaContableSubcategorias->obtenerSubcategoriaXDefinicion($subCategoria, $categoria);
                	
                	/******************/
                	
                    $arrayOrdenCompra[$rucProveedor.'-'.$cc.'-'.$ln.'-'.$solicitante.'-'.$subCategoria.'-'.$concepto] = array(
                        "Concepto"              => $concepto,
                        "IDProveedor"           => $datosProveedor['IDProveedor'],
                        "FormaPago"             => $formaPago,
                        "Observacion"           => $observacion,
                        "UsuarioComprador"      => $UsuarioComprador,
                        "FechaPedido"           => $fechaPedido,
                        "CondicionesIGV"        => ($condicionesIgv == "Afecta" ? $condicionesIgv : "Noafecta"),
                        "ModalidadPago"         => $datosProveedorPago['ModalidadPago'],
                        "Banco"                 => $datosProveedorPago['Banco'],
                        "CuentaBancaria"        => $datosProveedorPago['CuentaBancaria'],
                        "CuentaInterbancaria"   => $datosProveedorPago['CuentaInterbancaria'],
                        "TipoMoneda"            => $tipoMoneda,
                        "MontoCambio"           => (isset($moneda[$tipoMoneda]) ? $moneda[$tipoMoneda]['CAMBIO'] : 1),
                        "Budget"                => ($budget == "SI" ? $budget : "NO"),
                        "UsuarioSolicitante"    => $datosSolicitante['IdUsuario'],
                        "IDDelegacion"          => $datosDelegacion['IDDelegacion'],
                        "CC"                    => $cc,
                        "LN"                    => $ln,
                        "IDSubarea"             => $datosSubarea['IDSubarea'],
                        "CompraCentralizada"    => ($centralizado == 1 ? 1 : 0),
                        "EnvioFactura"          => $envioFactura,
                        "IDSubcategoria"        => $datosSubcategoria['IDSubcategoriaCC'],
                        "UsuarioCrea"           => $this->items['idUsuarioSession'],
                        "FechaCrea"             => $fechaActual,
                        "Localhost"             => $this->request->getIPAddress(),
                        "Estado"                => "PendienteFirma1",
                        "UsuarioEstado"         => $this->items['idUsuarioSession'],
                        "FechaEstado"           => $fechaActual,
                        "MotivoEstado"          => "Orden de Compra creada masivamente."
                    );
                }
                
                $arrayDetalle[$rucProveedor.'-'.$cc.'-'.$ln.'-'.$solicitante.'-'.$subCategoria.'-'.$concepto][] = array(
                    "Descripcion"   => $descripcion,
                    "Cantidad"      => $cantidad,
                    "PrecioUnitario"=> $costoUnitario,
                    "UsuarioCrea"   => $this->items['idUsuarioSession'],
                    "FechaCrea"     => $fechaActual,
                    "Localhost"     => $this->request->getIPAddress(),
                    "Estado"        => "A",
                    "UsuarioEstado" => $this->items['idUsuarioSession'],
                    "FechaEstado"   => $fechaActual,
                    "MotivoEstado"  => "Detalle de Orden de Compra creada masivamente."
                );
                
			}
			
		}

		foreach ($arrayOrdenCompra as $key => $concepto) 
		{
		    //  echo $key;
		    //  var_dump($concepto);exit;
		    $lastIdOc = $this->ordenCompra->insert($concepto,TRUE);
		    
		    //$lastIdOc = 12;
		    //var_dump($lastIdOc); exit;
		    
		    foreach($arrayDetalle[$key] as $clave => $detalle)
    		{
    		    $arrayDetalle[$key][$clave]['IDOrdenCompra'] = $lastIdOc;
    		}
    		
    		//var_dump($arrayDetalle[$key]); exit;
    		
    		$lastIdDetalle = $this->ordenCompraDetalle->insertBatch($arrayDetalle[$key]);
		  
            /*
            * ----------------------------
            * ACTUALIZAR MONTOS TOTALES SI ES REQUERIDO
            * ----------------------------
            */
            
            $this->actualizarMontosCabeceraOrdenCompra($lastIdOc);
            
            /*
            * ----------------------------
            * REGISTRAR USUARIOS RESPONSABLES DE LA FIRMA DE LA ORDEN DE COMPRA
            * ----------------------------
            */
            
            // SI DELEGACION USUARIO LOGUEADO = $delegacion 
            if($concepto['CompraCentralizada'] == 0)
            {
                $informacionSubarea = $this->estructuraSubareas->obtenerSubarea(11);
            }
            else
            {
                $informacionSubarea = $this->estructuraSubareas->obtenerSubarea($concepto['IDSubarea']);
            }
            
            if($concepto['CompraCentralizada'] == 0)
            {
                if($this->items['idDelegacionLog'] == $concepto['IDDelegacion'] && $informacionSubarea['Responsable_Subarea'] == $this->items['idUsuarioSession'])
                {
                    $informacionSubarea['Responsable_Subarea'] = $informacionSubarea['Responsable_Area'];
                    $informacionSubarea['Responsable_Area'] = $informacionSubarea['Responsable_Direccion'];
                }
                else if($this->items['idDelegacionLog'] == $concepto['IDDelegacion'] && $informacionSubarea['Responsable_Area'] == $this->items['idUsuarioSession'])
                {
                    $informacionSubarea['Responsable_Subarea'] = $informacionSubarea['Responsable_Direccion'];
                    $informacionSubarea['Responsable_Area'] = $informacionSubarea['Responsable_Direccion'];
                }
            }
            
            $dataResponsables = array (
                'IDOrdenCompra' => $lastIdOc,
                'UsuarioFirma1' => $informacionSubarea['Responsable_Subarea'],
                'UsuarioFirma2' => $informacionSubarea['Responsable_Area'],
                'UsuarioFirma3' => $informacionSubarea['Responsable_Direccion'],
                'UsuarioCrea'   => $this->items['idUsuarioSession'],
                'FechaCrea'     => $fechaActual,    
                'Localhost'     => $this->request->getIPAddress(),
                'UsuarioEstado' => $this->items['idUsuarioSession'],
                'FechaEstado'   => $fechaActual,    
                'MotivoEstado'  => "Habilitar usuarios responsables firma OC Masivamente.",    
                'Estado'        => "A"
            );
            // var_dump($dataResponsables); exit;
            $lastIdResponsable = $this->ordenCompraResponsable->insert($dataResponsables, TRUE);
    		  //  var_dump($lastIdResponsable); exit;
            $informacionOC = $this->ordenCompra->obtenerOrdenCompra($lastIdOc);
                
    	    $solicitante    = $this->usuarios->where("IdUsuario ", $informacionOC['UsuarioSolicitante'])->first();
    	    
    	    $responsable01 = $this->usuarios->where("IdUsuario ", $informacionOC['UsuarioFirma1'])->first();
    	    $responsable02 = $this->usuarios->where("IdUsuario ", $informacionOC['UsuarioFirma2'])->first();
    	    $responsable03 = $this->usuarios->where("IdUsuario ", $informacionOC['UsuarioFirma3'])->first();
    	    
    	    $informacionOC['IDSolicitante']        = $informacionOC['UsuarioSolicitante'];
    	    $informacionOC['UsuarioSolicitante']   = ucwords(mb_strtolower($solicitante['Nombres'].' '.$solicitante['Apellidos']));
    	    $informacionOC['CorreoSolicitante']    = $solicitante['Correo'];
    	    
    	    $informacionOC['UsuarioAprobador01']   = ucwords(mb_strtolower($responsable01['Nombres'].' '.$responsable01['Apellidos']));
    	    $informacionOC['CorreoAprobador01']    = $responsable01['Correo'];
    	    $informacionOC['MatriculaAprobador01'] = $responsable01['Matricula'];
    	    $informacionOC['IDAprobador01']        = $informacionOC['UsuarioFirma1'];
    	    
    	    $informacionOC['UsuarioAprobador02']   = ucwords(mb_strtolower($responsable02['Nombres'].' '.$responsable02['Apellidos']));
    	    $informacionOC['CorreoAprobador02']    = $responsable02['Correo'];
    	    $informacionOC['MatriculaAprobador02'] = $responsable02['Matricula'];
    	    
    	    $informacionOC['UsuarioAprobador03']   = ucwords(mb_strtolower($responsable03['Nombres'].' '.$responsable03['Apellidos']));
    	    $informacionOC['CorreoAprobador03']    = $responsable03['Correo'];
    	    $informacionOC['MatriculaAprobador03'] = $responsable03['Matricula'];
    	    
            $estadoCorreo = $this->complementos->enviarCorreoOrdenCompraPrimeraFirma($informacionOC,$lastIdOc);
    
            $dataCorreo = array(
                "IDOrdenCompra" => $lastIdOc,
                "Momento"       => "REGISTRO MASIVO",
                "Response"      => $estadoCorreo['RESPUESTA'],
                "Error"         => $estadoCorreo['ERROR'],
                'UsuarioCrea'   => $this->items['idUsuarioSession'],
                'FechaCrea'     => $fechaActual,    
                'Localhost'     => $this->request->getIPAddress()
            );
    
            $this->correoStatusOrdenCompra->insert($dataCorreo, TRUE);
		}
		
		$message = sprintf($this->mensajeError->msg201, "se registraron las OC correctamente.");
        echo $this->alertas->alertaExito($message);
		echo $this->alertas->refrescar(1);
	}
	
	public function exportarOrdenCompra($fechaInicio, $fechaFin)
	{
	    $arrayOrdenCompra = array(
	        "fechaInicio"  => $fechaInicio,
	        "fechaFin"  => $fechaFin
	    );
	    
	    $listadoOrdenCompra = $this->ordenCompra->datosExportarOrdenCompra($arrayOrdenCompra);
	    
        // foreach($listadoOrdenCompra as $key=>$value)
        // {
        //     if($value['UsuarioComprador'] != '' && $value['UsuarioComprador'] != null)
        //     {
        //         $comprador = $this->usuarios->where("IdUsuario", $value['UsuarioComprador'])->first();
        //         $listadoOrdenCompra[$key]['IDUsuarioComprador'] = $value['UsuarioComprador'];
        //         $listadoOrdenCompra[$key]['UsuarioComprador'] = !empty($comprador) ? ucwords(mb_strtolower($comprador['Nombres'].' '.$comprador['Apellidos'])) : "Sin información";
        //     }
        //     else
        //     {
        //         $listadoOrdenCompra[$key]['IDUsuarioComprador'] = "Sin información";
        //         $listadoOrdenCompra[$key]['UsuarioComprador'] = "Sin información";
        //     }
            
        //     if($value['UsuarioSolicitante'] != '' && $value['UsuarioSolicitante'] != null)
        //     {
        //         $solicitante = $this->usuarios->where("IdUsuario", $value['UsuarioSolicitante'])->first();
        //         $listadoOrdenCompra[$key]['IDUsuarioSolicitante'] = $value['UsuarioSolicitante'];
        //         $listadoOrdenCompra[$key]['UsuarioSolicitante'] = !empty($solicitante) ? ucwords(mb_strtolower($solicitante['Nombres'].' '.$solicitante['Apellidos'])) : "Sin información";
        //     }
        //     else
        //     {
        //         $listadoOrdenCompra[$key]['IDUsuarioSolicitante'] = "Sin información";
        //         $listadoOrdenCompra[$key]['UsuarioSolicitante'] = "Sin información";
        //     }
            
        //     if($value['IDSubarea'] != '' && $value['IDSubarea'] != null)
        //     {
        //         $subarea = $this->estructuraSubareas->obtenerSubarea($value['IDSubarea']);
                
        //         $listadoOrdenCompra[$key]['Subarea']    = $subarea['Subarea'];
        //         $listadoOrdenCompra[$key]['Area']       = $subarea['Area'];
        //         $listadoOrdenCompra[$key]['Direccion']  = $subarea['Direccion'];
        //     }
        //     else
        //     {
        //         $listadoOrdenCompra[$key]['Subarea']    = "Sin información";
        //         $listadoOrdenCompra[$key]['Area']       = "Sin información";
        //         $listadoOrdenCompra[$key]['Direccion']  = "Sin información";
        //     }
            
        //     $listadoOrdenCompra[$key]['TotalItem'] = number_format(round($value['Cantidad']*$value['PrecioUnitario'], 2), 2, '.', '');
            
        // }
	   // var_dump($listadoOrdenCompra);exit;
	   
        $filename = "órdenes_compra.xlsx";
        $writer = WriterEntityFactory::createXLSXWriter();
        //$writer->setFieldDelimiter(';');
        $writer->setShouldUseInlineStrings(true); // default (and recommended) value
        $writer->openToBrowser($filename);
        
        $cells = [
            WriterEntityFactory::createCell("Orden de Compra"),
            WriterEntityFactory::createCell("Estado"),
            WriterEntityFactory::createCell("Fecha de Emisión"),
            WriterEntityFactory::createCell("Fecha de Pedido"),
            WriterEntityFactory::createCell("Concepto"),
            WriterEntityFactory::createCell("Observación"),
            WriterEntityFactory::createCell("Solicitante"),
            WriterEntityFactory::createCell("Dirección"),
            WriterEntityFactory::createCell("Área"),
            WriterEntityFactory::createCell("Subárea"),
            WriterEntityFactory::createCell("CC"),
            WriterEntityFactory::createCell("LN"),
            WriterEntityFactory::createCell("Proveedor"),
            WriterEntityFactory::createCell("RUC"),
            WriterEntityFactory::createCell("Contacto"),
            WriterEntityFactory::createCell("Departamento"),
            WriterEntityFactory::createCell("Provincia"),
            WriterEntityFactory::createCell("Distrito"),
            WriterEntityFactory::createCell("Dirección Domicilio"),
            WriterEntityFactory::createCell("Teléfono 1"),
            WriterEntityFactory::createCell("Teléfono 2"),
            WriterEntityFactory::createCell("Email"),
            WriterEntityFactory::createCell("Forma de Pago"),
            WriterEntityFactory::createCell("Modalidad de Pago"),
            WriterEntityFactory::createCell("Banco"),
            WriterEntityFactory::createCell("Cuenta Bancaria"),
            WriterEntityFactory::createCell("Tipo de Moneda"),
            WriterEntityFactory::createCell("Cuenta Interbancaria"),
            WriterEntityFactory::createCell("Subtotal"),
            WriterEntityFactory::createCell("IGV"),
            WriterEntityFactory::createCell("Total"),
            WriterEntityFactory::createCell("ID Detalle"),
            WriterEntityFactory::createCell("Descripción"),
            WriterEntityFactory::createCell("Cantidad"),
            WriterEntityFactory::createCell("Precio Unitario"),
            WriterEntityFactory::createCell("Total Detalle"),
            WriterEntityFactory::createCell("Aprobador 01"),
            WriterEntityFactory::createCell("Aprobador 02"),
            WriterEntityFactory::createCell("Aprobador 03"),
            WriterEntityFactory::createCell("Categoría"),
            WriterEntityFactory::createCell("Subcategoría"),
            WriterEntityFactory::createCell("Comprador"),
            WriterEntityFactory::createCell("Comentarios")
            
        ];
        
        /** add a row at a time */
        $singleRow = WriterEntityFactory::createRow($cells);
        $writer->addRow($singleRow);
        
        foreach($listadoOrdenCompra as $key=>$item)
        {
            if($item['UsuarioComprador'] != '' && $item['UsuarioComprador'] != null)
            {
                $usuarioComprador = $this->usuarios->where("IdUsuario", $item['UsuarioComprador'])->first();
                $comprador = ucwords(mb_strtolower($usuarioComprador['Nombres'].' '.$usuarioComprador['Apellidos']));
            }
            else
            {
                $comprador = "Sin información";
            }
            
            if($item['UsuarioSolicitante'] != '' && $item['UsuarioSolicitante'] != null)
            {
                $usuarioSolicitante = $this->usuarios->where("IdUsuario", $item['UsuarioSolicitante'])->first();
                $solicitante = ucwords(mb_strtolower($usuarioSolicitante['Nombres'].' '.$usuarioSolicitante['Apellidos']));
            }
            else
            {
                $solicitante = "Sin información";
            }
            
            if($item['UsuarioFirma1'] != '' && $item['UsuarioFirma1'] != null)
            {
                $a01 = $this->usuarios->where("IdUsuario", $item['UsuarioFirma1'])->first();
                $aprobador01 = ucwords(mb_strtolower($a01['Nombres'].' '.$a01['Apellidos']));
            }
            else
            {
                $aprobador01 = "Sin información";
            }
            
            if($item['UsuarioFirma2'] != '' && $item['UsuarioFirma2'] != null)
            {
                $a02 = $this->usuarios->where("IdUsuario", $item['UsuarioFirma2'])->first();
                $aprobador02 = ucwords(mb_strtolower($a02['Nombres'].' '.$a02['Apellidos']));
            }
            else
            {
                $aprobador02 = "Sin información";
            }
            
            if($item['UsuarioFirma3'] != '' && $item['UsuarioFirma3'] != null)
            {
                $a03 = $this->usuarios->where("IdUsuario", $item['UsuarioFirma3'])->first();
                $aprobador03 = ucwords(mb_strtolower($a03['Nombres'].' '.$a03['Apellidos']));
            }
            else
            {
                $aprobador03 = "Sin información";
            }
            
            if($item['IDSubarea'] != '' && $item['IDSubarea'] != null)
            {
                $estructuraDepartamental = $this->estructuraSubareas->obtenerSubarea($item['IDSubarea']);
                
                $subarea    = $estructuraDepartamental['Subarea'];
                $area       = $estructuraDepartamental['Area'];
                $direccion  = $estructuraDepartamental['Direccion'];
            }
            else
            {
                $subarea    = "Sin información";
                $area       = "Sin información";
                $direccion  = "Sin información";
            }
            
            if($item['IDDistrito'] != '' && $item['IDDistrito'] != null)
            {
                $region = $this->regionDistrito->obtenerRegionxIDDistrito($item['IDDistrito']);
                
                $distrito       = $region['Distrito'];
                $provincia      = $region['Provincia'];
                $departamento   = $region['Departamento'];
            }
            else
            {
                $distrito       = "Sin información";
                $provincia      = "Sin información";
                $departamento   = "Sin información";
            }
            
            $totalItem = number_format(round($item['Cantidad']*$item['PrecioUnitario'], 2), 2, '.', '');
            
			$cells = [
                WriterEntityFactory::createCell($item['IDOrdenCompra']),
                WriterEntityFactory::createCell($item['Estado']),
                WriterEntityFactory::createCell($item['FechaCrea']),
                WriterEntityFactory::createCell($item['FechaPedido']),
                WriterEntityFactory::createCell($item['Concepto']),
                WriterEntityFactory::createCell($item['Observacion']),
                WriterEntityFactory::createCell($solicitante),
                WriterEntityFactory::createCell($direccion),
                WriterEntityFactory::createCell($area),
                WriterEntityFactory::createCell($subarea),
                WriterEntityFactory::createCell($item['CC']),
                WriterEntityFactory::createCell($item['LN']),
                WriterEntityFactory::createCell($item['Proveedor']),
                WriterEntityFactory::createCell($item['RUC']),
                WriterEntityFactory::createCell($item['Contacto']),
                WriterEntityFactory::createCell($departamento),
                WriterEntityFactory::createCell($provincia),
                WriterEntityFactory::createCell($distrito),
                WriterEntityFactory::createCell($item['Direccion']),
                WriterEntityFactory::createCell($item['Telefono01']),
                WriterEntityFactory::createCell($item['Telefono02']),
                WriterEntityFactory::createCell($item['Email']),
                WriterEntityFactory::createCell($item['FormaPago']),
                WriterEntityFactory::createCell($item['ModalidadPago']),
                WriterEntityFactory::createCell($item['Banco']),
                WriterEntityFactory::createCell($item['CuentaBancaria']),
                WriterEntityFactory::createCell($item['TipoMoneda']),
                WriterEntityFactory::createCell($item['CuentaInterbancaria']),
                WriterEntityFactory::createCell($item['Subtotal']),
                WriterEntityFactory::createCell($item['IGV']),
                WriterEntityFactory::createCell($item['Total']),
                WriterEntityFactory::createCell($item['IDDetalleOC']),
                WriterEntityFactory::createCell($item['Descripcion']),
                WriterEntityFactory::createCell($item['Cantidad']),
                WriterEntityFactory::createCell($item['PrecioUnitario']),
                WriterEntityFactory::createCell($totalItem),
                WriterEntityFactory::createCell($aprobador01),
                WriterEntityFactory::createCell($aprobador02),
                WriterEntityFactory::createCell($aprobador03),
                WriterEntityFactory::createCell($item['Categoria']),
                WriterEntityFactory::createCell($item['Subcategoria']),
                WriterEntityFactory::createCell($comprador),
                WriterEntityFactory::createCell($item['MotivoEstado']),
            ];
            
            /** add a row at a time */
            $singleRow = WriterEntityFactory::createRow($cells);
            $writer->addRow($singleRow);

        }
        
        $writer->close();
	   
// 		$datoExportar = $this->ordenCompraModelo 
// 				->select('oc.Id_OC,
// 				oc.Estado,
// 				oc.Fecha_Emision,
// 				oc.Fecha_Pedido,
// 				oc.Num_OC, 
// 				oc.Concepto_OC,
// 				oc.Comentario,
// 				CONCAT(usuario.Apellidos_U, " ", usuario.Apellido_Materno, " ", usuario.Nombres_U) NombreCompleto, 
// 				usuario.CC_U, 
// 				usuario.LN_U, 
// 				area.Area,
// 				proveedor.Nombre_Pro,
// 				proveedor.Ruc_Pro,
// 				proveedor.Contacto_Pro,
// 				proveedor.Direccion_Pro,
// 				proveedor.Distrito_Pro,
// 				proveedor.Telefono_Pro,
// 				proveedor.Telefono_Pro_2,
// 				proveedor.Email_Pro,
// 				proveedor.CondicionesPago_Pro,
// 				proveedor_pago.ModalidadPago,
// 				proveedor_pago.Banco,
// 				proveedor_pago.CuentaBancaria,
// 				oc.TipoMoneda,
// 				proveedor_pago.CuentaInterbancaria,
// 				oc.CC_OC,
// 				oc.LN_OC,
// 				oc.Subtotal_OC,
// 				oc.IGV_OC,
// 				oc.Total_OC,
// 				item.Id_Item,
// 				item.Descripcion,
// 				item.Cantidad,
// 				item.P_Unitario,
// 				item.Total,
// 				oc.CategoriaCompra,
// 				oc.Comprador,
// 				oc.subCategoria,
// 				oc.Observaciones')
// 				->join('usuario','oc.Id_U = usuario.Id_U')
// 				->join('area','usuario.Id_Area = area.Id_Area')
// 				->join('proveedor','oc.Id_Pro = proveedor.Id_Pro')
// 				->join('proveedor_pago','oc.Id_ProveedorPago = proveedor_pago.Id_ProveedorPago','left')
// 				->join('detalle_oc','oc.Id_OC = detalle_oc.Id_OC')
// 				->join('item','detalle_oc.Id_Item = item.Id_Item')
// 				->where($whereOcExportar)
// 				->orderBy('oc.Id_OC ','DESC')
// 				->findAll();
				
// 		/*********/


//         /***********/
//         		foreach ($datoExportar as &$dato) {
//         			$idOc = $dato['Id_OC'];
        			
//             		$whereOcExportar2 = array(
//             			'oc.Id_OC' => $idOc
//             		);
//             		$datoAprobadores = $this->ordenCompraModelo
//             					->select('oc.Id_OC, CONCAT(u1.Apellidos_U, " " , u1.Apellido_Materno, " " , u1.Nombres_U) Aprobador1, CONCAT(u2.Apellidos_U, " " , u2.Apellido_Materno, " " , u2.Nombres_U) Aprobador2')
//             					->join('oc_aprobacion oa', 'oc.Id_OC = oa.Id_OC')
//             					->join('usuario u1', 'oa.Id_U = u1.Id_U')
//             					->join('usuario u2', 'oa.Id_U = u2.Id_U')
//             					->where($whereOcExportar2)
//             					->orderBy('oc.Id_OC', 'DESC')
//             					->findAll();
//             		if(count($datoAprobadores) == 0){
//             		        $dato['Aprobador1'] = '';
//         					$dato['Aprobador2'] = '';
//             		}else if (count($datoAprobadores) == 1){
//             		        $dato['Aprobador1'] = $datoAprobadores[0]['Aprobador1'];
//         					$dato['Aprobador2'] = '';
//             		}else{
//             		        $dato['Aprobador1'] = $datoAprobadores[0]['Aprobador1'];
//         					$dato['Aprobador2'] = $datoAprobadores[1]['Aprobador2'];
//             		}
        			
//         		}
//         //var_dump($datoExportar); exit;
        
//         /*****/

// 		$arrayCabecera = array('IdOrdenCompra',
// 							'Estado',
// 							'Fecha_Emision', 
// 							'Fecha_Pedido', 
// 							'NumeroOrdenCompra', 
// 							'ConceptoOrdenCompra', 
// 							'Comentario',
// 							'NombreCompleto', 
// 							'CC', 
// 							'LN', 
// 							'Area',
// 							'Nombre_Pro',
// 							'Ruc_Pro',
// 							'Contacto_Pro',
// 							'Direccion_Pro',
// 							'Distrito_Pro',
// 							'Telefono_Pro',
// 							'Telefono_Pro_2',
// 							'Email_Pro',
// 							'CondicionesPago_Pro',
// 							'ModalidadPago',
// 							'Banco',
// 							'CuentaBancaria',
// 							'Moneda',
// 							'CuentaInterbancaria',
// 							'CC_OC',
// 							'LN_OC',
// 							'Subtotal_OC',
// 							'IGV_OC',
// 							'Total_OC',
// 							'Id_Item',
// 							'Descripcion',
// 							'Cantidad',
// 							'P_Unitario',
// 							'Total',
// 							'Aprobador1',
// 							'Aprobador2',
// 							'CategoriaCompra',
// 							'Comprador',
// 							'subCategoria',
// 							'Observaciones');

// 		download_send_headers("OrdenesCompra.csv");
// 		echo array2csv($datoExportar);
// 		die();
	}

    /********************* REGIÓN DEPARTAMENTO ********************************/
    
	/**************************************************************************/
	
    /*********************** REGIÓN PROVINCIA *********************************/
    
	/**************************************************************************/
	
    /************************ REGIÓN DISTRITO *********************************/
    
	/**************************************************************************/
	
    /**************************** MONEDAS *************************************/
    
	/**************************************************************************/
	
}