<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>

<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                        <h4 class="mb-sm-0"><?= $breadcrumb_alias ?></h4>
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
                                <li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                   <div class="row">
                      <div class="col-xl-3">
                         <div class="card card-h-100">
                            <div class="card-body overflow-auto" style="max-height: 300px;">
                               <h5 class="mb-1">Tus Eventos</h5>
                               <div id="external-events">
                                  <?//= $htmlHorarios; ?>
                               </div>
                            </div>
                         </div>
                         <div class="card">
                            <div class="card-body bg-info-subtle">
                               <div class="d-flex">
                                  <div class="flex-shrink-0">
                                     <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-calendar text-info icon-dual-info">
                                        <rect x="3" y="4" width="18" height="18" rx="2" ry="2"></rect>
                                        <line x1="16" y1="2" x2="16" y2="6"></line>
                                        <line x1="8" y1="2" x2="8" y2="6"></line>
                                        <line x1="3" y1="10" x2="21" y2="10"></line>
                                     </svg>
                                  </div>
                                  <div class="flex-grow-1 ms-3">
                                     <h6 class="fs-15">¡Bienvenido a tu Calendario!</h6>
                                     <p class="text-muted mb-0">Aquí puedes ver tus horarios de trabajo y registrar tu hora de inicio y finalización.</p>
                                  </div>
                               </div>
                            </div>
                         </div>
                      </div>
                      <div class="col-xl-9">
                         <div class="card card-h-100">
                            <div class="card-body">
                                <div id="calendar"></div>
                                <div class="text-center mt-4">
                                    <button class="btn btn-success <?php echo $tipoAsistencia == 'inicio' ? 'd-none':''; ?>" id="btn-start-work">Iniciar Trabajo</button>
                                    <button class="btn btn-danger" id="btn-end-work <?php echo $tipoAsistencia == 'fin' ? 'd-none':''; ?>">Finalizar Trabajo</button>
                                </div>
                            </div>
                         </div>
                      </div>
                   </div>
                   <div style="clear:both"></div>
                </div>
			</div>
			<span class="respuesta_global"></span>
		</div>
	</div>
</div>

<?= $this->section('js'); ?>
<script>
$(document).ready(function() {
    var calendarEl = document.getElementById('calendar');
    var idUsuarioPlanificacion = <?= $idUsuarioPlanificacion ?>;

    var calendar = new FullCalendar.Calendar(calendarEl, {
        initialView: 'dayGridMonth',
        locale: 'es', // Cambiar idioma a español
        editable: false, // Deshabilitar edición
        droppable: false, // Deshabilitar arrastrar eventos
        events: function(info, successCallback, failureCallback) {
            $.ajax({
                url: baseUrl + "/calendario-planificacion",
                type: 'POST',
                dataType: 'json',
                data: {
                    idUsuarioPlanificacion: idUsuarioPlanificacion,
                    start: info.startStr,
                    end: info.endStr
                },
                success: function(res) {
                    if (Array.isArray(res)) {
                        var events = [];
                        res.forEach(function(evt) {
                            events.push({
                                id: evt.id_planificacion,
                                title: evt.title,
                                start: evt.start,
                                end: evt.end,
                                extendedProps: {
                                    grupoTrabajo: evt.grupoTrabajo,
                                    jefeGrupoTrabajo: evt.jefeGrupoTrabajo,
                                    id_horario: evt.id_horario,
                                    id_planificacion : evt.id_planificacion,
                                    fechaTrabajo: evt.fechaTrabajo
                                }
                            });
                        });
                        successCallback(events);
                    } else {
                        console.error('La respuesta no es un array:', res);
                        alert('Hubo un error al cargar los eventos.');
                        failureCallback();
                    }
                },
                error: function() {
                    alert('Hubo un error al cargar los eventos.');
                    failureCallback();
                }
            });
        },
        eventClick: function(info) { 
            info.jsEvent.preventDefault();
            
            $('#modal-title').text(info.event.title);
            $('#event-start-date-tag').text(info.event.start.toLocaleDateString());
            $('#event-timepicker1-tag').text(info.event.start.toLocaleTimeString());
            $('#event-timepicker2-tag').text(info.event.end ? info.event.end.toLocaleTimeString() : '');
            $('#event-grupo-trabajo-tag').text(info.event.extendedProps.grupoTrabajo || 'No especificado');
            $('#event-jefe-grupo-trabajo-tag').text(info.event.extendedProps.jefeGrupoTrabajo || 'No disponible');

            var eventModal = new bootstrap.Modal(document.getElementById('event-modal'), {
                keyboard: true
            });
            eventModal.show();
        }
    });

    calendar.render();

    $('#btn-start-work').on('click', function() {
        registrarHora('inicio');
    });

    $('#btn-end-work').on('click', function() {
        registrarHora('fin');
    });

    function registrarHora(tipo) {
        var fechaHora = new Date().toISOString().slice(0, 19).replace('T', ' ');
        var parametros = {
            idUsuario: idUsuarioPlanificacion,
            tipo: tipo,
            fechaHora: fechaHora
        };

        $.ajax({
            url: baseUrl + "/registrar-hora-trabajo",
            type: "POST",
            data: parametros,
            success: function(response) {
                $('.respuesta_global').html(response);
                // console.log(response);
            },
            error: function() {
                alert('Error al registrar la hora.');
            }
        });
    }
});
</script>
<?php $this->endSection(); ?>

<?= $this->endSection(); ?>
