<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb_alias ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-12">
                   <div class="row">
                      <div class="col-xl-3">
                         <div class="card card-h-100">
                            <div class="card-body overflow-auto" style="max-height: 300px;">
                               <button class="btn btn-primary w-100 d-none" id="btn-new-event"><i class="mdi mdi-plus"></i> Crear nuevo Evento</button>
                               <div id="external-events"> <!-- Listar los horarios -->
                                  <br>
                                  <p class="text-muted">Arrastra y suelta tu evento o haz clic en el calendario</p>
                                  <!--<div class="external-event fc-event bg-success-subtle text-success" data-class="bg-success-subtle">-->
                                  <!--   <i class="mdi mdi-checkbox-blank-circle me-2"></i>Nueva Planificación de eventos-->
                                  <!--</div>-->
                                  <!--<div class="external-event fc-event bg-info-subtle text-info" data-class="bg-info-subtle">-->
                                  <!--   <i class="mdi mdi-checkbox-blank-circle me-2"></i>Reunión-->
                                  <!--</div>-->
                                  <!--<div class="external-event fc-event bg-warning-subtle text-warning" data-class="bg-warning-subtle">-->
                                  <!--   <i class="mdi mdi-checkbox-blank-circle me-2"></i>Generando informes-->
                                  <!--</div>-->
                                  <!--<div class="external-event fc-event bg-danger-subtle text-danger" data-class="bg-danger-subtle">-->
                                  <!--   <i class="mdi mdi-checkbox-blank-circle me-2"></i>Crear nuevo tema-->
                                  <!--</div>-->
                                  <?= $htmlHorarios; ?>
                               </div>
                            </div>
                         </div>
                         <div>
                            <h5 class="mb-1">Próximos Eventos</h5> <!-- Posible plantilla para mostrar dias con tardanzas, permisos, etc -->
                            <p class="text-muted">No te pierdas los eventos programados</p>
                            <div class="pe-2 me-n1 mb-3 simplebar-scrollable-y" data-simplebar="init" style="height: 400px">
                               <div class="simplebar-wrapper" style="margin: 0px -8px 0px 0px;">
                                  <div class="simplebar-height-auto-observer-wrapper">
                                     <div class="simplebar-height-auto-observer"></div>
                                  </div>
                                  <div class="simplebar-mask">
                                     <div class="simplebar-offset" style="right: 0px; bottom: 0px;">
                                        <div class="simplebar-content-wrapper" tabindex="0" role="region" aria-label="scrollable content" style="height: 100%; overflow: hidden scroll;">
                                           <div class="simplebar-content" style="padding: 0px 8px 0px 0px;">
                                              <div id="upcoming-event-list">
                                                 <div class="card mb-3">
                                                    <div class="card-body">
                                                       <div class="d-flex mb-3">
                                                          <div class="flex-grow-1"><i class="mdi mdi-checkbox-blank-circle me-2 text-info"></i><span class="fw-medium">3 Jan 2022 </span></div>
                                                          <div class="flex-shrink-0"><small class="badge bg-primary-subtle text-primary ms-auto">7:00 PM to 12:00 AM</small></div>
                                                       </div>
                                                       <h6 class="card-title fs-16"> Día Mundial del Braille</h6>
                                                       <p class="text-muted text-truncate-two-lines mb-0"> </p>
                                                    </div>
                                                 </div>
                                                 <div class="card mb-3">
                                                    <div class="card-body">
                                                       <div class="d-flex mb-3">
                                                          <div class="flex-grow-1"><i class="mdi mdi-checkbox-blank-circle me-2 text-info"></i><span class="fw-medium">29 Jan 2022 </span></div>
                                                          <div class="flex-shrink-0"><small class="badge bg-primary-subtle text-primary ms-auto">7:00 PM to 12:00 AM</small></div>
                                                       </div>
                                                       <h6 class="card-title fs-16"> Día Mundial de la Lepra</h6>
                                                       <p class="text-muted text-truncate-two-lines mb-0"> </p>
                                                    </div>
                                                 </div>
                                                 <div class="card mb-3">
                                                    <div class="card-body">
                                                       <div class="d-flex mb-3">
                                                          <div class="flex-grow-1"><i class="mdi mdi-checkbox-blank-circle me-2 text-info"></i><span class="fw-medium">20 Feb 2022 </span></div>
                                                          <div class="flex-shrink-0"><small class="badge bg-primary-subtle text-primary ms-auto">7:00 PM to 12:00 AM</small></div>
                                                       </div>
                                                       <h6 class="card-title fs-16"> Día Internacional de la Lengua Materna</h6>
                                                       <p class="text-muted text-truncate-two-lines mb-0"> </p>
                                                    </div>
                                                 </div>
                                                 <div class="card mb-3">
                                                    <div class="card-body">
                                                       <div class="d-flex mb-3">
                                                          <div class="flex-grow-1"><i class="mdi mdi-checkbox-blank-circle me-2 text-info"></i><span class="fw-medium">21 Feb 2022 </span></div>
                                                          <div class="flex-shrink-0"><small class="badge bg-primary-subtle text-primary ms-auto">7:00 PM to 12:00 AM</small></div>
                                                       </div>
                                                       <h6 class="card-title fs-16"> Día Mundial del Pensamiento</h6>
                                                       <p class="text-muted text-truncate-two-lines mb-0"> </p>
                                                    </div>
                                                 </div>
                                                 <div class="card mb-3">
                                                    <div class="card-body">
                                                       <div class="d-flex mb-3">
                                                          <div class="flex-grow-1"><i class="mdi mdi-checkbox-blank-circle me-2 text-info"></i><span class="fw-medium">7 Mar 2022 </span></div>
                                                          <div class="flex-shrink-0"><small class="badge bg-primary-subtle text-primary ms-auto">7:00 PM to 12:00 AM</small></div>
                                                       </div>
                                                       <h6 class="card-title fs-16"> Día Internacional de la Mujer</h6>
                                                       <p class="text-muted text-truncate-two-lines mb-0"> </p>
                                                    </div>
                                                 </div>
                                                 <div class="card mb-3">
                                                    <div class="card-body">
                                                       <div class="d-flex mb-3">
                                                          <div class="flex-grow-1"><i class="mdi mdi-checkbox-blank-circle me-2 text-info"></i><span class="fw-medium">20 Mar 2022 </span></div>
                                                          <div class="flex-shrink-0"><small class="badge bg-primary-subtle text-primary ms-auto">7:00 PM to 12:00 AM</small></div>
                                                       </div>
                                                       <h6 class="card-title fs-16"> Día Internacional de la Lengua Materna</h6>
                                                       <p class="text-muted text-truncate-two-lines mb-0"> </p>
                                                    </div>
                                                 </div>
                                                 <div class="card mb-3">
                                                    <div class="card-body">
                                                       <div class="d-flex mb-3">
                                                          <div class="flex-grow-1"><i class="mdi mdi-checkbox-blank-circle me-2 text-info"></i><span class="fw-medium">21 Mar 2022 </span></div>
                                                          <div class="flex-shrink-0"><small class="badge bg-primary-subtle text-primary ms-auto">7:00 PM to 12:00 AM</small></div>
                                                       </div>
                                                       <h6 class="card-title fs-16"> Dia Mundial del Agua</h6>
                                                       <p class="text-muted text-truncate-two-lines mb-0"> </p>
                                                    </div>
                                                 </div>
                                                 <div class="card mb-3">
                                                    <div class="card-body">
                                                       <div class="d-flex mb-3">
                                                          <div class="flex-grow-1"><i class="mdi mdi-checkbox-blank-circle me-2 text-info"></i><span class="fw-medium">6 Apr 2022 </span></div>
                                                          <div class="flex-shrink-0"><small class="badge bg-primary-subtle text-primary ms-auto">7:00 PM to 12:00 AM</small></div>
                                                       </div>
                                                       <h6 class="card-title fs-16"> Día mundial de la salud</h6>
                                                       <p class="text-muted text-truncate-two-lines mb-0"> </p>
                                                    </div>
                                                 </div>
                                                 <div class="card mb-3">
                                                    <div class="card-body">
                                                       <div class="d-flex mb-3">
                                                          <div class="flex-grow-1"><i class="mdi mdi-checkbox-blank-circle me-2 text-info"></i><span class="fw-medium">15 Apr 2022 </span></div>
                                                          <div class="flex-shrink-0"><small class="badge bg-primary-subtle text-primary ms-auto">7:00 PM to 12:00 AM</small></div>
                                                       </div>
                                                       <h6 class="card-title fs-16"> Día Internacional Especial de los Bibliotecarios</h6>
                                                       <p class="text-muted text-truncate-two-lines mb-0"> </p>
                                                    </div>
                                                 </div>
                                                 <div class="card mb-3">
                                                    <div class="card-body">
                                                       <div class="d-flex mb-3">
                                                          <div class="flex-grow-1"><i class="mdi mdi-checkbox-blank-circle me-2 text-info"></i><span class="fw-medium">21 Apr 2022 </span></div>
                                                          <div class="flex-shrink-0"><small class="badge bg-primary-subtle text-primary ms-auto">7:00 PM to 12:00 AM</small></div>
                                                       </div>
                                                       <h6 class="card-title fs-16"> Día de la Tierra</h6>
                                                       <p class="text-muted text-truncate-two-lines mb-0"> </p>
                                                    </div>
                                                 </div>
                                                 <div class="card mb-3">
                                                    <div class="card-body">
                                                       <div class="d-flex mb-3">
                                                          <div class="flex-grow-1"><i class="mdi mdi-checkbox-blank-circle me-2 text-primary"></i><span class="fw-medium">1 Jul 2024 </span></div>
                                                          <div class="flex-shrink-0"><small class="badge bg-primary-subtle text-primary ms-auto">Evento de día completo</small></div>
                                                       </div>
                                                       <h6 class="card-title fs-16"> Evento de todo el día</h6>
                                                       <p class="text-muted text-truncate-two-lines mb-0"> Un evento de todo el día es un evento que dura un día entero o más.</p>
                                                    </div>
                                                 </div>
                                                 <div class="card mb-3">
                                                    <div class="card-body">
                                                       <div class="d-flex mb-3">
                                                          <div class="flex-grow-1"><i class="mdi mdi-checkbox-blank-circle me-2 text-warning"></i><span class="fw-medium">14 Jul 2024 to 16 Jul 2024 </span></div>
                                                          <div class="flex-shrink-0"><small class="badge bg-primary-subtle text-primary ms-auto">Evento de día completo</small></div>
                                                       </div>
                                                       <h6 class="card-title fs-16"> Visitar curso en línea</h6>
                                                       <p class="text-muted text-truncate-two-lines mb-0"> Evento a largo plazo significa un incidente que dura más de 12 horas.</p>
                                                    </div>
                                                 </div>
                                                 <div class="card mb-3">
                                                    <div class="card-body">
                                                       <div class="d-flex mb-3">
                                                          <div class="flex-grow-1"><i class="mdi mdi-checkbox-blank-circle me-2 text-success"></i><span class="fw-medium">19 Jul 2024 </span></div>
                                                          <div class="flex-shrink-0"><small class="badge bg-primary-subtle text-primary ms-auto">12:30 PM to 12:00 AM</small></div>
                                                       </div>
                                                       <h6 class="card-title fs-16"> Reunión con el diseñador</h6>
                                                       <p class="text-muted text-truncate-two-lines mb-0"> Dile cómo aumentar el tráfico del sitio web</p>
                                                    </div>
                                                 </div>
                                                 <div class="card mb-3">
                                                    <div class="card-body">
                                                       <div class="d-flex mb-3">
                                                          <div class="flex-grow-1"><i class="mdi mdi-checkbox-blank-circle me-2 text-success"></i><span class="fw-medium">20 Jul 2024 </span></div>
                                                          <div class="flex-shrink-0"><small class="badge bg-primary-subtle text-primary ms-auto">7:00 PM to 12:00 AM</small></div>
                                                       </div>
                                                       <h6 class="card-title fs-16"> Fiesta de cumpleaños</h6>
                                                       <p class="text-muted text-truncate-two-lines mb-0"> Fiesta de pijamas familiar: ¡saque las mantas y las almohadas y organice una fiesta de pijamas familiar! Juegue divertidos juegos de fiesta, comparta refrigerios especiales y relájese con una película especial.</p>
                                                    </div>
                                                 </div>
                                                 <div class="card mb-3">
                                                    <div class="card-body">
                                                       <div class="d-flex mb-3">
                                                          <div class="flex-grow-1"><i class="mdi mdi-checkbox-blank-circle me-2 text-primary"></i><span class="fw-medium">23 Jul 2024 to 27 Jul 2024 </span></div>
                                                          <div class="flex-shrink-0"><small class="badge bg-primary-subtle text-primary ms-auto">Evento de día completo</small></div>
                                                       </div>
                                                       <h6 class="card-title fs-16"> Evento repetido</h6>
                                                       <p class="text-muted text-truncate-two-lines mb-0"> Un evento recurrente o repetitivo es simplemente cualquier evento que ocurrirá más de una vez en su calendario. </p>
                                                    </div>
                                                 </div>
                                                 <div class="card mb-3">
                                                    <div class="card-body">
                                                       <div class="d-flex mb-3">
                                                          <div class="flex-grow-1"><i class="mdi mdi-checkbox-blank-circle me-2 text-danger"></i><span class="fw-medium">28 Jul 2024 to 29 Jul 2024 </span></div>
                                                          <div class="flex-shrink-0"><small class="badge bg-primary-subtle text-primary ms-auto">Evento de día completo</small></div>
                                                       </div>
                                                       <h6 class="card-title fs-16"> Planificación estratégica semanal</h6>
                                                       <p class="text-muted text-truncate-two-lines mb-0"> Estrategias para crear su horario semanal</p>
                                                    </div>
                                                 </div>
                                                 <div class="card mb-3">
                                                    <div class="card-body">
                                                       <div class="d-flex mb-3">
                                                          <div class="flex-grow-1"><i class="mdi mdi-checkbox-blank-circle me-2 text-dark"></i><span class="fw-medium">28 Jul 2024 </span></div>
                                                          <div class="flex-shrink-0"><small class="badge bg-primary-subtle text-primary ms-auto">Evento de día completo</small></div>
                                                       </div>
                                                       <h6 class="card-title fs-16"> Haga clic para Google</h6>
                                                       <p class="text-muted text-truncate-two-lines mb-0"> </p>
                                                    </div>
                                                 </div>
                                                 <div class="card mb-3">
                                                    <div class="card-body">
                                                       <div class="d-flex mb-3">
                                                          <div class="flex-grow-1"><i class="mdi mdi-checkbox-blank-circle me-2 text-danger"></i><span class="fw-medium">10 Aug 2024 to 11 Aug 2024 </span></div>
                                                          <div class="flex-shrink-0"><small class="badge bg-primary-subtle text-primary ms-auto">8:00 PM to 4:00 PM</small></div>
                                                       </div>
                                                       <h6 class="card-title fs-16"> Reunión de clientes con Alexis</h6>
                                                       <p class="text-muted text-truncate-two-lines mb-0"> Una reunión es una reunión de dos o más personas que se ha convocado con el propósito de lograr un objetivo común a través de la interacción verbal, como compartir información o llegar a un acuerdo.</p>
                                                    </div>
                                                 </div>
                                                 <div class="card mb-3">
                                                    <div class="card-body">
                                                       <div class="d-flex mb-3">
                                                          <div class="flex-grow-1"><i class="mdi mdi-checkbox-blank-circle me-2 text-info"></i><span class="fw-medium">11 Aug 2024 </span></div>
                                                          <div class="flex-shrink-0"><small class="badge bg-primary-subtle text-primary ms-auto">8:00 PM to 4:00 PM</small></div>
                                                       </div>
                                                       <h6 class="card-title fs-16"> Discusión del proyecto Velzon con el equipo</h6>
                                                       <p class="text-muted text-truncate-two-lines mb-0"> Dile cómo aumentar el tráfico del sitio web</p>
                                                    </div>
                                                 </div>
                                              </div>
                                           </div>
                                        </div>
                                     </div>
                                  </div>
                                  <div class="simplebar-placeholder" style="width: 250px; height: 2531px;"></div>
                               </div>
                               <div class="simplebar-track simplebar-horizontal" style="visibility: hidden;">
                                  <div class="simplebar-scrollbar" style="width: 0px; display: none;"></div>
                               </div>
                               <div class="simplebar-track simplebar-vertical" style="visibility: visible;">
                                  <div class="simplebar-scrollbar" style="height: 63px; display: block; transform: translate3d(0px, 0px, 0px);"></div>
                               </div>
                            </div>
                         </div>
                         <div class="card">
                            <div class="card-body bg-info-subtle">
                               <div class="d-flex">
                                  <div class="flex-shrink-0">
                                     <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-calendar text-info icon-dual-info">
                                        <rect x="3" y="4" width="18" height="18" rx="2" ry="2"></rect>
                                        <line x1="16" y1="2" x2="16" y2="6"></line>
                                        <line x1="8" y1="2" x2="8" y2="6"></line>
                                        <line x1="3" y1="10" x2="21" y2="10"></line>
                                     </svg>
                                  </div>
                                  <div class="flex-grow-1 ms-3">
                                     <h6 class="fs-15">¡Bienvenido a tu Calendario!</h6>
                                     <p class="text-muted mb-0">En caso de que el libro de aplicaciones aparezca aquí. Haga clic en un evento para ver los detalles y administrar el evento de los solicitantes.</p>
                                  </div>
                               </div>
                            </div>
                         </div>
                         <!--end card-->
                      </div>
                      <!-- end col-->
                      <div class="col-xl-9">
                         <div class="card card-h-100">
                            <div class="card-body">
                                <div id="calendar"></div>
                             
                            </div>
                         </div>
                      </div>
                      
                      <!-- end col -->
                   </div>
                   <!--end row-->
                   <div style="clear:both"></div>

                </div>

			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>

</div>

                   <!-- Add New Event MODAL -->
                   <div class="modal fade" id="event-modal" tabindex="-1">
                      <div class="modal-dialog modal-dialog-centered">
                         <div class="modal-content border-0">
                            <div class="modal-header p-3 bg-info-subtle">
                               <h5 class="modal-title" id="modal-title">Evento</h5>
                               <button type="button" class="btn-close" data-bs-dismiss="modal" aria-hidden="true"></button>
                            </div>
                            <div class="modal-body p-4">
                               <form class="formulario view-event" name="event-form" action="<?=$baseUrl ?>/actualizar-planificacion-horaria" id="form-event" novalidate="" autocomplete="off" method="POST">
                                   <span class="respuesta"></span>
                                  <div class="text-end">
                                     <a href="#" class="btn btn-sm btn-soft-primary" id="edit-event-btn" data-id="edit-event" onclick="editEvent(this)" role="button">Editar</a>
                                  </div>
                                  <div class="event-details">
                                     <div class="d-flex mb-2">
                                        <div class="flex-grow-1 d-flex align-items-center">
                                           <div class="flex-shrink-0 me-3">
                                              <i class="ri-calendar-event-line text-muted fs-16"></i>
                                           </div>
                                           <div class="flex-grow-1">
                                              <h6 class="d-block fw-semibold mb-0" id="event-start-date-tag"></h6>
                                           </div>
                                        </div>
                                     </div>
                                     <div class="d-flex align-items-center mb-2">
                                        <div class="flex-shrink-0 me-3">
                                           <i class="ri-time-line text-muted fs-16"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                           <h6 class="d-block fw-semibold mb-0"><span id="event-timepicker1-tag"></span> - <span id="event-timepicker2-tag"></span></h6>
                                        </div>
                                     </div>
                                     <div class="d-flex align-items-center mb-2">
                                        <div class="flex-shrink-0 me-3">
                                           <i class="ri-bookmark-line text-muted fs-16"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                           <h6 class="d-block fw-semibold mb-0"> <span id="event-grupo-trabajo-tag"></span></h6>
                                        </div>
                                     </div>
                                     <div class="d-flex mb-3">
                                        <div class="flex-shrink-0 me-3">
                                           <i class="ri-shield-user-line text-muted fs-16"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                           <p class="d-block text-muted mb-0" id="event-jefe-grupo-trabajo-tag"></p>
                                        </div>
                                     </div>
                                  </div>
                                  <div class="row event-form">
                                     <div class="col-12">
                                        <div class="mb-3">
                                           <label for="lista_horarios" class="form-label">Horarios</label>
                                           <!--<div class="choices" data-type="select-one" tabindex="0" role="listbox" aria-haspopup="true" aria-expanded="false">-->
                                              <!--<div class="choices__inner">-->
                                                 <select class="form-select" name="lista_horarios" id="lista_horarios" required="" tabindex="-1" data-choice="active">
                                                    <option value="bg-danger-subtle" data-custom-properties=""></option>
                                                 </select>
                                                 <!--<div class="choices__list choices__list--single">-->
                                                 <!--   <div class="choices__item choices__item--selectable" data-item="" data-id="1" data-value="bg-danger-subtle" data-custom-properties="[object Object]" aria-selected="true">Danger</div>-->
                                                 <!--</div>-->
                                              <!--</div>-->
                                              <!--<div class="choices__list choices__list--dropdown" aria-expanded="false">-->
                                              <!--   <div class="choices__list" role="listbox">-->
                                              <!--      <div id="choices--event-category-item-choice-1" class="choices__item choices__item--choice is-selected choices__item--selectable is-highlighted" role="option" data-choice="" data-id="1" data-value="bg-danger-subtle" data-select-text="Press to select" data-choice-selectable="" aria-selected="true">Danger</div>-->
                                              <!--      <div id="choices--event-category-item-choice-2" class="choices__item choices__item--choice choices__item--selectable" role="option" data-choice="" data-id="2" data-value="bg-dark-subtle" data-select-text="Press to select" data-choice-selectable="">Dark</div>-->
                                              <!--      <div id="choices--event-category-item-choice-3" class="choices__item choices__item--choice choices__item--selectable" role="option" data-choice="" data-id="3" data-value="bg-info-subtle" data-select-text="Press to select" data-choice-selectable="">Info</div>-->
                                              <!--      <div id="choices--event-category-item-choice-4" class="choices__item choices__item--choice choices__item--selectable" role="option" data-choice="" data-id="4" data-value="bg-primary-subtle" data-select-text="Press to select" data-choice-selectable="">Primary</div>-->
                                              <!--      <div id="choices--event-category-item-choice-5" class="choices__item choices__item--choice choices__item--selectable" role="option" data-choice="" data-id="5" data-value="bg-success-subtle" data-select-text="Press to select" data-choice-selectable="">Success</div>-->
                                              <!--      <div id="choices--event-category-item-choice-6" class="choices__item choices__item--choice choices__item--selectable" role="option" data-choice="" data-id="6" data-value="bg-warning-subtle" data-select-text="Press to select" data-choice-selectable="">Warning</div>-->
                                              <!--   </div>-->
                                              <!--</div>-->
                                              
                                           <!--</div>-->
                                           <div class="invalid-feedback">Por favor seleccione una categoría de evento válida</div>
                                        </div>
                                     </div>
                                     <!--end col-->
                                     <div class="col-12">
                                        <div class="mb-3">
                                           <label for="codigo_horario" class="form-label">Código Horario</label>
                                           <input class="form-control" placeholder="Código Horario" type="text" name="codigo_horario" id="codigo_horario" required="" value="" disabled>
                                           <div class="invalid-feedback">Por favor proporcione un nombre de evento válido</div>
                                        </div>
                                     </div>
                                     <!--end col-->
                                     <div class="col-12">
                                        <div class="mb-3">
                                           <label for="fecha_horario">Fecha del evento</label>
                                           <div class="input-group">
                                              <input type="text" id="fecha_horario" name="fecha_horario" class="form-control flatpickr flatpickr-input" placeholder="Select date" required="" disabled>
                                              <span class="input-group-text"><i class="ri-calendar-event-line"></i></span>
                                           </div>
                                        </div>
                                     </div>
                                     <!--end col-->
                                     <div class="col-12" id="event-time">
                                        <div class="row">
                                           <div class="col-6">
                                              <div class="mb-3">
                                                 <label for="hora_inicio" class="form-label">Hora de inicio</label>
                                                 <div class="input-group">
                                                    <input id="hora_inicio" name="hora_inicio" type="text" class="form-control flatpickr flatpickr-input" placeholder="Hora de Inicio" disabled>
                                                    <span class="input-group-text"><i class="ri-time-line"></i></span>
                                                 </div>
                                              </div>
                                           </div>
                                           <div class="col-6">
                                              <div class="mb-3">
                                                 <label for="hora_finalizacion" class="form-label">Hora de finalización</label>
                                                 <div class="input-group">
                                                    <input id="hora_finalizacion" name="hora_finalizacion" type="text" class="form-control flatpickr flatpickr-input" placeholder="Hora de finalización" disabled>
                                                    <span class="input-group-text"><i class="ri-time-line"></i></span>
                                                 </div>
                                              </div>
                                           </div>
                                        </div>
                                     </div>
                                     <!--end col-->
                                     <div class="col-12">
                                        <div class="mb-3">
                                           <label for="grupo_trabajo">Grupo de Trabajo</label>
                                           <div>
                                              <input type="text" class="form-control" name="grupo_trabajo" id="grupo_trabajo" placeholder="Grupo de Trabajo" disabled>
                                           </div>
                                        </div>
                                     </div>
                                     <!--end col-->
                                     <input type="hidden" id="idUsuarioPlanificacion" name="idUsuarioPlanificacion" value="<?= $idUsuarioPlanificacion ?>">
                                     <input type="hidden" id="idPlanificacion" name="idPlanificacion" value="">
                                     <input type="hidden" id="idHorario" name="idHorario" value="">
                                     <input type="hidden" id="eventid" name="eventid" value="">
                                     <div class="col-12">
                                        <div class="mb-3">
                                           <label for="jefe_grupo_trabajo" class="form-label">Lider Grupo Trabajo</label>
                                           <div>
                                              <input type="text" class="form-control" name="jefe_grupo_trabajo" id="jefe_grupo_trabajo" placeholder="Jefe Grupo Trabajo" disabled>
                                           </div>
                                           <!--<textarea class="form-control d-none" id="event-description" placeholder="Enter a description" rows="3" spellcheck="false"></textarea>-->
                                        </div>
                                     </div>
                                     <div class="col-12">
                                        <div class="mb-3">
                                            <label for="motivo_cambio" class="form-label">Motivo</label>
                                            <textarea class="form-control" id="motivo_cambio" name="motivo_cambio" placeholder="Motivo del cambio" rows="3" spellcheck="false"></textarea>
                                        </div>
                                     </div>
                                     <!--end col-->
                                  </div>
                                  <!--end row-->
                                  <div class="hstack gap-2 justify-content-end">
                                     <button type="button" class="btn btn-soft-danger" id="btn-delete-event" hidden="true"><i class="ri-close-line align-bottom"></i> Borrar</button>
                                     <button type="submit" class="btn btn-success" id="btn-save-event" hidden>Guardar Cambios</button>
                                  </div>
                               </form>
                            </div>
                         </div>
                         <!-- end modal-content-->
                      </div>
                      <!-- end modal dialog-->
                   </div>
                   <!-- end modal-->
                   
<?= $this->section('js'); ?>
    <script>
        $(document).ready(function() {
   
            var calendarEl = document.getElementById('calendar');
            var idUsuarioPlanificacion = <?= $idUsuarioPlanificacion ?>;
        
            var calendar = new FullCalendar.Calendar(calendarEl, {
                initialView: 'dayGridMonth',
                locale: 'es', // Cambiar idioma a español
                editable: true,
                droppable: true,
                events: function(info, successCallback, failureCallback) {
                    $.ajax({
                        url: baseUrl + "/calendario-planificacion",
                        type: 'POST',
                        dataType: 'json', // Asegura que la respuesta se interprete como JSON
                        data: {
                            idUsuarioPlanificacion: idUsuarioPlanificacion,
                            start: info.startStr, // Fecha de inicio de la vista actual
                            end: info.endStr // Fecha de fin de la vista actual
                        },
                        success: function(res) {
                         
                             if (Array.isArray(res)) { // Verifica si res es un array
                                var events = [];
                                res.forEach(function(evt) {
                                    events.push({
                                        id:evt.id_planificacion,
                                        title: evt.title,
                                        start: evt.start,
                                        end: evt.end,
                                        extendedProps: {
                                            grupoTrabajo: evt.grupoTrabajo,
                                            jefeGrupoTrabajo: evt.jefeGrupoTrabajo,
                                            id_horario: evt.id_horario,
                                            id_planificacion : evt.id_planificacion,
                                            fechaTrabajo: evt.fechaTrabajo
                                        }
                                    });
                                });
                                successCallback(events); // Llama al callback con los eventos
                            } else {
                                console.error('La respuesta no es un array:', res);
                                alert('Hubo un error al cargar los eventos.');
                                failureCallback(); // Llama al callback de fallo
                            }
                            // successCallback(events); // Llama al callback con los eventos
                        },
                        error: function() {
                            alert('Hubo un error al cargar los eventos.');
                            failureCallback(); // Llama al callback de fallo
                        }
                    });
                },
                eventClick: function(info) { 
                    console.log(info.event.start.toLocaleDateString());
                    // Evitar que se abra el enlace predeterminado si el evento tiene un URL
                    info.jsEvent.preventDefault();
                    
                    
                    // // Guardar id_horario en el campo oculto
                    // $('#idHorario').value = info.event.extendedProps.id_horario;
                    // $('#idPlanificacion').value = info.event.extendedProps.id_planificacion; console.log(info.event.extendedProps.id_planificacion);
                    
                    // $('#event-start-date-tag').value = info.event.start.toLocaleDateString();
                    
                    // Actualiza el contenido del modal con los detalles del evento
                    $('#modal-title').text(info.event.title);
                    $('#event-start-date-tag').text(info.event.start.toLocaleDateString());
                    $('#event-timepicker1-tag').text(info.event.start.toLocaleTimeString());
                    $('#event-timepicker2-tag').text(info.event.end ? info.event.end.toLocaleTimeString() : '');
                    $('#event-grupo-trabajo-tag').text(info.event.extendedProps.grupoTrabajo || 'No especificado');
                    $('#event-jefe-grupo-trabajo-tag').text(info.event.extendedProps.jefeGrupoTrabajo || 'No disponible');
                   
                    // Guardar id_horario en el campo oculto
                    $('#idHorario').val(info.event.extendedProps.id_horario);
                    $('#idPlanificacion').val(info.event.extendedProps.id_planificacion);
                    
        
                    // Abre el modal
                    var eventModal = new bootstrap.Modal(document.getElementById('event-modal'), {
                        keyboard: true
                    });
                    
                    eventModal.show();
                },
                drop: function(info) { 
                    // console.log(info);
                    // console.log(calendar);
                    // Acción después de soltar el evento

                    var eventEl = info.draggedEl;
                    
                    // Acción después de soltar el evento
                    var eventId = $(info.draggedEl).data('id');
                    console.log('ID del evento arrastrado:', eventId);

                
                    // Obtener los valores de data-* del elemento arrastrado  // Obtener los datos del evento arrastrado
                    var idHorario = $(eventEl).data('id');
                    var codigo = $(eventEl).data('codigo');
                    var grupoTrabajo = $(eventEl).data('grupo-trabajo');
                    var horaInicio = $(eventEl).data('hora-inicio'); console.log(horaInicio);
                    var horaFin = $(eventEl).data('hora-fin');
                    
                    var start = info.date; console.log(start);
                    var end = info.date; // Puedes ajustar esto según la duración del evento
                    
                    // Normaliza la fecha de inicio y fin para solo considerar la parte de la fecha
                    start.setHours(0, 0, 0, 0); console.log(start);
                    end.setHours(23, 59, 59, 999);
        
                    // Verificar si ya hay un evento en la misma fecha (solo la fecha)
                    var existingEvents = calendar.getEvents();
                    var conflict = existingEvents.some(function(event) {
                        var eventStart = new Date(event.start);
                        var eventEnd = new Date(event.end);
                        
                        // Normaliza las fechas del evento existente para solo considerar la parte de la fecha
                        eventStart.setHours(0, 0, 0, 0);
                        eventEnd.setHours(23, 59, 59, 999);
                        
                        return (eventStart <= end && eventEnd >= start);
                    });
    

                    if (conflict) { 
                        var mensaje = 'Esta Seguro de Actualizar el horario ';
                        var urlPlanificacionHorario = baseUrl + '/calendario-planificacion-actualizar'
                        var parametros = {
                                    "idUsuario": idUsuarioPlanificacion,
                                    "idHorario": idHorario,
                                    "fecha": info.date
                                };

                        
                    } else { //alert('Si no hay conflicto, agregar el evento');
                        // Si no hay conflicto, agregar el evento
                        var mensaje = 'Esta Seguro de Crear el horario para este día';
                        var urlPlanificacionHorario = baseUrl + '/calendario-planificacion-crear';
                        var parametros = {
                                    "idUsuario": idUsuarioPlanificacion,
                                    "idHorario": idHorario,
                                    "fecha": info.date,
                                    "grupoTrabajo": grupoTrabajo
                                    };
                        // $(eventEl).remove();
                    }
                    console.log(parametros);
                    Swal.fire({
                            title: mensaje,
                            //text: "Recuerda que esta acción es permanente.",
                            icon: 'warning',
                            showCancelButton: true,
                            confirmButtonColor: '#282e38',
                            cancelButtonColor: '#f35d5d',
                            confirmButtonText: 'Confirmar'
                        }).then((result) => {
                            if (result.isConfirmed) {
                              
                                $.ajax({        
                                    url: urlPlanificacionHorario,
                                    type: "POST",
                                    data: parametros,
                                    success: function(response) {
                                        $('.respuesta').html(response);
                                    }, 
                                    error: function(jqXHR, textStatus, errorThrown){
                                        //$.unblockUI({});
                                        Swal.close();
                                        alert('Ha ocurrido un error interno.');
                                        console.log(jqXHR );
                                        console.log(textStatus);
                                        console.log(errorThrown);
                                    }
                                });
                                
                                // Elimina el evento arrastrado del DOM
                                // $(eventEl).remove(); 
                            
                            } else {
                                
                                // Revierte el evento si no se confirma
                                calendar.getEventById(eventId)?.remove();
    
                            }
                        });
                    
                    return false;
                    
                },
                eventDrop: function(info) {
                    // Aquí puedes manejar el caso donde el evento se mueve dentro del calendario
                    console.log('Evento movido:', info);
                }

            });
        
        // Configurar Draggable para eventos externos
        var externalEventsEl = document.getElementById('external-events');
        new FullCalendar.Draggable(externalEventsEl, {
            itemSelector: '.external-event',
            eventData: function(eventEl) {
                return {
                    id: $(eventEl).data('id'),
                    title: eventEl.innerText,
                    className: $(eventEl).data('class')
                };
            }
        });
        
        calendar.render();
        
    });

    </script>
<?php $this->endSection(); ?>

<!-- end main content-->
<?php $this->endSection(); ?>
<div class="flatpickr-calendar rangeMode animate" tabindex="-1">
   <div class="flatpickr-months">
      <span class="flatpickr-prev-month flatpickr-disabled">
         <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 17 17">
            <g></g>
            <path d="M5.207 8.471l7.146 7.147-0.707 0.707-7.853-7.854 7.854-7.853 0.707 0.707-7.147 7.146z"></path>
         </svg>
      </span>
      <div class="flatpickr-month">
         <div class="flatpickr-current-month">
            <select class="flatpickr-monthDropdown-months" aria-label="Month" tabindex="-1">
               <option class="flatpickr-monthDropdown-month" value="6" tabindex="-1">July</option>
               <option class="flatpickr-monthDropdown-month" value="7" tabindex="-1">August</option>
               <option class="flatpickr-monthDropdown-month" value="8" tabindex="-1">September</option>
               <option class="flatpickr-monthDropdown-month" value="9" tabindex="-1">October</option>
               <option class="flatpickr-monthDropdown-month" value="10" tabindex="-1">November</option>
               <option class="flatpickr-monthDropdown-month" value="11" tabindex="-1">December</option>
            </select>
            <div class="numInputWrapper"><input class="numInput cur-year" type="number" tabindex="-1" aria-label="Year" min="2024"><span class="arrowUp"></span><span class="arrowDown"></span></div>
         </div>
      </div>
      <span class="flatpickr-next-month">
         <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 17 17">
            <g></g>
            <path d="M13.207 8.472l-7.854 7.854-0.707-0.707 7.146-7.146-7.146-7.148 0.707-0.707 7.854 7.854z"></path>
         </svg>
      </span>
   </div>
   <div class="flatpickr-innerContainer">
      <div class="flatpickr-rContainer">
         <div class="flatpickr-weekdays">
            <div class="flatpickr-weekdaycontainer">
               <span class="flatpickr-weekday">
               Sun</span><span class="flatpickr-weekday">Mon</span><span class="flatpickr-weekday">Tue</span><span class="flatpickr-weekday">Wed</span><span class="flatpickr-weekday">Thu</span><span class="flatpickr-weekday">Fri</span><span class="flatpickr-weekday">Sat
               </span>
            </div>
         </div>
         <div class="flatpickr-days" tabindex="-1">
            <div class="dayContainer"><span class="flatpickr-day prevMonthDay flatpickr-disabled" aria-label="June 30, 2024">30</span><span class="flatpickr-day flatpickr-disabled" aria-label="July 1, 2024">1</span><span class="flatpickr-day flatpickr-disabled" aria-label="July 2, 2024">2</span><span class="flatpickr-day flatpickr-disabled" aria-label="July 3, 2024">3</span><span class="flatpickr-day flatpickr-disabled" aria-label="July 4, 2024">4</span><span class="flatpickr-day flatpickr-disabled" aria-label="July 5, 2024">5</span><span class="flatpickr-day flatpickr-disabled" aria-label="July 6, 2024">6</span><span class="flatpickr-day flatpickr-disabled" aria-label="July 7, 2024">7</span><span class="flatpickr-day flatpickr-disabled" aria-label="July 8, 2024">8</span><span class="flatpickr-day flatpickr-disabled" aria-label="July 9, 2024">9</span><span class="flatpickr-day flatpickr-disabled" aria-label="July 10, 2024">10</span><span class="flatpickr-day flatpickr-disabled" aria-label="July 11, 2024">11</span><span class="flatpickr-day flatpickr-disabled" aria-label="July 12, 2024">12</span><span class="flatpickr-day flatpickr-disabled" aria-label="July 13, 2024">13</span><span class="flatpickr-day flatpickr-disabled" aria-label="July 14, 2024">14</span><span class="flatpickr-day flatpickr-disabled" aria-label="July 15, 2024">15</span><span class="flatpickr-day flatpickr-disabled" aria-label="July 16, 2024">16</span><span class="flatpickr-day flatpickr-disabled" aria-label="July 17, 2024">17</span><span class="flatpickr-day flatpickr-disabled" aria-label="July 18, 2024">18</span><span class="flatpickr-day today" aria-label="July 19, 2024" aria-current="date" tabindex="-1">19</span><span class="flatpickr-day" aria-label="July 20, 2024" tabindex="-1">20</span><span class="flatpickr-day" aria-label="July 21, 2024" tabindex="-1">21</span><span class="flatpickr-day" aria-label="July 22, 2024" tabindex="-1">22</span><span class="flatpickr-day" aria-label="July 23, 2024" tabindex="-1">23</span><span class="flatpickr-day" aria-label="July 24, 2024" tabindex="-1">24</span><span class="flatpickr-day" aria-label="July 25, 2024" tabindex="-1">25</span><span class="flatpickr-day" aria-label="July 26, 2024" tabindex="-1">26</span><span class="flatpickr-day" aria-label="July 27, 2024" tabindex="-1">27</span><span class="flatpickr-day" aria-label="July 28, 2024" tabindex="-1">28</span><span class="flatpickr-day" aria-label="July 29, 2024" tabindex="-1">29</span><span class="flatpickr-day" aria-label="July 30, 2024" tabindex="-1">30</span><span class="flatpickr-day" aria-label="July 31, 2024" tabindex="-1">31</span><span class="flatpickr-day nextMonthDay" aria-label="August 1, 2024" tabindex="-1">1</span><span class="flatpickr-day nextMonthDay" aria-label="August 2, 2024" tabindex="-1">2</span><span class="flatpickr-day nextMonthDay" aria-label="August 3, 2024" tabindex="-1">3</span><span class="flatpickr-day nextMonthDay" aria-label="August 4, 2024" tabindex="-1">4</span><span class="flatpickr-day nextMonthDay" aria-label="August 5, 2024" tabindex="-1">5</span><span class="flatpickr-day nextMonthDay" aria-label="August 6, 2024" tabindex="-1">6</span><span class="flatpickr-day nextMonthDay" aria-label="August 7, 2024" tabindex="-1">7</span><span class="flatpickr-day nextMonthDay" aria-label="August 8, 2024" tabindex="-1">8</span><span class="flatpickr-day nextMonthDay" aria-label="August 9, 2024" tabindex="-1">9</span><span class="flatpickr-day nextMonthDay" aria-label="August 10, 2024" tabindex="-1">10</span></div>
         </div>
      </div>
   </div>
</div>
<div class="flatpickr-calendar hasTime noCalendar animate" tabindex="-1">
   <div class="flatpickr-time" tabindex="-1">
      <div class="numInputWrapper"><input class="numInput flatpickr-hour" type="number" aria-label="Hour" tabindex="-1" step="1" min="1" max="12" maxlength="2"><span class="arrowUp"></span><span class="arrowDown"></span></div>
      <span class="flatpickr-time-separator">:</span>
      <div class="numInputWrapper"><input class="numInput flatpickr-minute" type="number" aria-label="Minute" tabindex="-1" step="5" min="0" max="59" maxlength="2"><span class="arrowUp"></span><span class="arrowDown"></span></div>
      <span class="flatpickr-am-pm" title="Click to toggle" tabindex="-1">PM</span>
   </div>
</div>
<div class="flatpickr-calendar hasTime noCalendar animate" tabindex="-1">
   <div class="flatpickr-time" tabindex="-1">
      <div class="numInputWrapper"><input class="numInput flatpickr-hour" type="number" aria-label="Hour" tabindex="-1" step="1" min="1" max="12" maxlength="2"><span class="arrowUp"></span><span class="arrowDown"></span></div>
      <span class="flatpickr-time-separator">:</span>
      <div class="numInputWrapper"><input class="numInput flatpickr-minute" type="number" aria-label="Minute" tabindex="-1" step="5" min="0" max="59" maxlength="2"><span class="arrowUp"></span><span class="arrowDown"></span></div>
      <span class="flatpickr-am-pm" title="Click to toggle" tabindex="-1">PM</span>
   </div>
</div>
