<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb_alias ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $breadcrumb_alias ?></h5>
                            <div>
								<?php
								if (in_array("ADARES", $permisos)) 
								{
								?>
                                <button class="btn btn-primary datos-area-estructura" data-bs-toggle="modal" data-bs-target="#informacionAreaEstructura" data-id="0" data-accion="crear" id="crear-area-estructura">
									<i class="mdi mdi-plus-circle"></i> Agregar
								</button>
								<?php
								}
								?>
								<a href="<?= $baseUrl.'/'.$previo ?>" class="btn px-2 py-0" style="border-radius: 45%; background-color: red;"><i class="mdi mdi-arrow-left-circle" style="font-size: 24px; color: #FFF"></i></a>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblAreasEstructura" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								<thead>
									<tr>
										<th class="text-center align-middle">Código</th>
										<th class="text-center align-middle">Área</th>
										<th class="text-center align-middle">Observación</th>
										<th class="text-center align-middle">Estado</th>
										<th class="text-center align-middle">Acciones</th>
									</tr>
								</thead>
								<tbody>
									<?php 
									foreach($listaAreas as $items){ ?>
									<tr>
										<td class="text-center align-middle"><?= $items['IDArea'] ?></td>
										<td class="text-center align-middle"><?= $items['Area'] ?></td>
										<td class="text-center align-middle"><?= $items['Observacion'] ?></td>
										<td class="text-center align-middle">
										<?php
										if (in_array("ESARES", $permisos)) 
										{
										?>
											<button class="badge <?= $items['Estado'] == "A" ? 'bg-success' : 'bg-warning' ?> border-0 cambiar-estado-area-estructura" data-estado="<?= $items['Estado'] ?>" data-id="<?=$items['IDArea'] ?>"><?= $items['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO' ?></button>
										<?php
										}
										else
										{
										?>
											<span class="badge <?= $items['Estado'] == "A" ? 'bg-success' : 'bg-warning' ?> border-0" ><?= $items['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO' ?></span>
										<?php
										}
										?>
										</td>
										<td class="text-center align-middle">
											<div class="dropdown d-inline-block">
												<button class="btn btn-soft-secondary btn-sm dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">
													<i class="ri-more-fill align-middle"></i>
												</button>
												<ul class="dropdown-menu dropdown-menu-end">
													<li>
														<a href="#!" class="dropdown-item datos-area-estructura" data-bs-toggle="modal" data-bs-target="#informacionAreaEstructura" data-id="<?= $items['IDArea'] ?>" data-accion="ver" id="ver-area-estructura">
															<i class="ri-eye-fill align-bottom me-2 text-muted"></i> Ver
														</a>
													</li>
													<?php
													if (in_array("UPARES", $permisos)) 
													{
													?>
													<li>
														<a href="#!" class="dropdown-item edit-item-btn datos-area-estructura" data-bs-toggle="modal" data-bs-target="#informacionAreaEstructura" data-id="<?= $items['IDArea'] ?>" data-accion="editar" id="editar-area-estructura">
															<i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Editar
														</a>
													</li>
													<?php
													}
													
													if (in_array("ADSUES", $permisos)) 
													{
													?>
													<li>
														<a href="<?= $baseUrl ?>/listar-subareas-estructura/<?= $items['IDArea'] ?>" class="dropdown-item">
															<i class="mdi mdi-graph align-bottom me-2 text-muted"></i> Subáreas
														</a>
													</li>
													<?php
													}
													?>
												</ul>
											</div>
										</td>
									</tr>
									<?php } ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->
<!-- Modal Información Tipo Categoria -->
<div class="modal fade" id="informacionAreaEstructura" tabindex="-1" role="dialog" aria-labelledby="exampleinformacionAreaEstructura" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleinformacionAreaEstructura">Información del área</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formInformacionAreaEstructura" class="formulario" autocomplete="off" action="" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" id="txtIDDireccionEstructura_i" name="txtIDDireccionEstructura_i" value="<?= $direccion['IDDireccion'] ?>">
					<input type="hidden" id="txtIDAreaEstructura_i" name="txtIDAreaEstructura_i">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtAreaEstructura_i" class="form-label">Área</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Nombre Área" id="txtAreaEstructura_i" name="txtAreaEstructura_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtObservacionAreaEstructura_i" class="form-label">Observación</label>
								<textarea class="form-control" id="txtObservacionAreaEstructura_i" name="txtObservacionAreaEstructura_i" rows="3"></textarea>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" id="btnEjecutarAreaEstructura" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Actualizar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>