<?php namespace App\Models;

use CodeIgniter\Model;

class UsuarioGruposTrabajoModel extends Model {
    protected $table = 'usuario_grupostrabajo';
    protected $primaryKey = 'IdUsuario';
    protected $allowedFields = ['IdUsuario', 'IDGrupoTrabajo', 'UsuarioRegistra', 'FechaRegistra'];
    protected $useAutoIncrement = false;
    protected $useSoftDeletes = false;
    
    public function listarUsuariosGrupoTrabajo($array)
    {
        $builder = $this->db->table('vista_usuarios_grupostrabajo');
        
        if(isset($array['idusuario']) && $array['idusuario'] != '' && $array['idusuario'] != null)
        {
            $builder->where('IdUsuario', $array['idusuario']);
        }
        
        if(isset($array['idgrupotrabajo']) && $array['idgrupotrabajo'] != '' && $array['idgrupotrabajo'] != null)
        {
            $builder->where('IDGrupoTrabajo', $array['idgrupotrabajo']);
        }
        
        if(isset($array['like']) && $array['like'] != '' && $array['like'] != null)
        {
            $builder->where("(Matricula LIKE '%".$array['like']."%' OR 
            Nombres LIKE '%".$array['like']."%' OR
            Apellidos LIKE '%".$array['like']."%' OR 
            Usuario LIKE '%".$array['like']."%' OR 
            CONCAT(Nombres, ' ',Apellidos) LIKE '%".$array['like']."%' OR 
            NumeroDoc LIKE '%".$array['like']."%')");
        }
        
        $sql = $builder->getCompiledSelect();
        $datos = $this->db->query($sql)->getResultArray();
        
        return $datos;
    }
}
