<?php
namespace App\Models;

use CodeIgniter\Model;

class PlanificacionModel extends Model
{
    protected $table = 'planificacion';
    protected $primaryKey = 'IdPlanificacion';

    protected $useAutoIncrement = true;
    protected $returnType = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IdUsuario', 'FechaTrabajo', 'id_horario', 'UsuarioCreador', 'FechaCreacion', 'IDGrupoTrabajo','Motivo'];

    protected $useTimestamps = false;
    protected $createdField = 'created_at';
    protected $updatedField = 'updated_at';
    protected $deletedField = 'deleted_at';

    protected $validationRules = [];
    protected $validationMessages = [];
    protected $skipValidation = false;

    public function listaPlanificacionServerSide($get, $adicionales)
    {
        
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
        // $this->globales = new Globales();
        $fields = array(
            0 => 'tblusuario.Matricula',
            1 => 'tblusuario.Nombres',
            2 => 'horarios.horario',
            3 => 'horarios.codigo',
            4 => 'grupostrabajo.GrupoTrabajo',
            5 => 'tblusuario.Estado');
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        $this->select('planificacion.IdUsuario, planificacion.IdPlanificacion, horarios.horario, horarios.codigo, grupostrabajo.GrupoTrabajo, CONCAT(tblusuario.Nombres," ",tblusuario.Apellidos) AS nombresCompletos, tblusuario.Matricula, tblusuario.Estado');
        $this->join('tblusuario', 'tblusuario.IdUsuario = planificacion.IdUsuario');
        $this->join('horarios', 'horarios.id_horario = planificacion.id_horario');
        $this->join('grupostrabajo', 'grupostrabajo.IDGrupoTrabajo = planificacion.IDGrupoTrabajo');
        $this->groupBy('planificacion.IdUsuario'); // Agregar GROUP BY para evitar duplicados
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $this->orLike($fields[$k], $get['search']['value']);
                }
            }
            $this->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        // $this->where('horarios.EliminacionLogica',1);
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        foreach ($get['order'] as $order) {
            if(array_key_exists($order['column'], $fields))
            {
                $this->orderBy($fields[$order['column']], $order['dir']);
            }
        }
        /*
        * ----------------------------
        * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
        * ----------------------------
        */
        $this->limit($get['length'], $get['start']);
        /*
        * ----------------------------
        * EJECUTAR CONSULTA Y DEVOLVER VALORES
        * ----------------------------
        */
        // $this->get();
        // return $this->getLastQuery();
        $result = $this->get()->getResultArray(); 
        
        // Retornar datos y totales
        return   $result;  

    }
    
    public function listarHorariosXSeleccion($idHorarioSeleccionado)
    { 
        $whereDatos = array(
            'planificacion.id_horario' => $idHorarioSeleccionado,
            'horarios.EliminacionLogica' => 1
        );
        
        // Construimos la consulta directamente sobre el modelo actual
        $datos = $this->select('planificacion.FechaTrabajo, planificacion.IdUsuario,planificacion.Motivo, planificacion.IdPlanificacion, grupostrabajo.GrupoTrabajo, horarios.horario, horarios.id_horario, horarios.HoraInicio, horarios.HoraFin, horarios.codigo, tblusuario.Nombres, tblusuario.Apellidos')
            ->join('horarios', 'planificacion.id_horario = horarios.id_horario', 'left')
            ->join('grupostrabajo', 'grupostrabajo.IDGrupoTrabajo = planificacion.IDGrupoTrabajo', 'left')
            ->join('tblusuario', 'tblusuario.IdUsuario = grupostrabajo.JefeGrupoTrabajo', 'left')
            ->where($whereDatos)
            ->findAll(); // Ejecuta la consulta y obtiene los resultados
        
        return $datos; // Retorna los datos obtenidos
    }

}
