<?php
namespace App\Models;
use CodeIgniter\Model;

class EstructuraSubareaDelegacionesModel extends Model
{
    protected $table      = 'estructura_subarea_delegacion';
    protected $primaryKey = 'IDSubarea';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDSubarea', 'IDDelegacion', 'UsuarioRegistra', 'FechaRegistra', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function listarDelegacionesXSubarea($idSubarea)
    {
        $this->select('estructura_subarea_delegacion.IDSubarea,
            estructura_subarea_delegacion.IDDelegacion,
            estructura_delegacion.Delegacion,
            estructura_delegacion.CC,
            estructura_delegacion.LN');
        $this->join('estructura_delegacion', 'estructura_subarea_delegacion.IDDelegacion = estructura_delegacion.IDDelegacion');
        $this->where('estructura_subarea_delegacion.IDSubarea', $idSubarea);

        $datos = $this->findAll();
        return $datos;
    }
    
    // public function listadoCargosSelect($variable)
    // {
    //     $this->select('IDCargo,
    //         Cargo,
    //         Categoria');
    //     $this->like("Cargo", $variable);
    //     $this->orLike("Categoria", $variable);
        
    //     $datos = $this->findAll();
    //     return $datos;
    // }
}