<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>

<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $breadcrumb_alias ?></h5>
                            <div class="d-flex">
								<?php
								if(in_array("CSVUFL", $permisos))
								{
								?>
                                <button class="btn btn-info mx-1 d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#importarCSVUsuarioFlota">
									<i class="mdi mdi-file-upload mr-1" style="font-size: 18px;"></i> Importar Flota
								</button>
								<?php
								}
								
								if(in_array("CSVITU", $permisos))
								{
								?>
                                <button class="btn btn-danger mx-1 d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#importarCSVUsuarioIT">
									<i class="mdi mdi-file-upload mr-1" style="font-size: 18px;"></i> Importar IT
								</button>
								<?php
								}
								
								if(in_array("CSVUSU", $permisos))
								{
								?>
                                <button class="btn btn-success mx-1 d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#importarCSVUsuario">
									<i class="mdi mdi-file-upload mr-1" style="font-size: 18px;"></i> Importar Usuarios
								</button>
								<?php
								}
								
								if (in_array("ADDUSU", $permisos)) 
								{
								?>
                                <button class="btn btn-primary mx-1 d-flex align-items-center datos-usuario" data-bs-toggle="modal" data-bs-target="#informacionUsuario" data-id="0" data-accion="crear" id="crear-usuario">
									<i class="mdi mdi-plus-circle mr-1" style="font-size: 18px;"></i> Añadir 
								</button>
								<?php
								}
								?>
                            </div>
                        </div>
						<div class="card-body">
							<table id="ajax-usuarios" class="table table-bordered nowrap table-striped align-middle" style="width:100%">
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<?= $this->section('js'); ?>
<script>
			$(function () {
				/***SERVERSIDE USUARIOS***/
				assetListVM = {
					dt: null,
					init: function () {
						dt = $('#ajax-usuarios').DataTable({
							"serverSide": true,
							"processing": true,
							"ajax": {
								"url": baseUrl + "/usuariosServerside",
								type: 'GET'
							},
							"columns": [
								{"title": "Código", "data": "IdUsuario", "class": "text-center", "searchable": true },
								{"title": "Nombre y Apellido", "data": "nombre_usuario", "class": "text-center", "searchable": true },
								{"title": "Matrícula", "data": "Matricula", "class": "text-center", "searchable": true },
								{"title": "Documento de Identidad", "data": "NumeroDoc", "class": "text-center", "searchable": true },
								{"title": "Perfil", "data": "perfil_usuario", "class": "text-center", "searchable": true },
								{"title": "Usuario", "data": "Usuario", "class": "text-center", "searchable": true },
								{"title": "Sistemas", "data": "sistemas", "class": "text-center", "searchable": true },
								{"title": "Estado",
									"data": "Estado",
									class: 'text-center',
										render: function(data, type, row){  // con row obtienes la información por fila
										<?php
										if (in_array("ESTUSU", $permisos)) 
										{
										?>
										return "<button class='badge "+(row.Estado == 'Activo' ? 'bg-success' : 'bg-danger')+" border-0 cambiar-estado-usuario' data-estado='"+row.Estado+"' data-id='"+row.IdUsuario+"'>"+row.Estado+"</button>";
										<?php
										}
										else
										{
										?>
										return "<span class='badge "+(row.Estado == 'Activo' ? 'bg-success' : 'bg-danger')+"'>"+row.Estado+"</span>";
										<?php
										}
										?>
										
									}
								},
								{"title":"Acciones",
									"data": "acciones_usuario",
									class: 'text-center',
										render: function(data, type, row){  // con row obtienes la información por fila
										return "<div class='dropdown d-inline-block'>\n\
												<button class='btn btn-soft-secondary btn-sm dropdown' type='button' data-bs-toggle='dropdown' aria-expanded='false'>\n\
												<i class='ri-more-fill align-middle'></i>\n\
												</button>\n\
												<ul class='dropdown-menu dropdown-menu-end'>\n\
												    <li>\n\
														<a href='#!' class='dropdown-item datos-usuario d-flex justify-content-start align-items-center' data-bs-toggle='modal' data-bs-target='#informacionUsuario' data-id='"+row.IdUsuario+"' data-accion='ver' id='ver-usuario'>\n\
															<i class='ri-eye-fill align-bottom me-2 text-muted' style='font-size: 18px;'></i> Ver\n\
														</a>\n\
													</li>\n\
													<?php
													if (in_array("UPDUSU", $permisos)) 
													{
													?>
													<li>\n\
														<a href='#!' class='dropdown-item edit-item-btn datos-usuario d-flex justify-content-start align-items-center' data-bs-toggle='modal' data-bs-target='#informacionUsuario' data-id='"+row.IdUsuario+"' data-accion='editar' id='editar-usuario'>\n\
															<i class='ri-pencil-fill align-bottom me-2 text-muted' style='font-size: 18px;'></i> Editar\n\
														</a>\n\
													</li>\n\
													<?php
													}
													
													if (in_array("UPPEUS", $permisos))
													{
													?>
													<li>\n\
														<a class='dropdown-item edit-item-btn d-flex justify-content-start align-items-center' style='cursor: pointer;' data-bs-toggle='modal' data-bs-target='#editarPerfilUsuario' data-id='"+row.IdUsuario+"' id='editar-perfil-usuario'>\n\
															<i class='mdi mdi-scale-balance align-bottom me-2 text-muted' style='font-size: 18px;'></i> Editar Perfil\n\
														</a>\n\
													</li>\n\
													<?php
													}
													
													if (in_array("SAPEUS", $permisos))
													{
													?>
													<li>\n\
														<a href='<?= $baseUrl ?>/listar-permisos-usuario/"+row.IdUsuario+"' class='dropdown-item d-flex justify-content-start align-items-center'>\n\
															<i class='mdi mdi-account-eye align-bottom me-2 text-muted' style='font-size: 18px;'></i> Permisos\n\
														</a>\n\
													</li>\n\
													<?php
													}
													
													if (in_array("SARUUS", $permisos))
													{
													?>
													<li>\n\
														<a href='<?= $baseUrl ?>/listar-rutas-usuario/"+row.IdUsuario+"' class='dropdown-item d-flex justify-content-start align-items-center'>\n\
															<i class='mdi mdi-routes-clock align-bottom me-2 text-muted' style='font-size: 18px;'></i> Rutas\n\
														</a>\n\
													</li>\n\
													<?php
													}
													
													if (in_array("SASIUS", $permisos))
													{
													?>
													<li>\n\
														<a class='dropdown-item edit-item-btn d-flex justify-content-start align-items-center' style='cursor: pointer;' data-bs-toggle='modal' data-bs-target='#editarSistemasUsuario' data-id='"+row.IdUsuario+"' id='editar-sistemas-usuario'>\n\
															<i class='mdi mdi-database-cog align-bottom me-2 text-muted' style='font-size: 18px;'></i> Sistemas\n\
														</a>\n\
													</li>\n\
													<?php
													}
													
													if (in_array("PASUSU", $permisos))
													{
													?>
													<li>\n\
														<a class='dropdown-item edit-item-btn cambiar-password-usuario d-flex justify-content-start align-items-center' style='cursor: pointer;' data-id='"+row.IdUsuario+"' data-usuario='"+row.nombre_usuario+"'>\n\
															<i class='mdi mdi-lock-reset align-bottom me-2 text-muted' style='font-size: 18px;'></i> Restablecer Contraseña\n\
														</a>\n\
													</li>\n\
													<?php
													}
													
													if(in_array("SADEUS", $permisos))
													{
													?>
													<li>\n\
														<a href='<?= $baseUrl ?>/listar-delegaciones-usuario/"+row.IdUsuario+"' class='dropdown-item d-flex justify-content-start align-items-center'>\n\
															<i class='mdi mdi-domain align-bottom me-2 text-muted' style='font-size: 18px;'></i> Delegaciones Encargadas\n\
														</a>\n\
													</li>\n\
													<?php
													}
													?>
												</ul>\n\
											</div>";
									}
								},
							],

							"lengthMenu": [[10, 25, 50], [10, 25, 50]],
							responsive: true,
							autoWidth: false,
							"aaSorting": [[1, 'asc']],
						});
					}
				}

				assetListVM.init();
				/****FIN SERVERSIDE USUARIOS****/
			});
		</script>
<?php $this->endSection(); ?>
<!-- Modal Perfil Usuario -->
<div class="modal fade" id="editarPerfilUsuario" tabindex="-1" role="dialog" aria-labelledby="exampleEditarPerfilUsuario" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleEditarPerfilUsuario">Editar Usuario</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formEditarPerfilUsuario" class="formulario" autocomplete="off" action="" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
                            <div>
                                <label for="txtPerfilUsuario" class="form-label">Perfil*</label>
								<select class="form-select" aria-label="Perfil" id="txtPerfilUsuario" name="txtPerfilUsuario">
									<option selected="" value="">Seleccione una opción</option>
								</select>
                            </div>
                        </div>
						<span style="color: red;">* Si procede a realizar el cambio, todos los permisos y rutas personalizadas serán eliminadas y se asignarán los permisos y rutas por defecto del perfil.</span>
						<!--<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtPassword" class="form-label">Contraseña</label>
                            <div class="input-group">
                                <input type="text" class="form-control" aria-label="Password" id="txtPassword" name="txtPassword">
                            </div>
                        </div>-->
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" id="btnEjecutarOperador" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Actualizar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<!-- end main content-->

<!-- Modal Sistemas Usuario -->
<div class="modal fade" id="editarSistemasUsuario" tabindex="-1" role="dialog" aria-labelledby="exampleEditarSistemasUsuario" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleEditarSistemasUsuario">Editar Sistemas</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formEditarSistemasUsuario" class="formulario" autocomplete="off" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body d-flex justify-content-center">
					<input type="hidden" id="txtIDUsuario" name="txtIDUsuario">
					<div class="card text-dark col-7 bg-info" style="border: 1px solid #299CDB;">
						<div class="card-header" style="background-color: transparent; color: #FFF;">Sistemas</div>
						<div class="card-body" style="background-color: #FFF;" id="ctnSistemasUsuario">
							
					
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<!-- end main content-->
<!-- Modal Sistemas Usuario -->
<div class="modal fade" id="informacionUsuario" tabindex="-1" role="dialog" aria-labelledby="exampleinformacionUsuario" aria-hidden="true">
	<div class="modal-dialog modal-xl modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleinformacionUsuario">Información de usuario</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formInformacionUsuario" class="formulario" autocomplete="off" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body row d-flex m-0">
					<input type="hidden" id="txtIDUsuario_i" name="txtIDUsuario_i">
					<div class="row col-12 m-0 p-0 mb-3 d-flex">
					    <div class="col-xxl-4 col-md-12 col-12 px-3">
							<label for="txtMatriculaUsuario_i" class="form-label">Matrícula</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Matrícula" id="txtMatriculaUsuario_i" name="txtMatriculaUsuario_i">
							</div>
						</div>
					    <div class="col-xxl-4 col-md-12 col-12 px-3">
							<label for="txtNombresUsuario_i" class="form-label">Nombres</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Nombres" id="txtNombresUsuario_i" name="txtNombresUsuario_i">
							</div>
						</div>
					    <div class="col-xxl-4 col-md-12 col-12 px-3">
							<label for="txtApellidosUsuario_i" class="form-label">Apellidos</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Apellidos" id="txtApellidosUsuario_i" name="txtApellidosUsuario_i">
							</div>
						</div>
					</div>
					<div class="row col-12 m-0 p-0 mb-3 d-flex">
					    <div class="col-xxl-4 col-md-12 col-12 px-3">
							<div>
								<label for="txtTipoDocumentoUsuario_i" class="form-label">Tipo Documento</label>
								<select class="form-select" aria-label="Tipo de Documento" id="txtTipoDocumentoUsuario_i" name="txtTipoDocumentoUsuario_i">
								    <option value="">Seleccione Tipo Documento</option>
									<option value="DNI">DNI</option>
									<option value="CE">CE</option>
								</select>
							</div>
						</div>
					    <div class="col-xxl-4 col-md-12 col-12 px-3">
							<label for="txtDocumentoUsuario_i" class="form-label">Documento</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Documento" id="txtDocumentoUsuario_i" name="txtDocumentoUsuario_i">
							</div>
						</div>
					    <div class="col-xxl-4 col-md-12 col-12 px-3">
							<div>
								<label for="txtCargoUsuario_i" class="form-label">Cargo</label>
								<select class="form-select" aria-label="Cargo" id="txtCargoUsuario_i" name="txtCargoUsuario_i">
									<option value="">Seleccione una opción</option>
									
								</select>
							</div>
						</div>
					</div>
					<div class="row col-12 m-0 p-0 mb-3 d-flex">
					    <div class="col-xxl-4 col-md-12 col-12 px-3">
							<div>
								<label for="txtManagerUsuario_i" class="form-label">Jefe Directo</label>
								<select class="form-select" aria-label="Jefe Directo" id="txtManagerUsuario_i" name="txtManagerUsuario_i">
									<option value="">Seleccione una opción</option>
									
								</select>
							</div>
						</div>
					    <div class="col-xxl-4 col-md-12 col-12 px-3">
							<label for="txtFechaIngresoUsuario_i" class="form-label">Fecha Ingreso</label>
							<div class="input-group">
								<input type="date" class="form-control" aria-label="Fecha de Ingreso" id="txtFechaIngresoUsuario_i" name="txtFechaIngresoUsuario_i">
							</div>
						</div>
					    <div class="col-xxl-4 col-md-12 col-12 px-3">
							<label for="txtFTEUsuario_i" class="form-label">FTE</label>
							<div class="input-group">
								<input type="number" step="0.01" class="form-control" aria-label="FTE" id="txtFTEUsuario_i" name="txtFTEUsuario_i">
							</div>
						</div>
					</div>
					<div class="row col-12 m-0 p-0 mb-3 d-flex">
					    <div class="col-xxl-4 col-md-12 col-12 px-3">
							<div>
								<label for="txtDireccionEstrucUsuario_i" class="form-label">Dirección</label>
								<select class="form-select" aria-label="Dirección" id="txtDireccionEstrucUsuario_i" name="txtDireccionEstrucUsuario_i">
									<option value="">Seleccione una opción</option>
									
								</select>
							</div>
						</div>
					    <div class="col-xxl-4 col-md-12 col-12 px-3">
							<div>
								<label for="txtAreaEstrucUsuario_i" class="form-label">Área</label>
								<select class="form-select" aria-label="Área" id="txtAreaEstrucUsuario_i" name="txtAreaEstrucUsuario_i">
									<option value="">Seleccione una opción</option>
									
								</select>
							</div>
						</div>
					    <div class="col-xxl-4 col-md-12 col-12 px-3">
							<div>
								<label for="txtSubareaEstrucUsuario_i" class="form-label">Subárea</label>
								<select class="form-select" aria-label="Subárea" id="txtSubareaEstrucUsuario_i" name="txtSubareaEstrucUsuario_i">
									<option value="">Seleccione una opción</option>
									
								</select>
							</div>
						</div>
					</div>
					<div class="row col-12 m-0 p-0 mb-3 d-flex">
					    <div class="col-xxl-4 col-md-12 col-12 px-3">
							<div>
								<label for="txtDelegacionSubareaEstrucUsuario_i" class="form-label">CC - LN | Delegacion</label>
								<select class="form-select" aria-label="CC-LN" id="txtDelegacionSubareaEstrucUsuario_i" name="txtDelegacionSubareaEstrucUsuario_i">
									<option value="">Seleccione una opción</option>
									
								</select>
							</div>
						</div>
					    <div class="col-xxl-4 col-md-12 col-12 px-3">
							<label for="txtCorreoUsuario_i" class="form-label">Correo Corporativo</label>
							<div class="input-group">
								<input type="email" class="form-control" aria-label="Correo Corporativo" id="txtCorreoUsuario_i" name="txtCorreoUsuario_i">
							</div>
						</div>
					    <div class="col-xxl-4 col-md-12 col-12 px-3">
							<label for="txtUsuarioIngreso_i" class="form-label">Usuario</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Usuario de Ingreso" id="txtUsuarioIngreso_i" name="txtUsuarioIngreso_i">
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" id="btnEjecutarUsuario" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<!-- end main content-->
<!-- Modal Importar Usuarios -->
<div class="modal fade bd-example-modal-lg" id="importarCSVUsuario" tabindex="-1" role="dialog" aria-labelledby="exampleimportarCSVUsuario" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleimportarCSVUsuario">Importar CSV de Usuarios</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formulario" id="formImportarCSVUsuario" autocomplete="off" action="<?= $baseUrl ?>/importar-csv-usuario" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="row modal-body">
					<div class="col-12 mb-3">
						<h4>Consideraciones:</h4>
						<p>1.- Las fechas deben contar con el formato "YYYY-MM-DD".</p>
						<p>2.- Evitar espacios en blanco al inicio y al final del campo</p>
						<p>3.- Información de columna [TIPO DE DOCUMENTO]: [DNI, CE]</p>
						<p>4.- Si tiene fecha cese, se va a cambiar el estado del usuario a "Cesado".</p>
					</div>
					<div class="col-6 mb-3 d-flex justify-content-start">
					    <?php
						if(in_array("EXPUSU", $permisos))
						{
						?>
						<label class="btn btn-warning m-0 float-left" onclick="return descargarTotalUsuarios();">Descargar Base Usuarios</label>
						<?php
						}
						?>
					</div>
					<div class="col-6 mb-3 d-flex justify-content-end">
						
							<a class='btn btn-info border-0 texto-indicador' style="color: #FFF" href='<?= base_url().'/public/docs/Plantillas/plantilla csv usuarios.csv' ?>' download='Plantilla CSV Usuarios'>Descargar Plantilla</a>
						
					</div>
					<div class="mb-3">
						<label for="fileCSVUsuario" class="form-label">Seleccione CSV:</label>
						<input class="form-control" type="file" id="fileCSVUsuario" name="fileCSVUsuario">
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" class="btn btn-success"><i class="mdi mdi-content-save"></i> Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<!-- Modal Importar Usuarios IT-->
<div class="modal fade bd-example-modal-lg" id="importarCSVUsuarioIT" tabindex="-1" role="dialog" aria-labelledby="exampleimportarCSVUsuarioIT" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleimportarCSVUsuarioIT">Actualizar Correo y Usuario - Soporte IT</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formulario" id="formImportarCSVUsuarioIT" autocomplete="off" action="<?= $baseUrl ?>/importar-csv-usuario-it" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="row modal-body">
					<div class="col-12 mb-3">
						<h4>Consideraciones:</h4>
						<p>1.- El campo MATRÍCULA es obligatorio.</p>
						<p>2.- El campo USUARIO es obligatorio.</p>
						<p>3.- El correo se genera automáticamente de la siguiente forma: {campo USUARIO}@verisure.pe</p>
					</div>
					<div class="col-6 mb-3 d-flex justify-content-start">
					    <?php
						if(in_array("EXPUSU", $permisos))
						{
						?>
						<label class="btn btn-warning m-0 float-left" onclick="return descargarUsuariosSinCorreo();">Descargar Base Usuarios</label>
						<?php
						}
						?>
					</div>
					<div class="col-6 mb-3 d-flex justify-content-end">
						
							<a class='btn btn-info border-0 texto-indicador' style="color: #FFF" href='<?= base_url().'/public/docs/Plantillas/plantilla csv usuarios it.csv' ?>' download='Plantilla CSV Usuarios IT'>Descargar Plantilla</a>
						
					</div>
					<div class="mb-3">
						<label for="fileCSVUsuarioIT" class="form-label">Seleccione CSV:</label>
						<input class="form-control" type="file" id="fileCSVUsuarioIT" name="fileCSVUsuarioIT">
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" class="btn btn-success"><i class="mdi mdi-content-save"></i> Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<!-- Modal Importar Usuarios IT-->
<div class="modal fade bd-example-modal-lg" id="importarCSVUsuarioFlota" tabindex="-1" role="dialog" aria-labelledby="exampleimportarCSVUsuarioFlota" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleimportarCSVUsuarioFlota">Actualizar Placa y Brevete - Flota</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formulario" id="formImportarCSVUsuarioFlota" autocomplete="off" action="<?= $baseUrl ?>/importar-csv-usuario-flota" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
					<div class="col-12 mb-3">
						<h4>Consideraciones:</h4>
						<p>1.- El campo BREVETE es obligatorio.</p>
						<p>2.- El campo PLACA es obligatorio, sin guión.</p>
					</div>
					<div class="col-12 mb-3 d-flex justify-content-end">
						
							<a class='btn btn-info border-0 texto-indicador' style="color: #FFF" href='<?= base_url().'/public/docs/Plantillas/plantilla csv usuarios flota.csv' ?>' download='Plantilla CSV Usuarios Flota'>Descargar Plantilla</a>
						
					</div>
					<div class="mb-3">
						<label for="fileCSVUsuarioFlota" class="form-label">Seleccione CSV:</label>
						<input class="form-control" type="file" id="fileCSVUsuarioFlota" name="fileCSVUsuarioFlota">
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" class="btn btn-success"><i class="mdi mdi-content-save"></i> Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>