// import * as FilePond from 'filepond';
// import 'filepond/dist/filepond.css';

toastr.options = {
    "positionClass": "toast-bottom-center",
    "newestOnTop": true,
    "preventDuplicates": true
}

$(function () {
    
    // $('.validarNumerosEnteros').on('keyup', function() {
    //     var valor = $(this).val();
        
    //     // Remover cualquier carácter que no sea dígito
    //     valor = valor.replace(/\D/g, '');
    
    //     // Verificar si el valor resultante es un número entero válido
    //     if (/^\d*$/.test(valor)) {
    //         // Es un número entero válido, actualizar el valor del input
    //         $(this).val(valor);
    //     }
    // });

    // $('.validarNumerosDecimales').on('keyup', function(evt) {
    //     var inputValue = $(this).val().trim();

    //     // Limpiar el valor para permitir solo números y un punto decimal
    //     inputValue = inputValue.replace(/[^0-9.]/g, ''); // Remueve todo lo que no sea número o punto
    //     console.log("\n1: "+inputValue);
    //     var decimalIndex = inputValue.indexOf('.');
    //     // Limitar a máximo 4 decimales
    //     if (decimalIndex !== -1 && inputValue.substring(decimalIndex + 1).length > 4) {
    //         inputValue = inputValue.substring(0, decimalIndex + 5);
    //     console.log("\n2: "+inputValue);
    //     }
    //     console.log("\n3: "+inputValue);

    //     // Actualizar el valor del input
    //     $(this).val(inputValue);
    // });

    $('[data-tooltip="tooltip"]').tooltip();
    
    $("#txtPerfilUsuario").select2({
        minimumInputLength: 2,
        placeholder: 'Seleccione Perfil',
        dropdownParent: $('#editarPerfilUsuario .modal-body'),
        allowClear: true,
        language: {
            errorLoading: function() {
                return "La carga falló";
            },
            noResults: function() {
                return "No hay resultado";
            },
            searching: function() {
                return "Buscando..";
            }
        },
        ajax: {
            url: baseUrl + '/listado-perfil-select',
            dataType: 'json',
            type: "POST",
            quietMillis: 50,
            data: function (term) {
                return {
                    term: term
                };
            },
            processResults: function (data) {
                return {
                    results: data
                };
            }
        }
    });
    
});

function validarNumerosDecimales(evt, input) {
    // Backspace = 8, Enter = 13, ‘0′ = 48, ‘9′ = 57, ‘.’ = 46, ‘-’ = 43
    var key = window.Event ? evt.which : evt.keyCode;
    var chark = String.fromCharCode(key);
    var tempValue = input.value + chark;
    if (key >= 48 && key <= 57) {
        if (formatoDecimal(tempValue) === false) {
            return false;
        } else {
            return true;
        }
    } else {
        if (key == 8 || key == 13 || key == 0) {
            return true;
        } else if (key == 46) {
            if (formatoDecimal(tempValue) === false) {
                return false;
            } else {
                return true;
            }
        } else {
            return false;
        }
    }
}
function validarNumerosEnteros(evt, input) {
    // Backspace = 8, Enter = 13, ‘0′ = 48, ‘9′ = 57, ‘.’ = 46, ‘-’ = 43
    var key = window.Event ? evt.which : evt.keyCode;
    var chark = String.fromCharCode(key);
    var tempValue = input.value + chark;
    if (key >= 48 && key <= 57) {
        return true;
    } else {
        return false;
    }
}
function formatoDecimal(numero) {
    var preg = /^([0-9]+\.?[0-9]{0,4})$/;
    
    if (preg.test(numero) === true) {
        return true;
    } else {
        return false;
    }
}
    // $(document).on('click', '.select2-selection__clear', function(event) {
    //     event.stopPropagation(); // Prevenir que el clic se propague hacia arriba
    // });
    
var arrValoresRandom = [];

function generarRandom(num) {
    const characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    const charactersLength = characters.length;
    let result = "";
    for (let i = 0; i < num; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }
    
    if(arrValoresRandom.includes(result))
    {
        generarRandom(num);
    }
    else
    {
        arrValoresRandom.push(result);
        return result;    
    }
}

function agregarAdjunto(contenedorElementos)
{
    var random = generarRandom(5);
    
    // let contenedor = `<div id='divImg${contador}' class="col-md-6 col-12"><div id='ImgInstalacion${contador}' class="img-instalacion bg-2" style="background-image: url('');">
    //     <input id='txtImagen${contador}' type='file' name='txtImagen${contador}' accept='image/*' ${capture} onchange='mostrarVistaPreviaImg(${contador})' style='display: none;' />
    //     <div class="cont-resultado-aprobacion">
    //         <label ${action}><i class="fa fa-image" aria-hidden="true"></i> Cambiar imagen</label>
    //     </div>
    // </div></div>`;
    
    let contenedor = `<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px" id="adj${random}" style="border-radius: 10px;">
		<div class="col-xxl-5 col-md-12 col-12 mb-2">
			<div>
				<label for="txtNombreAdjunto_i${random}" class="form-label">Nombre Adjunto:</label>
				<input type="text" class="form-control" id="txtNombreAdjunto_i${random}" name="nombreAdjunto[${random}]">
			</div>
		</div>
		<div class="col-xxl-5 col-md-10 col-10 ">
		    <div>
				<label for="fileAdjunto_i${random}" class="form-label">Seleccione Adjunto:</label>
				<input class="form-control" type="file" id="fileAdjunto_i${random}" name="fileAdjunto[${random}]">
			</div>
		</div>
		<div class="col-xxl-2 col-md-2 col-2 d-flex justify-content-end align-items-center">
			<button type="button" class="btn bg-danger px-2 py-1" onclick="return quitarAdjunto('adj${random}');" data-tooltip="tooltip" aria-label="Eliminar Adjunto">
                <i class="mdi mdi-trash-can" style="font-size: 24px; color: #FFF"></i>
            </button>
		</div>
	</div>`;

    $("#"+contenedorElementos).append(contenedor);
}

function quitarAdjunto(contenedorEliminar)
{
    $('#'+contenedorEliminar).remove();
    return false;
}

function eliminarBloqueDinamico(contenedorEliminar)
{
    $('#'+contenedorEliminar).remove();
    return false;
}

function clickOne(flag){
    
    $("button[type=submit]").prop('disabled',flag);

}

function downloadPDF(idDiv)
{
    var divToPrint = document.getElementById(idDiv);
    var print = 'onload="window.print()"';
    var newWin = window.open('', 'Print-Window');
    newWin.document.open();
    newWin.document.write('<html><head><meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1"><title>Descargar Documento</title><meta name="viewport" content="width=device-width, initial-scale=1">\n\
                                <meta http-equiv="cache-control" content="no-cache" />\n\
                                <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css">\n\
                                <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css">\n\
                                <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">\n\
                                <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet">\n\
                                <link href="'+baseUrl+'/public/css/bootstrap.min.css" rel="stylesheet" type="text/css">\n\
                                <link href="'+baseUrl+'/public/libs/bootstrap-switch/css/bootstrap3/bootstrap-switch.min.css" rel="stylesheet" type="text/css">\n\
                                <link href="'+baseUrl+'/public/css/icons.min.css" rel="stylesheet" type="text/css">\n\
                                <link href="'+baseUrl+'/public/css/app.min.css" rel="stylesheet" type="text/css">\n\
                                <link href="'+baseUrl+'/public/css/custom.min.css" rel="stylesheet" type="text/css">\n\
                                <link rel="stylesheet" href="'+baseUrl+'/public/js/pages/plugins/toastr/toastr.min.css">\n\
                                <link rel="stylesheet" href="'+baseUrl+'/public/js/pages/plugins/sweetalert2-theme-bootstrap-4/bootstrap-4.min.css">\n\
                            </head>\n\
                            <body '+ print +' class="'+baseUrl+'">\n\
                                ' + divToPrint.innerHTML + '\n\
                                <script>$(document).ready(function () {$(".table").dataTable().fnDestroy(); $(".table").DataTable({"language": {"url": "//cdn.datatables.net/plug-ins/1.10.15/i18n/Spanish.json"}, responsive: true, stateSave: true});});</script>\n\
                            </body>\n\
                          </html>');
    newWin.document.close();
}

/* ------------------------------- */

function selectDireccionEstructura(elemento, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/listado-direccion-estructura', 
    {
    }, 
    function(response) {
        if (response.descripcion === 0) {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } else {
            var direcciones = $.parseJSON(response.listadoDirecciones);
            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            for(var i = 0; i < direcciones.length; i++){
                $("#"+elemento).append('\
                    <option value="' + direcciones[i].id + '" '+(idSeleccionado == direcciones[i].id ? 'selected' : '')+'>' + direcciones[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
    
}

/* ------------------------------- */

function selectResponsablesDireccion(elemento, idDireccion, idSeleccionado, nombreSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/listado-responsables-direccion-estructura', 
    {
        idDireccion : idDireccion
    }, 
    function(response) {
        if (response.descripcion === 0) {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } else {
            var responsables = $.parseJSON(response.listadoResponsables);
            $("#"+elemento).append('\
                    <option value="" '+(idSeleccionado == "" ? 'selected' : '' )+'>Seleccione una opción</td>\n\
                ');
            for(var i = 0; i < responsables.length; i++){
                $("#"+elemento).append('\
                    <option value="' + responsables[i].id + '" '+(idSeleccionado == responsables[i].id ? 'selected' : '' )+'>' + responsables[i].text +'</td>\n\
                ');
            }
            
            const ids = responsables.map(item => item.id);
            
            if(!ids.includes(idSeleccionado) && idSeleccionado != '')
            {
                $("#"+elemento).append('\
                    <option value="' + idSeleccionado + '" selected>' + nombreSeleccionado +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
}

/* ------------------------------- */

function selectAreaEstructura(elemento, idDireccion, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/listado-area-estructura', 
    {
        idDireccion : idDireccion
    }, 
    function(response) {
        if (response.descripcion === 0) {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } else {
            var areas = $.parseJSON(response.listadoAreas);
            $("#"+elemento).append('\
                    <option value="">Seleccione una opción</td>\n\
                ');
            for(var i = 0; i < areas.length; i++){
                $("#"+elemento).append('\
                    <option value="' + areas[i].id + '" '+(idSeleccionado == areas[i].id ? 'selected' : '' )+'>' + areas[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
    
}

/* ------------------------------- */

function selectResponsablesArea(elemento, idArea, idSeleccionado, nombreSeleccionado, modal)
{
    $('#'+elemento).empty();
    
    $.post(baseUrl + '/listado-responsables-area-estructura', 
    {
        idArea : idArea
    }, 
    function(response) {
        if (response.descripcion === 0) {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } else {
            var responsables = $.parseJSON(response.listadoResponsables);
            $("#"+elemento).append('\
                    <option value="" '+(idSeleccionado == "" ? 'selected' : '' )+'>Seleccione una opción</td>\n\
                ');
            for(var i = 0; i < responsables.length; i++){
                $("#"+elemento).append('\
                    <option value="' + responsables[i].id + '" '+(idSeleccionado == responsables[i].id ? 'selected' : '' )+'>' + responsables[i].text +'</td>\n\
                ');
            }
            
            const ids = responsables.map(item => item.id);
            
            if(!ids.includes(idSeleccionado) && idSeleccionado != '')
            {
                $("#"+elemento).append('\
                    <option value="' + idSeleccionado + '" selected>' + nombreSeleccionado +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
}

/* ------------------------------- */

function selectSubareaEstructura(elemento, idArea, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/listado-subarea-estructura', 
    {
        idArea : idArea
    }, 
    function(response) {
        if (response.descripcion === 0) {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } else {
            var subareas = $.parseJSON(response.listadoSubareas);
            $("#"+elemento).append('\
                    <option value="">Seleccione una opción</td>\n\
                ');
            for(var i = 0; i < subareas.length; i++){
                $("#"+elemento).append('\
                    <option value="' + subareas[i].id + '" '+(idSeleccionado == subareas[i].id ? 'selected' : '' )+'>' + subareas[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
    
}

/* ------------------------------- */

function selectResponsablesSubarea(elemento, idSubarea, idSeleccionado, nombreSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/listado-responsables-subarea-estructura', 
    {
        idSubarea : idSubarea
    }, 
    function(response) {
        if (response.descripcion === 0) {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } else {
            var responsables = $.parseJSON(response.listadoResponsables);
            $("#"+elemento).append('\
                    <option value="" '+(idSeleccionado == "" ? 'selected' : '' )+'>Seleccione una opción</td>\n\
                ');
            for(var i = 0; i < responsables.length; i++){
                $("#"+elemento).append('\
                    <option value="' + responsables[i].id + '" '+(idSeleccionado == responsables[i].id ? 'selected' : '' )+'>' + responsables[i].text +'</td>\n\
                ');
            }
            
            const ids = responsables.map(item => item.id);
            
            if(!ids.includes(idSeleccionado) && idSeleccionado != '')
            {
                $("#"+elemento).append('\
                    <option value="' + idSeleccionado + '" selected>' + nombreSeleccionado +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
}

/* ------------------------------- */

function selectDelegacionesEstructura(elemento, idSubarea, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/listado-delegacion-estructura', 
    {
        idSubarea : idSubarea
    }, 
    function(response) {
        if (response.descripcion === 0) {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } else {
            var delegaciones = $.parseJSON(response.listadoDelegaciones);
            $("#"+elemento).append('\
                    <option value="">Seleccione una opción</td>\n\
                ');
            for(var i = 0; i < delegaciones.length; i++){
                $("#"+elemento).append('\
                    <option value="' + delegaciones[i].id + '" data-cc="' + delegaciones[i].cc + '" data-ln="' + delegaciones[i].ln + '" '+(idSeleccionado == delegaciones[i].id ? 'selected' : '' )+'>' + delegaciones[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
    
}

function selectEstructuraDelegacion(elemento, idDelegacion, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    
    $.post(baseUrl + '/listado-estructura-delegacion', 
    {         
        idDelegacion : idDelegacion
    }, 
    function(response) {
        if (response.descripcion === 0) {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } else {
            
            var global = $.parseJSON(response.listadoGlobal);
            
            $("#"+elemento).append('\
                <option value="" selected>Seleccione una opción</td>\n\
            ');
            
            if(global.length > 0)
            {
                // var selected = global.length == 1 ? 'selected' : '';
                
                for(var i = 0; i < global.length; i++){
                    
                    var selected = (idSeleccionado != '' && idSeleccionado == global[i].id ? 'selected' : '');
                    
                    $("#"+elemento).append('\
                        <option value="' + global[i].id + '" data-area="' + global[i].idarea + '" data-direccion="' + global[i].iddireccion + '" '+selected+' >' + global[i].text +'</td>\n\
                    ');
                    
                    // if( selected === "selected" && $('#cboResponsableFirma01OC_roc').length && $('#cboResponsableFirma02OC_roc').length && $('#cboResponsableFirma03OC_roc').length)
                    // {
                    //     selectResponsablesSubarea("cboResponsableFirma01OC_roc", global[i].id, "", "", modal);
                    //     selectResponsablesArea("cboResponsableFirma02OC_roc", global[i].idarea, "", "", modal);
                    //     selectResponsablesDireccion("cboResponsableFirma03OC_roc", global[i].iddireccion, "", "", modal);
                    // }
                }
            }
            
        }
    }, 'json'); 
    
    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
    
}
/* ------------------------------- */

function selectRegionPais(elemento, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/listado-region-pais', 
    {
    }, 
    function(response) {
        if (response.descripcion === 0) {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } else {
            var pais = $.parseJSON(response.listadoPaises);
            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            for(var i = 0; i < pais.length; i++){
                $("#"+elemento).append('\
                    <option value="' + pais[i].id + '" '+(idSeleccionado == pais[i].id ? 'selected' : '')+'>' + pais[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
    
}

/* ------------------------------- */

function selectRegionDepartamentos(elemento, idPais, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/listado-region-departamentos', 
    {
        idPais : idPais
    }, 
    function(response) {
        if (response.descripcion === 0) {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } else {
            var departamentos = $.parseJSON(response.listadoDepartamentos);
            $("#"+elemento).append('\
                    <option value="">Seleccione una opción</td>\n\
                ');
            for(var i = 0; i < departamentos.length; i++){
                $("#"+elemento).append('\
                    <option value="' + departamentos[i].id + '" '+(idSeleccionado == departamentos[i].id ? 'selected' : '' )+'>' + departamentos[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
    
}

/* ------------------------------- */

function selectRegionProvincia(elemento, idDepartamento, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/listado-region-provincias', 
    {
        idDepartamento : idDepartamento
    }, 
    function(response) {
        if (response.descripcion === 0) {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } else {
            var provincias = $.parseJSON(response.listadoProvincias);
            $("#"+elemento).append('\
                    <option value="">Seleccione una opción</td>\n\
                ');
            for(var i = 0; i < provincias.length; i++){
                $("#"+elemento).append('\
                    <option value="' + provincias[i].id + '" '+(idSeleccionado == provincias[i].id ? 'selected' : '' )+'>' + provincias[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
    
}

/* ------------------------------- */

function selectRegionDistrito(elemento, idProvincia, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/listado-region-distritos', 
    {
        idProvincia : idProvincia
    }, 
    function(response) {
        if (response.descripcion === 0) {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } else {
            var distritos = $.parseJSON(response.listadoDistritos);
            $("#"+elemento).append('\
                    <option value="">Seleccione una opción</td>\n\
                ');
            for(var i = 0; i < distritos.length; i++){
                $("#"+elemento).append('\
                    <option value="' + distritos[i].id + '" '+(idSeleccionado == distritos[i].id ? 'selected' : '' )+'>' + distritos[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
    
}

/* ------------------------------- */

function selectMoneda(elemento, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/listado-monedas', 
    {
    }, 
    function(response) {
        if (response.descripcion === 0) {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } else {
            var monedas = $.parseJSON(response.listadoMonedas);
            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            for(var i = 0; i < monedas.length; i++){
                $("#"+elemento).append('\
                    <option value="' + monedas[i].id + '" data-simbolo="'+monedas[i].simbolo+'" '+(idSeleccionado == monedas[i].id ? 'selected' : '')+'>' + monedas[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
    
}

/* ------------------------------- */

function selectCabeceraModulo(elemento, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    
    $.post(baseUrl + '/obtener-cabecera', 
    {}, 
    function(response) {
        if (response.descripcion === 0) {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } 
        else {
            var cabecera = $.parseJSON(response.listadoCabecera);

            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            
            for(var i = 0; i < cabecera.length; i++){
                $("#"+elemento).append('\
                    <option value="' + cabecera[i].id + '" '+(idSeleccionado == cabecera[i].id ? 'selected' : '')+'>' + cabecera[i].cabecera +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
    
}

/* ------------------------------- */

$(document).on('submit', '.formulario', function() {
    
    var formulario = $(this);
    var metodoEnvio = formulario.attr('method');
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });

    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: new FormData(this),
        contentType: false,
        cache: false,
        processData: false,
        success: function(response) {
            //$.unblockUI({});
            Swal.close();
            formulario.find('.respuesta').html(response);
            console.log(response);
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            //$.unblockUI({});
            Swal.close();
            alert('Ha ocurrido un error interno.');
            console.log(jqXHR );
            console.log(textStatus);
            console.log(errorThrown);
        }
    });
    return false;
});

/* ------------------------------- */

$(document).on('click', '.datos-modulo', function(e) {
    $('#btnEjecutarModulo').removeClass("d-none");
    var idModulo = $(this).data('id');
    var accion = $(this).data('accion');
    if(accion == 'crear')
    {
        $('#exampleinformacionModulo').text("Registrar módulo");
        $('#formInformacionModulo').attr('action', baseUrl + '/registrar-modulo');

        $('#btnEjecutarModulo').html('<i class="mdi mdi-content-save"></i> Guardar');

        selectCabeceraModulo("txtCabecera_i", "", "informacionModulo")

        $('#txtModulo_i').removeAttr("disabled");
        $('#txtOrden_i').removeAttr("disabled");
        $('#txtIcono_i').removeAttr("disabled");
        $('#txtObservacionModulo_i').removeAttr("disabled");

        $('#txtModulo_i').val("");
        $('#txtOrden_i').val("");
        $('#txtIcono_i').val("");
        $('#txtObservacionModulo_i').val("");
        $('#txtModulo_i').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-modulo', 
        {         
            idModulo : idModulo
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionModulo').text("Información de módulo");
                    $('#btnEjecutarModulo').addClass("d-none");
                    $('#formInformacionModulo').attr('action', '');

                    $('#txtModulo_i').attr("disabled","disabled");
                    $('#txtIcono_i').attr("disabled","disabled");
                    $('#txtOrden_i').attr("disabled","disabled");
                    $('#txtObservacionModulo_i').attr("disabled","disabled");
                    $('#txtCabecera_i').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionModulo').text("Actualizar módulo");
                    $('#formInformacionModulo').attr('action', baseUrl + '/actualizar-modulo/' + idModulo);

                    $('#txtIcono_i').removeAttr("disabled");
                    $('#txtModulo_i').removeAttr("disabled");
                    $('#txtOrden_i').removeAttr("disabled");
                    $('#txtObservacionModulo_i').removeAttr("disabled");
                    $('#txtCabecera_i').removeAttr("disabled");
                }

                selectCabeceraModulo("txtCabecera_i", response.cabecera, "informacionModulo")

                $('#txtModulo_i').val(response.modulo);
                $('#txtOrden_i').val(response.orden);
                $('#txtIcono_i').val(response.icono);
                $('#txtObservacionModulo_i').val(response.observacion);
            }
        }, 'json'); 
    }
});

/* ------------------------------- */

$(document).on('click', '#btnAgregarRutasModulo', function(e) {
    var ruta = $("#txtRutaModulo").val();

    if(ruta == '')
    {
        Swal.fire({
            html: 'Debe digitar la ruta perteneciente al módulo.',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else
    {
        tableRutasModuloAgregar.row
            .add([
                ruta+"<input type='hidden' name='rutasModulo[]' value='"+ruta+"'>",
                "<button class='btn btn-danger btnDelete'><span class='mdi mdi-trash-can'></span></button>"
            ])
            .draw(false);
        
        $("#txtRutaModulo").val("");
        $("#txtRutaModulo").focus();
    }
});

// tableRutasModuloAgregar.on('click', 'button.btnDelete', function(e) {
//     e.preventDefault();
//     let $tr = $(this).closest('tr');
  
//     // Le pedimos al DataTable que borre la fila
//     tableRutasModuloAgregar.row($tr).remove().draw(false);
//   });

/* ------------------------------- */
$(document).on('keypress', '#txtCodigoAccionModulo', function(event) {
    var regex = new RegExp("^[a-zA-Z0-9]+$");
    var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
    if (!regex.test(key)) {
      event.preventDefault();
      return false;
    }
    else if(this.value.length >= 6)
    {
        event.preventDefault();
        return false;
    }
  });
/* ------------------------------- */
  $(document).on('click', '#editar-perfil-usuario', function(e) {
    var idUsuario = $(this).data('id');
    $('#formEditarPerfilUsuario').attr('action', baseUrl + '/modificar-usuario/' + idUsuario);
    $('#txtPerfilUsuario').val("");
});
/* ------------------------------- */
$(document).on('click', '.datos-ruta-modulo', function(e) {
    $('#btnEjecutarRutasModulo').removeClass("d-none");
    var idRutaModulo = $(this).data('id');
    var idModulo = $(this).data('modulo');
    var accion = $(this).data('accion');
    if(accion == 'crear')
    {
        $('#exampleinformacionRutasModulo').text("Crear Ruta");
        $('#formInformacionRutasModulo').attr('action', baseUrl + '/grabar-ruta/'+idModulo);

        $('#btnEjecutarRutasModulo').html('<i class="mdi mdi-content-save"></i> Guardar');
        $('#txtRutaModulo').removeAttr("disabled");
        $('#txtTipoRuta_i').removeAttr("disabled");
        $('#chkRutaRaiz').removeAttr("disabled");
        $('#chkRutaRaiz').removeAttr("checked", "checked");
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-ruta-modulo', 
        {         
            idRutaModulo : idRutaModulo
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionRutasModulo').text("Información de Ruta");
                    $('#btnEjecutarRutasModulo').addClass("d-none");
                    $('#formInformacionRutasModulo').attr('action', '');

                    $('#txtRutaModulo').attr("disabled","disabled");
                    $('#txtTipoRuta_i').attr("disabled","disabled");
                    $('#chkRutaRaiz').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionRutasModulo').text("Actualizar Ruta");
                    $('#formInformacionRutasModulo').attr('action', baseUrl + '/actualizar-ruta-modulo/' + idRutaModulo);

                    $('#txtRutaModulo').removeAttr("disabled");
                    $('#txtTipoRuta_i').removeAttr("disabled");
                    $('#chkRutaRaiz').removeAttr("disabled");
                }

                $('#txtIDRutaModulo_i').val(response.idruta);
                $('#txtRutaModulo').val(response.ruta);
                $('#txtTipoRuta_i').val(response.tipo);
                if(response.raiz=='Y')
                {
                    $('#chkRutaRaiz').attr("checked", "checked");
                }
                
            }
        }, 'json'); 
    }
});
/* ------------------------------- */
$(document).on('click', '.cambiar-estado-ruta-modulo', function() {
    var idRutaModulo = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' la ruta?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar'
    }).then((result) => {
        if (result.isConfirmed) {

            var parametros = {
                "idRutaModulo"  : idRutaModulo,
                "estado"        : estado
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-ruta-modulo',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
    
});
/* ------------------------------- */
$(document).on('click', '.cambiar-estado-modulo', function() {
    var idModulo = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' el módulo?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar'
    }).then((result) => {
        if (result.isConfirmed) {

            var parametros = {
                "idModulo"  : idModulo,
                "estado"        : estado
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-modulo',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
    
});
/* ------------------------------- */
$(document).on('click', '.datos-perfil', function(e) {
    $('#btnEjecutarPerfil').removeClass("d-none");
    var idPerfil = $(this).data('id');
    var accion = $(this).data('accion');
    if(accion == 'crear')
    {
        $('#exampleinformacionPerfil').text("Registrar perfil");
        $('#formInformacionPerfil').attr('action', baseUrl + '/registrar-perfil');

        $('#btnEjecutarPerfil').html('<i class="mdi mdi-content-save"></i> Guardar');

        $('#txtPerfil').removeAttr("disabled");
        $('#txtURLBasePerfil').removeAttr("disabled");
        
        $('#txtPerfil').val("");
        $('#txtURLBasePerfil').val("");
        
        $('#txtPerfil').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-perfil', 
        {         
            idPerfil : idPerfil
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionPerfil').text("Información de perfil");
                    $('#btnEjecutarPerfil').addClass("d-none");
                    $('#formInformacionPerfil').attr('action', '');

                    $('#txtPerfil').attr("disabled","disabled");
                    $('#txtURLBasePerfil').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionPerfil').text("Actualizar perfil");
                    $('#formInformacionPerfil').attr('action', baseUrl + '/actualizar-perfil/' + idPerfil);

                    $('#txtPerfil').removeAttr("disabled");
                    $('#txtURLBasePerfil').removeAttr("disabled");
                }

                $('#txtIDPerfil_i').val(response.idperfil);
                $('#txtPerfil').val(response.perfil);
                $('#txtURLBasePerfil').val(response.url);
            }
        }, 'json'); 
    }
});
/* ------------------------------- */
$(document).on('click', '.cambiar-estado-perfil', function() {
    var idPerfil = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' el perfil?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar'
    }).then((result) => {
        if (result.isConfirmed) {

            var parametros = {
                "idPerfil"  : idPerfil,
                "estado"        : estado
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-perfil',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
    
});
/* ------------------------------- */


