<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $elementoSeleccionadoModulo ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $subtitulo ?></h5>
                            <div class="d-flex">
								<?php
								if (in_array("ADUAPR", $permisos)) 
								{
								?>
                                <button class="btn bg-warning d-flex align-items-center mx-1 color-white" data-bs-toggle="collapse" data-bs-target="#collapseAsociarExternoProveedor" aria-expanded="false" aria-controls="collapseAsociarExternoProveedor" data-proveedor="<?= $proveedor['IDProveedor'] ?>" id="asociar-usuario-acceso-proveedor">
									<i class="mdi mdi-account-star me-1" style="font-size: 14px; color: #FFF"></i> Asociar 
								</button>
								<?php
								}
								
								if (in_array("ADUAPR", $permisos)) 
								{
								?>
                                <button class="btn bg-success d-flex align-items-center mx-1 color-white" data-bs-toggle="modal" data-bs-target="#agregarUsuarioAccesoProveedor" data-id="0" data-proveedor="<?= $proveedor['IDProveedor'] ?>" data-accion="crear" id="crear-usuario-acceso-proveedor">
									<i class="mdi mdi-plus-circle me-1" style="font-size: 14px; color: #FFF"></i> Nuevo 
								</button>
								<?php
								}
								?>
								<a href="<?= $baseUrl.'/'.$previo ?>" class="btn px-2 py-0 d-flex justify-content-end align-items-center mx-1" style="background-color: red;">
								    <i class="mdi mdi-arrow-left-circle me-1" style="font-size: 24px; color: #FFF"></i>
								</a>
                            </div>
                        </div>
						<div class="card-body">
						    <div class="row col-12 m-0 mb-3 p-3 bg-sistema-25 collapse" id="collapseAsociarExternoProveedor" style="border-radius: 20px;">
						        <h3 class="mb-3">Asociar usuario a proveedor</h3>
                                <div class="col-xxl-9 col-md-12 col-12 mb-3">
                                    <div>
                                        <label for="cboUsuariosExternos" class="form-label">Usuario:</label>
                                        <select class="form-select" aria-label="Usuario" id="cboUsuariosExternos" name="cboUsuariosExternos">
                                            <option selected="" value="">Seleccione una opción</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-xxl-3 col-md-12 col-12 mb-3 d-flex flex-row-reverse align-items-center">
                                    <div>
                                        <button type="button" class="btn bg-info color-white" id="btnAgregarExternoProveedor" data-proveedor="<?= $proveedor['IDProveedor'] ?>">
                                        <i class="mdi mdi-plus-circle color-white me-1" style="font-size: 14px;"></i> Agregar
                                    </button>
                                    </div>
                                </div>
                            </div>
							<table id="tblUsuariosAccesoProveedor" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								<thead>
									<tr>
										<th class="text-center align-middle">Código</th>
										<th class="text-center align-middle">Nombres</th>
										<th class="text-center align-middle">Apellidos</th>
										<th class="text-center align-middle">NroDocumento</th>
										<th class="text-center align-middle">NroContacto</th>
										<th class="text-center align-middle">Email</th>
										<th class="text-center align-middle">Cargo</th>
										<th class="text-center align-middle">Estado Usuario</th>
										<th class="text-center align-middle">Acciones</th>
									</tr>
								</thead>
								<tbody>
									<?php 
									foreach($listadoUsuarios as $items){ ?>
									<tr>
										<td class="text-center align-middle"><?= $items['IDExterno'] ?></td>
										<td class="text-center align-middle"><?= $items['Nombres'] ?></td>
										<td class="text-center align-middle"><?= $items['Apellidos'] ?></td>
										<td class="text-center align-middle"><?= $items['NroDocumento'] ?></td>
										<td class="text-center align-middle"><?= $items['NroContacto'] ?></td>
										<td class="text-center align-middle"><?= $items['CorreoElectronico'] ?></td>
										<td class="text-center align-middle"><?= $items['Cargo'] ?></td>
										<td class="text-center align-middle">
										    <span class="badge <?= $items['Estado'] == "A" ? 'bg-success' : 'bg-danger' ?> border-0" ><?= $items['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO' ?></span>
										</td>
										<td class="text-center align-middle">
											<button class="badge bg-danger border-0 p-2 eliminar-externo-proveedor" data-externo="<?= $items['IDExterno'] ?>" data-proveedor="<?= $items['IDProveedor'] ?>">
												<i class="mdi mdi-trash-can-outline align-bottom" style="font-size: 20px; color: #FFF;"></i>
											</button>
										</td>
									</tr>
									<?php } ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->
<!-- Modal Información Tipologia -->
<div class="modal fade zoomIn" id="agregarUsuarioAccesoProveedor" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleagregarUsuarioAccesoProveedor" aria-hidden="true">
	<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleagregarUsuarioAccesoProveedor">Agregar Usuario Externo</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formAgregarUsuarioExternoProveedor" class="formulario" autocomplete="off" action="<?= $baseUrl ?>/registrar-externo-proveedor" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" id="txtIDProveedor" name="txtIDProveedor" value="<?= $proveedor['IDProveedor'] ?>">
					<div class="row col-12 m-0 p-0 mb-3 d-flex">
					    <div class="col-xxl-6 col-md-12 col-12 px-3">
							<label for="txtNombresExterno" class="form-label">Nombres</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Nombres" id="txtNombresExterno" name="txtNombresExterno">
							</div>
						</div>
					    <div class="col-xxl-6 col-md-12 col-12 px-3">
							<label for="txtApellidosExterno" class="form-label">Apellidos</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Apellidos" id="txtApellidosExterno" name="txtApellidosExterno">
							</div>
						</div>
					</div>
					<div class="row col-12 m-0 p-0 mb-3 d-flex">
					    <div class="col-xxl-6 col-md-12 col-12 px-3">
							<label for="txtNroDocumentoExterno" class="form-label">Nro Documento</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Documento" id="txtNroDocumentoExterno" name="txtNroDocumentoExterno">
							</div>
						</div>
					    <div class="col-xxl-6 col-md-12 col-12 px-3">
							<label for="txtNroContactoExterno" class="form-label">Nro Contacto</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Nro Contacto" id="txtNroContactoExterno" name="txtNroContactoExterno">
							</div>
						</div>
					</div>
					<div class="row col-12 m-0 p-0 mb-3 d-flex">
					    <div class="col-xxl-12 col-md-12 col-12 px-3">
							<label for="txtCorreoElectronicoExterno" class="form-label">Correo Electrónico</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Correo Electrónico" id="txtCorreoElectronicoExterno" name="txtCorreoElectronicoExterno">
							</div>
						</div>
					</div>
					<div class="row col-12 m-0 p-0 mb-0 d-flex">
						<div class="col-xxl-12 col-md-12 col-12 px-3">
							<label for="txtCargoExterno" class="form-label">Cargo</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Cargo" id="txtCargoExterno" name="txtCargoExterno">
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick me-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" class="btn bg-success color-white"><i class="mdi mdi-content-save me-1" style="font-size: 14px;"></i>Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>