<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- Main content -->

<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
		<!-- start page title -->
    		<div class="row">
    			<div class="col-12">
    				<div class="page-title-box d-sm-flex align-items-center justify-content-between">
    					<h4 class="mb-sm-0"><?= $breadcrumb_alias ?></h4>
    
    					<div class="page-title-right">
    						<ol class="breadcrumb m-0">
    							<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
    							<li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
    						</ol>
    					</div>
    
    				</div>
    			</div>
    		</div>
    		<!-- end page title -->
    		<div class="row">
    		    <div class="col-12">
                    <div class="card">
                        <div class="card-header bg-red-verisure">
                            <div class="d-flex align-items-center">
                                <div class="flex-grow-1">
                                    <h6 class="card-title mb-0 color-white">Estadísticas</h6>
                                </div>
                                <div class="flex-shrink-0 bg-white">
                                    <ul class="list-inline card-toolbar-menu d-flex align-items-center mb-0">
                                        <li class="list-inline-item">
                                            <a class="align-middle minimize-card" data-bs-toggle="collapse" href="#collapseexample1" role="button" aria-expanded="false" aria-controls="collapseExample2">
                                                <i class="mdi mdi-plus align-middle plus"></i>
                                                <i class="mdi mdi-minus align-middle minus"></i>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="card-body row collapse show" id="collapseexample1">
                            <div class="col-6 col-md-2 col-lg-2">
                                <center>
                                    <div id="demo-pie-1" class="pie-title-center"><span class="pie-value"></span> </div>
                                </center>
                                <div>
                                    <center>
                                        <h5>
                                            Pdte. Firma1: <label class="label-ico offer-radius" id="label-pie-1"> </label>
                                        </h5>
                                    </center>
                                </div>
                            </div>
                            <div class="col-6 col-md-2 col-lg-2">
                                <center>
                                    <div id="demo-pie-2" class="pie-title-center" data-percent=""> <span class="pie-value"></span> </div>
                                    <br>
                                </center>
                                <div>
                                    <center>
                                        <h5>
                                            Pdte. Firma2: <label class="label-ico offer-radius" id="label-pie-2"> </label>
                                        </h5>
                                    </center>
                                </div>
                            </div>
                            <div class="col-6 col-md-2 col-lg-2">
                                <center>
                                    <div id="demo-pie-6" class="pie-title-center" data-percent=""> <span class="pie-value"></span> </div>
                                    <br>
                                </center>
                                <div>
                                    <center>
                                        <h5>
                                            Pdte. Firma3: <label class="label-ico offer-radius" id="label-pie-6"></label>
                                        </h5>
                                    </center>
                                </div>
                            </div>
                            <div class="col-6 col-md-2 col-lg-2">
                                <center>
                                    <div id="demo-pie-3" class="pie-title-center" data-percent=""> <span class="pie-value"></span> </div>
                                    <br>
                                </center>
                                <div>
                                    <center>
                                        <h5>
                                            Aprobado: <label class="label-ico offer-radius" id="label-pie-3"></label>
                                        </h5>
                                    </center>
                                </div>
                            </div>
                            <div class="col-6 col-md-2 col-lg-2">
                                <center>
                                    <div id="demo-pie-5" class="pie-title-center" data-percent=""> <span class="pie-value"></span> </div>
                                    <br>
                                </center>
                                <div>
                                    <center>
                                        <h5>
                                            Anulado: <label class="label-ico offer-radius" id="label-pie-5"></label>
                                        </h5>
                                    </center>
                                </div>
                            </div>
                            <div class="col-6 col-md-2 col-lg-2">
                                <center>
                                    <div id="demo-pie-4" class="pie-title-center" data-percent=""> <span class="pie-value"></span> </div>
                                    <br>
                                </center>
                                <div>
                                    <center>
                                        <h5>
                                            Rechazado: <label class="label-ico offer-radius" id="label-pie-4"></label>
                                        </h5>
                                    </center>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
    			<div class="col-12">
    				<div class="card">
    					<div class="card-header align-items-center d-flex bg-red-verisure color-white">
    						<h4 class="card-title mb-0 flex-grow-1 color-white"><?= $breadcrumb_alias ?></h4>
    						<div class="d-flex">
    						    <?php
								if (in_array("IMPOCO", $permisos)) 
								{
								?>
    							<button type="button" class="btn fondoAzulCorporativo d-flex mx-1 color-white" data-bs-toggle="modal" data-bs-target="#modal-importar-oc" id="btnImportarOC">
    								<i class="mdi mdi-database-import-outline me-1" style="font-size: 14px;"></i> Importar
    							</button>
    							<?php
    							}
    							
								if (in_array("EXPOCO", $permisos)) 
								{
								?>
    							<button type="button" class="btn bg-warning d-flex mx-1 color-white" data-bs-toggle="modal" data-bs-target="#modal-exportar-oc">
    								<i class="mdi mdi-file-download me-1" style="font-size: 14px;"></i> Exportar
    							</button>
    							<?php
    							}
    							
								if (in_array("ADDOCO", $permisos)) 
								{
								?>
								<a href="<?= $baseUrl ?>/nueva-orden-compra" role="button" class="btn bg-info d-flex mx-1 color-white">
                                        <i class="mdi mdi-plus-circle me-1" style="font-size: 14px;"></i> Nuevo
                                </a>
    							<?php
								}
								?>
    						</div>
    					</div>
    					<!-- /.card-header -->
    					<div class="card-body">
    					    <ul class="nav nav-tabs nav-justified nav-border-top nav-border-top-success mb-3 bg-white" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <a class="nav-link active" data-bs-toggle="tab" href="#nav-oc-pendientes-firma" role="tab" aria-selected="true">
                                        <i class="ri-home-5-line align-middle me-1"></i> Pendientes por Firmar
                                    </a>
                                </li>
                                <li class="nav-item" role="presentation" id="navOrdenCompraHistorico">
                                    <a class="nav-link" data-bs-toggle="tab" href="#nav-oc-historico" role="tab" aria-selected="false" tabindex="-1">
                                        <i class="ri-user-line me-1 align-middle"></i> Histórico
                                    </a>
                                </li>
                            </ul>
                            <div class="tab-content text-muted" style="background-color: transparent;">
                                <div class="tab-pane active show" id="nav-oc-pendientes-firma" role="tabpanel" style="background-color: transparent!important">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="card" id="ticketsList">
                                                <!--end card-body-->
                                                <div class="card-body">
                                                    <div class="mb-4 table-responsive">
                                                        <table id="tblOrdenesCompra" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
    								
    							                        </table>
                                                    </div>
                                                </div>
                                                <!--end card-body-->
                                            </div>
                                            <!--end card-->
                                        </div>
                                        <!--end col-->
                                    </div>
                                </div>
                                <div class="tab-pane" id="nav-oc-historico" role="tabpanel" style="background-color: transparent;">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="card" id="ticketsList">
                                                <!--end card-body-->
                                                <div class="card-body">
                                                    <div class="mb-4">
                                                        <table id="tblHistoricoOrdenCompra" class="table table-bordered dt-responsive nowrap table-striped align-middle">
                                                            
                                                        </table>
                                                    </div>
                                                </div>
                                                <!--end card-body-->
                                            </div>
                                            <!--end card-->
                                        </div>
                                        <!--end col-->
                                    </div>
                                </div>
                            </div>
    					</div>
    					<!-- /.card-body -->
    				</div>
    				<!-- /.card -->
    			</div>
    			<!-- /.col -->
    		</div>
    		<!-- end row-->
    	</div>
		<span class="respuesta_global"></span>
    	<!-- container-fluid -->
    </div>
    <!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- /.content -->
<?= $this->section('js'); ?>
<script>
	$(function () {
		/***SERVERSIDE ORDEN DE COMPRA***/
		assetListVM = {
			dt: null,
			init: function () {
				dt = $('#tblOrdenesCompra').DataTable({
					"serverSide": true,
					"processing": true,
					"ajax": {
						"url": baseUrl + "/ordenCompraServerside",
						type: 'GET'
					},
					"columns": [
						{"title": "# OC", "data": "oc", "class": "text-center", "searchable": true },
						{"title": "Fecha de Emisión", "data": "emision", "class": "text-center", "searchable": true },
						{"title": "Concepto", "data": "concepto", "class": "text-center", "searchable": true },
						{"title": "Proveedor", "data": "proveedor", "class": "text-center", "searchable": true },
						{"title": "Solicitante", "data": "solicitante", "class": "text-center", "searchable": true, "orderable": false },
						{"title": "CC", "data": "cc", "class": "text-center", "searchable": true },
						{"title": "Monto Total", "data": "total", "class": "text-center", "searchable": true },
						{"title": "Estado",
							"data": "Estado",
							class: 'text-center',
							render: function(data, type, row){  // con row obtienes la información por fila
								if (row.Estado == 'Aprobado') {
                                    return "<span class='badge badge-aprobadoCorporativo'>" + row.Estado + "</span>";
                                }
                                if (row.Estado == 'PreAprobado') {
                                    return "<span class='badge badge-amarilloCorporativo'>" + row.Estado + "</span>";
                                }
                                if (row.Estado == 'PendienteAprobacion') {
                                    return "<span class='badge badge-amarilloCorporativo'>" + row.Estado + "</span>";
                                }
                                if (row.Estado == 'Anulado') {
                                    return "<span class='badge bg-danger'>" + row.Estado + "</span>";
                                }
                                if (row.Estado == 'PendienteFirma1') {
                                    return "<span class='badge badge-amarilloCorporativo'>" + row.Estado + "</span>";
                                }
                                if (row.Estado == 'PendienteFirma2') {
                                    return "<span class='badge badge-amarilloCorporativo'>" + row.Estado + "</span>";
                                }
                                if (row.Estado == 'PendienteFirma3') {
                                    return "<span class='badge badge-amarilloCorporativo'>" + row.Estado + "</span>";
                                }
                                if (row.Estado == 'Rechazado') {
                                    return "<span class='badge bg-danger'>" + row.Estado + "</span>";
                                }
                                if (row.Estado == '' || row.Estado == null) {
                                    return "<span class='badge' >" + row.Estado + "</span>";
                                }
							}
						},
						{"title": "Comprador", "data": "comprador", "class": "text-center", "searchable": true, "orderable": false },
						{"title": "Categoría de Compra", "data": "categoria", "class": "text-center", "searchable": true, "orderable": false },
						{"title": "Acciones", "data": "acciones", "class": "text-center", "searchable": false, "orderable": false },
					],

					"lengthMenu": [[10, 25, 50], [10, 25, 50]],
					responsive: true,
					autoWidth: false,
					"pageLength": 10,
					"paging": true,
					"aaSorting": [[0, 'desc']],
				});
			}
		}

		assetListVM.init();
		/****FIN SERVERSIDE PROVEEDORES****/
		
		porcentaje();
	});
</script>
<?php $this->endSection(); ?>

<!-- EXPORTAR EXCEL -->
<div class="modal fade zoomIn" id="modal-exportar-oc" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleModalExportarOC" aria-hidden="true">
    <div class="modal-dialog modal-md modal-dialog-centered" role="document">
        <div class="modal-content" style="border: none;">
            <div class="modal-header bg-sistema p-3">
                <h4 class="modal-title color-white">Exportar Orden de Compra</h4>
                <button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close">
                </button>
            </div>

            <!--<form class="formulario" action="<?= $baseUrl ?>/exportar-orden-compra" method="POST" method="POST" accept-charset="utf-8">-->
                <span class="respuesta"></span>
                <div class="modal-body">
                    <div class="row col-12 m-0 p-0">
                        <div class="form-group col-6">
                            <label for="fechaInicio">Fecha Inicio</label>
                            <input type="date" class="form-control" id="fechaInicio" name="fechaInicio" value="<?= date("Y-m-d") ?>">
                            
                        </div>
                        <div class="form-group col-6">
                            <label for="fechaFin">Fecha Fin</label>
                            <input type="date" class="form-control" id="fechaFin" name="fechaFin" value="<?= date("Y-m-d") ?>">
                        </div>
                        <!-- <a href="#" role="button" class="btn btn-success btn-xs p-2">
							<i class="fas fa-file-excel mr-1"></i>Exportar
						</a> -->
                    </div>

                </div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger d-flex justify-content-end align-items-center color-white" data-bs-dismiss="modal"><span class="mdi mdi-close-thick me-2" style="font-size: 14px;"></span>Cerrar</button>
					<button type="button" id="exportarOrdenCompra" class="btn bg-success d-flex justify-content-end align-items-center color-white"><i class="mdi mdi-download me-2 color-white" style="font-size: 14px;"></i>Descargar</button>
				</div>
            <!--</form>-->
        </div>
    </div>
</div>

<!-- IMPORTAR EXCEL -->
<div class="modal fade zoomIn" id="modal-importar-oc" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleModalImportarOC" aria-hidden="true">
	<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h4 class="modal-title color-white" id="exampleModalImportarOC">Importar Órdenes de Compra</h4>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
				<!--<button class="btn btn-warning ml-auto text-white" type="button" id="btnExportarModelo">-->
				<!--	<i class="fas fa-download mr-1"></i>Descargar Modelo-->
				<!--</button>-->
			</div>
			<form class="formularioImportarOC" id="formImportarOC" autocomplete="off" action="<?= $baseUrl ?>/importar-orden-compra" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
					<div class="col-12 mb-3">
						<h4>Consideraciones:</h4>
						<ol>
						    <li>Información de columna [RUC]: Solo admite números.</li>
						    <li>Información de columnas [Dirección-Área-Subárea-CC-LN]: Debe descargar el fichero de Subáreas para copiar los nombres correctamente.</li>
						    <li>Información de columna [SOLICITANTE]: Correo electrónico del solicitante sin el dominio (@verisure.pe)</li>
						    <li>Información de columnas [Categoría-Subcategoría]: Debe descargar el fichero de subcategorías para copiar los nombres correctamente.</li>
						    <li>Información de columna [CONCEPTO]: No debe tener caracteres extraños ejm. <span class="text-danger mb-0">'*+^</span></li>
						    <li>Información de columna [BUDGET]: [SI, NO]</li>
						    <li>Información de columna [TIPO MONEDA]: [PEN, USD, EUR]</li>
						    <li>Información de columna [CONDICION IGV]: [Afecta, Noafecta]</li>
						    <li>Información de columna [OBSERVACIÓN]: No debe tener caracteres extraños ejm. <span class="text-danger mb-0">'*+^</span></li>
						    <li>Información de columna [DESCRIPCIÓN]: No debe tener caracteres extraños ejm. <span class="text-danger mb-0">'*+^</span></li>
						    <li>Información de columna [CANTIDAD]: Solo admite números enteros.</li>
						    <li>Información de columna [PRECIO UNITARIO]: Debe tener solo separador de decimales (".") ejem. <span class="text-danger mb-0">3011.99</span></li>
						    <li>Información de columna [CENTRALIZADO]: Si es una orden de compra centralizada, colocar "1". Cualquier otro valor se va a considerar como compra no centralizada.</li>
						</ol>
					</div>
    				<hr>
    				<h4 class="mb-3">Plantillas:</h4>
					<div class="row col-12 m-0 p-0">
					    <div class="col-lg-6 col-12 d-flex justify-content-center align-items-center">
					        <!--<a class='btn btn-success border-0 texto-indicador' style="color: #FFF" href='<?= base_url().'/public/docs/Plantillas/plantilla csv linea.csv' ?>' download='Plantilla CSV Línea'>Descargar Plantilla</a>-->
					        <div class="card card-light">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="flex-shrink-0">
                                            <span class="mdi mdi-download color-sistema" style="font-size: 48px;"></span>
                                        </div>
                                        <div class="flex-grow-1 ms-3">
                                            <p class="card-text">Si desea conocer las <strong class="fw-medium">Subcategorías</strong> con sus respectivas <strong class="fw-medium">Categorías</strong> presione el enlace de abajo.</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <div class="text-center">
                                        <a onclick="return descargarSubcategoriasCuentaContable();" class="text-body" style="cursor: pointer;">Descargar Información <i class="ri-arrow-right-s-line align-middle lh-1"></i></a>
                                    </div>
                                </div>
                            </div>
					    </div>
					    <div class="col-lg-6 col-12 d-flex justify-content-center align-items-center">
					        <div class="card card-light">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="flex-shrink-0">
                                            <span class="mdi mdi-download color-sistema" style="font-size: 48px;"></span>
                                        </div>
                                        <div class="flex-grow-1 ms-3">
                                            <p class="card-text">Si desea conocer las <strong class="fw-medium">Subáreas</strong> con sus respectivas <strong class="fw-medium">Delegaciones (CC - LN)</strong> presione el enlace de abajo.</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <div class="text-center">
                                        <a onclick="return descargarEstructuraDepartamental();" class="text-body" style="cursor: pointer;">Descargar Información <i class="ri-arrow-right-s-line align-middle lh-1"></i></a>
                                    </div>
                                </div>
                            </div>
					    </div>
					    <div class="col-lg-12 col-12 d-flex justify-content-center align-items-center">
					        <!--<a class='btn btn-success border-0 texto-indicador' style="color: #FFF" href='<?= base_url().'/public/docs/Plantillas/plantilla csv linea.csv' ?>' download='Plantilla CSV Línea'>Descargar Plantilla</a>-->
					        <div class="card card-light">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="flex-shrink-0">
                                            <span class="mdi mdi-download color-sistema" style="font-size: 48px;"></span>
                                        </div>
                                        <div class="flex-grow-1 ms-3">
                                            <p class="card-text">Si desea descargar la <strong class="fw-medium">Plantilla de Importación OC</strong> presione el enlace de abajo.</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <div class="text-center">
                                        <a class="text-body" href='<?= base_url().'/public/docs/Plantillas/plantilla csv orden compra.csv' ?>' download='Plantilla CSV Orden de Compra'>Descargar Plantilla <i class="ri-arrow-right-s-line align-middle lh-1"></i></a>
                                        <!--<a href="javascript:void(0);" class="text-body">Descargar Plantilla</a>-->
                                    </div>
                                </div>
                            </div>
					    </div>
					</div>
    				<hr>
    				<h4 class="mb-3">Importar archivo:</h4>
					<div class="col-12 mb-0 d-flex justify-content-center">
					    <div class="col-7 m-0 p-0">
					        <input type="file" id="inputGroupFile01" class="filepond" name="inputGroupFile01" data-max-file-size="100MB" data-max-files="1" />
					    </div>
					</div>
					<!--<div class="mb-3">-->
					<!--	<label for="fileCSVLinea" class="form-label">Seleccione CSV:</label>-->
					<!--	<input class="form-control" type="file" id="fileCSVLinea" name="fileCSVLinea">-->
					<!--</div>-->
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-danger d-flex justify-content-center" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" class="btn btn-success d-flex justify-content-center"><i class="mdi mdi-content-save mx-1" style="font-size: 14px;"></i>Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<?php $this->endSection(); ?>