<?php namespace App\Models;

use CodeIgniter\Model;

class UsuarioPermisosModel extends Model {
  protected $table = 'usuario_permisos';
  protected $primaryKey = 'IdUsuario';
  protected $allowedFields = ['IdUsuario', 'IDAccionModulo', 'UsuarioRegistra', 'FechaRegistra'];
  protected $useAutoIncrement = false;
  protected $useSoftDeletes = false;
  
  public function listarPermisosUsuario($idUsuario)
  {
      $this->select('modulos_acciones.IDAccionModulo,
        modulos_acciones.IDModulo, 
        modulos_acciones.Codigo, 
        modulos_acciones.Accion, 
        IF(usuario_permisos.IdUsuario IS NULL, 0, 1) AS "ACTIVO"');
      $this->join('modulos_acciones', 'usuario_permisos.IDAccionModulo = modulos_acciones.IDAccionModulo AND usuario_permisos.IdUsuario = "'.$idUsuario.'"', 'right');
      
      $datos = $this->findAll();
      return $datos;
  }
}
