<?php
namespace App\Models;
use CodeIgniter\Model;

class RequerimientosModel extends Model
{
    protected $table      = 'requerimientos';
    protected $primaryKey = 'IDRequerimiento';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['Requerimiento', 'Tipo', 'Observacion', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function listadoRequerimientos($array)
    {
        $this->select('
        requerimientos.IDRequerimiento,
        requerimientos.Requerimiento,
        requerimientos.Tipo,
        requerimientos.Observacion,
        requerimientos.Estado');
        
        if(!empty($array))
        {
            if(isset($array['estado']) && !empty($array['estado']))
            {
                $this->where('requerimientos.Estado', $array['estado']);
            }
            
            if(isset($array['tipo']) && !empty($array['tipo']))
            {
                $this->where('requerimientos.Tipo', $array['tipo']);
            }

        }
        $datos = $this->findAll();
        return $datos;
    }
    
  
    
    
}