<?php
namespace App\Models;
use CodeIgniter\Model;

class ProveedorModel extends Model
{
    protected $table      = 'proveedor';
    protected $primaryKey = 'IDProveedor';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['Nombre', 'RUC', 'Contacto', 'IDDistrito', 'Direccion', 'Telefono01', 'Telefono02', 'Email', 'FormaPago', 'CuentaDetraccion', 'CodigoDetraccion', 'Observacion','UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    // public function listadoProveedor($array)
    // {
    //     $this->select('proveedor.IDProveedor,
    //         proveedor.Nombre,
    //         proveedor.RUC,
    //         proveedor.Contacto,
    //         proveedor.IDDistrito,
    //         proveedor.Direccion,
    //         proveedor.Telefono01,
    //         proveedor.Telefono02,
    //         proveedor.Email,
    //         proveedor.FormaPago,
    //         proveedor.CuentaDetraccion,
    //         proveedor.CodigoDetraccion,
    //         proveedor.Observacion,
    //         dbMASTERUSUARIO.region_distrito.Distrito,
    //         dbMASTERUSUARIO.region_distrito.IDProvincia,
    //         dbMASTERUSUARIO.region_provincia.Provincia,
    //         dbMASTERUSUARIO.region_provincia.IDDepartamento,
    //         dbMASTERUSUARIO.region_departamento.Departamento,
    //         dbMASTERUSUARIO.region_departamento.IDPais,
    //         GROUP_CONCAT(distinct proveedor_tipologia.IDTipologia separator "|") AS TIPOLOGIAS');
    //     $this->join('dbMASTERUSUARIO.region_distrito', 'proveedor.IDDistrito = dbMASTERUSUARIO.region_distrito.IDDistrito', 'left');
    //     $this->join('dbMASTERUSUARIO.region_provincia', 'dbMASTERUSUARIO.region_distrito.IDProvincia = dbMASTERUSUARIO.region_provincia.IDProvincia', 'left');
    //     $this->join('dbMASTERUSUARIO.region_departamento', 'dbMASTERUSUARIO.region_provincia.IDDepartamento = dbMASTERUSUARIO.region_departamento.IDDepartamento', 'left');
    //     $this->join('proveedor_tipologia', 'proveedor.IDProveedor = proveedor_tipologia.IDProveedor', 'left');
        
    //     if(isset($array['Estado']) && $array['Estado'] != '')
    //     {
    //         $this->where("proveedor.Estado", $array['Estado']);
    //     }
        
    //     $this->groupBy('proveedor.IDProveedor');
    //     $datos = $this->findAll();
    //     return $datos;
    // }
    public function listadoProveedor($array)
    {
        $this->select('proveedor.IDProveedor,
            proveedor.Nombre,
            proveedor.RUC,
            proveedor.Contacto,
            proveedor.IDDistrito,
            proveedor.Direccion,
            proveedor.Telefono01,
            proveedor.Telefono02,
            proveedor.Email,
            proveedor.FormaPago,
            proveedor.CuentaDetraccion,
            proveedor.CodigoDetraccion,
            proveedor.Observacion, 
            PP.ModalidadPago, 
            PP.CuentaBancaria');
        
        $this->join('(SELECT IDProveedor, ModalidadPago, Banco, CuentaBancaria, CuentaInterbancaria, Moneda FROM proveedor_pago WHERE Estado = "A" ORDER BY Prioridad ASC LIMIT 1) AS PP', 'proveedor.IDProveedor = PP.IDProveedor', 'left');
        
        if(isset($array['Estado']) && $array['Estado'] != '')
        {
            $this->where("proveedor.Estado", $array['Estado']);
        }
        
        $datos = $this->findAll();
        return $datos;
    }
    
    public function listadoProveedoresAutocompletado($array)
    {
        $this->select('proveedor.IDProveedor,
            proveedor.Nombre,
            proveedor.RUC,
            proveedor.Contacto,
            proveedor.IDDistrito,
            proveedor.Direccion,
            proveedor.Telefono01,
            proveedor.Telefono02,
            proveedor.Email,
            proveedor.FormaPago,
            proveedor.CuentaDetraccion,
            proveedor.CodigoDetraccion,
            proveedor.Observacion');
        $this->where("(proveedor.Nombre LIKE '%".$array["variable"]."%' OR 
            proveedor.RUC LIKE '%".$array["variable"]."%' OR
            proveedor.Contacto LIKE '%".$array["variable"]."%' OR 
            proveedor.Direccion LIKE '%".$array["variable"]."%')");
            
        if(isset($array['Estado']) && $array['Estado'] != '')
        {
            $this->where("proveedor.Estado", $array['Estado']);
        }
        
        $datos = $this->findAll();
        return $datos;
    }
    
    // public function listaGeneralProveedor($orderBy,$where,$length,$start) {
    //     $sSelect = "proveedor.IDProveedor,proveedor.RUC,proveedor.Nombre,proveedor.Contacto,dbMASTERUSUARIO.region_departamento.Departamento AS 'Departamento',dbMASTERUSUARIO.region_provincia.Provincia AS 'Provincia', dbMASTERUSUARIO.region_distrito.Distrito AS 'Distrito', proveedor.Telefono01 , proveedor.Telefono02, proveedor.Email, proveedor.Estado, 'SININFO' AS acciones_proveedor";
    //     $sTable = "proveedor LEFT JOIN dbMASTERUSUARIO.region_distrito ON proveedor.IDDistrito = dbMASTERUSUARIO.region_distrito.IDDistrito LEFT JOIN dbMASTERUSUARIO.region_provincia ON dbMASTERUSUARIO.region_distrito.IDProvincia = dbMASTERUSUARIO.region_provincia.IDProvincia LEFT JOIN dbMASTERUSUARIO.region_departamento ON dbMASTERUSUARIO.region_provincia.IDDepartamento = dbMASTERUSUARIO.region_departamento.IDDepartamento ";
    //     $whereRespuesta = $where==""?"":"WHERE (".$where ."')";
    //     $consulta = "SELECT " . $sSelect ." FROM ".  $sTable . " " .$whereRespuesta ."  " . $orderBy . " LIMIT ". $length ." OFFSET " .$start;
    //     echo $consulta;
    //     exit;
    //     $obtieneConsulta = $this->db->query($consulta);
    //     $query = $obtieneConsulta->get();
    //     echo $query; exit;
    //     $consultaTotal = "SELECT count(IDProveedor) as total FROM proveedor";
    //     $totalRegistros = $this->db->query($consultaTotal);
    //     $obtieneTotalRegistros = $totalRegistros->getResultArray();
        
    //     if ($obtieneConsulta->getNumRows() > 0) {
    //         $datos = [
    //             // 'draw' => "4",
    //             'data' => $obtieneConsulta->getResultArray(),
    //             'recordsTotal' => $obtieneTotalRegistros[0]['total'],
    //             'recordsFiltered' => (int)(($obtieneTotalRegistros[0]['total']*$length)/$length)
    //         ];
    //         return $datos;
    //     } else {
    //         return FALSE;
    //     }
    // }

    public function listaGeneralProveedor($get, $adicionales) 
    {
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
    
        // $this->globales = new Globales();
        
        $fields = array(
            0 => 'proveedor.RUC', 
            1 => 'proveedor.Nombre', 
            2 => 'proveedor.Contacto', 
            6 => 'proveedor.Telefono01', 
            7 => 'proveedor.Telefono02', 
            8 => 'proveedor.Email', 
            9 => 'proveedor.Estado');
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        
        $this->select('
            proveedor.IDProveedor,
            proveedor.RUC,
            proveedor.Nombre,
            proveedor.Contacto,
            proveedor.Telefono01, 
            proveedor.Telefono02, 
            proveedor.IDDistrito,
            proveedor.Email, 
            proveedor.Estado');
            
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $this->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $this->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        
        foreach ($get['order'] as $order) {
            if(array_key_exists($order['column'], $fields))
            {
                $this->orderBy($fields[$order['column']], $order['dir']);
            }
        }
        
        /*
        * ----------------------------
        * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
        * ----------------------------
        */
        
        /* Antes de Codeiginiter 4.5.4*/
        // $this->limit($get['length'], $get['start']);
        
        /*
        * ----------------------------
        * EJECUTAR CONSULTA, LIMITAR CANTIDAD DE RESULTADOS DE QUERY Y DEVOLVER VALORES
        * ----------------------------
        */
        
        /* Antes de Codeiginiter 4.5.4*/
        // $this->get();
        // echo $this->getLastQuery();
        // exit;
        
        
        // $result = $this->get()->getResultArray();
        // return $result;
        
        /* Despues de Codeiginiter 4.5.4*/
        $result = $this->findAll($get['length'], $get['start']);
        
        // echo $this->getLastQuery();
        // exit;
        
        return $result;
    }

    // public function obtenerProveedor($idProveedor)
    // {
    //     $this->select('proveedor.IDProveedor,
    //         proveedor.Nombre,
    //         proveedor.RUC,
    //         proveedor.Contacto,
    //         proveedor.IDDistrito,
    //         proveedor.Direccion,
    //         proveedor.Telefono01,
    //         proveedor.Telefono02,
    //         proveedor.Email,
    //         proveedor.FormaPago,
    //         proveedor.CuentaDetraccion,
    //         proveedor.CodigoDetraccion,
    //         proveedor.Observacion,
    //         dbMASTERUSUARIO.region_distrito.Distrito,
    //         dbMASTERUSUARIO.region_distrito.IDProvincia,
    //         dbMASTERUSUARIO.region_provincia.Provincia,
    //         dbMASTERUSUARIO.region_provincia.IDDepartamento,
    //         dbMASTERUSUARIO.region_departamento.Departamento,
    //         dbMASTERUSUARIO.region_departamento.IDPais,
    //         dbMASTERUSUARIO.region_pais.Pais,
    //         GROUP_CONCAT(distinct proveedor_tipologia.IDTipologia separator "|") AS TIPOLOGIAS,
    //         PP.ModalidadPago,
    //         PP.Banco,
    //         PP.CuentaBancaria,
    //         PP.CuentaInterbancaria,
    //         PP.Moneda');
    //     $this->join('dbMASTERUSUARIO.region_distrito', 'proveedor.IDDistrito = dbMASTERUSUARIO.region_distrito.IDDistrito', 'left');
    //     $this->join('dbMASTERUSUARIO.region_provincia', 'dbMASTERUSUARIO.region_distrito.IDProvincia = dbMASTERUSUARIO.region_provincia.IDProvincia', 'left');
    //     $this->join('dbMASTERUSUARIO.region_departamento', 'dbMASTERUSUARIO.region_provincia.IDDepartamento = dbMASTERUSUARIO.region_departamento.IDDepartamento', 'left');
    //     $this->join('dbMASTERUSUARIO.region_pais', 'dbMASTERUSUARIO.region_departamento.IDPais = dbMASTERUSUARIO.region_pais.IDPais', 'left');
    //     $this->join('proveedor_tipologia', 'proveedor.IDProveedor = proveedor_tipologia.IDProveedor', 'left');
    //     $this->join('(SELECT IDProveedor, ModalidadPago, Banco, CuentaBancaria, CuentaInterbancaria, Moneda FROM proveedor_pago WHERE IDProveedor = "'.$idProveedor.'" AND Estado = "A" ORDER BY Prioridad ASC LIMIT 1) AS PP', 'proveedor.IDProveedor = PP.IDProveedor', 'left');
    //     $this->where('proveedor.IDProveedor', $idProveedor);
    //     $this->groupBy('proveedor.IDProveedor');

    //     $datos = $this->first();
    //     return $datos;
    // }
    
    public function obtenerProveedor($idProveedor)
    {
        $this->select('proveedor.IDProveedor,
            proveedor.Nombre,
            proveedor.RUC,
            proveedor.Contacto,
            proveedor.IDDistrito,
            proveedor.Direccion,
            proveedor.Telefono01,
            proveedor.Telefono02,
            proveedor.Email,
            proveedor.FormaPago,
            proveedor.CuentaDetraccion,
            proveedor.CodigoDetraccion,
            proveedor.Observacion,
            proveedor.IDDistrito,
            GROUP_CONCAT(distinct proveedor_tipologia.IDTipologia separator "|") AS TIPOLOGIAS,
            PP.ModalidadPago,
            PP.Banco,
            PP.CuentaBancaria,
            PP.CuentaInterbancaria,
            PP.Moneda');
        $this->join('proveedor_tipologia', 'proveedor.IDProveedor = proveedor_tipologia.IDProveedor', 'left');
        $this->join('(SELECT IDProveedor, ModalidadPago, Banco, CuentaBancaria, CuentaInterbancaria, Moneda FROM proveedor_pago WHERE IDProveedor = "'.$idProveedor.'" AND Estado = "A" ORDER BY Prioridad ASC LIMIT 1) AS PP', 'proveedor.IDProveedor = PP.IDProveedor', 'left');
        $this->where('proveedor.IDProveedor', $idProveedor);
        $this->groupBy('proveedor.IDProveedor');

        $datos = $this->first();
        return $datos;
    }
    
}