<?php

use CodeIgniter\Router\RouteCollection;
// $routes->get('test-controller', 'TestController::index');
// $routes->add('test', function() {
//     return 'Ruta de prueba funcionando';
// });
/**
 * @var RouteCollection $routes
 */
// $routes->get('/', 'Home::index');
$routes->set404Override(function()
{
    echo view('errors/404');
});
/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.
$routes->get('/', 'Acceso::login');

/* ACCESO */
$routes->add('entrar', 'Acceso::entrar');
$routes->add('salir','Acceso::salir');
$routes->add('iniciar-sesion','Acceso::login');
$routes->add('olvido-contrasena', 'Acceso::olvidoContrasena');
$routes->add('solicitar-recuperacion', 'Acceso::solicitarRecuperacion');
$routes->add('recuperar-cuenta/(:any)', 'Acceso::recuperarCuenta/$1');
$routes->add('grabar-recuperacion/(:any)', 'Acceso::grabarRecuperacion/$1');

/* ADMINISTRACIÓN */
$routes->add('descargatxt/(:any)','Administracion::descargatxt/$1');/* NUEVO */

$routes->add('listar-usuarios','Administracion::listarUsuarios');/* NUEVO */

$routes->add('listar-perfiles','Administracion::listarPerfiles');/* NUEVO */
$routes->add('registrar-perfil','Administracion::registrarPerfil');/* NUEVO */
$routes->add('listado-perfil-select','Administracion::listadoPerfilesSelect');/* NUEVO */
$routes->add('obtener-datos-perfil','Administracion::obtenerDatosPerfil');/* NUEVO */
$routes->add('actualizar-perfil/(:any)','Administracion::actualizarPerfil/$1');/* NUEVO */
$routes->add('cambiar-estado-perfil','Administracion::modificarEstadoPerfil');/* NUEVO */

$routes->add('listar-permisos-perfil/(:any)','Administracion::listarPermisosPerfil/$1');/* NUEVO */
$routes->add('grabar-permisos-perfil/(:any)','Administracion::guardarPermisosPerfil/$1');/* NUEVO */
$routes->add('listar-rutas-perfil/(:any)','Administracion::listarRutasPerfil/$1');/* NUEVO */
$routes->add('grabar-rutas-perfil/(:any)','Administracion::guardarRutasPerfil/$1');/* NUEVO */

$routes->add('obtener-cabecera','Administracion::obtenerCabecera');/* NUEVO */
$routes->add('listar-modulos','Administracion::listarModulos');/* NUEVO */
$routes->add('registrar-modulo','Administracion::registrarModulo');/* NUEVO */
$routes->add('cambiar-estado-modulo','Administracion::modificarEstadoModulo');/* NUEVO */
$routes->add('obtener-datos-modulo','Administracion::obtenerDatosModulo');/* NUEVO */
$routes->add('actualizar-modulo/(:any)','Administracion::modificarModulo/$1');/* NUEVO */
$routes->add('listar-rutas-modulo/(:any)','Administracion::listarRutasModulo/$1');/* NUEVO */
$routes->add('grabar-ruta/(:any)','Administracion::guardarRutaModulo/$1');/* NUEVO */
$routes->add('obtener-datos-ruta-modulo','Administracion::obtenerDatosRutaModulo');/* NUEVO */
$routes->add('actualizar-ruta-modulo/(:any)','Administracion::modificarRutaModulo/$1');/* NUEVO */
$routes->add('cambiar-estado-ruta-modulo','Administracion::modificarEstadoRutaModulo');/* NUEVO */
$routes->add('listar-acciones-modulo/(:any)','Administracion::listarAccionesModulo/$1');/* NUEVO */
$routes->add('grabar-accion/(:any)','Administracion::guardarAccionModulo/$1');/* NUEVO */

/* USUARIOS */
$routes->add('usuariosServerside','Usuarios::listarUsuarioDataTable');/* NUEVO */
$routes->add('obtener-datos-usuario/(:any)','Usuarios::obtenerDatosUsuario/$1');
$routes->add('modificar-usuario/(:any)','Usuarios::modificarUsuario/$1');/* NUEVO */
$routes->add('listado-usuarios-select','Usuarios::listadoUsuariosSelect');
$routes->add('listado-usuarios-comprador','Usuarios::listadoUsuariosComprador');

$routes->add('listar-permisos-usuario/(:any)','Usuarios::listarPermisosUsuario/$1');/* NUEVO */
$routes->add('grabar-permisos-usuario/(:any)','Usuarios::guardarPermisosUsuario/$1');/* NUEVO */
$routes->add('listar-rutas-usuario/(:any)','Usuarios::listarRutasUsuario/$1');/* NUEVO */
$routes->add('grabar-rutas-usuario/(:any)','Usuarios::guardarRutasUsuario/$1');/* NUEVO */

/* NOTIFICACIONES */
$routes->add('cargar-notificaciones-header','Notificaciones::cargarNotificacionesHeader');/* NUEVO */
$routes->add('cantidad-notificaciones-header','Notificaciones::cantidadNotificacionesHeader');/* NUEVO */
$routes->add('registrar-vista-notificacion','Notificaciones::registrarVisualizacionNotificacion');/* NUEVO */

/******************************************************************************/
	
/*************************** CONFIGURACIÓN ************************************/

$routes->add('listado-codigos-detraccion','Configuracion::listadoCodigosDetraccion');/* NUEVO */

$routes->add('listar-tipologias','Configuracion::listarTipologias');/* NUEVO */
$routes->add('registrar-tipologia','Configuracion::registrarTipologia');/* NUEVO */
$routes->add('obtener-datos-tipologia','Configuracion::obtenerDatosTipologia');
$routes->add('actualizar-tipologia/(:any)','Configuracion::modificarTipologia/$1');
$routes->add('cambiar-estado-tipologia','Configuracion::modificarEstadoTipologia');/* NUEVO */
$routes->add('listado-tipologias','Configuracion::listadoTipologias');/* NUEVO */

$routes->add('listar-bancos','Configuracion::listarBancos');/* NUEVO */
$routes->add('registrar-banco','Configuracion::registrarBanco');/* NUEVO */
$routes->add('obtener-datos-banco','Configuracion::obtenerDatosBanco');
$routes->add('actualizar-banco/(:any)','Configuracion::modificarBanco/$1');
$routes->add('cambiar-estado-banco','Configuracion::modificarEstadoBanco');/* NUEVO */
$routes->add('listado-bancos','Configuracion::listadoBanco');/* NUEVO */

$routes->add('listar-formas-pago','Configuracion::listarFormasPago');/* NUEVO */
$routes->add('registrar-forma-pago','Configuracion::registrarFormaPago');/* NUEVO */
$routes->add('obtener-datos-forma-pago','Configuracion::obtenerDatosFormaPago');
$routes->add('actualizar-forma-pago/(:any)','Configuracion::modificarFormaPago/$1');
$routes->add('cambiar-estado-forma-pago','Configuracion::modificarEstadoFormaPago');/* NUEVO */
$routes->add('listado-formas-pago','Configuracion::listadoFormasPago');/* NUEVO */

$routes->add('listar-modalidad-pago','Configuracion::listarModalidadPago');/* NUEVO */
$routes->add('registrar-modalidad-pago','Configuracion::registrarModalidadPago');/* NUEVO */
$routes->add('obtener-datos-modalidad-pago','Configuracion::obtenerDatosModalidadPago');
$routes->add('actualizar-modalidad-pago/(:any)','Configuracion::modificarModalidadPago/$1');
$routes->add('cambiar-estado-modalidad-pago','Configuracion::modificarEstadoModalidadPago');/* NUEVO */
$routes->add('listado-modalidad-pago','Configuracion::listadoModalidadPago');/* NUEVO */

$routes->add('listar-cuentas-contables','Configuracion::listarCuentasContables');/* NUEVO */
$routes->add('registrar-cuenta-contable','Configuracion::registrarCuentaContable');/* NUEVO */
$routes->add('obtener-datos-cuenta-contable','Configuracion::obtenerDatosCuentaContable');
$routes->add('actualizar-cuenta-contable/(:any)','Configuracion::modificarCuentaContable/$1');
$routes->add('cambiar-estado-cuenta-contable','Configuracion::modificarEstadoCuentaContable');/* NUEVO */
$routes->add('listado-cuentas-contables','Configuracion::listadoCuentasContables');/* NUEVO */

$routes->add('listar-categorias-cuenta-contable/(:any)','Configuracion::listarCategoriasCuentaContable/$1');/* NUEVO */
$routes->add('registrar-categoria-cuenta-contable','Configuracion::registrarCategoriaCuentaContable');/* NUEVO */
$routes->add('obtener-datos-categoria-cuenta-contable','Configuracion::obtenerDatosCategoriaCuentaContable');/* NUEVO */
$routes->add('actualizar-categoria-cuenta-contable/(:any)','Configuracion::modificarCategoriaCuentaContable/$1');/* NUEVO */
$routes->add('cambiar-estado-categoria-cuenta-contable','Configuracion::modificarEstadoCategoriaCuentaContable');/* NUEVO */
$routes->add('listado-categoria-cuenta-contable','Configuracion::listadoCategoriaCuentaContable');/* NUEVO */

$routes->add('listar-subcategorias-cuenta-contable/(:any)','Configuracion::listarSubcategoriasCuentaContable/$1');/* NUEVO */
$routes->add('registrar-subcategoria-cuenta-contable','Configuracion::registrarSubcategoriaCuentaContable');/* NUEVO */
$routes->add('obtener-datos-subcategoria-cuenta-contable','Configuracion::obtenerDatosSubcategoriaCuentaContable');/* NUEVO */
$routes->add('actualizar-subcategoria-cuenta-contable/(:any)','Configuracion::modificarSubcategoriaCuentaContable/$1');/* NUEVO */
$routes->add('cambiar-estado-subcategoria-cuenta-contable','Configuracion::modificarEstadoSubcategoriaCuentaContable');/* NUEVO */
$routes->add('listado-subcategoria-cuenta-contable','Configuracion::listadoSubcategoriaCuentaContable');/* NUEVO */
$routes->add('exportar-subcategorias-cuenta-contable','Configuracion::exportarSubcategoriasCuentaContable');/* NUEVO */

$routes->add('listar-requerimientos','Configuracion::listarRequerimientos');/* NUEVO */
$routes->add('registrar-requerimiento','Configuracion::registrarRequerimiento');/* NUEVO */
$routes->add('obtener-datos-requerimiento','Configuracion::obtenerDatosRequerimiento');/* NUEVO */
$routes->add('actualizar-requerimiento/(:any)','Configuracion::modificarRequerimiento/$1');/* NUEVO */
$routes->add('cambiar-estado-requerimiento','Configuracion::modificarEstadoRequerimiento');/* NUEVO */
$routes->add('listado-requerimiento','Configuracion::listadoRequerimientos');/* NUEVO */
$routes->add('listado-tipo-requerimiento','Configuracion::listadoTipoRequerimientos');/* NUEVO */

$routes->add('listar-motivos-requerimiento/(:any)','Configuracion::listarMotivosRequerimiento/$1');/* NUEVO */
$routes->add('registrar-motivo-requerimiento','Configuracion::registrarMotivoRequerimiento');/* NUEVO */
$routes->add('obtener-datos-motivo-requerimiento','Configuracion::obtenerDatosMotivoRequerimiento');/* NUEVO */
$routes->add('actualizar-motivo-requerimiento/(:any)','Configuracion::modificarMotivoRequerimiento/$1');/* NUEVO */
$routes->add('cambiar-estado-motivo-requerimiento','Configuracion::modificarEstadoMotivoRequerimiento');/* NUEVO */
$routes->add('listado-motivo-requerimiento','Configuracion::listadoMotivosRequerimiento');/* NUEVO */

/******************************************************************************/
	
/********************************* PROVEEDOR **********************************/ 

$routes->add('listar-proveedores','Proveedor::listarProveedores');/* NUEVO */
$routes->add('proveedoresServerside','Proveedor::proveedoresServerside');/* NUEVO */
$routes->add('registrar-proveedor','Proveedor::registrarProveedor');/* NUEVO */
$routes->add('obtener-datos-proveedor','Proveedor::obtenerDatosProveedor');/* NUEVO */
$routes->add('actualizar-proveedor/(:any)','Proveedor::modificarProveedor/$1');
$routes->add('cambiar-estado-proveedor','Proveedor::modificarEstadoProveedor');/* NUEVO */
$routes->add('recargar-tabla-modalidad-pago-proveedor','Proveedor::recargarTablaModalidadPagoProveedor');/* NUEVO */
$routes->add('registrar-modalidad-pago-proveedor','Proveedor::registrarModalidadPagoProveedor');/* NUEVO */
$routes->add('obtener-datos-modalidad-pago-proveedor','Proveedor::obtenerDatosModalidadPagoProveedor');
$routes->add('actualizar-modalidad-pago-proveedor/(:any)','Proveedor::modificarModalidadPagoProveedor/$1');
$routes->add('cambiar-estado-modalidad-pago-proveedor','Proveedor::modificarEstadoModalidadPagoProveedor');/* NUEVO */
$routes->add('listado-proveedores','Proveedor::listadoProveedores');/* NUEVO */
$routes->add('listado-proveedores-autocompletado','Proveedor::listadoProveedoresAutocompletado');/* NUEVO */
$routes->add('exportar-proveedores','Proveedor::exportarProveedores');/* NUEVO */

$routes->add('listar-accesos-proveedor/(:any)','Proveedor::listadoUsuariosAccesoProveedor/$1');/* NUEVO */
$routes->add('registrar-externo-proveedor','Proveedor::registrarUsuarioExternoProveedor');/* NUEVO */
$routes->add('eliminar-externo-proveedor','Proveedor::eliminarUsuarioExternoProveedor');/* NUEVO */
$routes->add('busqueda-externo-acceso','Proveedor::busquedaUsuarioExterno');/* NUEVO */
$routes->add('asociar-externo-proveedor','Proveedor::asociarUsuarioExternoProveedor');/* NUEVO */

$routes->add('listar-acceso-externos','Proveedor::listadoAccesoExternos/$1');/* NUEVO */
/******************************************************************************/
	
/********************************** PROCESOS **********************************/ 
$routes->add('listar-peticiones','Peticiones::listarPeticiones');/* NUEVO */
$routes->add('grabar-peticion','Peticiones::registrarPeticion');/* NUEVO */
$routes->add('detalle-peticion/(:any)','Peticiones::detallePeticion/$1');/* NUEVO */
$routes->add('agregar-comentario-peticion','Peticiones::registrarComentarioPeticion');/* NUEVO */
$routes->add('cambio-estado-peticion/(:any)','Peticiones::modificarEstadoPeticion/$1');/* NUEVO */
$routes->add('peticionesServersideHistorico','Peticiones::peticionesServersideHistorico');/* NUEVO */
$routes->add('informacion-prospecto-peticion/(:any)','Peticiones::informacionProspectoPeticion/$1');/* NUEVO */


$routes->add('listar-ordenes-compra','OrdenCompra::listarOrdenesCompra');/* NUEVO */
$routes->add('ordenCompraServerside','OrdenCompra::ordenCompraServerside');/* NUEVO */
$routes->add('ordenCompraServersideHistorico','OrdenCompra::ordenCompraServersideHistorico');/* NUEVO */
$routes->add('nueva-orden-compra','OrdenCompra::nuevaOrdenCompra');/* NUEVO */
$routes->add('registrar-orden-compra','OrdenCompra::registrarOrdenCompra');/* NUEVO */
$routes->add('obtener-datos-orden-compra','OrdenCompra::obtenerDatosOrdenCompra');/* NUEVO */
$routes->add('actualizar-responsables-firma-oc','OrdenCompra::modificarResponsablesFirmaOrdenCompra');/* NUEVO */
$routes->add('editar-orden-compra/(:any)','OrdenCompra::editarOrdenCompra/$1');/* NUEVO */
$routes->add('actualizar-orden-compra/(:any)','OrdenCompra::modificarOrdenCompra/$1');
$routes->add('recargar-tabla-detalle-orden-compra','OrdenCompra::recargarTablaDetalleOrdenCompra');/* NUEVO */
$routes->add('registrar-detalle-orden-compra','OrdenCompra::registrarDetalleOrdenCompra');/* NUEVO */
$routes->add('obtener-datos-detalle-orden-compra','OrdenCompra::obtenerDatosDetalleOrdenCompra');
$routes->add('actualizar-detalle-orden-compra/(:any)','OrdenCompra::modificarDetalleOrdenCompra/$1');
$routes->add('validar-cambio-estado-orden-compra','OrdenCompra::validarCambioEstadoOrdenCompra');
$routes->add('cambiar-estado-orden-compra','OrdenCompra::modificarEstadoOrdenCompra');
$routes->add('cambiar-estado-detalle-orden-compra','OrdenCompra::modificarEstadoDetalleOrdenCompra');/* NUEVO */
$routes->add('ver-pdf-orden-compra/(:any)','OrdenCompra::verPDFOrdenCompra/$1');/* NUEVO */
$routes->add('compras-grafica','OrdenCompra::obtenerDatosGraficaCompra');/* NUEVO */
$routes->add('importar-orden-compra','OrdenCompra::importarCSVOrdenCompra');/* NUEVO */
$routes->add('exportar-orden-compra/(:any)/(:any)','OrdenCompra::exportarOrdenCompra/$1/$2');/* NUEVO */
$routes->add('listar-comprobantes-orden-compra/(:any)','OrdenCompra::listarComprobanteOrdenCompra/$1');/* NUEVO */
$routes->add('guardar-validacion-comprobantes-orden-compra','OrdenCompra::guardarValidacionComprobantesOrdenCompra');/* NUEVO */
// $routes->add('registrar-proveedor','Configuracion::registrarProveedor');/* NUEVO */
// $routes->add('obtener-datos-proveedor','Configuracion::obtenerDatosProveedor');/* NUEVO */
// $routes->add('recargar-tabla-modalidad-pago-proveedor','Configuracion::recargarTablaModalidadPagoProveedor');/* NUEVO */
// $routes->add('cambiar-estado-modalidad-pago-proveedor','Configuracion::modificarEstadoModalidadPagoProveedor');/* NUEVO */

$routes->add('obtener-datos-comprobante-orden-compra','OrdenCompra::obtenerDatosComprobanteOrdenCompra');/* NUEVO */
$routes->add('comprobantes-pendientes-validacion','OrdenCompra::listarComprobantesPendientesValidacion');/* NUEVO */
$routes->add('validacion-comprobante-oc','OrdenCompra::registrarValidacionComprobanteOrdenCompra');/* NUEVO */
/******************************************************************************/
	
/****************************** REMOTOS **************************************/

$routes->add('listado-region-pais','Remotos::listadoRegionPais');/* NUEVO */
$routes->add('listado-region-departamentos','Remotos::listadoRegionDepartamento');/* NUEVO */
$routes->add('listado-region-provincias','Remotos::listadoRegionProvincia');/* NUEVO */
$routes->add('listado-region-distritos','Remotos::listadoRegionDistrito');/* NUEVO */
$routes->add('listado-monedas','Remotos::listadoMonedas');/* NUEVO */

$routes->add('listado-direccion-estructura','Remotos::listadoDireccionesEstructura');/* NUEVO */
$routes->add('listado-area-estructura','Remotos::listadoAreasEstructura');/* NUEVO */
$routes->add('listado-subarea-estructura','Remotos::listadoSubareasEstructura');/* NUEVO */
$routes->add('listado-delegacion-estructura','Remotos::listadoDelegacionEstructura');/* NUEVO */
$routes->add('listado-estructura-delegacion','Remotos::listadoEstructuraDelegacion');/* NUEVO */
$routes->add('exportar-estructura-departamental','Remotos::exportarEstructuraDepartamental');/* NUEVO */

$routes->add('listado-responsables-direccion-estructura','Remotos::listadoResponsablesDireccionEstructura');/* NUEVO */
$routes->add('listado-responsables-area-estructura','Remotos::listadoResponsablesAreaEstructura');/* NUEVO */
$routes->add('listado-responsables-subarea-estructura','Remotos::listadoResponsablesSubareaEstructura');/* NUEVO */