<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<div class="row">
                <div class="col-lg-12">
                    <div class="card mt-n4 mx-n4 mb-n5">
                        <div class="bg-sistema-50 color-white">
                            <div class="card-body pb-4 mb-5">
                                <div class="row">
                                    <div class="col-md">
                                        <div class="row align-items-center px-3">
                                            <div class="col-md">
                                                <h4 class="fw-semibold color-white" id="ticket-title">#<?= $ordenCompra['IDOrdenCompra'] ?> - <?= $ordenCompra['Concepto'] ?></h4>
                                                <div class="hstack gap-3 flex-wrap">
                                                    <div class="text-muted color-white">Fecha de Pedido : <span class="fw-medium"><?= date("d-m-Y", strtotime($ordenCompra['FechaPedido'])) ?></span></div>
                                                    <div class="vr"></div>
                                                </div>
                                            </div>
                                            <!--end col-->
                                        </div>
                                        <!--end row-->
                                    </div>
                                    <!--end col-->
                                    <div class="col-md-auto mt-md-0 mt-4 d-flex justify-content-end align-items-center">
                                        <div class="hstack gap-1 flex-wrap">
                                            <!--<button type="button" class="btn bg-crea px-2 py-1">-->
                                            <!--    <i class="" style="font-size: 24px; color: #FFF"></i>-->
                                            <!--</button>-->
                                            <?php
                                            if(in_array("ADCOOC", $permisos) && empty($comprobantes))
                                            {
                                            ?>
                                            <button type="button" class="btn bg-success color-white px-2 py-1 mx-1" data-bs-target="#adjuntarFacturasOC" data-oc="<?= $ordenCompra['IDOrdenCompra'] ?>" id="btnAdjuntarComprobantesOC" data-tooltip="tooltip" title="Adjuntar Factura">
                								<i class="mdi mdi-plus-circle m-0" style="font-size: 24px;"></i>
                							</button>
                                            <?php
                                            }
                                            ?>
                                            <button type="button" class="btn bg-warning waves-effect waves-light layout-rightside-btn color-white px-2 py-1 mx-1" data-bs-toggle="offcanvas" data-bs-target="#informacionComprobanteOrdenCompra" aria-controls="informacionComprobanteOrdenCompra" data-tooltip="tooltip" title="Información de Orden de Compra">
                                                <i class="mdi mdi-information m-0" style="font-size: 24px;"></i>
                                            </button>
                                            <a href="<?= $baseUrl.'/'.$previo ?>" class="btn bg-red-verisure-50 color-white px-2 py-1 mx-1" data-tooltip="tooltip" title="Volver">
                                                <i class="mdi mdi-arrow-left-circle color-white" style="font-size: 24px;"></i>
                                            </a>
                                        </div>
                                    </div>
                                    <!--end col-->
                                </div>
                                <!--end row-->
                            </div><!-- end card body -->
                        </div>
                    </div><!-- end card -->
                </div><!-- end col -->
            </div><!-- end row -->
            
            <?php
            $idPdf = "0";
            $idXml = "0";
            $validoXml = "N";
            $validoPdf = "N";
            $existepdf = false;
            $existexml = false;
            
            if(!empty($comprobantes))
            {
                foreach($comprobantes as $item)
                {
                    if($item['Extension'] == "pdf")
                    {
                        $idPdf = $item['IDDetalleComprobante'];
                        $existepdf = true;
                        $validoPdf = $item['ComprobanteValido'];
                    }
                    
                    if($item['Extension'] == "xml")
                    {
                        $idXml = $item['IDDetalleComprobante'];
                        $existexml = true;
                        $validoXml = $item['ComprobanteValido'];
                    }
                }
            }
            ?>

            <div class="row">
                <div class="col-xxl-12">
                    <div class="card">
                        <div class="card-header d-flex align-items-center">
                            <h3 class="mb-0 flex-grow-1">Comprobantes</h3>
                            <div class="d-flex">
                                <?php
                                if(in_array("APCOOC", $permisos))
                                {
                                ?>
                                <button type="button" class="btn <?= $pdfValidacion && $xmlValidacion ? "bg-success" : "bg-sistema" ?> color-white px-2 py-1 mx-1" data-bs-target="#validarFacturaOrdenCompra" data-oc="<?= $ordenCompra['IDOrdenCompra'] ?>" id="btnGuardarValidacionFacturaOC" data-tooltip="tooltip" title="Validar Comprobante Adjuntado">
                                    <i class="mdi mdi-arrow-decision m-0" style="font-size: 24px;"></i>
                                </button>
                                <?php
                                }
                                
                                if(!empty($comprobantes) && $existexml)
                                {
                                ?>
                                <a class="btn bg-info color-white px-2 py-1 mx-1" href="<?= base_url().'/descargar-adjunto-comprobante/'.$idXml ?>" data-tooltip="tooltip" title="Descargar XML">
                                    <i class="mdi mdi-xml m-0" style="font-size: 24px;" ></i>
                                </a>
                                <?php
                                }
                                ?>
                            </div>
                        </div>
                        <div class="row col-12 card-body m-0 p-0">
                            <?php
                            if(!empty($comprobantes) && $existepdf)
                            {
                            ?>
                            <div class="col-12 col-lg-6 p-2">
                                <div class="card border-sistema-2px">
                                    <div class="card-header bg-sistema">
                                        <h4 class="mb-0 color-white">PDF Adjunto</h4>
                                    </div>
                                    <div class="row col-12 card-body m-0 p-0">
                                        <embed src="<?= $baseUrl ?>/mostrar-adjunto-comprobante/<?= $idPdf ?>" width="100%" height="800px" type="application/pdf">
                                    </div>
                                </div>
                            </div>
                            <?php
                            }
                            ?>
                            <div class="col-12 col-lg-6 p-2">
                                <div class="card border-sistema-2px">
                                    <div class="card-header bg-sistema">
                                        <h4 class="mb-0 color-white">Orden de Compra</h4>
                                    </div>
                                    <div class="row col-12 card-body m-0 p-0 px-3">
                                        <embed src="<?= $baseUrl ?>/mostrar-orden-compra-comprobante/<?= $ordenCompra['IDOrdenCompra'] ?>" width="100%" height="800px" type="application/pdf">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->


<div class="offcanvas offcanvas-end border-0" tabindex="-1" id="informacionComprobanteOrdenCompra" aria-modal="true" role="dialog">
    <div class="d-flex align-items-center bg-sistema bg-gradient p-3 offcanvas-header">
        <h5 class="m-0 me-2 text-white">Información de Comprobante</h5>
        <button type="button" class="btn-close btn-close-white ms-auto" id="customizerclose-btn" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body p-0">
        <div data-simplebar="init" class="h-100 simplebar-scrollable-y">
            <div class="simplebar-wrapper" style="margin: 0px;">
                <div class="simplebar-height-auto-observer-wrapper">
                    <div class="simplebar-height-auto-observer">
                        
                    </div>
                </div>
                <div class="simplebar-mask">
                    <div class="simplebar-offset" style="right: 0px; bottom: 0px;">
                        <div class="simplebar-content-wrapper" tabindex="0" role="region" aria-label="scrollable content" style="height: 100%; overflow: hidden scroll;">
                            <div class="simplebar-content px-3">
                                <div class="col-12 px-3 my-3">
        							<div>
        								<label class="form-label fw-bold color-sistema">Orden de Compra</label>
        								<label class="form-control color-sistema">#<?= $ordenCompra['IDOrdenCompra'] ?></label>
        							</div>
        						</div>
        						<hr class="m-0 p-0">
        						<div class="col-12 px-3 my-3">
        							<div>
        								<label class="form-label fw-bold">Concepto</label>
        								<label class="form-control"><?= $ordenCompra['Concepto'] ?></label>
        							</div>
        						</div>
        						<hr class="m-0 p-0">
        						<div class="col-12 px-3 my-3">
        							<div>
        								<label class="form-label fw-bold">CC - LN</label>
        								<label class="form-control"><?= $ordenCompra['CC'].' - '.$ordenCompra['LN'] ?></label>
        							</div>
        						</div>
        						<hr class="m-0 p-0">
        						<div class="col-12 px-3 my-3">
        							<div>
        								<label class="form-label fw-bold">Nro Factura</label>
        								<label class="form-control"><?= $ordenCompra['NroFactura'] != '' && $ordenCompra['NroFactura'] != null ? $ordenCompra['NroFactura'] : "Sin Información" ?></label>
        							</div>
        						</div>
        						<hr class="m-0 p-0">
        						<div class="col-12 px-3 my-3">
        							<div>
        								<label class="form-label fw-bold">Fecha Emisión Factura</label>
        								<label class="form-control"><?= $ordenCompra['FechaEmisionFactura'] != '' && $ordenCompra['FechaEmisionFactura'] != null ? date("Y-m-d", strtotime($ordenCompra['FechaEmisionFactura'])) : "Sin Información" ?></label>
        							</div>
        						</div>
        						<hr class="m-0 p-0">
        						<div class="col-12 px-3 my-3">
        							<div>
        								<label class="form-label fw-bold">Moneda</label>
        								<label class="form-control"><?= $ordenCompra['TipoMoneda'] != '' && $ordenCompra['TipoMoneda'] != null ? $moneda[$ordenCompra['TipoMoneda']]['NOMBRE'].' ('.$moneda[$ordenCompra['TipoMoneda']]['SIMBOLO'].')' : '' ?></label>
        							</div>
        						</div>
        						<hr class="m-0 p-0">
        						<div class="col-12 px-3 my-3">
        							<div>
        								<label class="form-label fw-bold">Total</label>
        								<label class="form-control"><?= $ordenCompra['Total'] ?></label>
        							</div>
        						</div>
        						<hr class="m-0 p-0">
        						<!--<div class="col-12 px-3 my-3">-->
        						<!--	<div>-->
        						<!--		<label class="form-label fw-bold">Forma de Pago</label>-->
        						<!--		<label class="form-control"><?= $ordenCompra['descripcionFormaPago'] ?></label>-->
        						<!--	</div>-->
        						<!--</div>-->
        						<!--<hr class="m-0 p-0">-->
        						<?php
        						
        						$ultimoDiaPago = (string) $ordenCompra['FechaEmisionFactura'] != '' && $ordenCompra['FechaEmisionFactura'] != null ? date("Y-m-d", strtotime($ordenCompra['FechaEmisionFactura'].'+ '.$ordenCompra['DiasPago'].' days')) : "";
        						
        						if($ultimoDiaPago != '')
        						{
        						    
            						$fecha = new DateTime($ultimoDiaPago);
            						
            						// Verificamos si la fecha ya es viernes
                                    if ($fecha->format('l') !== 'Friday') {
                                        // Si no es viernes, buscamos el próximo viernes
                                        $fecha->modify('next friday');
                                    }

        						    $viernesProximo = $fecha->format('Y-m-d');
        						}
        						else
        						{
        						    $viernesProximo = "Sin información";
        						}
        						
        						?>
        						<!--<div class="col-12 px-3 my-3">-->
        						<!--	<div>-->
        						<!--		<label class="form-label fw-bold">Fecha de Pago</label>-->
        						<!--		<label class="form-control"><?= $viernesProximo ?></label>-->
        						<!--	</div>-->
        						<!--</div>-->
        						<hr class="m-0 p-0">
        						<div class="col-12 px-3 my-3">
        							<div>
        								<label class="form-label fw-bold">Cuenta Contable</label>
        								<label class="form-control"><?= $ordenCompra['CuentaContable'] != '' && $ordenCompra['CuentaContable'] != NULL ? $ordenCompra['CodigoCuentaContable'].' | '.$ordenCompra['CuentaContable'] : "Sin Información" ?></label>
        							</div>
        						</div>
        						<hr class="m-0 p-0">
        						<div class="col-12 px-3 my-3">
        							<div>
        								<label class="form-label fw-bold">Categoría</label>
        								<label class="form-control"><?= $ordenCompra['Categoria'] != '' && $ordenCompra['Categoria'] != NULL ? $ordenCompra['Categoria'] : "Sin Información"?></label>
        							</div>
        						</div>
        						<hr class="m-0 p-0">
        						<div class="col-12 px-3 my-3">
        							<div>
        								<label class="form-label fw-bold">Subcategoría</label>
        								<label class="form-control"><?= $ordenCompra['Subcategoria'] != '' && $ordenCompra['Subcategoria'] != NULL ? $ordenCompra['Subcategoria'] : "Sin Información"?></label>
        							</div>
        						</div>
        						<hr class="m-0 p-0">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="simplebar-placeholder" style="width: 400px; height: 1978px;">
                    
                </div>
            </div>
            <div class="simplebar-track simplebar-horizontal" style="visibility: hidden;">
                <div class="simplebar-scrollbar" style="width: 0px; display: none;">
                    
                </div>
            </div>
            <div class="simplebar-track simplebar-vertical" style="visibility: visible;">
                <div class="simplebar-scrollbar" style="height: 314px; transform: translate3d(0px, 0px, 0px); display: block;">
                    
                </div>
            </div>
        </div>
    </div>
    <div class="offcanvas-footer border-top p-3 text-center">
        <div class="row">
            <div class="col-4">
                <button type="button" class="btn btn-danger w-100" data-bs-dismiss="offcanvas" aria-label="Close">Cerrar</button>
            </div>
        </div>
    </div>
</div>


<!-- Modal Adjuntar Comprobante XML -->
<!--<div class="modal fade zoomIn" id="reemplazarComprobantexml" data-bs-backdrop="static" role="dialog" aria-labelledby="examplereemplazarComprobantexml" aria-hidden="true">-->
<!--	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">-->
<!--		<div class="modal-content" style="border: none;">-->
<!--			<div class="modal-header bg-sistema p-3">-->
<!--				<h5 class="modal-title color-white" id="examplereemplazarComprobantexml">Adjuntar XML</h5>-->
<!--				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>-->
<!--			</div>-->
<!--			<form id="formReemplazarComprobanteXML" class="formularioReemplazarComprobanteXML" action="<?= $baseUrl ?>/reemplazar-comprobante-orden-compra" method="POST" enctype="multipart/form-data" autocomplete="off" accept-charset="utf-8">-->
				
<!--				<div class="row modal-body">-->
<!--				    <input type="hidden" class="txtIDComprobanteOC_rfoc" id="txtIDComprobanteOC_rfoc" name="txtIDComprobanteOC_rfoc">-->
					
<!--    				<h3 class="mb-3">Comprobantes</h3>-->
<!--    				<div class="col-xxl-12 col-lg-12 d-flex justify-content-center">-->
<!--                        <div class="col-8 card card-height-100 border-sistema-2px px-3">-->
<!--                            <div class="card-header align-items-center d-flex">-->
<!--                                <h4 class="card-title mb-0 flex-grow-1 text-center">XML</h4>-->
<!--                            </div><!-- end card header -->-->
<!--                            <hr class="m-0 p-0">-->
<!--                            <div class="card-body p-0 m-0 pt-3 d-flex justify-content-center">-->
<!--                                <div class="col-12 m-0 p-0">-->
<!--        					        <input type="file" id="txtXMLOC_poc" class="filepond" name="txtXMLOC_poc" data-max-file-size="100MB" data-max-files="1" />-->
<!--        					    </div>-->
<!--                            </div><!-- end cardbody -->-->
<!--                        </div><!-- end card -->-->
<!--                    </div>-->
<!--    				<hr class="m-0">-->
<!--    				<span class="row col-12 m-0 py-2 justify-content-center respuesta"></span>-->
<!--				</div>-->
<!--				<div class="modal-footer">-->
<!--					<button type="button" class="btn bg-danger d-flex justify-content-end align-items-center color-white" data-bs-dismiss="modal"><span class="mdi mdi-close-thick me-2" style="font-size: 14px;"></span>Cerrar</button>-->
<!--					<button type="submit" class="btn bg-success d-flex justify-content-end align-items-center color-white"><i class="mdi mdi-file-upload me-2 color-white" style="font-size: 14px;"></i>Importar</button>-->
<!--				</div>-->
<!--			</form>-->
<!--		</div>-->
<!--	</div>-->
<!--</div>-->

<!-- Modal Adjuntar Comprobante PDF -->
<!--<div class="modal fade zoomIn" id="reemplazarComprobantepdf" data-bs-backdrop="static" role="dialog" aria-labelledby="examplereemplazarComprobantepdf" aria-hidden="true">-->
<!--	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">-->
<!--		<div class="modal-content" style="border: none;">-->
<!--			<div class="modal-header bg-sistema p-3">-->
<!--				<h5 class="modal-title color-white" id="examplereemplazarComprobantepdf">Adjuntar PDF</h5>-->
<!--				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>-->
<!--			</div>-->
<!--			<form id="formReemplazarComprobantePDF" class="formularioReemplazarComprobantePDF" action="<?= $baseUrl ?>/reemplazar-comprobante-orden-compra" method="POST" enctype="multipart/form-data" autocomplete="off" accept-charset="utf-8">-->
				
<!--				<div class="row modal-body">-->
<!--				    <input type="hidden" class="txtIDComprobanteOC_rfoc" id="txtIDComprobanteOC_rfoc" name="txtIDComprobanteOC_rfoc">-->
					
<!--    				<h3 class="mb-3">Comprobantes</h3>-->
<!--    				<div class="col-xxl-12 col-lg-12 d-flex justify-content-center">-->
<!--                        <div class="card card-height-100 border-sistema-2px px-3">-->
<!--                            <div class="card-header align-items-center d-flex">-->
<!--                                <h4 class="card-title mb-0 flex-grow-1 text-center">PDF</h4>-->
<!--                            </div><!-- end card header -->-->
<!--                            <hr class="m-0 p-0">-->
<!--                            <div class="card-body p-0 m-0 pt-3 d-flex justify-content-center">-->
<!--                                <div class="col-12 m-0 p-0">-->
<!--        					        <input type="file" id="txtPDFOC_poc" class="filepond" name="txtPDFOC_poc" data-max-file-size="100MB" data-max-files="1" />-->
<!--        					    </div>-->
<!--                            </div><!-- end cardbody -->-->
<!--                        </div><!-- end card -->-->
<!--                    </div>-->
<!--    				<hr class="m-0">-->
<!--    				<span class="row col-12 m-0 py-2 justify-content-center respuesta"></span>-->
<!--				</div>-->
<!--				<div class="modal-footer">-->
<!--					<button type="button" class="btn bg-danger d-flex justify-content-end align-items-center color-white" data-bs-dismiss="modal"><span class="mdi mdi-close-thick me-2" style="font-size: 14px;"></span>Cerrar</button>-->
<!--					<button type="submit" class="btn bg-success d-flex justify-content-end align-items-center color-white"><i class="mdi mdi-file-upload me-2 color-white" style="font-size: 14px;"></i>Importar</button>-->
<!--				</div>-->
<!--			</form>-->
<!--		</div>-->
<!--	</div>-->
<!--</div>-->

<!-- Modal Validar Factura Orden de Compra -->
<div class="modal fade zoomIn" id="validarFacturaOrdenCompra" data-bs-backdrop="static" role="dialog" aria-labelledby="examplevalidarFacturaOrdenCompra" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-md" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="examplevalidarFacturaOrdenCompra">Validar Factura de Orden de Compra</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formValidarFacturaOrdenCompra" class="formulario" action="<?= $baseUrl ?>/validar-factura-orden-compra" method="POST" enctype="multipart/form-data" autocomplete="off" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="row modal-body" id="ctnValidarFacturaOrdenCompra">
				    <input type="hidden" id="txtIDOrdenCompra_vfoc" name="txtIDOrdenCompra_vfoc" value="<?= $ordenCompra['IDOrdenCompra'] ?>">
                    <div class="col-6 p-3">
                        <div class="card border-sistema-25 m-0">
                            <div class="card-header">
                                <h5 class="card-title mb-0 fw-bold text-center">¿XML Válido?</h5>
                            </div>
                            <div class="card-body d-flex justify-content-center bd-highlight px-5">
                                <!--<div class=" mb-0 justify-content-center">-->
                                    <input type="radio" class="btn-check" name="detallecomprobante[<?= $idXml ?>]" id="success-outlined-<?= $idXml ?>" value="Y" >
                                    <label class="btn btn-icon btn-outline-success me-auto bd-highlight m-0" for="success-outlined-<?= $idXml ?>">Si</label>
                                
                                    <input type="radio" class="btn-check" name="detallecomprobante[<?= $idXml ?>]" id="danger-outlined-<?= $idXml ?>" value="N" >
                                    <label class="btn btn-icon btn-outline-danger bd-highlight m-0" for="danger-outlined-<?= $idXml ?>">No</label>
                                <!--</div>-->
                            </div>
                        </div>
                    </div>
                    <div class="col-6 p-3">
                        <div class="card border-sistema-25 m-0">
                            <div class="card-header">
                                <h5 class="card-title mb-0 fw-bold text-center">¿PDF Válido?</h5>
                            </div>
                            <div class="card-body d-flex justify-content-center bd-highlight px-5">
                                <!--<div class="flex-shrink-0 mb-0 justify-content-center">-->
                                    <input type="radio" class="btn-check" name="detallecomprobante[<?= $idPdf ?>]" id="success-outlined-<?= $idPdf ?>" value="Y" >
                                    <label class="btn btn-icon btn-outline-success me-auto bd-highlight m-0" for="success-outlined-<?= $idPdf ?>">Si</label>
                                
                                    <input type="radio" class="btn-check" name="detallecomprobante[<?= $idPdf ?>]" id="danger-outlined-<?= $idPdf ?>" value="N" >
                                    <label class="btn btn-icon btn-outline-danger bd-highlight m-0" for="danger-outlined-<?= $idPdf ?>">No</label>
                                <!--</div>-->
                            </div>
                        </div>
                    </div>
                    <div class="col-12 col-md-12 my-2">
						<div class="col-12 border-sistema-2px p-2 d-flex justify-content-between align-items-center" style="border-radius: 15px;">
						    <h5 class="color-sistema m-0" for="chkDetraccion_vfoc">¿Detracción?</h5>
						    <div class="form-check form-switch form-switch-lg d-flex justify-content-start align-items-center" for="chkDetraccion_vfoc">
								<input class="form-check-input form-check-input-sistema" type="checkbox" role="switch" name="chkDetraccion_vfoc" id="chkDetraccion_vfoc">
								<label class="form-check-label m-0" for="chkDetraccion_vfoc"></label>
							</div>
						</div>
					</div>
                    <div class="col-12 my-2">
                        <div class="form-group">
                            <label for="cboCodigoDetraccion_vfoc">Código Detracción</label>
                            <select class="form-select" id="cboCodigoDetraccion_vfoc" name="cboCodigoDetraccion_vfoc" disabled>
                            </select>
                        </div>
                    </div>
                    <!--<div class="col-12 my-2">-->
                    <!--    <div class="form-group">-->
                    <!--        <label for="cboSunat10_vfoc">Sunat 10</label>-->
                    <!--        <select class="form-select" id="cboSunat10_vfoc" name="cboSunat10_vfoc">-->
                    <!--        </select>-->
                    <!--    </div>-->
                    <!--</div>-->
				</div>

				<div class="modal-footer">
					<button type="button" class="btn bg-danger d-flex justify-content-end align-items-center color-white" data-bs-dismiss="modal"><span class="mdi mdi-close-thick me-2" style="font-size: 14px;"></span>Cerrar</button>
					<button type="submit" class="btn bg-success d-flex justify-content-end align-items-center color-white"><i class="mdi mdi-save me-2 color-white" style="font-size: 14px;"></i>Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<!-- Modal Adjuntar Validación -->
<div class="modal fade zoomIn" id="adjuntarFacturasOC" data-bs-backdrop="static" role="dialog" aria-labelledby="exampleadjuntarFacturasOC" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleadjuntarFacturasOC">Adjuntar Factura</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formAdjuntarFacturaOC" class="formularioAdjuntarFacturaOC" action="<?= $baseUrl ?>/adjuntar-factura-orden-compra" method="POST" enctype="multipart/form-data" autocomplete="off" accept-charset="utf-8">
				
				<div class="row modal-body">
				    <input type="hidden" id="txtIDOrdenCompra_rfoc" name="txtIDOrdenCompra_rfoc">
					<!--<h3 class="mb-3">Orden de Compra</h3>-->
    			    <!--<div class="row m-0 mb-3">-->
    					<div class="col-xxl-8 col-md-12 col-12 mb-3">
    						<div>
    							<label for="txtNroOrdenCompra" class="form-label" style="color: #0A497B;">Nro Orden de Compra</label>
    							<input type="text" class="form-control" style="color: #0A497B; border-color: #0A497B;" id="txtNroOrdenCompra" name="txtNroOrdenCompra" disabled>
    						</div>
    					</div>
    					<div class="col-xxl-12 col-md-12 col-12 mb-3">
    						<div>
    							<label for="txtConceptoOrdenCompra" class="form-label">Concepto</label>
    							<input type="text" class="form-control" id="txtConceptoOrdenCompra" name="txtConceptoOrdenCompra" disabled>
    						</div>
    					</div>
    					<div class="col-xxl-12 col-md-12 col-12 mb-3">
    						<div>
    							<label for="txtProveedorOrdenCompra" class="form-label">Proveedor</label>
    							<input type="text" class="form-control" id="txtProveedorOrdenCompra" name="txtProveedorOrdenCompra" disabled>
    						</div>
    					</div>
    					<div class="col-xxl-6 col-md-12 col-12 mb-3">
    						<div>
    							<label for="txtFechaEmisionOrdenCompra" class="form-label">Fecha Emisión</label>
    							<input type="date" class="form-control" id="txtFechaEmisionOrdenCompra" name="txtFechaEmisionOrdenCompra" disabled>
    						</div>
    					</div>
    					<div class="col-xxl-6 col-md-12 col-12 mb-3">
    					    <label for="txtMontoTotalOrdenCompra" class="form-label">Monto Total</label>
    						<div class="input-group">
                                <span class="input-group-text" id="spnSimboloMontoOrdenCompra">S/</span>
                                <input type="number" step="0.01" class="form-control" placeholder="Monto Total" id="txtMontoTotalOrdenCompra" name="txtMontoTotalOrdenCompra" aria-label="Monto Total" aria-describedby="basic-addon1" disabled>
                            </div>
    					</div>
    				<!--</div>-->
    				<hr>
    				<h3 class="mb-3">Comprobantes</h3>
    				<div class="col-xxl-6 col-lg-6">
                        <div class="card card-height-100 border-sistema-2px px-3">
                            <div class="card-header align-items-center d-flex">
                                <h4 class="card-title mb-0 flex-grow-1 text-center">XML</h4>
                            </div><!-- end card header -->
                            <hr class="m-0 p-0">
                            <div class="card-body p-0 m-0 pt-3 d-flex justify-content-center">
                                <div class="col-12 m-0 p-0">
        					        <input type="file" id="txtXMLOC_poc" class="filepond" name="txtXMLOC_poc" data-max-file-size="100MB" data-max-files="1" />
        					    </div>
                            </div><!-- end cardbody -->
                        </div><!-- end card -->
                    </div>
    				<div class="col-xxl-6 col-lg-6">
                        <div class="card card-height-100 border-sistema-2px px-3">
                            <div class="card-header align-items-center d-flex">
                                <h4 class="card-title mb-0 flex-grow-1 text-center">PDF</h4>
                            </div><!-- end card header -->
                            <hr class="m-0 p-0">
                            <div class="card-body p-0 m-0 pt-3 d-flex justify-content-center">
                                <div class="col-12 m-0 p-0">
        					        <input type="file" id="txtPDFOC_poc" class="filepond" name="txtPDFOC_poc" data-max-file-size="100MB" data-max-files="1" />
        					    </div>
                            </div><!-- end cardbody -->
                        </div><!-- end card -->
                    </div>
    				<hr class="m-0">
    				<span class="row col-12 m-0 py-2 justify-content-center respuesta"></span>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger d-flex justify-content-end align-items-center color-white" data-bs-dismiss="modal"><span class="mdi mdi-close-thick me-2" style="font-size: 14px;"></span>Cerrar</button>
					<button type="submit" class="btn bg-success d-flex justify-content-end align-items-center color-white"><i class="mdi mdi-file-upload me-2 color-white" style="font-size: 14px;"></i>Importar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<?= $this->section('js'); ?>
<script>
	$(function () {
		pondXMLProveedor = FilePond.create(
            document.querySelector("#txtXMLOC_poc"), {
                labelIdle: 'Arrastre y suelte el XML asociado a la OC o <span class="filepond--label-action">explore</span>',
                allowMultiple: false,
                instantUpload: false,
                allowProcess: false,
                acceptedFileTypes: ['text/xml', 'application/xml'],
                onaddfile: (file) => {
                    // Validación manual por extensión
                    const allowedExtensions = /(\.xml)$/i;
                    if (!allowedExtensions.exec(file.name)) {
                        Swal.fire({
                            text: "El formato del archivo debe ser XML.",
                            icon: 'warning',
                            showCancelButton: false,
                            cancelButtonText: 'No',
                            confirmButtonColor: '#282e38',
                            confirmButtonText: 'OK'
                        });
                        // Remover el archivo
                        pondXMLProveedor.removeFile(file.id);
                        return false; // Detener el envío del archivo
                    }
                    return true; // Permitir el archivo
                }
            }
        );
		pondPDFProveedor = FilePond.create(
            document.querySelector("#txtPDFOC_poc"), {
                labelIdle: 'Arrastre y suelte el PDF asociado a la OC o <span class="filepond--label-action">explore</span>',
                allowMultiple: false,
                instantUpload: false,
                allowProcess: false,
                acceptedFileTypes: ['application/pdf'],
                onaddfile: (file) => {
                    // Validación manual por extensión
                    const allowedExtensions = /(\.pdf)$/i;
                    if (!allowedExtensions.exec(file.name)) {
                        Swal.fire({
                            text: "El formato del archivo debe ser PDF.",
                            icon: 'warning',
                            showCancelButton: false,
                            cancelButtonText: 'No',
                            confirmButtonColor: '#282e38',
                            confirmButtonText: 'OK'
                        });
                        // Remover el archivo
                        pondPDFProveedor.removeFile(file.id);
                        return false; // Detener el envíodel archivo
                    }
                    return true; // Permitir el archivo
                }
            }
        );
	});
</script>
<?php $this->endSection(); ?>
<?php $this->endSection(); ?>