<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb_alias ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $breadcrumb_alias ?></h5>
                            <div class="d-flex">
								<?php
								if (in_array("ADSBCC", $permisos)) 
								{
								?>
                                <button class="btn btn-primary datos-subcategoria-cc mx-2 d-flex justify-content-end align-items-center" data-bs-target="#informacionSubcategoriaCuentaContable" data-id="0" data-accion="crear" id="crear-subcategoria-cc">
									<i class="mdi mdi-plus-circle me-2" style="font-size: 18px;"></i> Agregar
								</button>
								<?php
								}
								?>
								<a href="<?= $baseUrl.'/'.$previo ?>" class="btn px-2 py-0 d-flex justify-content-end align-items-center" style="background-color: red;"><i class="mdi mdi-arrow-left-circle" style="font-size: 24px; color: #FFF"></i></a>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblSubcategoriasCuentaContable" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								<thead>
									<tr>
										<th class="text-center align-middle">Correlativo</th>
										<th class="text-center align-middle">Subcategoría</th>
										<th class="text-center align-middle">Observación</th>
										<th class="text-center align-middle">Estado</th>
										<th class="text-center align-middle">Acciones</th>
									</tr>
								</thead>
								<tbody>
									<?php 
									foreach($listaSubcategorias as $items){ ?>
									<tr>
										<td class="text-center align-middle"><?= $items['IDSubcategoriaCC'] ?></td>
										<td class="text-center align-middle"><?= $items['Subcategoria'] ?></td>
										<td class="text-center align-middle"><?= $items['Observacion'] ?></td>
										<td class="text-center align-middle">
										<?php
										if (in_array("ESSBCC", $permisos)) 
										{
										?>
											<button class="badge <?= $items['Estado'] == "A" ? 'bg-success' : 'bg-warning' ?> border-0 cambiar-estado-subcategoria-cc" data-estado="<?= $items['Estado'] ?>" data-id="<?=$items['IDSubcategoriaCC'] ?>"><?= $items['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO' ?></button>
										<?php
										}
										else
										{
										?>
											<span class="badge <?= $items['Estado'] == "A" ? 'bg-success' : 'bg-warning' ?> border-0" ><?= $items['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO' ?></span>
										<?php
										}
										?>
										</td>
										<td class="text-center align-middle">
											<div class="dropdown d-inline-block">
												<button class="btn btn-soft-secondary btn-sm dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">
													<i class="ri-more-fill align-middle"></i>
												</button>
												<ul class="dropdown-menu dropdown-menu-end">
													<li>
														<a href="#!" class="dropdown-item datos-subcategoria-cc" data-bs-target="#informacionSubcategoriaCuentaContable" data-id="<?= $items['IDSubcategoriaCC'] ?>" data-accion="ver" id="ver-subcategoria-cc">
															<i class="ri-eye-fill align-bottom me-2 text-muted"></i> Ver
														</a>
													</li>
													<?php
													if (in_array("UPCACC", $permisos)) 
													{
													?>
													<li>
														<a href="#!" class="dropdown-item edit-item-btn datos-subcategoria-cc" data-bs-target="#informacionSubcategoriaCuentaContable" data-id="<?= $items['IDSubcategoriaCC'] ?>" data-accion="editar" id="editar-subcategoria-cc">
															<i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Editar
														</a>
													</li>
													<?php
													}
													?>
												</ul>
											</div>
										</td>
									</tr>
									<?php } ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->
<!-- Modal Información Categoria -->
<div class="modal fade zoomIn" id="informacionSubcategoriaCuentaContable" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleinformacionSubcategoriaCuentaContable" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleinformacionSubcategoriaCuentaContable">Información de la subcategoría</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formInformacionSubcategoriasCuentaContable" class="formulario" autocomplete="off" action="" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" id="txtIDCategoriaCC_i" name="txtIDCategoriaCC_i" value="<?= $categoria['IDCategoriaCC'] ?>">
					<input type="hidden" id="txtIDSubcategoriaCC_i" name="txtIDSubcategoriaCC_i">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtSubcategoriaCC_i" class="form-label">Subcategoría</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Subcategoría" id="txtSubcategoriaCC_i" name="txtSubcategoriaCC_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtObservacionSubcategoriaCC_i" class="form-label">Observación</label>
								<textarea class="form-control" id="txtObservacionSubcategoriaCC_i" name="txtObservacionSubcategoriaCC_i" rows="4"></textarea>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger d-flex justify-content-end align-items-center color-white" data-bs-dismiss="modal"><span class="mdi mdi-close-thick me-2" style="font-size: 18px;"></span>Cerrar</button>
					<button type="submit" id="btnEjecutarSubcategoriaCC" class="btn bg-success d-flex justify-content-end align-items-center color-white"><i class="mdi mdi-content-save me-2 color-white" style="font-size: 18px;"></i> Actualizar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<?php $this->endSection(); ?>