<?php
namespace App\Models;
use CodeIgniter\Model;

class ComprobantesPagoModel extends Model
{
    protected $table      = 'comprobantes_pago';
    protected $primaryKey = 'IDComprobante';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['TipoComprobante', 'Origen', 'IDOrigen', 'Observacion', 'NroFactura', 'FechaEmisionFactura', 'MontoFactura', 'DetraccionFactura', 'CodigoDetraccionFactura', 'Sunat10Factura', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'UsuarioCreaProveedor', 'FechaCreaProveedor', 'UsuarioModificaProveedor', 'FechaModificaProveedor', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function listadoComprobantesPagoXOrigen($array)
    {
        $this->select('comprobantes_pago.IDComprobante,
        comprobantes_pago.TipoComprobante,
        tipo_comprobante_pago.CodigoSUNAT,
        tipo_comprobante_pago.ComprobantePago,
        comprobantes_pago.Origen,
        comprobantes_pago.IDOrigen,
        comprobantes_pago.UsuarioCrea,
        comprobantes_pago.FechaCrea,
        comprobantes_pago.UsuarioCreaProveedor,
        comprobantes_pago.FechaCreaProveedor
        ');
        
        $this->join('tipo_comprobante_pago', 'comprobantes_pago.TipoComprobante = tipo_comprobante_pago.IDTipoComprobantePago', 'left');
        
        if(!empty($array))
        {
            if(isset($array['Origen']) && $array['Origen'] != ""&& $array['Origen'] != null )
            {
                $this->where('comprobantes_pago.Origen', $array['Origen']);
            }
            
            if(isset($array['IDOrigen']) && $array['IDOrigen'] != "" && $array['IDOrigen'] != null )
            {
                $this->where('comprobantes_pago.IDOrigen', $array['IDOrigen']);
            }
        }
        
        $datos = $this->findAll();
        return $datos;
    }
    

}