<?php
namespace App\Models;
use CodeIgniter\Model;

class ComprobantesPagoDetalleModel extends Model
{
    protected $table      = 'comprobantes_pago_detalle';
    protected $primaryKey = 'IDDetalleComprobante';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDComprobante', 'Nombre', 'Extension', 'Observacion', 'Token', 'ComprobanteValido', 'UsuarioValidacion', 'FechaValidacion', 'ObservacionValidacion', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'UsuarioCreaProveedor', 'FechaCreaProveedor', 'UsuarioModificaProveedor', 'FechaModificaProveedor', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    
    public function listadoDetalleComprobantesPago($array)
    {
        $this->select('comprobantes_pago.IDComprobante,
        comprobantes_pago.TipoComprobante,
        tipo_comprobante_pago.CodigoSUNAT,
        tipo_comprobante_pago.ComprobantePago,
        comprobantes_pago.Origen,
        comprobantes_pago.IDOrigen,
        comprobantes_pago.DetraccionFactura,
        comprobantes_pago.CodigoDetraccionFactura,
        comprobantes_pago.UsuarioCrea,
        comprobantes_pago.FechaCrea,
        comprobantes_pago.UsuarioCreaProveedor,
        comprobantes_pago.FechaCreaProveedor,
        comprobantes_pago_detalle.IDDetalleComprobante,
        comprobantes_pago_detalle.Nombre,
        comprobantes_pago_detalle.Extension,
        comprobantes_pago_detalle.Token,
        comprobantes_pago_detalle.UsuarioValidacion,
        comprobantes_pago_detalle.ComprobanteValido,
        comprobantes_pago_detalle.FechaValidacion');
        
        $this->join('comprobantes_pago', 'comprobantes_pago_detalle.IDComprobante = comprobantes_pago.IDComprobante');
        $this->join('tipo_comprobante_pago', 'comprobantes_pago.TipoComprobante = tipo_comprobante_pago.IDTipoComprobantePago', 'left');
        
        if(!empty($array))
        {
            if(isset($array['Origen']) && $array['Origen'] != ""&& $array['Origen'] != null )
            {
                $this->where('comprobantes_pago.Origen', $array['Origen']);
            }
            
            if(isset($array['IDOrigen']) && $array['IDOrigen'] != "" && $array['IDOrigen'] != null )
            {
                $this->where('comprobantes_pago.IDOrigen', $array['IDOrigen']);
            }
            
            if(isset($array['TipoComprobante']) && $array['TipoComprobante'] != "" && $array['TipoComprobante'] != null )
            {
                $this->where('comprobantes_pago.TipoComprobante', $array['TipoComprobante']);
            }
        }
        
        $datos = $this->findAll();
        // echo $this->getLastQuery();
        // exit;
        return $datos;
    }
    
    public function datosExportarComprobantesPago($array)
    {
        $this->select('comprobantes_pago.IDComprobante,
        comprobantes_pago.TipoComprobante,
        tipo_comprobante_pago.CodigoSUNAT,
        tipo_comprobante_pago.ComprobantePago,
        comprobantes_pago.Origen,
        comprobantes_pago.IDOrigen,
        comprobantes_pago.NroFactura,
        comprobantes_pago.FechaEmisionFactura,
        comprobantes_pago.MontoFactura,
        comprobantes_pago.DetraccionFactura,
        comprobantes_pago.CodigoDetraccionFactura,
        comprobantes_pago.UsuarioCrea,
        comprobantes_pago.FechaCrea,
        comprobantes_pago.UsuarioCreaProveedor,
        comprobantes_pago.FechaCreaProveedor');
        
        $this->join('comprobantes_pago', 'comprobantes_pago_detalle.IDComprobante = comprobantes_pago.IDComprobante');
        $this->join('tipo_comprobante_pago', 'comprobantes_pago.TipoComprobante = tipo_comprobante_pago.IDTipoComprobantePago', 'left');
        
        if(!empty($array))
        {
            if(isset($array['Origen']) && $array['Origen'] === "OC" )
            {
                $this->select('proveedor.RUC,
                ordencompra.IDOrdenCompra,
                ordencompra.Concepto,
                ordencompra.TipoMoneda,
                ordencompra.Total,
                ordencompra.Dimension,
                ordencompra.CondicionesIGV,
                cuentacontable.CodigoCuentaContable,
                dimensiones_delegacion.CC AS "Dimension_CC",
                dimensiones_delegacion.LN AS "Dimension_LN",
                dimensiones_delegacion.Porcentaje AS "Dimension_Porcentaje"');
                $this->join('ordencompra', 'comprobantes_pago.IDOrigen = ordencompra.IDOrdenCompra', 'left');
                $this->join('proveedor', 'ordencompra.IDProveedor = proveedor.IDProveedor', 'left');
                $this->join('cuentacontable_subcategorias', 'ordencompra.IDSubcategoria = cuentacontable_subcategorias.IDSubcategoriaCC', 'left');
                $this->join('cuentacontable_categorias', 'cuentacontable_subcategorias.IDCategoriaCC = cuentacontable_categorias.IDCategoriaCC', 'left');
                $this->join('cuentacontable', 'cuentacontable_categorias.IDCuentaContable = cuentacontable.IDCuentaContable', 'left');
                $this->join('dimensiones_delegacion', 'ordencompra.Dimension = dimensiones_delegacion.Delegacion', 'left');
            }
            
            if(isset($array['Origen']) && $array['Origen'] != ""&& $array['Origen'] != null )
            {
                $this->where('comprobantes_pago.Origen', $array['Origen']);
            }
            
            if(isset($array['IDOrigen']) && $array['IDOrigen'] != "" && $array['IDOrigen'] != null )
            {
                $this->where('comprobantes_pago.IDOrigen', $array['IDOrigen']);
            }
            
            if(isset($array['TipoComprobante']) && $array['TipoComprobante'] != "" && $array['TipoComprobante'] != null )
            {
                $this->where('comprobantes_pago.TipoComprobante', $array['TipoComprobante']);
            }
            
            if(isset($array['InicioValidacion']) && $array['InicioValidacion'] != "" && $array['InicioValidacion'] != null )
            {
                $this->where('comprobantes_pago_detalle.FechaValidacion >=', $array['InicioValidacion']);
            }
            
            if(isset($array['FinValidacion']) && $array['FinValidacion'] != "" && $array['FinValidacion'] != null )
            {
                $this->where('comprobantes_pago_detalle.FechaValidacion <=', $array['FinValidacion']);
            }
        }
        
        $this->groupBy('comprobantes_pago.IDComprobante, dimensiones_delegacion.CC, dimensiones_delegacion.LN');
    
        $datos = $this->findAll();
        // echo $this->getLastQuery();
        // exit;
        return $datos;
    }
    
    public function obtenerDetalleComprobantePago($idDetalleComprobante)
    {
        $this->select('comprobantes_pago.IDComprobante,
        comprobantes_pago.TipoComprobante,
        tipo_comprobante_pago.CodigoSUNAT,
        tipo_comprobante_pago.ComprobantePago,
        comprobantes_pago.Origen,
        comprobantes_pago.IDOrigen,
        comprobantes_pago.UsuarioCrea,
        comprobantes_pago.FechaCrea,
        comprobantes_pago.UsuarioCreaProveedor,
        comprobantes_pago.FechaCreaProveedor,
        comprobantes_pago_detalle.IDDetalleComprobante,
        comprobantes_pago_detalle.Nombre,
        comprobantes_pago_detalle.Extension,
        comprobantes_pago_detalle.Token,
        comprobantes_pago_detalle.UsuarioValidacion,
        comprobantes_pago_detalle.ComprobanteValido,
        comprobantes_pago_detalle.FechaValidacion');
        
        $this->join('comprobantes_pago', 'comprobantes_pago_detalle.IDComprobante = comprobantes_pago.IDComprobante', 'left');
        $this->join('tipo_comprobante_pago', 'comprobantes_pago.TipoComprobante = tipo_comprobante_pago.IDTipoComprobantePago', 'left');
        
        $this->where('comprobantes_pago_detalle.IDDetalleComprobante', $idDetalleComprobante);
        
        $datos = $this->first();
        return $datos;
    }
}