<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;

class Notificaciones extends BaseController
{
	public function __construct(){
 		
        $this->notificaciones = new \App\Models\NotificacionesModel();
        $this->notificacionesVistos = new \App\Models\NotificacionesVisualizadasModel();
	}

    public function cargarNotificacionesHeader()
    {
        if(isset($this->items['id']))
        {
            $array = array(
                "idusuario" => $this->items['id'],
                "idperfil" => $this->items['idPerfil'],
                "solonovisto" => "Y"
            );
            
		    $notificaciones = $this->notificaciones->listarNotificaciones($array);
		    
		    if(!empty($notificaciones))
		    {
		        $text = '';
		        
		        foreach($notificaciones as $item)
		        {
		            $text .= '<div class="text-reset notification-item d-block dropdown-item position-relative '.($item['UsuarioVisualizado'] == '' || $item['UsuarioVisualizado'] == null ? "bg-sistema-25" : "").' mb-2" onclick=\'return notificacionVista("'.$item['IDNotificacion'].'")\'>
                        <div class="d-flex">
                            <div class="avatar-xs me-3 flex-shrink-0">
                                <span class="avatar-title bg-sistema text-info rounded-circle fs-16">
                                    <i class="bx bx-badge-check color-white"></i>
                                </span>
                            </div>
                            <div class="flex-grow-1">
                                <a href="'.$this->items['baseUrl'].'/'.$item['URL'].'" target="_blank" class="stretched-link">
                                    <h6 class="mt-0 mb-2 lh-base">'.$item['Mensaje'].'</h6>
                                </a>
                                <p class="mb-0 fs-11 fw-medium text-uppercase text-muted d-flex justify-content-end">
                                    <span><i class="mdi mdi-clock-outline"></i> '.date("d/m/Y H:i:s", strtotime($item['FechaRegistra'])).'</span>
                                </p>
                            </div>
                        </div>
                    </div>';
		        }
		        
		      //  $text .= '<div class="my-3 text-center view-all" style="display: block;">
        //             <button type="button" class="btn btn-soft-success waves-effect waves-light">View
        //                 All Notifications <i class="ri-arrow-right-line align-middle"></i></button>
        //         </div>';
                
                return $text;
		    }
		    else
		    {
		        return '<div class="alert alert-info alert-border-left alert-dismissible fade show" role="alert">
                    <i class="ri-alert-line me-3 align-middle fs-16"></i><strong>No se encontraron notificaciones.</strong>
                </div>';
		    }
		} 
		else 
		{
			return '<div class="alert alert-warning alert-border-left alert-dismissible fade show" role="alert">
                <i class="ri-alert-line me-3 align-middle fs-16"></i><strong>Por favor, vuelva a iniciar sesión.</strong>
            </div>';
		}
    }
    
    public function cantidadNotificacionesHeader()
    {
        if(isset($this->items['id']))
        {
            $array = array(
                "idusuario" => $this->items['id'],
                "idperfil" => $this->items['idPerfil']
            );
		    $notificaciones = $this->notificaciones->listarNotificaciones($array);
		    $arrayNoVistos = $this->notificaciones->cantidadNotificacionesSinVer($array);
		    
            if(empty($notificaciones))
            {
                $this->session->set(array("popupNotificacion" => 0));
                
                $resultado = array(
    				'popup'     => (string) '',
    				'cantidad'  => (string) $arrayNoVistos['TOTALNOVISTO']
    			);
            }
            else
            {
                $texto = '';
                if($notificaciones[0]['UsuarioVisualizado'] == null && $this->session->get('popupNotificacion') != $notificaciones[0]['IDNotificacion'])
                {
                    $texto .= '<script>';
                    $texto .= 'toastr["info"]("'.strip_tags($notificaciones[0]['Mensaje']).'");';
                    $texto .= 'toastr.options = {';
                    $texto .= '"closeButton": false,';
                    $texto .= '"debug": false,';
                    $texto .= '"newestOnTop": false,';
                    $texto .= '"progressBar": true,';
                    $texto .= '"onclick": null,';
                    $texto .= '"positionClass": "toast-bottom-right",';
                    $texto .= '"preventDuplicates": false,';
                    $texto .= '"onclick": null,';
                    $texto .= '"showDuration": "500",';
                    $texto .= '"hideDuration": "1000",';
                    $texto .= '"timeOut": "10000",';
                    $texto .= '"extendedTimeOut": "1000",';
                    $texto .= '"showEasing": "swing",';
                    $texto .= '"hideEasing": "linear",';
                    $texto .= '"showMethod": "fadeIn",';
                    $texto .= '"hideMethod": "fadeOut"';
                    $texto .= '}</script>';
                    
                    $this->session->set(array("popupNotificacion" => $notificaciones[0]['IDNotificacion']));
                }
        		    
                $resultado = array(
    				'popup'     => (string) $texto,
    				'cantidad'  => (string) $arrayNoVistos['TOTALNOVISTO']
    			);
            }
		} 
		else 
		{
		    $texto = '';
		    $resultado = array(
				'popup'     => (string) $texto,
				'cantidad'  => (string) "-1"
			);
		}
		
		echo json_encode($resultado);
    }
    
    public function registrarVisualizacionNotificacion()
    {
        if(isset($this->items['id']))
        {
            $fechaActual = date("Y-m-d H:i:s");
        
            $idNotificacion = $this->request->getPost('idNotificacion');
            $validaExistencia = $this->notificacionesVistos->where(array("IDNotificacion" => $idNotificacion, "UsuarioVisualizado" => $this->items['id']))->first();
        
            if($idNotificacion != '' && $idNotificacion != null && empty($validaExistencia))
            {
                $data = array (
                    'IDNotificacion'    => $idNotificacion,
                    'UsuarioVisualizado'=> $this->items['id'],
                    'FechaVisualizado'  => $fechaActual
                );
        
                $lastId = $this->notificacionesVistos->insert($data, TRUE);
            }
        }
    }
}