<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;

// require 'vendor/autoload.php';
// use PhpOffice\PhpSpreadsheet\Spreadsheet;
// use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
// use PhpOffice\PhpSpreadsheet\IOFactory;
// use PhpOffice\PhpSpreadsheet\Cell\Coordinate;

class Administracion extends BaseController
{

	public function __construct(){
        $this->auditoria = new \App\Models\AuditoriaModel();
        
		$this->usuarioModelo = new \App\Models\UsuarioModel();
        $this->usuarioPerfil = new \App\Models\UsuarioPerfilModel();
        $this->usuarioPermisos = new \App\Models\UsuarioPermisosModel();
        $this->usuarioRutas = new \App\Models\UsuarioRutasModel();
        
		$this->perfilModelo = new \App\Models\PerfilModel();
		
        $this->modulo = new \App\Models\ModuloModel();
        $this->moduloAcciones = new \App\Models\ModulosAccionesModel();
        $this->moduloRutas = new \App\Models\ModulosRutasModel();
        $this->moduloCabecera = new \App\Models\ModulosCabeceraModel();
        $this->perfilPermisos = new \App\Models\PerfilPermisosModel();
        $this->perfilRutas = new \App\Models\PerfilRutasModel();
        
	}

    public function descargatxt($nombreTXT)
    {
        // Define el directorio igual que hiciste al crear el archivo
        //$directorio = base_url();
        $raiz = 'public/';
        // Valida el archivo recibido, eliminando caracteres no permitidos y diagonales para evitar retrocesos en ruta
        $file = (isset($nombreTXT)) ? str_replace('/', '', filter_var($nombreTXT, FILTER_SANITIZE_URL)) : '';
        
        // Separar para obtener extensión
        $partes = explode('.', $file);
        // No se especificó el archivo, no es .txt o no existe
        if($file == '' || end($partes) != 'txt' || !file_exists($raiz.$file)) {
            die('Archivo no encontrado');
        }

        header('Content-Description: File Transfer');
        header('Content-Disposition: attachment; filename='.$raiz.$file);
        header('Expires: 0');
        header('Cache-Control: must-revalidate');
        header('Pragma: public');
        header('Content-Length: ' . filesize($raiz.$file));
        header("Content-Type: text/plain");
        readfile($raiz.$file);
    }

	public function obtenerCabecera(){
    	/*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        $listadoCabeceras = $this->moduloCabecera->findAll();
        
        $cabeceras=array();

		if (!empty($listadoCabeceras)) {
            foreach ($listadoCabeceras as $items) {
                $cabeceras[] = array(
					'id' => (string) $items['IDCabecera'],
         	        'cabecera' => (string) $items['Cabecera'],
                );
            }

            $resultado = array(
				'listadoCabecera' => json_encode($cabeceras)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
	}

	public function listarPerfiles(){
		if(isset($this->items['id'])){
			/* BUSCAR PERFILES */
			$wherePerfil = array(
				//'perfil.eliminacion_logica' => 1
			);

			$listaPerfiles = $this->perfilModelo
				->where($wherePerfil)
				->findAll();

			$data = array (
				'session'       => 'on',
				'titulo'        => 'Perfiles | Verisure',
				'breadcrumb'    => $this->items['modulo'],
				'listaPerfiles' => $listaPerfiles,
			);
			$data = array_merge($data, $this->items);
			return view('administracion/listar_perfiles',$data);			
		} else {
			return view('errors/500');
		}
	}

    public function listadoPerfilesSelect()
    {
        $elemento = $this->request->getPost('term');
        
        $listado = $this->perfilModelo->listadoPerfilesSelect($elemento['term']);

        $elementos=array();

        foreach ($listado as $items) {
            $elementos[] = array(
                'id' => (string) $items['IDPerfil'],
                'text' => (string) $items['Perfil']
            );
        }

        echo json_encode($elementos);
    }

    public function registrarPerfil()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $perfil = ucfirst(mb_strtolower($this->request->getPost('txtPerfil')));
        $url = $this->request->getPost('txtURLBasePerfil');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($perfil, 'required|trim|minlength[1]|maxlength[50]', 'Perfil');
        $error .= $this->complementos->validaCampo($url, 'required|trim|minlength[1]|maxlength[200]', 'URL');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
		$perfilExistente = $this->perfilModelo->where('Perfil', $perfil)->findAll();
        
        if(count($perfilExistente)>0)
        {
            $msgExistencia .= "<li>El perfil ya fue registrado. [CAMPO] <small>PERFIL</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }


        $data = array (
            'Perfil'        => $perfil,
            'URLBase'       => $url,
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress(),
            'Estado'        => 'A'
        );

        $lastId = $this->perfilModelo->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $perfil);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

	public function obtenerDatosPerfil(){
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idPerfil = $this->request->getPost('idPerfil');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idPerfil, 'required|trim|numeric', 'ID Perfil');
                
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
        $datosPerfil = $this->perfilModelo->where("IDPerfil", $idPerfil)->first();

        if(!empty($datosPerfil)){
			$resultado = array(
				'idperfil' => (string) $idPerfil,
				'perfil' => (string) $datosPerfil['Perfil'],
				'url' => (string) $datosPerfil['URLBase']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        
        echo json_encode($resultado, JSON_NUMERIC_CHECK);	
    }

	public function actualizarPerfil($idPerfil)
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $perfil = $this->request->getPost('txtPerfil');
        $url = $this->request->getPost('txtURLBasePerfil');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($perfil, 'required|trim|minlength[1]|maxlength[50]', 'Perfil');
        $error .= $this->complementos->validaCampo($url, 'required|trim|minlength[1]|maxlength[200]', 'URL');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            'Perfil'            => $perfil,
            'URLBase'           => $url,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->perfilModelo->update([$idPerfil], $data);

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg503, $perfil);
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }		
	}

    public function modificarEstadoPerfil()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idPerfil = $this->request->getPost('idPerfil');
        $estado = $this->request->getPost('estado');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idPerfil, 'required|trim|numeric', 'ID Perfil');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'Estado'            => $estado
        );
        $lastId = $this->perfilModelo->update([$idPerfil], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idPerfil);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
	public function listarPermisosPerfil($idPerfil)
    {
		if(isset($this->items['id'])){
			/* BUSCAR PERMISOS*/
            
			$listaPermisos = $this->perfilPermisos->listarPermisosPerfil($idPerfil);
            $perfil = $this->perfilModelo->where("IDPerfil", $idPerfil)->first();
			$listaModulos = $this->modulo->findAll();

			$data = array (
				'session'           => 'on',
				'titulo'            => 'Permisos | Verisure',
				'breadcrumb'        => $this->items['modulo'],
				'breadcrumb_alias'  => 'Permisos de Perfil',
                'previo'            => 'listar-perfiles',
				'listaPermisos'     => $listaPermisos,
                'listaModulos'      => $listaModulos,
                'perfilSeleccionado'=> $perfil,
                'idPerfilSeleccionado'  => $idPerfil
			);
			$data = array_merge($data, $this->items);
			return view('administracion/listar_permisos_perfil',$data);			
		} else {
			return view('errors/500');
		}
	}

	public function listarRutasPerfil($idPerfil)
    {
		if(isset($this->items['id'])){
			/* BUSCAR PERMISOS*/
            
			$listaRutas = $this->perfilRutas->listarRutasPerfil($idPerfil);
            $perfil = $this->perfilModelo->where("IDPerfil", $idPerfil)->first();
			$listaModulos = $this->modulo->findAll();

			$data = array (
				'session'           => 'on',
				'titulo'            => 'Rutas | Verisure',
				'breadcrumb'        => $this->items['modulo'],
				'breadcrumb_alias'  => 'Rutas de Perfil',
                'previo'            => 'listar-perfiles',
				'listaRutas'        => $listaRutas,
                'listaModulos'      => $listaModulos,
                'perfilSeleccionado'=> $perfil,
                'idPerfilSeleccionado'  => $idPerfil
			);
			$data = array_merge($data, $this->items);
			return view('administracion/listar_rutas_perfil',$data);			
		} else {
			return view('errors/500');
		}
	}
	public function listarUsuarios(){
	   // echo $this->items['id']; exit;
		if(isset($this->items['id'])){
			/* BUSCAR USUARIOS */
            /* BUSCAR PERFILES  */
            
			$data = array (
				'session'           => 'on',
				'titulo'            => 'Usuarios | Verisure',
				'breadcrumb'        => $this->items['modulo'],
				'breadcrumb_alias'  => 'Listado de usuarios'
			);
			$data = array_merge($data, $this->items);
			return view('administracion/listar_usuarios',$data);			
		} else {
			return view('errors/500');	
		}
	}

    public function grabarUsuario(){

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $perfil = $this->request->getPost('perfil');
        $usuario = $this->request->getPost('usuario');
        $nombres = $this->request->getPost('nombres');
        $apellidos = $this->request->getPost('apellidos');
        $tipoDocumento = $this->request->getPost('tipo_documento');
        $numeroDocumento = $this->request->getPost('numero_documento');
        $correoElectronico = $this->request->getPost('correo_electronico');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($perfil, 'required|trim|numeric|minlength[1]|maxlength[3]', 'Perfil');
        $error .= $this->complementos->validaCampo($usuario, 'required|trim|minlength[1]|maxlength[100]', 'Usuario');
        $error .= $this->complementos->validaCampo($nombres, 'required|trim|name|minlength[1]|maxlength[100]', 'Nombres');
        $error .= $this->complementos->validaCampo($apellidos, 'required|trim|name|minlength[1]|maxlength[100]', 'Apellidos');
        $error .= $this->complementos->validaCampo($tipoDocumento, 'required|trim|name|minlength[1]|maxlength[6]', 'Tipo de documento');
        $error .= $this->complementos->validaCampo($numeroDocumento, 'required|numeric|trim|minlength[8]|maxlength[12]', 'Número de documento');
        $error .= $this->complementos->validaCampo($correoElectronico, 'required|trim|email|minlength[1]|maxlength[100]', 'Correo electrónico');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $contrasena = $this->scripts->crearContrasena();
            
        $data = array (
            'usuario' => $usuario,
            'contrasena' => sha1($contrasena),
            'perfil_id' => $perfil,
            'nombres' => strtoupper($nombres),
            'apellidos' => strtoupper($apellidos),
            'tipo_documento' => $tipoDocumento,
            'numero_documento' => $numeroDocumento,
            'correo_electronico' => $correoElectronico,
            'fecha_registro' => date("Y-m-d H:i:s"),
            'eliminacion_logica' => 1,
        );
        $lastId = $this->usuarioModelo->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $nombres.' '.$apellidos);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }  

	public function obtenerDatosUsuario(){
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $usuario = $this->request->getPost('usuario');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($usuario, 'required|trim|numeric|minlength[1]|maxlength[10]', 'Usuario');
                
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $whereUsuario = array (
            'usuario.id_usuario' => $usuario,
            'usuario.eliminacion_logica' => 1
        );
        $datosUsuario = $this->usuarioModelo
				->where($whereUsuario)
				->findAll();

        if(!empty($datosUsuario)){
            foreach ($datosUsuario as $items) {
                $resultado[] = array(
					'id_usuario' => (string) $items['id_usuario'],
					'usuario' => (string) $items['usuario'],
         	        'perfil_id' => (string) $items['perfil_id'],
         	        'nombres' => (string) $items['nombres'],
         	        'apellidos' => (string) $items['apellidos'],
         	        'tipo_documento' => (string) $items['tipo_documento'],
         	        'numero_documento' => (string) $items['numero_documento'],
         	        'correo_electronico' => (string) $items['correo_electronico']
                );
            }
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        
        echo json_encode($resultado, JSON_NUMERIC_CHECK);	
    }

    public function actualizarUsuario($idUsuario){

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $perfil = $this->request->getPost('perfil_e');
        $usuario = $this->request->getPost('usuario_e');
        $nombres = $this->request->getPost('nombres_e');
        $apellidos = $this->request->getPost('apellidos_e');
        $tipoDocumento = $this->request->getPost('tipo_documento_e');
        $numeroDocumento = $this->request->getPost('numero_documento_e');
        $correoElectronico = $this->request->getPost('correo_electronico_e');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($perfil, 'required|trim|numeric|minlength[1]|maxlength[3]', 'Perfil');
        $error .= $this->complementos->validaCampo($usuario, 'required|trim|minlength[1]|maxlength[100]', 'Usuario');
        $error .= $this->complementos->validaCampo($nombres, 'required|trim|name|minlength[1]|maxlength[100]', 'Nombres');
        $error .= $this->complementos->validaCampo($apellidos, 'required|trim|name|minlength[1]|maxlength[100]', 'Apellidos');
        $error .= $this->complementos->validaCampo($tipoDocumento, 'required|trim|name|minlength[1]|maxlength[6]', 'Tipo de documento');
        $error .= $this->complementos->validaCampo($numeroDocumento, 'required|numeric|trim|minlength[8]|maxlength[12]', 'Número de documento');
        $error .= $this->complementos->validaCampo($correoElectronico, 'required|trim|email|minlength[1]|maxlength[100]', 'Correo electrónico');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
            
        $data = array (
            'usuario' => $usuario,
            'perfil_id' => $perfil,
            'nombres' => strtoupper($nombres),
            'apellidos' => strtoupper($apellidos),
            'tipo_documento' => $tipoDocumento,
            'numero_documento' => $numeroDocumento,
            'correo_electronico' => $correoElectronico,
            'fecha_actualizacion' => date("Y-m-d H:i:s")
        );
        $lastId = $this->usuarioModelo->update([$idUsuario], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $nombres.' '.$apellidos);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

    public function eliminarUsuario($idUsuario){
        $data = array (
            'eliminacion_logica' => 0
        );
        $lastId = $this->usuarioModelo->update([$idUsuario], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg504, "usuario");
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

    public function reactivarUsuario($idUsuario){
        $data = array (
            'eliminacion_logica' => 1
        );
        $lastId = $this->usuarioModelo->update([$idUsuario], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, "usuario");
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

    public function listarModulos()
    {
        if(isset($this->items['id'])){
			/* BUSCAR USUARIOS */
			$listaModulos = $this->modulo->listarModulos();
            //$listaModulos = array();
            /* BUSCAR PERFILES */
            
			$data = array (
				'session'           => 'on',
				'titulo'            => 'Módulos | Verisure',
				'breadcrumb'        => $this->items['modulo'],
				'breadcrumb_alias'  => 'Listado de módulos',
				'listaModulos'      => $listaModulos
			);
			$data = array_merge($data, $this->items);
			return view('administracion/listar_modulos',$data);			
		} else {
			return view('errors/500');	
		}
    }

    public function registrarModulo()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $modulo = ucfirst(mb_strtolower($this->request->getPost('txtModulo_i')));
        $cabecera = $this->request->getPost('txtCabecera_i');
        $orden = $this->request->getPost('txtOrden_i');
        $icono = $this->request->getPost('txtIcono_i');
        $observacion = $this->request->getPost('txtObservacionModulo_i') ;
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($modulo, 'required|trim|alphaspecial|minlength[1]|maxlength[50]', 'Módulo');
        $error .= $this->complementos->validaCampo($cabecera, 'required|trim|numeric', 'Cabecera');
        $error .= $this->complementos->validaCampo($orden, 'required|trim|numeric', 'Orden');
        $error .= $this->complementos->validaCampo($icono, 'required|trim', 'Ícono');
        $error .= $this->complementos->validaCampo($observacion, 'required|trim', 'Observación');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
		$moduloExistente = $this->modulo->where('Modulo', $modulo)->findAll();
        
        if(count($moduloExistente)>0)
        {
            $msgExistencia .= "<li>El módulo ya fue registrado. [CAMPO] <small>MÓDULO</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }


        $data = array (
            'IDCabecera'    => $cabecera,
            'Modulo'        => $modulo,
            'Orden'         => $orden,
            'Icono'         => $icono,
            'Observacion'   => $observacion,
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress(),
            'Estado'        => 'A'
        );

        $lastId = $this->modulo->insert($data, TRUE);

		if($lastId !== FALSE){
		    /*$parametros = array("accion" => "ACTUALIZARPOSICIONESMODULOS", "idmodulo" => $lastId, "idcabecera" => $cabecera, "orden" => $orden);
		    $this->auditoria->spModulo($parametros);*/
			$message = sprintf($this->mensajeError->msg502, $modulo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

    public function modificarModulo($idModulo){

        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $modulo = ucfirst(mb_strtolower($this->request->getPost('txtModulo_i')));
        $cabecera = $this->request->getPost('txtCabecera_i');
        $orden = $this->request->getPost('txtOrden_i');
        $icono = $this->request->getPost('txtIcono_i');
        $observacion = $this->request->getPost('txtObservacionModulo_i');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($modulo, 'required|trim', 'Modulo');
        $error .= $this->complementos->validaCampo($cabecera, 'required|trim|numeric', 'Cabecera');
        $error .= $this->complementos->validaCampo($orden, 'required|trim|numeric', 'Orden');
        $error .= $this->complementos->validaCampo($icono, 'required|trim', 'Ícono');
        $error .= $this->complementos->validaCampo($observacion, 'required|trim', 'Observación');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'IDCabecera'        => $cabecera,
            'Modulo'            => $modulo,
            'Orden'             => $orden,
            'Icono'             => $icono,
            'Observacion'       => $observacion,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );
        $lastId = $this->modulo->update([$idModulo], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idModulo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function modificarEstadoModulo()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idModulo = $this->request->getPost('idModulo');
        $estado = $this->request->getPost('estado');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idModulo, 'required|trim|numeric', 'ID Módulo');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'Estado'            => $estado
        );
        $lastId = $this->modulo->update([$idModulo], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idModulo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
	public function obtenerDatosModulo() {

		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idModulo = $this->request->getPost('idModulo');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idModulo, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosModulo = $this->modulo->where('IDModulo', $idModulo)->first();

		if(!empty($datosModulo)){
			$resultado = array(
				'idmodulo' => (string) $idModulo,
				'cabecera' => (string) $datosModulo['IDCabecera'],
				'modulo' => (string) $datosModulo['Modulo'],
				'orden' => (string) $datosModulo['Orden'],
				'icono' => (string) $datosModulo['Icono'],
				'observacion' => (string) $datosModulo['Observacion']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);		
	}
    
    public function listarRutasModulo($idModulo)
    {
        if(isset($this->items['id'])){
			/* BUSCAR RUTAS */
			$listaRutas = $this->moduloRutas->where("IDModulo", $idModulo)->findAll();
            $modulo = $this->modulo->where('IDModulo', $idModulo)->first();

			$data = array (
				'session'           => 'on',
				'titulo'            => 'Rutas | Verisure',
				'breadcrumb'        => $this->items['modulo'],
				'breadcrumb_alias'  => 'Listado de rutas',
                'previo'            => 'listar-modulos',
				'listaRutas'        => $listaRutas,
                'moduloSeleccionado'=> $modulo,
                'idModulo'          => $idModulo
			);
			$data = array_merge($data, $this->items);
			return view('administracion/listar_rutas_modulos',$data);			
		} else {
			return view('errors/500');	
		}
    }

    public function guardarRutaModulo($idModulo)
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $ruta = $this->request->getPost('txtRutaModulo') ;
        $tipo = $this->request->getPost('txtTipoRuta_i') ;
        $raiz = $this->request->getPost('chkRutaRaiz') ;
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($ruta, 'required|trim', 'Ruta');
        $error .= $this->complementos->validaCampo($tipo, 'required|trim', 'Tipo de Ruta');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
		$rutaExistente = $this->moduloRutas->where('Ruta', $ruta)->findAll();
        
        if(count($rutaExistente)>0)
        {
            $msgExistencia .= "<li>La ruta ya fue registrada. [CAMPO] <small>RUTA</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }


        $data = array (
            'IDModulo'  => $idModulo, 
            'Ruta'      => $ruta,
            'TipoRuta'  => $tipo,
            'RaizModulo'=> (isset($raiz) ? 'Y' : 'N'),
            'Estado'    => 'A'
        );

        $lastId = $this->moduloRutas->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $ruta);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

	public function obtenerDatosRutaModulo() 
    {

		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idRutaModulo = $this->request->getPost('idRutaModulo');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idRutaModulo, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosRuta = $this->moduloRutas->where('IDRuta', $idRutaModulo)->first();

		if(!empty($datosRuta)){
			$resultado = array(
				'idruta' => (string) $idRutaModulo,
				'ruta' => (string) $datosRuta['Ruta'],
				'tipo' => (string) $datosRuta['TipoRuta'],
				'raiz' => (string) $datosRuta['RaizModulo']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);		
	}

    public function modificarRutaModulo($idRutaModulo){

        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $ruta = $this->request->getPost('txtRutaModulo');
        $tipo = $this->request->getPost('txtTipoRuta_i');
        $raiz = $this->request->getPost('chkRutaRaiz');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($ruta, 'required|trim', 'Ruta');
        $error .= $this->complementos->validaCampo($tipo, 'required|trim', 'Tipo de Ruta');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'Ruta'              => $ruta,
            'TipoRuta'          => $tipo,
            'RaizModulo'        => (isset($raiz) ? 'Y' : 'N')
        );
        $lastId = $this->moduloRutas->update([$idRutaModulo], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idRutaModulo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

    public function modificarEstadoRutaModulo(){

        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idRutaModulo = $this->request->getPost('idRutaModulo');
        $estado = $this->request->getPost('estado');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idRutaModulo, 'required|trim|numeric', 'ID Ruta Módulo');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'Estado'            => $estado
        );
        $lastId = $this->moduloRutas->update([$idRutaModulo], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idRutaModulo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

    public function listarAccionesModulo($idModulo)
    {
        if(isset($this->items['id'])){
			/* BUSCAR ACCIONES */
			$listaAcciones = $this->moduloAcciones->where("IDModulo", $idModulo)->findAll();
            
			$data = array (
				'session'           => 'on',
				'titulo'            => 'Acciones | Verisure',
				'breadcrumb'        => $this->items['modulo'],
				'breadcrumb_alias'  => 'Listado de acciones',
                'previo'            => 'listar-modulos',
				'listaAcciones'     => $listaAcciones,
                'idModulo'          => $idModulo
			);
			$data = array_merge($data, $this->items);
			return view('administracion/listar_acciones_modulos',$data);			
		} else {
			return view('errors/500');	
		}
    }
    
    public function guardarAccionModulo($idModulo)
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $codigo = $this->request->getPost('txtCodigoAccionModulo') ;
        $accion = $this->request->getPost('txtAccionModulo') ;
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($accion, 'required|trim', 'Acción');
        $error .= $this->complementos->validaCampo($codigo, 'required|trim|minlength[6]|maxlength[6]', 'Código');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
		$accionExistente = $this->moduloAcciones->where('Accion', $accion)->findAll();
		$codigoExistente = $this->moduloAcciones->where('Codigo', $codigo)->findAll();
        
        if(count($accionExistente)>0)
        {
            $msgExistencia .= "<li>La acción ya fue registrada. [CAMPO] <small>ACCIÓN</small></li>";
        }

        if(count($codigoExistente)>0)
        {
            $msgExistencia .= "<li>El código ya fue registrada. [CAMPO] <small>CÓDIGO</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }


        $data = array (
            'IDModulo'  => $idModulo, 
            'Codigo'    => $codigo,
            'Accion'    => $accion,
            'Estado'    => 'A'
        );

        $lastId = $this->moduloAcciones->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $accion);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

    public function guardarPermisosPerfil($idPerfil)
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $permisos = $this->request->getPost('permisos') ;
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';

        if(isset($permisos) && empty($permisos))
        {
            $error .= "<li>No hay permisos seleccionados.</li>";
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * OBTENER PERMISOS EXISTENTES Y EVALUAR NUEVOS PERMISOS Y PERMISOS RETIRADOS
        * ----------------------------
        */
        
        $listadoPermisosPrev = $this->perfilPermisos->where("IDPerfil", $idPerfil)->findAll();
        $arrayPermisosExistentes = array_column($listadoPermisosPrev, "IDAccionModulo");
        
        $arrayNuevosPermisos = array_keys($permisos);
        
        $agregarPermisos = array_diff($arrayNuevosPermisos, $arrayPermisosExistentes);
        $quitarPermisos = array_diff($arrayPermisosExistentes, $arrayNuevosPermisos);
        
        /*
        * ----------------------------
        * LIMPIAR EXISTENCIA PREVIA
        * ----------------------------
        */

        if(count($listadoPermisosPrev) > 0)
        {
            $this->perfilPermisos->delete($idPerfil);
        }

        /*
        * ----------------------------
        * GENERAR NUEVA DATA
        * ----------------------------
        */

        $dataPermisos = array();

        foreach($permisos as $key => $value)
        {
            $dataPermisos[] = array (
                'IDPerfil'          => $idPerfil, 
                'IDAccionModulo'    => $key,
                'UsuarioRegistra'   => $this->items['id'],
                'FechaRegistra'     => $fechaActual
            );
        }
        $lastId = $this->perfilPermisos->insertBatch($dataPermisos, TRUE);

		if($lastId !== FALSE){
		    $usuariosPerfil = $this->usuarioPerfil->where("IDPerfil", $idPerfil)->findAll();
		    $listadoUsuariosPerfil = array_column($usuariosPerfil, "IdUsuario");;
		    
		    if(!empty($listadoUsuariosPerfil))
		    {
    		    //ELIMINAR PERMISOS DESACTIVADOS
    		    
    		    if(!empty($quitarPermisos))
    		    {
    		        $this->usuarioPermisos->whereIn('IdUsuario', $listadoUsuariosPerfil)->whereIn('IDAccionModulo', $quitarPermisos)->delete();
    		    }
    		    
    		    //INSERTAR PERMISOS ACTIVADOS NUEVOS
    		    
    		    if(!empty($agregarPermisos))
    		    {
    		        $dataPermisosNuevos = array();
    		    
    		        foreach($listadoUsuariosPerfil as $usuarios)
    		        {
    		            foreach($agregarPermisos as $new)
        		        {
        		            $wherePermisos = array(
        		                "IdUsuario"         => $usuarios,
        		                "IDAccionModulo"    => $new
        		            );
        		            
        		            $existe = $this->usuarioPermisos->where($wherePermisos)->countAllResults();
        		            
        		            if($existe == 0)
        		            {
        		                $dataPermisosNuevos[] = array (
                                    'IdUsuario'         => $usuarios, 
                                    'IDAccionModulo'    => $new,
                                    'UsuarioRegistra'   => $this->items['id'],
                                    'FechaRegistra'     => $fechaActual
                                );
        		            }
        		        }
    		        }
    		        
    		        $this->usuarioPermisos->insertBatch($dataPermisosNuevos, TRUE);
    		    }
		    }
		    
			$message = sprintf($this->mensajeError->msg502, $idPerfil);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function guardarRutasPerfil($idPerfil)
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $rutas = $this->request->getPost('rutas') ;
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';

        if(isset($rutas) && empty($rutas))
        {
            $error .= "<li>No hay rutas seleccionados.</li>";
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * OBTENER RUTAS EXISTENTES Y EVALUAR NUEVAS RUTAS Y RUTAS RETIRADAS
        * ----------------------------
        */
        
        $listadoRutasPrev = $this->perfilRutas->where("IDPerfil", $idPerfil)->findAll();
        $arrayRutasExistentes = array_column($listadoRutasPrev, "IDRuta");
        
        $arrayNuevasRutas = array_keys($rutas);
        
        $agregarRutas = array_diff($arrayNuevasRutas, $arrayRutasExistentes);
        $quitarRutas = array_diff($arrayRutasExistentes, $arrayNuevasRutas);
        
        /*
        * ----------------------------
        * LIMPIAR EXISTENCIA PREVIA
        * ----------------------------
        */

        if(count($listadoRutasPrev) > 0)
        {
            $this->perfilRutas->delete($idPerfil);
        }

        /*
        * ----------------------------
        * GENERAR NUEVA DATA
        * ----------------------------
        */

        $dataRutas = array();

        foreach($rutas as $key => $value)
        {
            $dataRutas[] = array (
                'IDPerfil'          => $idPerfil, 
                'IDRuta'            => $key,
                'UsuarioRegistra'   => $this->items['id'],
                'FechaRegistra'     => $fechaActual
            );
        }
        $lastId = $this->perfilRutas->insertBatch($dataRutas, TRUE);

		if($lastId !== FALSE){
		    $usuariosPerfil = $this->usuarioPerfil->where("IDPerfil", $idPerfil)->findAll();
		    $listadoUsuariosPerfil = array_column($usuariosPerfil, "IdUsuario");;
		    
		    if(!empty($listadoUsuariosPerfil))
		    {
    		    //ELIMINAR RUTAS DESACTIVADOS
    		    
    		    if(!empty($quitarRutas))
    		    {
    		        $this->usuarioRutas->whereIn('IdUsuario', $listadoUsuariosPerfil)->whereIn('IDRuta', $quitarRutas)->delete();
    		    }
    		    
    		    //INSERTAR PERMISOS ACTIVADOS NUEVOS
    		    
    		    if(!empty($agregarRutas))
    		    {
    		        $dataRutasNuevas = array();
    		    
    		        foreach($listadoUsuariosPerfil as $usuarios)
    		        {
    		            foreach($agregarRutas as $new)
        		        {
        		            $whereRutas = array(
        		                "IdUsuario" => $usuarios,
        		                "IDRuta"    => $new
        		            );
        		            
        		            $existe = $this->usuarioRutas->where($whereRutas)->countAllResults();
        		            
        		            if($existe == 0)
        		            {
        		                $dataRutasNuevas[] = array (
                                    'IdUsuario'         => $usuarios, 
                                    'IDRuta'            => $new,
                                    'UsuarioRegistra'   => $this->items['id'],
                                    'FechaRegistra'     => $fechaActual
                                );
        		            }
        		        }
    		        }
    		        
    		        $this->usuarioRutas->insertBatch($dataRutasNuevas, TRUE);
    		    }
		    }
		    
			$message = sprintf($this->mensajeError->msg502, $idPerfil);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
}