<?php
namespace App\Models;
use CodeIgniter\Model;

class VATarjetasAccesoModel extends Model
{
    protected $table      = 'tarjetas_acceso';
    protected $primaryKey = 'IDTarjetaAcceso';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['Serie', 'PrecioCompra', 'Observacion', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function listarTarjetasAcceso()
    {
        $this->select('
            tarjetas_acceso.IDTarjetaAcceso,
            tarjetas_acceso.Serie,
            tarjetas_acceso.PrecioCompra,
            tarjetas_acceso.Observacion,
            tarjetas_acceso.Estado,
            asignacion.UsuarioAsignado');
        $this->join('(SELECT asignaciones_detalle.IDElemento, asignaciones.UsuarioAsignado FROM asignaciones INNER JOIN asignaciones_detalle ON asignaciones.IDAsignacion = asignaciones_detalle.IDAsignacion LEFT JOIN devoluciones_detalle ON asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion WHERE devoluciones_detalle.IDDevolucion IS NULL AND asignaciones_detalle.TipoElemento="TARJETA") AS asignacion', 'tarjetas_acceso.IDTarjetaAcceso = asignacion.IDElemento', 'left');

        $datos = $this->findAll();
        return $datos;
    }
    
    public function listarTarjetasAccesoDisponibles($variable)
    {
        $consulta = "SELECT 
            tarjetas_acceso.IDTarjetaAcceso, 
            tarjetas_acceso.Serie, 
            tarjetas_acceso.PrecioCompra,
            tarjetas_acceso.Observacion
        FROM
            tarjetas_acceso 
        WHERE 
            (tarjetas_acceso.Serie LIKE '%".$variable."%' OR tarjetas_acceso.Observacion LIKE '%".$variable."%') AND
            tarjetas_acceso.Estado IN ('A') AND 
            tarjetas_acceso.IDTarjetaAcceso NOT IN (SELECT 
                    asignaciones_detalle.IDElemento 
                FROM 
                    asignaciones_detalle 
                LEFT JOIN 
                    devoluciones_detalle ON asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion 
                WHERE 
                    devoluciones_detalle.IDDevolucion IS NULL AND 
                    asignaciones_detalle.TipoElemento = 'TARJETA')";
        
        $obtieneConsulta = $this->db->query($consulta);
        return $obtieneConsulta->getResultArray();
    }
}