<?php
namespace App\Models;
use CodeIgniter\Model;

class VATarjetasAccesoDireccionesModel extends Model
{
    protected $table      = 'tarjetas_acceso_direcciones';
    protected $primaryKey = 'IDTarjetaAcceso';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDTarjetaAcceso', 'IDDireccion', 'UsuarioRegistra', 'FechaRegistra'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function listarDireccionesTarjetaAcceso($idTarjetaAcceso)
    {
        $this->select('dbMASTERUSUARIO.direccion.id_direccion,
            dbMASTERUSUARIO.direccion.Direccion,
            IF(tarjetas_acceso_direcciones.IDTarjetaAcceso IS NULL, 0, 1) AS "ACTIVO"');
        $this->join('dbMASTERUSUARIO.direccion', 'tarjetas_acceso_direcciones.IDDireccion = dbMASTERUSUARIO.direccion.id_direccion AND tarjetas_acceso_direcciones.IDTarjetaAcceso = "'.$idTarjetaAcceso.'"', 'right');
        
        $datos = $this->findAll();
        return $datos;
    }
    
}