<?php namespace App\Models;

use CodeIgniter\Model;

class UsuarioModelo extends Model {
/*    protected $table = 'usuario';
    protected $primaryKey = 'id_usuario';
    protected $allowedFields = ['id_usuario','usuario','contrasena','perfil_id','nombres','apellidos','tipo_documento','numero_documento','correo_electronico','token','fecha_caducidad_token','fecha_solicitud_recuperacion','fecha_cambio_contrasena','fecha_registro','fecha_actualizacion','eliminacion_logica'];
*/
    protected $DBGroup = 'baseT';
    protected $table = 'tblusuario';
    protected $primaryKey = 'IdUsuario';
    protected $allowedFields = ['IdArea','IdPerfil','Matricula','Nombres','Apellidos','TipoDocumento','NumeroDoc','Telefono','Demo','Cargo','Categoria','Instalador','CC','LN','Manager','Correo','Usuario','Password','FechaIngreso','FechaCese','Estado','FTE','Foto','FechaHoraREG','FechaHoraMODIF','RMKT','Token','Estrellas','TCTV','RemarketingTV','TC','Push','Pull','Equipo','RemarketingTC'];

    public function validarIngresoUsuario($usuario)
    {
        $this->select('tblusuario.IdUsuario,
            tblusuario.Usuario,
            tblusuario.Nombres,
            tblusuario.Apellidos,
            tblusuario.TipoDocumento,
            tblusuario.NumeroDoc,
            tblusuario.Correo,
            tblusuario.Estado,
            tblusuario.Password,
            estructura_area.IDArea,
            estructura_area.Area,
            estructura_direccion.IDDireccion,
            estructura_direccion.Direccion,
            estructura_delegacion.CC,
            cargos.Cargo');
        $this->join('estructura_delegacion', 'tblusuario.IDDelegacion = estructura_delegacion.IDDelegacion', 'left');
        $this->join('estructura_subarea', 'tblusuario.IDSubarea = estructura_subarea.IDSubarea', 'left');
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->join('cargos', 'tblusuario.IDCargo = cargos.IDCargo', 'left');
        $this->where('tblusuario.Usuario', $usuario);
        $datos = $this->first();
        return $datos;
    }

    public function validarSistemaUsuario($idUsuario, $raiz)
    {
        $this->select('tblusuario.IdUsuario,
            usuario_sistemas.IDSistema,
            sistemas.Sistema,
            sistemas.Estado');
        $this->join('usuario_sistemas', 'tblusuario.IdUsuario = usuario_sistemas.IdUsuario');
        $this->join('sistemas', 'usuario_sistemas.IDSistema = sistemas.IDSistema');
        $this->where('usuario_sistemas.IdUsuario', $idUsuario);
        $this->where('sistemas.Raiz', $raiz);
        $datos = $this->first();
        return $datos;
    }

    public function listaGeneralUsuario($orderBy,$where,$length,$start) {
        $sSelect = "tblusuario.IdUsuario,CONCAT(tblusuario.Nombres, ' ', tblusuario.Apellidos) as nombre_usuario,tblusuario.Matricula,tblusuario.NumeroDoc,dbACTIVOS.perfil.Perfil AS perfil_usuario, tblusuario.Usuario,tblusuario.Estado, 'SININFO' AS acciones_usuario";
        $sTable = "tblusuario LEFT JOIN dbACTIVOS.usuario_perfil ON tblusuario.IdUsuario = dbACTIVOS.usuario_perfil.IdUsuario LEFT JOIN dbACTIVOS.perfil ON dbACTIVOS.usuario_perfil.IDPerfil = dbACTIVOS.perfil.IDPerfil";
        $whereRespuesta = $where==""?"":"WHERE (".$where ."')";
        $consulta = "SELECT " . $sSelect ." FROM ".  $sTable . " " .$whereRespuesta ."  " . $orderBy . " LIMIT ". $length ." OFFSET " .$start;
        
        $obtieneConsulta = $this->db->query($consulta);
        $consultaTotal = "SELECT count(IdUsuario) as total FROM tblusuario";
        $totalRegistros = $this->db->query($consultaTotal);
        $obtieneTotalRegistros = $totalRegistros->getResultArray();
        
        if ($obtieneConsulta->getNumRows() > 0) {
            $datos = [
                // 'draw' => "4",
                'data' => $obtieneConsulta->getResultArray(),
                'recordsTotal' => $obtieneTotalRegistros[0]['total'],
                'recordsFiltered' => (int)(($obtieneTotalRegistros[0]['total']*$length)/$length)
            ];
            return $datos;
        } else {
            return FALSE;
        }
    }

    public function buscarUsuario($idUsuario)
    {
        $this->select('tblusuario.IdUsuario,
            tblusuario.Matricula,
            tblusuario.Usuario,
            tblusuario.Nombres,
            tblusuario.Apellidos,
            tblusuario.TipoDocumento,
            tblusuario.NumeroDoc,
            tblusuario.Correo,
            tblusuario.Estado,
            tblusuario.IDDelegacion,
            tblusuario.IDSubarea,
            estructura_area.IDArea,
            estructura_area.Area,
            estructura_direccion.IDDireccion,
            estructura_direccion.Direccion,
            estructura_delegacion.CC,
            cargos.Cargo');
        $this->join('estructura_delegacion', 'tblusuario.IDDelegacion = estructura_delegacion.IDDelegacion', 'left');
        $this->join('estructura_subarea', 'tblusuario.IDSubarea = estructura_subarea.IDSubarea', 'left');
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->join('cargos', 'tblusuario.IDCargo = cargos.IDCargo', 'left');
        $this->where('tblusuario.IdUsuario', $idUsuario);
        $datos = $this->first();
        return $datos;
    }

    public function buscarUsuarioXusuario($usuario)
    {
        $this->select('tblusuario.IdUsuario,
            tblusuario.Matricula,
            tblusuario.Usuario,
            tblusuario.Nombres,
            tblusuario.Apellidos,
            tblusuario.TipoDocumento,
            tblusuario.NumeroDoc,
            tblusuario.Correo,
            tblusuario.Estado,
            tblusuario.IDSubarea,
            tblusuario.IDDelegacion,
            estructura_area.IDArea,
            estructura_area.Area,
            estructura_direccion.IDDireccion,
            estructura_direccion.Direccion,
            estructura_delegacion.CC,
            cargos.Cargo');
        $this->join('estructura_delegacion', 'tblusuario.IDDelegacion = estructura_delegacion.IDDelegacion', 'left');
        $this->join('estructura_subarea', 'tblusuario.IDSubarea = estructura_subarea.IDSubarea', 'left');
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->join('cargos', 'tblusuario.IDCargo = cargos.IDCargo', 'left');
        $this->where('tblusuario.Usuario', $usuario);
        $datos = $this->first();
        return $datos;
    }

    public function listadoUsuariosSelect($variable, $cc = '')
    {
        $this->select('
        tblusuario.IdUsuario,
        tblusuario.Matricula,
        tblusuario.Nombres,
        tblusuario.Apellidos,
        tblusuario.NumeroDoc,
        estructura_delegacion.CC');
        $this->join('estructura_delegacion', 'tblusuario.IDDelegacion = estructura_delegacion.IDDelegacion', 'left');
        $this->join('estructura_subarea', 'tblusuario.IDSubarea = estructura_subarea.IDSubarea', 'left');
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->join('cargos', 'tblusuario.IDCargo = cargos.IDCargo', 'left');
        $this->where("(tblusuario.Matricula LIKE '%".$variable."%' OR 
            tblusuario.Nombres LIKE '%".$variable."%' OR
            tblusuario.Apellidos LIKE '%".$variable."%' OR 
            tblusuario.Usuario LIKE '%".$variable."%' OR 
            CONCAT(tblusuario.Nombres, ' ',tblusuario.Apellidos) LIKE '%".$variable."%' OR 
            tblusuario.NumeroDoc LIKE '%".$variable."%')");

        if($cc != '')
        {
            $this->where('estructura_delegacion.CC', $cc);
        }
        
        $datos = $this->findAll();
        return $datos;
    }

    public function listaGeneralUsuarios($array) 
    {
        $this->select('
        tblusuario.IdUsuario,
        tblusuario.Matricula,
        tblusuario.Nombres,
        tblusuario.Apellidos,
        tblusuario.NumeroDoc,
        estructura_delegacion.CC,
        tblusuario.Estado');
        $this->join('estructura_delegacion', 'tblusuario.IDDelegacion = estructura_delegacion.IDDelegacion', 'left');
        $this->join('estructura_subarea', 'tblusuario.IDSubarea = estructura_subarea.IDSubarea', 'left');
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->join('cargos', 'tblusuario.IDCargo = cargos.IDCargo', 'left');

        if(isset($array['estado']) && $array['estado'] != '')
        {
            $this->where("tblusuario.Estado", $array['estado']);
        }
        
        $datos = $this->findAll();
        return $datos;
    }
    
}
