<?php namespace App\Models;

use CodeIgniter\Model;

class PerfilRutasModelo extends Model {
  protected $table = 'perfil_rutas';
  protected $primaryKey = 'IDPerfil';
  protected $allowedFields = ['IDPerfil', 'IDRuta', 'UsuarioRegistra', 'FechaRegistra'];
  protected $useAutoIncrement = false;
  protected $useSoftDeletes = false;
  
  public function listarRutasPerfil($idPerfil)
  {
      $this->select('modulos_rutas.IDRuta,
        modulos_rutas.IDModulo, 
        modulos_rutas.Ruta,
        modulos_rutas.RaizModulo,
        modulos_rutas.TipoRuta,
        IF(perfil_rutas.IDPerfil IS NULL, 0, 1) AS "ACTIVO"');
      $this->join('modulos_rutas', 'perfil_rutas.IDRuta = modulos_rutas.IDRuta AND perfil_rutas.IDPerfil = "'.$idPerfil.'"', 'right');
      
      $datos = $this->findAll();
      return $datos;
  }
}
