toastr.options = {
    "positionClass": "toast-bottom-center",
    "newestOnTop": true,
    "preventDuplicates": true
}

const initialDataQuill = {
  about: [
    {
      insert:
        'Ingrese el texto requerido aquí.\n',
    },
  ],
};

const tableDetalleAsignacion = new DataTable('#tblDetalleAsignacion');

const tableRutasModuloAgregar = new DataTable('#tblRutasModuloAgregar');

const tblDetalleReposicion = new DataTable('#tblDetalleReposicion');

const tableDescuentosMensual = new DataTable('#tblDescuentosMensual');

const tableCategorias = new DataTable('#tblCategorias');

const tableTipoCategoria = new DataTable('#tblTipoCategoria');

const tableSubtiposTipoCategoria = new DataTable('#tblSubtiposTipoCategoria');

const tableHardware = new DataTable("#tblHardware");

const tableTarjetasAcceso = new DataTable("#tblTarjetasAcceso");

const tableKitDemo = new DataTable("#tblKitDemo");

const tableInformacionLegales = new DataTable("#tblInformacionLegales");
$(function () {
    const quillTextoLegal = new Quill('#txtTextoLegal_i', {});
    
    new DataTable('#tblContratoLinea', {
        order: [[3, 'asc']]
    });
    /*
    $("input[data-bootstrap-switch]").each(function(){
        $(this).bootstrapSwitch('state', $(this).prop('checked'));
    }); 
    */
    $('#chkIncluyeMovil').bootstrapSwitch({
        onSwitchChange: function(e, state) { 
            if(state == true)
            {
                $('#ctnRegistroEquipo').removeClass("d-none");
            }
            else
            {
                $('#ctnRegistroEquipo').addClass("d-none");
            }
        }
    });

    $("#txtAsignado").select2({
        minimumInputLength: 2,
        placeholder: 'Seleccione Asignado',
        allowClear: true,
        language: {
            errorLoading: function() {
                return "La carga falló";
            },
            noResults: function() {
                return "No hay resultado";
            },
            searching: function() {
                return "Buscando..";
            }
        },
        ajax: {
            url: baseUrl + '/listado-usuarios-select',
            dataType: 'json',
            type: "POST",
            quietMillis: 50,
            data: function (term) {
                return {
                    term: term
                };
            },
            processResults: function (data) {
                return {
                    results: data
                };
            }
        }
    });
    /*
    $(document).on('change', '#txtElementoNuevaAsignacion', function() {
        $('#txtItem').empty();
        var elemento = $(this).val();
        $.post(baseUrl + '/obtener-elementos-asignacion', 
        {
            elemento : elemento
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                var elementos = $.parseJSON(response.listadoElementos);
                $("#txtItem").append('\
                    <option value="">Seleccione una opción</td>\n\
                ');
                for(var i = 0; i < elementos.length; i++){
                    $("#txtItem").append('\
                        <option value="' + elementos[i].id + '" >' + elementos[i].elemento +'</td>\n\
                    ');
                }
            }
        }, 'json');
    
        $('#txtItem').select2();
    });
*/
    $(document).on('change', '#txtFinalGarantia_i', function() {
        $('#txtFinalVidaUtil_i').empty();
        var finalGarantia = $(this).val();
        vec = finalGarantia.split('-');
        
        var fecha = new Date(vec[0], vec[1], vec[2]);
        fecha.setFullYear(fecha.getFullYear()+1);
        
        if(vec[2] == 29 && vec[1] == 2)
        {
            fecha.setMonth(fecha.getMonth()+1);
            fecha.setDate('1');
        }
        
        finalVidaUtil = fecha.getFullYear()+'-'+(fecha.getMonth()<10 ? "0"+fecha.getMonth() : fecha.getMonth())+'-'+(fecha.getDate()<10 ? "0"+fecha.getDate() : fecha.getDate());
        $('#txtFinalVidaUtil_i').val(finalVidaUtil);
    });
    
    $('#txtMonedaCompraHardware_i').select2({
        dropdownParent: $('#informacionHardware .modal-body')
    });
    
    $("#txtItem").select2({
        minimumInputLength: 2,
        placeholder: 'Seleccione Item',
        allowClear: true,
        language: {
            errorLoading: function() {
                return "La carga falló";
            },
            noResults: function() {
                return "No hay resultado";
            },
            searching: function() {
                return "Buscando..";
            }
        },
        ajax: {
            url: baseUrl + '/obtener-elementos-asignacion',
            dataType: 'json',
            type: "POST",
            quietMillis: 50,
            data: function (term) {
                var el = $("#txtElementoNuevaAsignacion").val();
                term['elemento'] = el;
                var usuario = $("#txtAsignado").val();
                
                if(el=='HARDWARE' && usuario == '')
                {
                    Swal.fire({
                        html: 'Debe seleccionar el usuario para filtrar el HARDWARE',
                        heightAuto: true,
                        showConfirmButton: false
                    });
                }
                else
                {
                    term['usuario'] = usuario;
                    return {
                        term: term
                    };
                }
            },
            processResults: function (data) {
                return {
                    results: data
                };
            }
        }
    });
    
    /* NUEVA ASIGNACIÓN URES */
    $('#txtElementoNuevaAsignacion2').select2({
        dropdownParent: $('#nuevaAsignacionURES .modal-body')
    });
    
    $("#txtItem2").select2({
        minimumInputLength: 2,
        placeholder: 'Seleccione Item',
        dropdownParent: $('#nuevaAsignacionURES .modal-body'),
        allowClear: true,
        language: {
            errorLoading: function() {
                return "La carga falló";
            },
            noResults: function() {
                return "No hay resultado";
            },
            searching: function() {
                return "Buscando..";
            }
        },
        ajax: {
            url: baseUrl + '/obtener-elementos-asignacion',
            dataType: 'json',
            type: "POST",
            quietMillis: 50,
            data: function (term) {
                var el = $("#txtElementoNuevaAsignacion2").val();
                term['elemento'] = el;
                // var usuario = $("#txtAsignado").val();
                var usuario = $("#txtUsuarioAsignacionURES").val();
                
                if((el=='HARDWARE' || el=='KITDEMO') && usuario == '')
                {
                    Swal.fire({
                        html: 'Debe seleccionar el usuario asignado para filtrar el ELEMENTO seleccionado',
                        heightAuto: true,
                        showConfirmButton: false
                    });
                }
                else
                {
                    term['usuario'] = usuario;
                    return {
                        term: term
                    };
                }
            },
            processResults: function (data) {
                return {
                    results: data
                };
            }
        }
    });
    
    /*****************************************************************************/
    
    
    $('#txtRemitenteAsignacion').select2();
    
    $("#txtPerfilUsuario").select2({
        minimumInputLength: 2,
        placeholder: 'Seleccione Perfil',
        dropdownParent: $('#editarPerfilUsuario .modal-body'),
        allowClear: true,
        language: {
            errorLoading: function() {
                return "La carga falló";
            },
            noResults: function() {
                return "No hay resultado";
            },
            searching: function() {
                return "Buscando..";
            }
        },
        ajax: {
            url: baseUrl + '/listado-perfil-select',
            dataType: 'json',
            type: "POST",
            quietMillis: 50,
            data: function (term) {
                return {
                    term: term
                };
            },
            processResults: function (data) {
                return {
                    results: data
                };
            }
        }
    });
    
    $("#txtAdjudicadoReposicion").select2({
        minimumInputLength: 2,
        placeholder: 'Seleccione Adjudicado',
        allowClear: true,
        language: {
            errorLoading: function() {
                return "La carga falló";
            },
            noResults: function() {
                return "No hay resultado";
            },
            searching: function() {
                return "Buscando..";
            }
        },
        ajax: {
            url: baseUrl + '/listado-usuarios-select',
            dataType: 'json',
            type: "POST",
            quietMillis: 50,
            data: function (term) {
                return {
                    term: term
                };
            },
            processResults: function (data) {
                return {
                    results: data
                };
            }
        }
    });
    
    $('#txtMotivoReposicion').select2();
    
    $("#txtUsuarioDevolucion").select2({
        minimumInputLength: 2,
        placeholder: 'Seleccione Usuario',
        allowClear: true,
        language: {
            errorLoading: function() {
                return "La carga falló";
            },
            noResults: function() {
                return "No hay resultado";
            },
            searching: function() {
                return "Buscando..";
            }
        },
        ajax: {
            url: baseUrl + '/listado-usuarios-select',
            dataType: 'json',
            type: "POST",
            quietMillis: 50,
            data: function (term) {
                return {
                    term: term
                };
            },
            processResults: function (data) {
                return {
                    results: data
                };
            }
        }
    });
    
    $("#txtUsuarioAsignacionURES").select2({
        minimumInputLength: 2,
        placeholder: 'Seleccione Usuario',
        dropdownParent: $('#nuevaAsignacionURES .modal-body'),
        allowClear: true,
        language: {
            errorLoading: function() {
                return "La carga falló";
            },
            noResults: function() {
                return "No hay resultado";
            },
            searching: function() {
                return "Buscando..";
            }
        },
        ajax: {
            url: baseUrl + '/listado-usuarios-select',
            dataType: 'json',
            type: "POST",
            quietMillis: 50,
            data: function (term) {
                return {
                    term: term
                };
            },
            processResults: function (data) {
                return {
                    results: data
                };
            }
        }
    });
    
    $('#txtTipoAsignacionURES').select2({
        dropdownParent: $('#nuevaAsignacionURES .modal-body')
    });
    

});
/* ------------------------------- */

function destory_editor(selector){
    if($(selector)[0])
    {
        var content = $(selector).find('.ql-editor').html();
        $(selector).html(content);

        $(selector).siblings('.ql-toolbar').remove();
        $(selector + " *[class*='ql-']").removeClass (function (index, css) {
           return (css.match (/(^|\s)ql-\S+/g) || []).join(' ');
        });

        $(selector + "[class*='ql-']").removeClass (function (index, css) {
           return (css.match (/(^|\s)ql-\S+/g) || []).join(' ');
        });
    }
}

/* ------------------------------- */

var arrValoresRandom = [];

function generarRandom(num) {
    const characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    const charactersLength = characters.length;
    let result = "";
    for (let i = 0; i < num; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }
    
    if(arrValoresRandom.includes(result))
    {
        generarRandom(num);
    }
    else
    {
        arrValoresRandom.push(result);
        return result;    
    }
}

/* ------------------------------- */

function eliminarBloqueDinamico(contenedorEliminar)
{
    $('#'+contenedorEliminar).remove();
    return false;
}

/* ------------------------------- */
$(document).on('change', '#txtModeloComercial_i', function() {
    var idDispositivo = $(this).val();
    var modal=$(this).closest('.modal.fade').attr("id");
    
    if(modal == 'informacionHardware')
    {
        $("#txtCategoriaHardware_i").empty();
        $("#txtTipoHardware_i").empty();
        $("#txtSubtipoHardware_i").empty();
        
        $.post(baseUrl + '/obtener-datos-dispositivo', 
        {         
            idDispositivo : idDispositivo
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                $("#txtCategoriaHardware_i").val(response.categoria);
                $("#txtTipoHardware_i").val(response.tipo);
                $("#txtSubtipoHardware_i").val(response.subtipo);
            }
        }, 'json'); 
    }
    
});
/* ------------------------------- */

function downloadPDF(idDiv)
{
    var divToPrint = document.getElementById(idDiv);
    var print = 'onload="window.print()"';
    var newWin = window.open('', 'Print-Window');
    newWin.document.open();
    newWin.document.write('<html><head><meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1"><title>Descargar Documento</title><meta name="viewport" content="width=device-width, initial-scale=1">\n\
                                <meta http-equiv="cache-control" content="no-cache" />\n\
                                <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css">\n\
                                <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css">\n\
                                <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">\n\
                                <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet">\n\
                                <link href="'+baseUrl+'/public/css/bootstrap.min.css" rel="stylesheet" type="text/css">\n\
                                <link href="'+baseUrl+'/public/libs/bootstrap-switch/css/bootstrap3/bootstrap-switch.min.css" rel="stylesheet" type="text/css">\n\
                                <link href="'+baseUrl+'/public/css/icons.min.css" rel="stylesheet" type="text/css">\n\
                                <link href="'+baseUrl+'/public/css/app.min.css" rel="stylesheet" type="text/css">\n\
                                <link href="'+baseUrl+'/public/css/custom.min.css" rel="stylesheet" type="text/css">\n\
                                <link rel="stylesheet" href="'+baseUrl+'/public/js/pages/plugins/toastr/toastr.min.css">\n\
                                <link rel="stylesheet" href="'+baseUrl+'/public/js/pages/plugins/sweetalert2-theme-bootstrap-4/bootstrap-4.min.css">\n\
                            </head>\n\
                            <body '+ print +' class="'+baseUrl+'">\n\
                                ' + divToPrint.innerHTML + '\n\
                                <script>$(document).ready(function () {$(".table").dataTable().fnDestroy(); $(".table").DataTable({"language": {"url": "//cdn.datatables.net/plug-ins/1.10.15/i18n/Spanish.json"}, responsive: true, stateSave: true});});</script>\n\
                            </body>\n\
                          </html>');
    newWin.document.close();
}

/* ------------------------------- */

function selectDireccionEstructura(elemento, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/listado-direccion-estructura', 
    {
    }, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var direcciones = $.parseJSON(response.listadoDirecciones);
            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            for(var i = 0; i < direcciones.length; i++){
                $("#"+elemento).append('\
                    <option value="' + direcciones[i].id + '" '+(idSeleccionado == direcciones[i].id ? 'selected' : '')+'>' + direcciones[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2({
        dropdownParent: $('#'+modal+' .modal-body')
    });
}

/* ------------------------------- */

function selectAreaEstructura(elemento, idDireccion, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/listado-area-estructura', 
    {
        idDireccion : idDireccion
    }, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var areas = $.parseJSON(response.listadoAreas);
            $("#"+elemento).append('\
                    <option value="">Seleccione una opción</td>\n\
                ');
            for(var i = 0; i < areas.length; i++){
                $("#"+elemento).append('\
                    <option value="' + areas[i].id + '" '+(idSeleccionado == areas[i].id ? 'selected' : '' )+'>' + areas[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2({
        dropdownParent: $('#'+modal+' .modal-body')
    });
}

/* ------------------------------- */

function selectSubareaEstructura(elemento, idArea, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/listado-subarea-estructura', 
    {
        idArea : idArea
    }, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var subareas = $.parseJSON(response.listadoSubareas);
            $("#"+elemento).append('\
                    <option value="">Seleccione una opción</td>\n\
                ');
            for(var i = 0; i < subareas.length; i++){
                $("#"+elemento).append('\
                    <option value="' + subareas[i].id + '" '+(idSeleccionado == subareas[i].id ? 'selected' : '' )+'>' + subareas[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2({
        dropdownParent: $('#'+modal+' .modal-body')
    });
}

function selectCategorias(elemento, idSeleccionado, modal)
{
    $.post(baseUrl + '/obtener-categorias', 
    {}, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var categorias = $.parseJSON(response.listadoCategorias);

            for(var i = 0; i < categorias.length; i++){
                $("#"+elemento).append('\
                    <option value="' + categorias[i].id + '" '+(idSeleccionado == categorias[i].id ? 'selected' : '')+'>' + categorias[i].categoria +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2({
        dropdownParent: $('#'+modal+' .modal-body')
    });
}

function selectTipos(elemento, idCategoria, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/obtener-tipos', 
    {
        idCategoria : idCategoria
    }, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var tipos = $.parseJSON(response.listadoTipos);
            $("#"+elemento).append('\
                    <option value="">Seleccione una opción</td>\n\
                ');
            for(var i = 0; i < tipos.length; i++){
                $("#"+elemento).append('\
                    <option value="' + tipos[i].id + '" '+(idSeleccionado == tipos[i].id ? 'selected' : '' )+'>' + tipos[i].tipo +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2({
        dropdownParent: $('#'+modal+' .modal-body')
    });
}

function selectSubtipos(elemento, idTipo, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/obtener-subtipos', 
    {         
        idTipo : idTipo
    }, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var subtipos = $.parseJSON(response.listadoSubtipos);
            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            for(var i = 0; i < subtipos.length; i++){
                $("#"+elemento).append('\
                    <option value="' + subtipos[i].id + '" '+(idSeleccionado == subtipos[i].id ? 'selected' : '' )+'>' + subtipos[i].subtipo +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2({
        dropdownParent: $('#'+modal+' .modal-body')
    });
}

function selectMarcas(elemento, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/obtener-marcas', 
    {}, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var marcas = $.parseJSON(response.listadoMarcas);
            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            for(var i = 0; i < marcas.length; i++){
                $("#"+elemento).append('\
                    <option value="' + marcas[i].id + '" '+(idSeleccionado == marcas[i].id ? 'selected' : '')+'>' + marcas[i].marca +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2({
        dropdownParent: $('#'+modal+' .modal-body')
    });
}

function selectDispositivos(elemento, idMarca, idSeleccionado, categoria, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/obtener-dispositivos', 
    {
        idMarca : idMarca,
        categoria : categoria
    }, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var dispositivos = $.parseJSON(response.listadoDispositivos);
            $("#"+elemento).append('\
                    <option value="">Seleccione una opción</td>\n\
                ');
            for(var i = 0; i < dispositivos.length; i++){
                $("#"+elemento).append('\
                    <option value="' + dispositivos[i].id + '" '+(idSeleccionado == dispositivos[i].id ? 'selected' : '' )+'>' + dispositivos[i].dispositivo +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2({
        dropdownParent: $('#'+modal+' .modal-body')
    });
}

function selectOperadores(elemento, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/obtener-operadores', 
    {}, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var operadores = $.parseJSON(response.listadoOperadores);
            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            for(var i = 0; i < operadores.length; i++){
                $("#"+elemento).append('\
                    <option value="' + operadores[i].id + '" '+(idSeleccionado == operadores[i].id ? 'selected' : '')+'>' + operadores[i].operador +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2({
        dropdownParent: $('#'+modal+' .modal-body')
    });
}

function selectPlanes(elemento, idOperador, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/obtener-planes', 
    {
        idOperador : idOperador
    }, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var planes = $.parseJSON(response.listadoPlanes);
            $("#"+elemento).append('\
                    <option value="">Seleccione una opción</td>\n\
                ');
            for(var i = 0; i < planes.length; i++){
                $("#"+elemento).append('\
                    <option value="' + planes[i].id + '" '+(idSeleccionado == planes[i].id ? 'selected' : '' )+'>' + planes[i].plan +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2({
        dropdownParent: $('#'+modal+' .modal-body')
    });
}

function selectEstadosMovil(elemento,idSeleccionado)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/obtener-estados-movil', 
    {}, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var estados = $.parseJSON(response.listadoEstados);
            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            for(var i = 0; i < estados.length; i++){
                $("#"+elemento).append('\
                    <option value="' + estados[i].id + '" '+(idSeleccionado == estados[i].id ? 'selected' : '')+'>' + estados[i].estado +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2();
}

function selectMotivosEstadoMovil(elemento, estado, idSeleccionado)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/obtener-motivos-estado-movil', 
    {
        estado : estado
    }, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var motivos = $.parseJSON(response.listadoMotivos);
            $("#"+elemento).append('\
                    <option value="">Seleccione una opción</td>\n\
                ');
            for(var i = 0; i < motivos.length; i++){
                $("#"+elemento).append('\
                    <option value="' + motivos[i].id + '" '+(idSeleccionado == motivos[i].id ? 'selected' : '' )+'>' + motivos[i].motivo +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2();
}
function selectEstadosLinea(elemento,idSeleccionado)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/obtener-estados-linea', 
    {}, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var estados = $.parseJSON(response.listadoEstados);
            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            for(var i = 0; i < estados.length; i++){
                $("#"+elemento).append('\
                    <option value="' + estados[i].id + '" '+(idSeleccionado == estados[i].id ? 'selected' : '')+'>' + estados[i].estado +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2();
}

function selectMotivosEstadoLinea(elemento, estado, idSeleccionado,modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/obtener-motivos-estado-linea', 
    {
        estado : estado
    }, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var motivos = $.parseJSON(response.listadoMotivos);
            $("#"+elemento).append('\
                    <option value="">Seleccione una opción</td>\n\
                ');
            for(var i = 0; i < motivos.length; i++){
                $("#"+elemento).append('\
                    <option value="' + motivos[i].id + '" '+(idSeleccionado == motivos[i].id ? 'selected' : '' )+'>' + motivos[i].motivo +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2({
        dropdownParent: $('#'+modal+' .modal-body')
    });
}

function clickOne(flag){
    
    $("button[type=submit]").prop('disabled',flag);

}

function selectCabeceraModulo(elemento, idSeleccionado, modal)
{
    $.post(baseUrl + '/obtener-cabecera', 
    {}, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var cabecera = $.parseJSON(response.listadoCabecera);

            for(var i = 0; i < cabecera.length; i++){
                $("#"+elemento).append('\
                    <option value="' + cabecera[i].id + '" '+(idSeleccionado == cabecera[i].id ? 'selected' : '')+'>' + cabecera[i].cabecera +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2({
        dropdownParent: $('#'+modal+' .modal-body')
    });
}

/* ------------------------------- */

function selectElementoDemo(elemento, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/listado-elementos-demo', 
    {
    }, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var elementosDemo = $.parseJSON(response.listadoElementosDemo);
            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            for(var i = 0; i < elementosDemo.length; i++){
                $("#"+elemento).append('\
                    <option value="' + elementosDemo[i].id + '" '+(idSeleccionado == elementosDemo[i].id ? 'selected' : '')+'>' + elementosDemo[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2({
        dropdownParent: $('#'+modal+' .modal-body')
    });
}
/* ------------------------------- */
$(document).on('submit', '.formulario', function() {
    
    var formulario = $(this);
    var metodoEnvio = formulario.attr('method');
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });

    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: new FormData(this),
        contentType: false,
        cache: false,
        processData: false,
        success: function(response) {
            //$.unblockUI({});
            Swal.close();
            formulario.find('.respuesta').html(response);
            console.log(response);
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            //$.unblockUI({});
            Swal.close();
            alert('Ha ocurrido un error interno.');
            console.log(jqXHR );
            console.log(textStatus);
            console.log(errorThrown);
        }
    });
    return false;
});
/* ------------------------------- */
$(document).on('click', '.removerInfo', function(e) {
    e.preventDefault();
    vinculo = $(this).attr("data-url");
    respuesta = $(this).attr("data-response");

    Swal.fire({
        title: '¿Estas seguro que deseas continuar?',
        text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
    }).then((result) => {
        if (result.isConfirmed) {
            $.post(vinculo, 
                { }, 
                function (response) {
                    $('.'+respuesta).html(response);
                });
                return false;
            }
    });
});
/* ------------------------------- */
$(document).on('click', '.editar-instalacion', function(e) {
    var reincidente = $(this).data('id');

    $.post(baseUrl + '/obtener-datos-instalacion', 
        {         
            reincidente : reincidente
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                var subacciones = $.parseJSON(response.listaSubAcciones);

                $('#formulario-actualizar-gestion').attr('action', baseUrl + '/actualizar-gestion/' + response.id_gestion);
                $('#gestionable').val(response.gestionable);
                $('#accion').val(response.accion_id);
                $('#estado').val(response.status);
                $('#comentarios').val(response.comentarios);
                $('#fecha_mantenimiento').val(response.fecha_mantenimiento);
                
                if(response.con_mantenimiento == "Con Mant. Agendado"){
                    $("#divMantenimiento").removeClass("d-none");
                    if(response.accion == 'Agendar visita técnica' && response.subaccion == 'Agendar visita técnica'){
                        $('#fecha_mantenimiento').prop("diasbled", false);
                    }
                } else {
                    $("#divMantenimiento").addClass("d-none");
                    if(response.accion == 'Agendar visita técnica' && response.subaccion == 'Agendar visita técnica'){
                        $('#fecha_mantenimiento').prop("diasbled", false);
                    }
                }

                for(var i = 0; i < subacciones.length; i++){
                    if(subacciones[i].id_subaccion == response.subaccion_id){
                    $("#subaccion").append('\
                        <option value="' + subacciones[i].id_subaccion + '" selected>' + subacciones[i].subaccion +'</td>\n\
                    ');
                    } else {
                        $("#subaccion").append('\
                            <option value="' + subacciones[i].id_subaccion + '" >' + subacciones[i].subaccion +'</td>\n\
                        ');
                    }
                }
            }
        }, 'json');
});
/* ------------------------------- */
$(document).on('click', '.ver-instalacion', function(e) {
    var cliente = $(this).data('id');

    $.post(baseUrl + '/obtener-gestiones-cliente', 
        {         
            cliente : cliente
        }, 
        function (response) {
            var resultado = jQuery.parseJSON(response);
            $("#bodyRutas").empty();

            for(var i = 0; i < resultado.length; i++){
                    var color = "";
                    if(resultado[i].status == "No Iniciado"){
                        color = "bg-dark";
                    } else if (resultado[i].status == "No Contactado" || resultado[i].status == "Stand By"){
                        color = "bg-info";
                    } else if (resultado[i].status == "En Progreso"){
                        color = "bg-warning";
                    } else if (resultado[i].status == "Ilocalizable" || resultado[i].status == "Inviable"){
                        color = "bg-danger";
                    } else if (resultado[i].status == "Completado"){
                        color = "bg-success";
                    } else if (resultado[i].status == "No aplica"){
                        color = "bg-primary";
                    }

                    $("#bodyRutas").append('\
                    <tr>\n\
                        <td class="text-center align-midddle">' + resultado[i].categoria +'</td>\n\
                        <td class="text-center align-midddle">' + resultado[i].gestionable +'</td>\n\
                        <td class="text-center align-midddle">' + resultado[i].accion + '</td>\n\
                        <td class="text-center align-midddle">' + resultado[i].subaccion + '</td>\n\
                        <td class="text-center align-midddle">\n\
                            <span class="badge ' + color + ' text-light">' + resultado[i].status  +'</span>\n\
                        </td>\n\
                        <td class="text-center align-midddle">' + resultado[i].fecha_gestion + '</td>\n\
                    </tr>');
            }
        });
});
/* ------------------------------- */
$('#accion').change(function () {
    var accion = $(this).val();

    $.post(baseUrl + '/subacciones', {
        accion: accion
    },
        function (response) {
            $('#subaccion').html('<option value="">Seleccione una opción</option>');
            var total = Object.keys(response).length;

            for (var i = 0; i < total; i++) {
                if (response[i].descripcion === 0) {
                    $('#subaccion').append('<option value=""></option>');
                } else {
                    $('#subaccion').append('<option value="' + response[i].id + '">' + response[i].subaccion + '</option>');
                }
            }
        }, 'json');

    if(accion == 4){
        $("#divMantenimiento").removeClass("d-none");
        $('#fecha_mantenimiento').prop("disabled", false);
    } else {
        $("#divMantenimiento").addClass("d-none");
        $('#fecha_mantenimiento').prop("disabled", true);
    }
});
/* ------------------------------- */
$('#subaccion').change(function () {
    var subaccion = $(this).val();

    if(subaccion == 10){
        $("#divMantenimiento").removeClass("d-none");
        $('#fecha_mantenimiento').prop("disabled", false);
    } else {
        $("#divMantenimiento").addClass("d-none");
        $('#fecha_mantenimiento').prop("disabled", true);
    }
});
/* ------------------------------- */
$('#filtrar_resultados').change(function () {
    var path = window.location.pathname.split('/');

    var categoria = $(this).val();




    window.location = baseUrl + "/" + path[2] + "?sort_by=" + orden;
});

/* ------------------------------- */
$(document).on('change', '#txtMarca_i', function() {
    var idMarca = $(this).val();
    var categoria = $(this).data("categoria");
    $("#txtModeloComercial_i").empty();
    var modal=$(this).closest('.modal.fade').attr("id");
    selectDispositivos('txtModeloComercial_i', idMarca, '', categoria, modal);
});
$(document).on('change', '#txtEstadoMovil_i', function() {
    var idEstado = $(this).val();
    $("#txtMotivoMovil_i").empty();
    selectMotivosEstadoMovil('txtMotivoMovil_i', idEstado, '');
});

/* ------------------------------- */
$(document).on('click', '.datos-movil', function(e) {
    const fechaActual = moment();
    const fechaFormateada = fechaActual.format("YYYY-MM-DD");
    
    $('#btnEjecutarMovil').removeClass("d-none");
    var idMovil = $(this).data('id');
    var accion = $(this).data('accion');
    
    var modal=$("#txtMarca_i").closest('.modal.fade').attr("id");
    
    if(accion == "crear")
    {
        selectMarcas("txtMarca_i",'',modal);
        $('#ctnEstadosMovil').removeClass("d-none");

        $('#txtModeloComercial_i').empty();
        $('#txtProveedor_i').val('');
        $('#txtIMEI_i').val('');
        $('#txtFechaCompra_i').val(fechaFormateada);
        $('#txtPrecioCompra_i').val('');
        $('#txtPrecioLista_i').val('');

        $('#exampleinformacionMovil').text("Crear móvil");
        $('#formInformacionMovil').attr('action', baseUrl + '/grabar-movil');

        $('#btnEjecutarMovil').html('<i class="mdi mdi-content-save"></i> Guardar');
        $('#txtMarca_i').removeAttr("disabled");
        $('#txtModeloComercial_i').removeAttr("disabled");
        $('#txtProveedor_i').removeAttr("disabled");
        $('#txtIMEI_i').removeAttr("disabled");
        $('#txtFechaCompra_i').removeAttr("disabled");
        $('#txtPrecioCompra_i').removeAttr("disabled");
        $('#txtPrecioLista_i').removeAttr("disabled");

        
        $('#txtMotivoMovil_i').empty();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-movil', 
        {         
            idMovil : idMovil
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                $('#ctnEstadosMovil').addClass("d-none");
                $('#txtFechaCompra_i').attr("disabled","disabled");
                $('#txtIMEI_i').attr("disabled","disabled");
                $('#txtMarca_i').attr("disabled","disabled");
                $('#txtModeloComercial_i').attr("disabled","disabled");

                if(accion == 'ver')
                {
                    $('#exampleinformacionMovil').text("Información de móvil");
                    $('#btnEjecutarMovil').addClass("d-none");
                    $('#formInformacionMovil').attr('action', '');

                    $('#txtProveedor_i').attr("disabled","disabled");
                    $('#txtPrecioCompra_i').attr("disabled","disabled");
                    $('#txtPrecioLista_i').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionMovil').text("Actualizar móvil");
                    $('#formInformacionMovil').attr('action', baseUrl + '/actualizar-movil/' + response.idmovil);

                    $('#txtProveedor_i').removeAttr("disabled");
                    $('#txtPrecioCompra_i').removeAttr("disabled");
                    $('#txtPrecioLista_i').removeAttr("disabled");
                    
                    if(accion == 'editar-full')
                    {
                        //alert("full");
                        $('#txtIMEI_i').removeAttr("disabled");
                        $('#txtFechaCompra_i').removeAttr("disabled");
                        $('#txtMarca_i').removeAttr("disabled");
                        $('#txtModeloComercial_i').removeAttr("disabled");
                    }
                }

                $('#txtIDMovil_i').val(response.idmovil);
                selectMarcas("txtMarca_i",response.marca, modal);
                selectDispositivos('txtModeloComercial_i', response.marca, response.modelo, $("#txtMarca_i").data("categoria"), modal);
                
                $('#txtProveedor_i').val(response.proveedor);
                $('#txtIMEI_i').val(response.imei);
                $('#txtFechaCompra_i').val(response.fecha_compra);
                $('#txtPrecioCompra_i').val(response.precio_compra);
                $('#txtPrecioLista_i').val(response.precio_lista);
            }
        }, 'json'); 
    }
});
/* ------------------------------- */
$(document).on('change', '#txtEstadoLinea', function() {
    var idEstado = $(this).val();
    $("#txtMotivoLinea").empty();
    selectMotivosEstadoLinea('txtMotivoLinea', idEstado, '', 'informacionLinea');
});

/* ------------------------------- */
$(document).on('click', '.datos-linea', function(e) {
    
    $('#btnEjecutarLinea').removeClass("d-none");
    var idLinea = $(this).data('id');
    var accion = $(this).data('accion');
    
    if(accion == "crear")
    {
        selectEstadosLinea("txtEstadoLinea",'');
        $('#ctnEstadosLinea').removeClass("d-none");

        $('#txtNumero').empty();
        $('#txtICCID').empty();
        $('#txtNumero').removeAttr("disabled");
        $('#txtICCID').removeAttr("disabled");
        $('#btnEjecutarLinea').html('<i class="mdi mdi-content-save"></i> Guardar');
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-linea', 
        {         
            idLinea : idLinea
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                $('#ctnEstadosLinea').addClass("d-none");
                $('#txtNumero').attr("disabled","disabled");
                $('#txtICCID').attr("disabled","disabled");

                if(accion == 'ver')
                {
                    $('#exampleinformacionLinea').text("Información de Línea");
                    $('#btnEjecutarLinea').addClass("d-none");
                    $('#formInformacionLinea').attr('action', '');
                    $('#ctnEstadosLinea').addClass("d-none");

                    $('#txtNumero').attr("disabled","disabled");
                    $('#txtICCID').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionLinea').text("Actualizar Línea");
                    $('#formInformacionLinea').attr('action', baseUrl + '/actualizar-linea/' + response.idlinea);
                    $('#ctnEstadosLinea').addClass("d-none");

                    $('#txtNumero').removeAttr("disabled");
                    $('#txtICCID').removeAttr("disabled");
                }

                $('#txtIDLinea_i').val(response.idlinea);
                
                $('#txtNumero').val(response.numero);
                $('#txtICCID').val(response.iccid);
            }
        }, 'json');
    }
});
/* ------------------------------- */
$(document).on('change', '#txtOperador', function() {
    var idOperador = $(this).val();
    $("#txtPlan").empty();
    selectPlanes('txtPlan', idOperador, '','agregarContrato');
});
$(document).on('change', '#txtOperador_i', function() {
    var idOperador = $(this).val();
    $("#txtPlan_i").empty();
    selectPlanes('txtPlan_i', idOperador, '','informacionContrato');
});
$(document).on('change', '#txtMarca', function() {
    var idMarca = $(this).val();
    var categoria = $(this).data("categoria");
    $("#txtModeloComercial").empty();
    var modal=$(this).closest('.modal.fade').attr("id");
    selectDispositivos("txtModeloComercial", idMarca, '', categoria, modal);
});
/* ------------------------------- */
$(document).on('click', '#crear-contrato', function(e) {
    $("#ctnPenalidadContratoVigente").empty();
    var idLinea = $(this).attr("data-linea");
    
    var parametros = {
        "idLinea"  : idLinea
	};
    $.ajax({        
        url: baseUrl + '/validar-contrato-linea-actual',
        type: "POST",
        data: parametros,
        dataType: 'json',
        success: function(response) {
            
            Swal.fire({
                title: "Mensaje: "+response.mensaje,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#282e38',
                cancelButtonColor: '#f35d5d',
                confirmButtonText: 'Confirmar'
            }).then((result) => {
                if (result.isConfirmed) {
                    const fechaActual = moment();
                    const fechaFormateada = fechaActual.format("YYYY-MM-DD");
                    
                    selectOperadores("txtOperador",'','agregarContrato');
                
                    selectMarcas("txtMarca",'','agregarContrato');
                    $('#txtOperador').removeAttr("disabled");
                    $('#txtPlan').removeAttr("disabled");
                    $('#txtInicioContrato').removeAttr("disabled");
                    $('#txtPeriodoPermanencia').removeAttr("disabled");
                
                    $('#txtInicioContrato').val(fechaFormateada);
                    $('#txtFechaCompra').val(fechaFormateada);
                    
                    $('#txtPlan').empty();
                    
                    if(response.form=='PEN')
                    {
                        $("#ctnPenalidadContratoVigente").html('<label for="txtMontoDeducible" class="form-label">Monto Penalidad:</label>\n\
                            <div class="input-group">\n\
                                <input type="number" min="1" step="0.01" class="form-control" aria-label="Monto Penalidad" id="txtMontoDeducible" name="txtMontoDeducible">\n\
                            </div>');
                    }
                    
                    $("#agregarContrato").modal("show");
                }
            });
            
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            //$.unblockUI({});
            Swal.close();
            alert('Ha ocurrido un error interno.');
            console.log(jqXHR );
            console.log(textStatus);
            console.log(errorThrown);
        }
    });
    
});
/* ------------------------------- */
$(document).on('click', '.datos-contrato', function(e) {
    $('#btnEjecutarContrato').removeClass("d-none");
    var idContrato = $(this).data('id');
    var accion = $(this).data('accion');
    
    $.post(baseUrl + '/obtener-datos-contrato', 
        {         
            idContrato : idContrato
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                
                $('#txtInicioContrato_i').attr("disabled","disabled");
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionContrato').text("Información de contrato");
                    $('#btnEjecutarContrato').addClass("d-none");
                    $('#formInformacionContrato').attr('action', '');

                    $('#txtOperador_i').attr("disabled","disabled");
                    $('#txtPlan_i').attr("disabled","disabled");
                    $('#txtDiaFacturacion_i').attr("disabled","disabled");
                    $('#txtPeriodoPermanencia_i').attr("disabled","disabled");
                    $('#txtValorCuota_i').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionContrato').text("Actualizar contrato");
                    $('#formInformacionContrato').attr('action', baseUrl + '/actualizar-contrato/' + idContrato);

                    $('#txtOperador_i').removeAttr("disabled");
                    $('#txtPlan_i').removeAttr("disabled");
                    $('#txtDiaFacturacion_i').removeAttr("disabled");
                    $('#txtPeriodoPermanencia_i').removeAttr("disabled");
                    $('#txtValorCuota_i').removeAttr("disabled");
                    $('#txtInicioContrato_i').removeAttr("disabled");
                }

                $('#txtIDContrato_i').val(response.idcontrato);
                
                selectOperadores("txtOperador_i", response.idoperador, "informacionContrato");
                selectPlanes("txtPlan_i", response.idoperador, response.idplan, "informacionContrato");
                
                $('#txtDiaFacturacion_i').val(response.diafacturacion);
                $('#txtInicioContrato_i').val(response.iniciocontrato);
                $('#txtPeriodoPermanencia_i').val(response.periodo);
                $('#txtValorCuota_i').val(response.montocuota);
            }
        }, 'json'); 
});

/* ------------------------------- */
$(document).on('click', '.datos-seguro', function(e) {
    $('#btnEjecutarSeguro').removeClass("d-none");
    var idSeguro = $(this).data('id');
    var accion = $(this).data('accion');
    
    $.post(baseUrl + '/obtener-datos-seguro', 
        {         
            idSeguro : idSeguro
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                
                $('#txtInicioContrato_i').attr("disabled","disabled");

                if(accion == 'ver')
                {
                    $('#exampleinformacionSeguro').text("Información de seguro");
                    $('#btnEjecutarSeguro').addClass("d-none");
                    $('#formInformacionSeguro').attr('action', '');

                    $('#txtNumSeguro_i').attr("disabled","disabled");
                    $('#txtServicio_i').attr("disabled","disabled");
                    $('#txtPlan_i').attr("disabled","disabled");
                    $('#txtCostoPlan_i').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionSeguro').text("Actualizar seguro");
                    $('#formInformacionSeguro').attr('action', baseUrl + '/actualizar-seguro/' + idSeguro);

                    $('#txtNumSeguro_i').removeAttr("disabled");
                    $('#txtServicio_i').removeAttr("disabled");
                    $('#txtPlan_i').removeAttr("disabled");
                    $('#txtCostoPlan_i').removeAttr("disabled");
                }

                $('#txtIdSeguro').val(response.idseguro);
                $('#txtNumSeguro_i').val(response.nro_seguro);
                $('#txtServicio_i').val(response.servicio);
                $('#txtPlan_i').val(response.plan);
                $('#txtCostoPlan_i').val(response.costo_plan);
                $('#txtInicioContrato_i').val(response.inicio_contrato);
            }
        }, 'json'); 
});
/* ------------------------------- */
$(document).on('click', '.datos-marca', function(e) {
    $('#btnEjecutarMarca').removeClass("d-none");
    var idMarca = $(this).data('id');
    var accion = $(this).data('accion');
    if(accion == 'crear')
    {
        $('#exampleinformacionMarca').text("Crear marca");
        $('#formInformacionMarca').attr('action', baseUrl + '/registrar-marca');

        $('#btnEjecutarMarca').html('<i class="mdi mdi-content-save"></i> Guardar');
        $('#txtMarca_i').removeAttr("disabled");
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-marca', 
        {         
            idMarca : idMarca
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionMarca').text("Información de marca");
                    $('#btnEjecutarMarca').addClass("d-none");
                    $('#formInformacionMarca').attr('action', '');

                    $('#txtMarca_i').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionMarca').text("Actualizar marca");
                    $('#formInformacionMarca').attr('action', baseUrl + '/actualizar-marca/' + idMarca);

                    $('#txtMarca_i').removeAttr("disabled");
                }

                $('#txtIDMarca_i').val(response.idmarca);
                $('#txtMarca_i').val(response.marca);
            }
        }, 'json'); 
    }
});

/* ------------------------------- */
$(document).on('click', '.cambiar-estado-marca', function() {
    var idMarca = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' la marca?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {

            var motivo = result.value;
            var parametros = {
                "idMarca" : idMarca,
                "estado" : estado,
                "motivo" : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-marca',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
});
/* ------------------------------- */
$(document).on('click', '.datos-dispositivo', function(e) {
    $('#btnEjecutarDispositivo').removeClass("d-none");
    var idDispositivo = $(this).data('id');
    var accion = $(this).data('accion');

    if(accion == 'crear')
    {
        selectCategorias("txtCategoriaDispositivo_i",'', "informacionDispositivo");

        $('#exampleinformacionDispositivo').text("Crear dispositivo");
        $('#formInformacionDispositivo').attr('action', baseUrl + '/registrar-dispositivo');

        $('#btnEjecutarDispositivo').html('<i class="mdi mdi-content-save"></i> Guardar');
        $('#txtModelo_i').removeAttr("disabled");
        $('#txtCategoriaDispositivo_i').removeAttr("disabled");
        $('#txtTipo_i').removeAttr("disabled");
        $('#txtSubtipo_i').removeAttr("disabled");
    }
    else 
    {
        $.post(baseUrl + '/obtener-datos-dispositivo', 
        {         
            idDispositivo : idDispositivo
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {

                if(accion == 'ver')
                {
                    $('#exampleinformacionDispositivo').text("Información de dispositivo");
                    $('#btnEjecutarDispositivo').addClass("d-none");
                    $('#formInformacionDispositivo').attr('action', '');

                    $('#txtModelo_i').attr("disabled","disabled");
                    $('#txtCategoriaDispositivo_i').attr("disabled","disabled");
                    $('#txtTipo_i').attr("disabled","disabled");
                    $('#txtSubtipo_i').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionDispositivo').text("Actualizar dispositivo");
                    $('#formInformacionDispositivo').attr('action', baseUrl + '/actualizar-dispositivo/' + idDispositivo);

                    $('#txtModelo_i').removeAttr("disabled");
                    $('#txtCategoriaDispositivo_i').removeAttr("disabled");
                    $('#txtTipo_i').removeAttr("disabled");
                    $('#txtSubtipo_i').removeAttr("disabled");
                }

                $('#txtIDDispositivo_i').val(response.iddispositivo);
                $('#txtModelo_i').val(response.modelo);
                
                selectCategorias("txtCategoriaDispositivo_i", response.idcategoria, "informacionDispositivo");
                selectTipos("txtTipo_i",response.idcategoria, response.idtipo, "informacionDispositivo");
                selectSubtipos("txtSubtipo_i",response.idtipo, response.idsubtipo, "informacionDispositivo");
            }
        }, 'json'); 
    }
});
/* ------------------------------- */
$(document).on('change', '#txtCategoriaDispositivo_i', function() {
    var idCategoria = $(this).val();
    $("#txtTipo_i").empty();
    $("#txtSubtipo_i").empty();
    selectTipos('txtTipo_i', idCategoria, '', "informacionDispositivo");
});
$(document).on('change', '#txtTipo_i', function() {
    var idTipo = $(this).val();
    $("#txtSubtipo_i").empty();
    selectSubtipos('txtSubtipo_i', idTipo, '', "informacionDispositivo");
});
/* ------------------------------- */
$(document).on('click', '.cambiar-estado-dispositivo', function() {
    var idDispositivo = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' el dispositivo?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {

            var motivo = result.value;
            var parametros = {
                "idDispositivo" : idDispositivo,
                "estado" : estado,
                "motivo" : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-dispositivo',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
});

/* ------------------------------- */
$(document).on('click', '.datos-operador', function(e) {
    $('#btnEjecutarOperador').removeClass("d-none");
    var idOperador = $(this).data('id');
    var accion = $(this).data('accion');
    if(accion == 'crear')
    {
        $('#exampleinformacionOperador').text("Crear operador");
        $('#formInformacionOperador').attr('action', baseUrl + '/registrar-operador');

        $('#btnEjecutarOperador').html('<i class="mdi mdi-content-save"></i> Guardar');
        $('#txtOperador_i').removeAttr("disabled");
        $('#txtObservacion_i').removeAttr("disabled");
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-operador', 
        {         
            idOperador : idOperador
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionOperador').text("Información de operador");
                    $('#btnEjecutarOperador').addClass("d-none");
                    $('#formInformacionOperador').attr('action', '');

                    $('#txtOperador_i').attr("disabled","disabled");
                    $('#txtObservacion_i').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionOperador').text("Actualizar operador");
                    $('#formInformacionOperador').attr('action', baseUrl + '/actualizar-operador/' + idOperador);

                    $('#txtOperador_i').removeAttr("disabled");
                    $('#txtObservacion_i').removeAttr("disabled");
                }

                $('#txtIDOperador_i').val(response.idoperador);
                $('#txtOperador_i').val(response.operador);
                $('#txtObservacion_i').val(response.observacion);
            }
        }, 'json'); 
    }
});

/* ------------------------------- */
$(document).on('click', '.cambiar-estado-operador', function() {
    var idOperador = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' el operador?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {

            var motivo = result.value;
            var parametros = {
                "idOperador" : idOperador,
                "estado" : estado,
                "motivo" : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-operador',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
});

/* ------------------------------- */
$(document).on('click', '.datos-plan', function(e) {
    $('#btnEjecutarPlan').removeClass("d-none");
    var idPlan = $(this).data('id');
    var accion = $(this).data('accion');
    if(accion == 'crear')
    {
        $('#exampleinformacionPlan').text("Crear plan");
        $('#formInformacionPlan').attr('action', baseUrl + '/registrar-plan');

        $('#btnEjecutarPlan').html('<i class="mdi mdi-content-save"></i> Guardar');
        $('#txtPlan_i').removeAttr("disabled");
        $('#txtPlanOperador_i').removeAttr("disabled");
        $('#txtPrecioPlan_i').removeAttr("disabled");
        $('#txtPorcentDescuento_i').removeAttr("disabled");
        $('#txtPrecioFinal_i').removeAttr("disabled");
        $('#txtCapacidadDescarga_i').removeAttr("disabled");
        $('#txtObservacion_i').removeAttr("disabled");
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-plan', 
        {         
            idPlan : idPlan
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionPlan').text("Información de plan");
                    $('#btnEjecutarPlan').addClass("d-none");
                    $('#formInformacionPlan').attr('action', '');

                    $('#txtPlan_i').attr("disabled","disabled");
                    $('#txtPlanOperador_i').attr("disabled","disabled");
                    $('#txtPrecioPlan_i').attr("disabled","disabled");
                    $('#txtPorcentDescuento_i').attr("disabled","disabled");
                    $('#txtPrecioFinal_i').attr("disabled","disabled");
                    $('#txtCapacidadDescarga_i').attr("disabled","disabled");
                    $('#txtObservacion_i').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionPlan').text("Actualizar plan");
                    $('#formInformacionPlan').attr('action', baseUrl + '/actualizar-plan/' + idPlan);

                    $('#txtPlan_i').removeAttr("disabled");
                    $('#txtPlanOperador_i').removeAttr("disabled");
                    $('#txtPrecioPlan_i').removeAttr("disabled");
                    $('#txtPorcentDescuento_i').removeAttr("disabled");
                    $('#txtPrecioFinal_i').removeAttr("disabled");
                    $('#txtCapacidadDescarga_i').removeAttr("disabled");
                    $('#txtObservacion_i').removeAttr("disabled");
                }

                $('#txtIDPlan_i').val(response.idplan);
                $('#txtPlan_i').val(response.plan);
                $('#txtPlanOperador_i').val(response.planoperador);
                $('#txtPrecioPlan_i').val(response.precioplan);
                $('#txtPorcentDescuento_i').val(response.descuento);
                $('#txtPrecioFinal_i').val(response.preciofinal);
                $('#txtCapacidadDescarga_i').val(response.capacidad);
                $('#txtObservacion_i').val(response.observacion);
            }
        }, 'json'); 
    }
});

/* ------------------------------- */
$(document).on('click', '.cambiar-estado-plan', function() {
    var idPlan = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' el plan?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {

            var motivo = result.value;
            var parametros = {
                "idPlan" : idPlan,
                "estado" : estado,
                "motivo" : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-plan',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */
$(document).on('change', '#txtItem', function(e) {
    var idItem = $(this).val();
    var elemento = $("#txtElementoNuevaAsignacion").val();
    if(idItem != '')
    {
        $.post(baseUrl + '/obtener-monto-reposicion', 
        {         
            idItem : idItem,
            elemento : elemento
        }, 
        function(response) {
            if (response.descripcion === 0) {
                alert("Ocurrió un error al obtener los datos.");
            } else {
                $('#txtMontoReposicion').val(response.reposicion);
                $('#txtMonedaReposicion').val(response.moneda);
                $('#lblMonedaReposicion').html(response.simbolo);
            }
        }, 'json'); 
    }
});

/* ------------------------------- */

$(document).on('click', '#btnAgregarElementoAsignacion', function(e) {
    var elemento = $("#txtElementoNuevaAsignacion").val();
    var lblelemento = $("#txtElementoNuevaAsignacion option:selected").text();
    var item = $("#txtItem").val();
    var lblitem = $("#txtItem").select2('data')[0]['text'];
    var reposicion = $("#txtMontoReposicion").val() == '' ? '0' : $("#txtMontoReposicion").val();
    var observacionElemento = $("#txtObservacionElemento").val();
    
    var moneda = $('#txtMonedaReposicion').val();
    var lblmoneda = $('#lblMonedaReposicion').html();

    var elementosSeleccionados = [];
    $(document).find("input[name='correlativoAsignacion[]']").each(function() {
        elementosSeleccionados.push($(this).val());
    });
    
    if(elementosSeleccionados.includes(elemento+"-"+item))
    {
        Swal.fire({
            html: 'No puede seleccionar el mismo item 2 veces',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else if(elemento == '')
    {
        Swal.fire({
            html: 'Debe seleccionar el elemento a asignar',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else if(item == '')
    {
        Swal.fire({
            html: 'Debe seleccionar el item a asignar',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else
    {
        tableDetalleAsignacion.row
            .add([
                lblelemento+"<input type='hidden' name='elemento[]' value='"+elemento+"'> <input type='hidden' name='correlativoAsignacion[]' value='"+elemento+"-"+item+"' disabled>",
                lblitem+"<input type='hidden' name='item[]' value='"+item+"'>"+"<input type='hidden' name='etiquetaitem[]' value='"+lblitem+"'>",
                observacionElemento+"<input type='hidden' name='obselemento[]' value='"+observacionElemento+"'>",
                lblmoneda+" "+reposicion+"<input type='hidden' name='reposicion[]' value='"+reposicion+"'><input type='hidden' name='moneda[]' value='"+moneda+"'>",
                "<button class='btn btn-danger btnDelete'><span class='mdi mdi-trash-can'></span></button>"
            ])
            .draw(false);
        
        $("#txtElementoNuevaAsignacion").val("");
        $("#txtMontoReposicion").val("");
                $('#txtMonedaReposicion').val("PEN");
                $('#lblMonedaReposicion').html("S/");
        $('#txtItem').html('');
        $("#txtItem").val(null).trigger('change');
        $("#txtObservacionElemento").val("");
    }
});

tableDetalleAsignacion.on('click', 'button.btnDelete', function() {
    let $tr = $(this).closest('tr');
  
    // Le pedimos al DataTable que borre la fila
    tableDetalleAsignacion.row($tr).remove().draw(false);
  });
  
/* ------------------------------- */

$(document).on('click', '.datos-modulo', function(e) {
    $('#btnEjecutarModulo').removeClass("d-none");
    var idModulo = $(this).data('id');
    var accion = $(this).data('accion');
    if(accion == 'crear')
    {
        $('#exampleinformacionModulo').text("Registrar módulo");
        $('#formInformacionModulo').attr('action', baseUrl + '/registrar-modulo');

        $('#btnEjecutarModulo').html('<i class="mdi mdi-content-save"></i> Guardar');

        selectCabeceraModulo("txtCabecera_i", "", "informacionModulo")

        $('#txtModulo_i').removeAttr("disabled");
        $('#txtOrden_i').removeAttr("disabled");
        $('#txtIcono_i').removeAttr("disabled");
        $('#txtObservacionModulo_i').removeAttr("disabled");

        $('#txtModulo_i').val("");
        $('#txtOrden_i').val("");
        $('#txtIcono_i').val("");
        $('#txtObservacionModulo_i').val("");
        $('#txtModulo_i').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-modulo', 
        {         
            idModulo : idModulo
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionModulo').text("Información de módulo");
                    $('#btnEjecutarModulo').addClass("d-none");
                    $('#formInformacionModulo').attr('action', '');

                    $('#txtModulo_i').attr("disabled","disabled");
                    $('#txtIcono_i').attr("disabled","disabled");
                    $('#txtOrden_i').attr("disabled","disabled");
                    $('#txtObservacionModulo_i').attr("disabled","disabled");
                    $('#txtCabecera_i').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionModulo').text("Actualizar módulo");
                    $('#formInformacionModulo').attr('action', baseUrl + '/actualizar-modulo/' + idModulo);

                    $('#txtIcono_i').removeAttr("disabled");
                    $('#txtModulo_i').removeAttr("disabled");
                    $('#txtOrden_i').removeAttr("disabled");
                    $('#txtObservacionModulo_i').removeAttr("disabled");
                    $('#txtCabecera_i').removeAttr("disabled");
                }

                selectCabeceraModulo("txtCabecera_i", response.cabecera, "informacionModulo")

                $('#txtModulo_i').val(response.modulo);
                $('#txtOrden_i').val(response.orden);
                $('#txtIcono_i').val(response.icono);
                $('#txtObservacionModulo_i').val(response.observacion);
            }
        }, 'json'); 
    }
});

/* ------------------------------- */

$(document).on('click', '#btnAgregarRutasModulo', function(e) {
    var ruta = $("#txtRutaModulo").val();

    if(ruta == '')
    {
        Swal.fire({
            html: 'Debe digitar la ruta perteneciente al módulo.',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else
    {
        tableRutasModuloAgregar.row
            .add([
                ruta+"<input type='hidden' name='rutasModulo[]' value='"+ruta+"'>",
                "<button class='btn btn-danger btnDelete'><span class='mdi mdi-trash-can'></span></button>"
            ])
            .draw(false);
        
        $("#txtRutaModulo").val("");
        $("#txtRutaModulo").focus();
    }
});

tableRutasModuloAgregar.on('click', 'button.btnDelete', function(e) {
    e.preventDefault();
    let $tr = $(this).closest('tr');
  
    // Le pedimos al DataTable que borre la fila
    tableRutasModuloAgregar.row($tr).remove().draw(false);
  });
  
/* ------------------------------- */

$(document).on('keypress', '#txtCodigoAccionModulo', function(event) {
    var regex = new RegExp("^[a-zA-Z0-9]+$");
    var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
    if (!regex.test(key)) {
      event.preventDefault();
      return false;
    }
    else if(this.value.length >= 6)
    {
        event.preventDefault();
        return false;
    }
  });

/* ------------------------------- */

  $(document).on('click', '#editar-perfil-usuario', function(e) {
    
    var idUsuario = $(this).data('id');
    $('#formEditarPerfilUsuario').attr('action', baseUrl + '/modificar-usuario/' + idUsuario);
    
    $('#txtPerfilUsuario').val("");
    $('#txtPassword').focus();
});

/* ------------------------------- */
$(document).on('click', '.datos-ruta-modulo', function(e) {
    $('#btnEjecutarRutasModulo').removeClass("d-none");
    var idRutaModulo = $(this).data('id');
    var idModulo = $(this).data('modulo');
    var accion = $(this).data('accion');
    if(accion == 'crear')
    {
        $('#exampleinformacionRutasModulo').text("Crear Ruta");
        $('#formInformacionRutasModulo').attr('action', baseUrl + '/grabar-ruta/'+idModulo);

        $('#btnEjecutarRutasModulo').html('<i class="mdi mdi-content-save"></i> Guardar');
        $('#txtRutaModulo').removeAttr("disabled");
        $('#txtTipoRuta_i').removeAttr("disabled");
        $('#chkRutaRaiz').removeAttr("disabled");
        $('#chkRutaRaiz').removeAttr("checked", "checked");
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-ruta-modulo', 
        {         
            idRutaModulo : idRutaModulo
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionRutasModulo').text("Información de Ruta");
                    $('#btnEjecutarRutasModulo').addClass("d-none");
                    $('#formInformacionRutasModulo').attr('action', '');

                    $('#txtRutaModulo').attr("disabled","disabled");
                    $('#txtTipoRuta_i').attr("disabled","disabled");
                    $('#chkRutaRaiz').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionRutasModulo').text("Actualizar Ruta");
                    $('#formInformacionRutasModulo').attr('action', baseUrl + '/actualizar-ruta-modulo/' + idRutaModulo);

                    $('#txtRutaModulo').removeAttr("disabled");
                    $('#txtTipoRuta_i').removeAttr("disabled");
                    $('#chkRutaRaiz').removeAttr("disabled");
                }

                $('#txtIDRutaModulo_i').val(response.idruta);
                $('#txtRutaModulo').val(response.ruta);
                $('#txtTipoRuta_i').val(response.tipo);
                if(response.raiz=='Y')
                {
                    $('#chkRutaRaiz').attr("checked", "checked");
                }
                
            }
        }, 'json'); 
    }
});

/* ------------------------------- */
$(document).on('click', '.cambiar-estado-ruta-modulo', function() {
    var idRutaModulo = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' la ruta?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar'
    }).then((result) => {
        if (result.isConfirmed) {

            var parametros = {
                "idRutaModulo"  : idRutaModulo,
                "estado"        : estado
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-ruta-modulo',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */
$(document).on('click', '.cambiar-estado-modulo', function() {
    var idModulo = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' el módulo?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar'
    }).then((result) => {
        if (result.isConfirmed) {

            var parametros = {
                "idModulo"  : idModulo,
                "estado"        : estado
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-modulo',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

$(document).on('click', '.datos-perfil', function(e) {
    $('#btnEjecutarPerfil').removeClass("d-none");
    var idPerfil = $(this).data('id');
    var accion = $(this).data('accion');
    if(accion == 'crear')
    {
        $('#exampleinformacionPerfil').text("Registrar perfil");
        $('#formInformacionPerfil').attr('action', baseUrl + '/registrar-perfil');

        $('#btnEjecutarPerfil').html('<i class="mdi mdi-content-save"></i> Guardar');

        $('#txtPerfil').removeAttr("disabled");
        $('#txtURLBasePerfil').removeAttr("disabled");
        
        $('#txtPerfil').val("");
        $('#txtURLBasePerfil').val("");
        
        $('#txtPerfil').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-perfil', 
        {         
            idPerfil : idPerfil
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionPerfil').text("Información de perfil");
                    $('#btnEjecutarPerfil').addClass("d-none");
                    $('#formInformacionPerfil').attr('action', '');

                    $('#txtPerfil').attr("disabled","disabled");
                    $('#txtURLBasePerfil').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionPerfil').text("Actualizar perfil");
                    $('#formInformacionPerfil').attr('action', baseUrl + '/actualizar-perfil/' + idPerfil);

                    $('#txtPerfil').removeAttr("disabled");
                    $('#txtURLBasePerfil').removeAttr("disabled");
                }

                $('#txtIDPerfil_i').val(response.idperfil);
                $('#txtPerfil').val(response.perfil);
                $('#txtURLBasePerfil').val(response.url);
            }
        }, 'json'); 
    }
});

/* ------------------------------- */
$(document).on('click', '.cambiar-estado-perfil', function() {
    var idPerfil = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' el perfil?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar'
    }).then((result) => {
        if (result.isConfirmed) {

            var parametros = {
                "idPerfil"  : idPerfil,
                "estado"        : estado
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-perfil',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
    
});
/* ------------------------------- */
$(document).on('change', '#txtAdjudicadoReposicion', function(e) {
    var idUsuario = $(this).val();

    $('#txtItemReposicion').empty();
    $.post(baseUrl + '/listado-items-asignados', 
    {
        idUsuario : idUsuario
    }, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var items = $.parseJSON(response.listadoItems);
            $("#txtItemReposicion").append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            for(var i = 0; i < items.length; i++){
                $("#txtItemReposicion").append('\
                    <option value="' + items[i].id + '" >' + items[i].item +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#txtItemReposicion').select2();
});
/* ------------------------------- */
$(document).on('change', '#txtMotivoReposicion', function(e) {
    var estado = $(this).val();
    if(estado == "ROB" || estado == "PER")
    {
        $("#fileAdjuntoReposicion").prop("disabled", false);
    }
    else
    {
        $("#fileAdjuntoReposicion").prop("disabled", true);
    }
});
/* ------------------------------- */
$(document).on('change', '#txtItemReposicion', function(e) {
    var idDetalleAsignacion = $(this).val();
    var idUsuario = $("#txtAdjudicadoReposicion").val();
    var situacion = $("#txtMotivoReposicion").val();

    $('#txtMontoDescuento').val('');
    $('#txtMontoVerisure').val('');
    $('#txtMontoTrabajador').val('');

    if(idDetalleAsignacion != '')
    {
        
        if(situacion == '')
        {
            Swal.fire({
                html: 'Debe seleccionar el motivo a reponer',
                heightAuto: true,
                showConfirmButton: true
            });
            $("#txtItemReposicion").val(null).trigger('change');
        }
        else 
        {
            $.post(baseUrl + '/obtener-monto-descuento-reposicion', 
            {         
                idDetalleAsignacion : idDetalleAsignacion,
                idUsuario : idUsuario,
                situacion : situacion
            }, 
            function(response) {
                if (response.descripcion === 0) {
                    alert("Ocurrió un error al obtener los datos.");
                } else {
                    $('#txtMontoDescuento').val(response.total);
                    $('#txtMontoVerisure').val(response.verisure);
                    $('#txtMontoTrabajador').val(response.trabajador);
                }
            }, 'json'); 
        }
    }
});

/* ------------------------------- */

$(document).on('click', '#btnAgregarElementoReposicion', function(e) {
    var item = $("#txtItemReposicion").val();
    var lblitem = $("#txtItemReposicion").select2('data')[0]['text'];

    var totalDescuento = $("#txtMontoDescuento").val();
    var totalVerisure = $("#txtMontoVerisure").val();
    var totalTrabajador = $("#txtMontoTrabajador").val();
    var observacion = $("#txtObservacionElemento").val();

    var elementosSeleccionados = [];
    $(document).find("input[name='itemReposicion[]']").each(function() {
        elementosSeleccionados.push($(this).val());
    });
    
    if(elementosSeleccionados.includes(item))
    {
        Swal.fire({
            html: 'No puede seleccionar el mismo item 2 veces',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else if(item == '')
    {
        Swal.fire({
            html: 'Debe seleccionar el item a reponer',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else
    {
        tblDetalleReposicion.row
            .add([
                lblitem+"<input type='hidden' name='itemReposicion[]' value='"+item+"'>"+"<input type='hidden' name='etiquetaitem["+item+"]' value='"+lblitem+"'>",
                "S/ "+totalDescuento+"<input type='hidden' name='totalDescuento["+item+"]' value='"+totalDescuento+"'>",
                "S/ "+totalVerisure+"<input type='hidden' name='totalVerisure["+item+"]' value='"+totalVerisure+"'>",
                "S/ "+totalTrabajador+"<input type='hidden' name='totalTrabajador["+item+"]' value='"+totalTrabajador+"'>",
                observacion+"<input type='hidden' name='obselemento["+item+"]' value='"+observacion+"'>",
                "<button class='btn btn-danger btnDelete' ><span class='mdi mdi-trash-can'></span></button>"
            ])
            .draw(false);
        
        $("#txtItemReposicion").val(null).trigger('change');
        $("#txtMontoDescuento").val("");
        $("#txtMontoVerisure").val("");
        $("#txtMontoTrabajador").val("");
        $("#txtObservacionElemento").val("");
    }
});

tblDetalleReposicion.on('click', 'button.btnDelete', function() {
    let $tr = $(this).closest('tr');
  
    // Le pedimos al DataTable que borre la fila
    tblDetalleReposicion.row($tr).remove().draw(false);
  });
  
/* ------------------------------- */
$(document).on('change', '#txtUsuarioDevolucion', function(e) {
    var random = generarRandom(5);
    
    var idUsuario = $(this).val();

    $.post(baseUrl + '/pendientes-devolucion', 
    {
        idUsuario : idUsuario
    }, 
    function(response) {
        if (response.descripcion === 0) {
            $("#ctnElementosDevolucion").empty();
            $("#ctnElementosDevolucion").html('<div class="alert alert-warning" role="alert">\n\
            <h4 class="alert-heading">\n\
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-exclamation-triangle-fill flex-shrink-0 me-2" viewBox="0 0 16 16" role="img" aria-label="Warning:">\n\
                <path d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z"/>\n\
            </svg>\n\
            No hay dispositivos asignados!\n\
            </h4>\n\
            <p>No se encontraron dispositivos asignados.</p>\n\
            <hr>\n\
            <p class="mb-0">Por favor, validar los dispositivos entregados y reportarlo con SOPORTE IT.</p>\n\
          </div>')
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var items = $.parseJSON(response.listadoItems);

            $("#ctnElementosDevolucion").empty();
            for(var i = 0; i < items.length; i++){
                $("#ctnElementosDevolucion").append('<div class="row col-12 mb-3 p-3" style="border: 1px solid red;" id="ctnDevolucion'+random+'">\n\
                    <div class="col-xxl-12 col-md-12 col-12 mb-3">\n\
                        <label class="form-label">Elemento</label>\n\
                        <div class="input-group">\n\
                            <input type="hidden" name="etiqueta['+items[i].idDetalleAsignacion+'][ETIQUETA]" value="'+items[i].item+'">\n\
                            <input type="hidden" name="elemento[]" value="'+items[i].idDetalleAsignacion+'">\n\
                            <input type="text" class="form-control" value="'+items[i].item+'" disabled>\n\
                        </div>\n\
                    </div>\n\
                    <div class="col-xxl-12 col-md-12 col-12 mb-3">\n\
                        <div>\n\
                            <label for="txtSituacionElemento'+items[i].idDetalleAsignacion+'" class="form-label">Situación</label>\n\
                            <select class="form-select" aria-label="Situación" id="txtSituacionElemento'+items[i].idDetalleAsignacion+'" name="txtSituacionElemento['+items[i].idDetalleAsignacion+'][SITUACION]" required>\n\
                                <option selected="" value="">Seleccione una opción</option>\n\
                                <option value="INO">INOPERATIVO</option>\n\
                                <option value="ROB">ROBO</option>\n\
                                <option value="PER">PÉRDIDA</option>\n\
                                <option value="NOD">NO DEVOLUCIÓN</option>\n\
                                <option value="FAL">FALLA</option>\n\
                                <option value="FVU">BAJA POR FIN DE VIDA ÚTIL</option>\n\
                                <option value="DEV">DEVOLUCIÓN OK</option>\n\
                            </select>\n\
                        </div>\n\
                    </div>\n\
                    <div class="col-xxl-10 col-md-10 col-10 mb-3">\n\
                        <div>\n\
                            <label for="txtObservacionElemento'+items[i].idDetalleAsignacion+'" class="form-label">Observación</label>\n\
                            <textarea class="form-control" id="txtObservacionElemento'+items[i].idDetalleAsignacion+'" name="txtObservacionElemento['+items[i].idDetalleAsignacion+'][OBSERVACION]" rows="3" required></textarea>\n\
                        </div>\n\
                    </div>\n\
            		<div class="col-xxl-2 col-md-2 col-2 d-flex justify-content-end align-items-center">\n\
            			<button type="button" class="btn bg-danger px-2 py-1" onclick=\'return eliminarBloqueDinamico("ctnDevolucion'+random+'");\' data-tooltip="tooltip" aria-label="Eliminar Elemento">\n\
                            <i class="mdi mdi-trash-can" style="font-size: 24px; color: #FFF"></i>\n\
                        </button>\n\
            		</div>\n\
                </div>');
            }
        }
    }, 'json');
});
/* ------------------------------- */
$(document).on('click', '#btnEnviarCorreoAsignacion', function(e) {
    var idAsignacion = $(this).attr("data-id");
    
    var parametros = {
        "idAsignacion"  : idAsignacion
    };
    $.ajax({        
        url: baseUrl + '/enviar-correo-asignacion',
        type: "POST",
        data: parametros,
        success: function(response) {
            $('.respuesta_global').html(response);
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            //$.unblockUI({});
            Swal.close();
            alert('Ha ocurrido un error interno.');
            console.log(jqXHR );
            console.log(textStatus);
            console.log(errorThrown);
        }
    });
});

/* ------------------------------- */
$(document).on('click', '#btnEnviarCorreoDevolucion', function(e) {
    var idDevolucion = $(this).attr("data-id");
    
    var parametros = {
        "idDevolucion"  : idDevolucion
    };
    $.ajax({        
        url: baseUrl + '/enviar-correo-devolucion',
        type: "POST",
        data: parametros,
        success: function(response) {
            $('.respuesta_global').html(response);
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            //$.unblockUI({});
            Swal.close();
            alert('Ha ocurrido un error interno.');
            console.log(jqXHR );
            console.log(textStatus);
            console.log(errorThrown);
        }
    });
});

/* ------------------------------- */

$(document).on('click', '#btnEnviarCorreoReposicion', function(e) {
    var idReposicion = $(this).attr("data-id");
    
    var parametros = {
        "idReposicion"  : idReposicion
    };
    $.ajax({        
        url: baseUrl + '/enviar-correo-reposicion',
        type: "POST",
        data: parametros,
        success: function(response) {
            $('.respuesta_global').html(response);
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            //$.unblockUI({});
            Swal.close();
            alert('Ha ocurrido un error interno.');
            console.log(jqXHR );
            console.log(textStatus);
            console.log(errorThrown);
        }
    });
});


/* ------------------------------- */

function confirmarReposicion()
{
    event.preventDefault();

    Swal.fire({
        title: '¿Estas seguro en solicitar la reposición?',
        type: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Si',
        cancelButtonText: "No",
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
      }).then((result) => {
        if (result.value) {
        $("#frmNuevaReposicion").submit();
        }
        return false;
      })
}

/* ------------------------------- */

function recargarTablaDescuentoMensual()
{
    var mes = $("#txtMesDescuento").val();
    var anio = $("#txtAnioDescuento").val();
    $('#tblDescuentosMensual').DataTable().destroy();
    
    $("#tblDescuentosMensual").DataTable({
        "ajax": {
            "url": baseUrl + "/recargar-descuento-mensual",
            "type": "POST",
            "data": {
                "anio" : anio,
                "mes": mes
            },
            "dataSrc": function (json) {
                
                for ( var i=0, ien=json.data.length ; i<ien ; i++ ) 
                {
                    if(json.data[i]['cobrado'] == 'N')
                    {
                        json.data[i]['cobrado'] = '<span class="badge bg-danger border-0">NO</span>';
                    }
                    else
                    {
                        json.data[i]['cobrado'] = '<span class="badge bg-success border-0">SI</span>';
                    }
                    
                    if(json.data[i]['monto_cobrado'] == '')
                    {
                        json.data[i]['monto_cobrado'] = '<span class="badge bg-light border-0 text-dark">Sin información</span>';
                    }
                    else
                    {
                        json.data[i]['monto_cobrado'] = 'S/ '+json.data[i]['monto_cobrado'];
                    }
                    
                    if(json.data[i]['fecha_cobro'] == '')
                    {
                        json.data[i]['fecha_cobro'] = '<span class="badge bg-light border-0 text-dark">Sin información</span>';
                    }
                    
                    if(json.data[i]['observacion_cobro'] == '')
                    {
                        json.data[i]['observacion_cobro'] = '<span class="badge bg-light border-0 text-dark">Sin información</span>';
                    }
                    
                    json.data[i]['monto_descuento'] = 'S/ '+json.data[i]['monto_descuento'];
                    
                    
                }
                
                $("#lblSubtitulo").html(json.subtitulo);
                return json.data;
            },
            "error": function (xhr, error, thrown) {
                alert(thrown.message)
            }
        },
        columnDefs: [
            { className: "text-center align-middle", targets: "_all" }
        ],
        columns: [
           { data: 'matricula' },
           { data: 'usuario' },
           { data: 'monto_descuento' },
           { data: 'periodo' },
           { data: 'cuota' },
           { data: 'cobrado' },
           { data: 'monto_cobrado' },
           { data: 'fecha_cobro' },
           { data: 'observacion_cobro' }
        ]
    });
    $("#filtrosDescuentoMensual").modal("hide");
}
/* ------------------------------- */

function descargarDescuentosMensualPendiente()
{
    var mes = $("#txtMesDescuento").val();
    var anio = $("#txtAnioDescuento").val();
    window.open(baseUrl+"/exportar-descuento-mensual/"+mes+"/"+anio,'_blank');
}

/* ------------------------------- */

$(document).on('change', "input[name='txtImportarDescuentoCobrado']", function(e) {
    var myFile = $(this).prop('files')[0];
    
    var formData = new FormData();
    formData.append("file", myFile);
    
    $.ajax({        
        url: baseUrl+"/importar-descuento-mensual",
        type: "POST",
        data: formData,
        contentType: false,
        cache: false,
        processData: false,
        success: function(response) {
            Swal.close();
            $('.respuesta_global').html(response);
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            alert('Ha ocurrido un error interno.');
            console.log(jqXHR );
            console.log(textStatus);
            console.log(errorThrown);
        }
    });
    return false;
    // var idReposicion = $(this).attr("data-id");
    
    // var parametros = {
    //     "idReposicion"  : idReposicion
    // };
    // $.ajax({        
    //     url: baseUrl + '/enviar-correo-reposicion',
    //     type: "POST",
    //     data: parametros,
    //     success: function(response) {
    //         $('.respuesta_global').html(response);
    //     }, 
    //     error: function(jqXHR, textStatus, errorThrown){
    //         //$.unblockUI({});
    //         Swal.close();
    //         alert('Ha ocurrido un error interno.');
    //         console.log(jqXHR );
    //         console.log(textStatus);
    //         console.log(errorThrown);
    //     }
    // });
});

/* ------------------------------- */

$(document).on('click', '.datos-categoria', function(e) {
    $('#btnEjecutarCategoria').addClass("d-none");
    var idCategoria = $(this).data('id');
    var accion = $(this).data('accion');
    
    $('#txtNombreCategoria_i').attr("disabled","disabled");
    $('#txtClaveCategoria_i').attr("disabled","disabled");
    $('#txtObservacionCategoria_i').attr("disabled","disabled");
    
    $('#txtNombreCategoria_i').val("");
    $('#txtClaveCategoria_i').val("");
    $('#txtObservacionCategoria_i').val("");
        
    if(accion == 'crear')
    {
        $('#exampleinformacionCategoria').text("Registrar categoría");
        $('#formInformacionCategoria').attr('action', baseUrl + '/registrar-categoria');
        $('#btnEjecutarCategoria').removeClass("d-none");
        $('#btnEjecutarCategoria').html('<i class="mdi mdi-content-save"></i> Guardar');

        $('#txtNombreCategoria_i').removeAttr("disabled");
        $('#txtClaveCategoria_i').removeAttr("disabled");
        $('#txtObservacionCategoria_i').removeAttr("disabled");
        
        $('#txtNombreCategoria_i').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-categoria', 
        {         
            idCategoria : idCategoria
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionCategoria').text("Información del categoria");
                    $('#btnEjecutarCategoria').addClass("d-none");
                    $('#formInformacionCategoria').attr('action', '');

                    $('#txtNombreCategoria_i').attr("disabled","disabled");
                    $('#txtClaveCategoria_i').attr("disabled","disabled");
                    $('#txtObservacionCategoria_i').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionCategoria').text("Actualizar categoria");
                    $('#formInformacionCategoria').attr('action', baseUrl + '/actualizar-categoria/' + idCategoria);
                    $('#btnEjecutarCategoria').removeClass("d-none");

                    $('#txtNombreCategoria_i').removeAttr("disabled");
                    $('#txtClaveCategoria_i').removeAttr("disabled");
                    $('#txtObservacionCategoria_i').removeAttr("disabled");
                    
                }

                $('#txtNombreCategoria_i').val(response.categoria);
                $('#txtClaveCategoria_i').val(response.clave);
                $('#txtObservacionCategoria_i').val(response.observacion);
            }
        }, 'json'); 
    }
});

/* ------------------------------- */
$(document).on('click', '.cambiar-estado-categoria', function() {
    var idCategoria = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' la categoria?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            
            var motivo = result.value;
            
            var parametros = {
                "idCategoria"   : idCategoria,
                "estado"        : estado,
                "motivo"        : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-categoria',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

$(document).on('click', '.datos-tipo-categoria', function(e) {
    $('#btnEjecutarTipoCategoria').addClass("d-none");
    var idTipo = $(this).data('id');
    var accion = $(this).data('accion');
    
    $('#txtNombreTipoCategoria_i').attr("disabled","disabled");
    $('#txtObservacionTipoCategoria_i').attr("disabled","disabled");
    
    $('#txtNombreTipoCategoria_i').val("");
    $('#txtObservacionTipoCategoria_i').val("");
    
    if(accion == 'crear')
    {
        $('#exampleinformacionTipoCategoria').text("Registrar tipo de categoría");
        $('#formInformacionTipoCategoria').attr('action', baseUrl + '/registrar-tipo-categoria');
        $('#btnEjecutarTipoCategoria').removeClass("d-none");
        $('#btnEjecutarTipoCategoria').html('<i class="mdi mdi-content-save"></i> Guardar');

        $('#txtNombreTipoCategoria_i').removeAttr("disabled");
        $('#txtObservacionTipoCategoria_i').removeAttr("disabled");
        
        $('#txtNombreTipoCategoria_i').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-tipo-categoria', 
        {         
            idTipo : idTipo
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionTipoCategoria').text("Información del tipo de categoria");
                    $('#btnEjecutarTipoCategoria').addClass("d-none");
                    $('#formInformacionTipoCategoria').attr('action', '');

                    $('#txtNombreTipoCategoria_i').attr("disabled","disabled");
                    $('#txtObservacionTipoCategoria_i').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionTipoCategoria').text("Actualizar el tipo de categoria");
                    $('#formInformacionTipoCategoria').attr('action', baseUrl + '/actualizar-tipo-categoria/' + idTipo);
                    $('#btnEjecutarTipoCategoria').removeClass("d-none");

                    $('#txtNombreTipoCategoria_i').removeAttr("disabled");
                    $('#txtObservacionTipoCategoria_i').removeAttr("disabled");
                }

                $('#txtNombreTipoCategoria_i').val(response.tipo);
                $('#txtObservacionTipoCategoria_i').val(response.observacion);
            }
        }, 'json'); 
    }
});

/* ------------------------------- */
$(document).on('click', '.cambiar-estado-tipo-categoria', function() {
    var idTipo = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' el tipo de categoria?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            
            var motivo = result.value;
            
            var parametros = {
                "idTipo"    : idTipo,
                "estado"    : estado,
                "motivo"    : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-tipo-categoria',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

$(document).on('click', '.datos-subtipo-tipo-categoria', function(e) {
    $('#btnEjecutarSubtipoCategoria').addClass("d-none");
    var idSubtipo = $(this).data('id');
    var accion = $(this).data('accion');
    
    $('#txtNombreSubtipoCategoria_i').attr("disabled","disabled");
    $('#txtObservacionSubtipoCategoria_i').attr("disabled","disabled");
    
    $('#txtNombreSubtipoCategoria_i').val("");
    $('#txtObservacionSubtipoCategoria_i').val("");
    
    if(accion == 'crear')
    {
        $('#exampleinformacionSubtipoCategoria').text("Registrar subtipo de categoría");
        $('#formInformacionSubtipoCategoria').attr('action', baseUrl + '/registrar-subtipo-tipo');
        $('#btnEjecutarSubtipoCategoria').removeClass("d-none");
        $('#btnEjecutarSubtipoCategoria').html('<i class="mdi mdi-content-save"></i> Guardar');

        $('#txtNombreSubtipoCategoria_i').removeAttr("disabled");
        $('#txtObservacionSubtipoCategoria_i').removeAttr("disabled");
        
        $('#txtNombreSubtipoCategoria_i').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-subtipo-tipo', 
        {         
            idSubtipo : idSubtipo
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionSubtipoCategoria').text("Información del subtipo de categoría");
                    $('#btnEjecutarSubtipoCategoria').addClass("d-none");
                    $('#formInformacionSubtipoCategoria').attr('action', '');

                    $('#txtNombreSubtipoCategoria_i').attr("disabled","disabled");
                    $('#txtObservacionSubtipoCategoria_i').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionSubtipoCategoria').text("Actualizar el subtipo de categoría");
                    $('#formInformacionSubtipoCategoria').attr('action', baseUrl + '/actualizar-subtipo-tipo/' + idSubtipo);
                    $('#btnEjecutarSubtipoCategoria').removeClass("d-none");

                    $('#txtNombreSubtipoCategoria_i').removeAttr("disabled");
                    $('#txtObservacionSubtipoCategoria_i').removeAttr("disabled");
                }

                $('#txtNombreSubtipoCategoria_i').val(response.subtipo);
                $('#txtObservacionSubtipoCategoria_i').val(response.observacion);
            }
        }, 'json'); 
    }
});

/* ------------------------------- */
$(document).on('click', '.cambiar-estado-subtipo-tipo-categoria', function() {
    var idSubtipo = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' el subtipo de categoria?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            
            var motivo = result.value;
            
            var parametros = {
                "idSubtipo" : idSubtipo,
                "estado"    : estado,
                "motivo"    : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-subtipo-tipo',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

$(document).on('click', '.datos-tarjeta-acceso', function(e) {
    $('#btnEjecutarTarjetaAcceso').addClass("d-none");
    var idTarjetaAcceso = $(this).data('id');
    var accion = $(this).data('accion');
    
    $('#txtSerieTarjetaAcceso_i').attr("disabled","disabled");
    $('#txtPrecioCompra_i').attr("disabled","disabled");
    $('#txtObservacionTarjetaAcceso_i').attr("disabled","disabled");
    
    $('#txtSerieTarjetaAcceso_i').val("");
    $('#txtPrecioCompra_i').val("");
    $('#txtObservacionTarjetaAcceso_i').val("");
        
    if(accion == 'crear')
    {
        $('#exampleinformacionTarjetaAcceso').text("Registrar tarjeta de acceso");
        $('#formInformacionTarjetaAcceso').attr('action', baseUrl + '/registrar-tarjeta-acceso');
        $('#btnEjecutarTarjetaAcceso').removeClass("d-none");
        $('#btnEjecutarTarjetaAcceso').html('<i class="mdi mdi-content-save"></i> Guardar');

        $('#txtSerieTarjetaAcceso_i').removeAttr("disabled");
        $('#txtPrecioCompra_i').removeAttr("disabled");
        $('#txtObservacionTarjetaAcceso_i').removeAttr("disabled");
        
        $('#txtSerieTarjetaAcceso_i').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-tarjeta-acceso', 
        {         
            idTarjetaAcceso : idTarjetaAcceso
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionTarjetaAcceso').text("Información de la tarjeta de acceso");
                    $('#btnEjecutarTarjetaAcceso').addClass("d-none");
                    $('#formInformacionTarjetaAcceso').attr('action', '');

                    $('#txtSerieTarjetaAcceso_i').attr("disabled","disabled");
                    $('#txtPrecioCompra_i').attr("disabled","disabled");
                    $('#txtObservacionTarjetaAcceso_i').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionTarjetaAcceso').text("Actualizar tarjeta de acceso");
                    $('#formInformacionTarjetaAcceso').attr('action', baseUrl + '/actualizar-tarjeta-acceso/' + idTarjetaAcceso);
                    $('#btnEjecutarTarjetaAcceso').removeClass("d-none");

                    $('#txtSerieTarjetaAcceso_i').removeAttr("disabled");
                    $('#txtPrecioCompra_i').removeAttr("disabled");
                    $('#txtObservacionTarjetaAcceso_i').removeAttr("disabled");
                }

                $('#txtIDTarjetaAcceso_i').val(response.idtarjetaacceso);
                $('#txtSerieTarjetaAcceso_i').val(response.serie);
                $('#txtPrecioCompra_i').val(response.precio);
                $('#txtObservacionTarjetaAcceso_i').val(response.observacion);
            }
        }, 'json'); 
    }
});

/* ------------------------------- */

$(document).on('change', '#txtDireccionReserva_i', function() {
    var idDireccion = $(this).val();
    $("#txtAreaReserva_i").empty();
    $("#txtSubareaReserva_i").empty();
    var formulario=$(this).closest('form').attr("id");
    
    selectAreaEstructura('txtAreaReserva_i', idDireccion, '', formulario);
});
$(document).on('change', '#txtAreaReserva_i', function() {
    var idArea = $(this).val();
    $("#txtSubareaReserva_i").empty();
    var formulario=$(this).closest('form').attr("id");
    
    selectSubareaEstructura('txtSubareaReserva_i', idArea, '', formulario);
});
/* ------------------------------- */

$(document).on('click', '.datos-hardware', function(e) {
    $('#btnEjecutarHardware').addClass("d-none");
    var idHardware = $(this).data('id');
    var accion = $(this).data('accion');
    var formulario = $(this).data('bs-target');
    //var formulario=$(this).closest('form').attr("id");
    
    $(formulario + ' input[type=text]').attr("disabled","disabled");
    $(formulario + ' input[type=date]').attr("disabled","disabled");
    $(formulario + ' input[type=number]').attr("disabled","disabled");
    $(formulario + ' select').attr("disabled","disabled");
    
    $(formulario + ' input[type=text]').val("");
    $(formulario + ' input[type=date]').val("");
    $(formulario + ' input[type=number]').val("");
    $(formulario + ' select').val("");
    
    if(accion == 'crear')
    {
        selectMarcas("txtMarca_i",'',formulario.substring(1));
        
        $('#exampleinformacionHardware').text("Registrar hardware");
        $('#formInformacionHardware').attr('action', baseUrl + '/registrar-hardware');
        $('#btnEjecutarHardware').removeClass("d-none");
        $('#btnEjecutarHardware').html('<i class="mdi mdi-content-save"></i> Guardar');

        $(formulario + ' input[type=text]').removeAttr("disabled");
        $(formulario + ' input[type=date]').removeAttr("disabled");
        $(formulario + ' input[type=number]').removeAttr("disabled");
        $(formulario + ' select').removeAttr("disabled");
        
        $("#txtCategoriaHardware_i").attr("disabled","disabled");
        $("#txtTipoHardware_i").attr("disabled","disabled");
        $("#txtSubtipoHardware_i").attr("disabled","disabled");
        $('#txtMonedaCompraHardware_i').val("PEN").trigger('change');
        
        selectDireccionEstructura("txtDireccionReserva_i", '',formulario.substring(1));
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-hardware', 
        {         
            idHardware : idHardware
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionHardware').text("Información del hardware");
                    $('#btnEjecutarHardware').addClass("d-none");
                    $('#formInformacionHardware').attr('action', '');

                    $(formulario + ' input[type=text]').attr("disabled","disabled");
                    $(formulario + ' input[type=date]').attr("disabled","disabled");
                    $(formulario + ' input[type=number]').attr("disabled","disabled");
                    $(formulario + ' select').attr("disabled","disabled");
                    
                }
                else
                {
                    $('#exampleinformacionHardware').text("Actualizar hardware");
                    $('#formInformacionHardware').attr('action', baseUrl + '/actualizar-hardware/' + idHardware);
                    $('#btnEjecutarHardware').removeClass("d-none");

                    $(formulario + ' input[type=text]').removeAttr("disabled");
                    $(formulario + ' input[type=date]').removeAttr("disabled");
                    $(formulario + ' input[type=number]').removeAttr("disabled");
                    $(formulario + ' select').removeAttr("disabled");
                    
                }

                $("#txtCategoriaHardware_i").attr("disabled","disabled");
                $("#txtTipoHardware_i").attr("disabled","disabled");
                $("#txtSubtipoHardware_i").attr("disabled","disabled");
                
                selectMarcas("txtMarca_i",response.idmarca,formulario.substring(1));
                selectDispositivos('txtModeloComercial_i', response.idmarca, response.idmodelo, $("#txtMarca_i").data("categoria"),formulario.substring(1));
                
                $('#txtIDHardware_i').val(response.idhardware);
                $('#txtHostnameHardware_i').val(response.hostnamehardware);
                $('#txtSerieHardware_i').val(response.serie);
                $('#txtTAGHardware_i').val(response.tag);
                $('#txtProcesadorHardware_i').val(response.procesador);
                $('#txtGenProcesadorHardware_i').val(response.generacion);
                $('#txtRamHardware_i').val(response.ram);
                $('#txtTipoRAMHardware_i').val(response.tiporam);
                $('#txtHDDHardware_i').val(response.hdd);
                $('#txtSSDHardware_i').val(response.ssd);
                $('#txtPulgadasHardware_i').val(response.pulgadas);
                $('#txtInicioGarantia_i').val(response.iniciogarantia);
                $('#txtFinalGarantia_i').val(response.finalgarantia);
                $('#txtFinalVidaUtil_i').val(response.finalvidautil);
                $('#txtDetalleHardware_i').val(response.detalle);
                
                selectDireccionEstructura("txtDireccionReserva_i", response.iddireccion,formulario.substring(1));
                selectAreaEstructura('txtAreaReserva_i', response.iddireccion, response.idarea, formulario.substring(1));
                selectSubareaEstructura('txtSubareaReserva_i', response.idarea, response.idsubarea, formulario.substring(1));
                
                if(response.iddireccion!='' && response.iddireccion!=null && response.idarea!= '' && response.idarea!=null && response.idsubarea!='' && response.idsubarea!=null)
                {
                    $("#txtDireccionReserva_i").attr("disabled","disabled");
                    $("#txtAreaReserva_i").attr("disabled","disabled");
                    $("#txtSubareaReserva_i").attr("disabled","disabled");
                }
                
                $('#txtAlbaranHardware_i').val(response.albaran);
                $('#txtFacturaHardware_i').val(response.factura);
                $('#txtOCHardware_i').val(response.ordencompra);
                $('#txtFechaCompra_i').val(response.fechacompra);
                $('#txtPrecioCompra_i').val(response.preciocompra);
                $('#txtMonedaCompraHardware_i').val(response.monedacompra).trigger('change');
                
                $("#txtCategoriaHardware_i").val(response.categoria);
                $("#txtTipoHardware_i").val(response.tipo);
                $("#txtSubtipoHardware_i").val(response.subtipo);
                
                response.procesador == '' || $('#txtProcesadorHardware_i').val() > 0 ? '' : $("#txtProcesadorHardware_i").append($('<option>', {value: response.procesador,text: response.procesador,selected: true}));
                response.generacion == '' || $('#txtGenProcesadorHardware_i').val() > 0 ? '' : $("#txtGenProcesadorHardware_i").append($('<option>', {value: response.generacion,text: response.generacion+" generación",selected: true}));
                response.ram == '' || $('#txtRamHardware_i').val() > 0 ? '' : $("#txtRamHardware_i").append($('<option>', {value: response.ram,text: response.ram+" GB",selected: true}));
                response.hdd == '' || $('#txtHDDHardware_i').val() > 0 ? '' : $("#txtHDDHardware_i").append($('<option>', {value: response.hdd,text: response.hdd+" GB",selected: true}));
                response.ssd == '' || $('#txtSSDHardware_i').val() > 0 ? '' : $("#txtSSDHardware_i").append($('<option>', {value: response.ssd,text: response.ssd+" GB",selected: true}));
                response.pulgadas == '' || $('#txtPulgadasHardware_i').val() > 0 ? '' : $("#txtPulgadasHardware_i").append($('<option>', {value: response.pulgadas,text: response.pulgadas+"''",selected: true}));
            }
        }, 'json'); 
    }
});

/* ------------------------------- */

  $(document).on('click', '#editar-direcciones-tarjeta-acceso', function(e) {
    $("#ctnDireccionesTarjetaAcceso").empty();
    $("#txtIDTarjetaAcceso").val('');
    
    var idTarjetaAcceso = $(this).data('id');
    
    $.post(baseUrl + '/listado-direcciones-tarjeta-acceso', 
    {         
        idTarjetaAcceso : idTarjetaAcceso
    }, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            
            var direcciones = $.parseJSON(response.listadoDirecciones);
            
            var opc = '';
            
            for(var i = 0; i < direcciones.length; i++)
            {
                opc += '<div class="col-xxl-12 col-md-12 col-12 my-2 px-3">\n\
					<div class="form-check form-switch d-flex">\n\
						<input class="form-check-input" type="checkbox" role="switch" name="direcciones['+direcciones[i].iddireccion+']" id="chkDireccion'+direcciones[i].iddireccion+'" '+(direcciones[i].activo == 1 ? "checked" : "")+' >\n\
						<label class="form-check-label col-12" style="text-align: right;" for="chkDireccion'+direcciones[i].iddireccion+'">'+direcciones[i].direccion+'</label>\n\
					</div>\n\
					<input type="hidden" name="nombre['+direcciones[i].iddireccion+']" value="'+direcciones[i].direccion+'">\n\
				</div><hr>';
            }
            
            $('#formEditarDireccionesTarjetaAcceso').attr('action', baseUrl + '/grabar-direcciones-tarjeta-acceso/' + idTarjetaAcceso);
            $("#txtIDTarjetaAcceso").val(idTarjetaAcceso);
            $("#ctnDireccionesTarjetaAcceso").html(opc);
        }
    }, 'json'); 
});

/* ------------------------------- */

$(document).on('click', '.datos-elemento-demo', function(e) {
    $('#btnEjecutarElementoDemo').addClass("d-none");
    var idElementoDemo = $(this).data('id');
    var accion = $(this).data('accion');
    
    $('#txtSKUElementoDemo_i').attr("disabled","disabled");
    $('#txtNombreElementoDemo_i').attr("disabled","disabled");
    $('#txtObservacionElementoDemo_i').attr("disabled","disabled");
    $('#txtPrecioReposicionElementoDemo_i').attr("disabled","disabled");
    
    $('#txtSKUElementoDemo_i').val("");
    $('#txtNombreElementoDemo_i').val("");
    $('#txtObservacionElementoDemo_i').val("");
    $('#txtPrecioReposicionElementoDemo_i').val("");
        
    if(accion == 'crear')
    {
        $('#exampleinformacionElementoDemo').text("Registrar elemento demo");
        $('#formInformacionElementoDemo').attr('action', baseUrl + '/registrar-elemento-demo');
        $('#btnEjecutarElementoDemo').removeClass("d-none");
        $('#btnEjecutarElementoDemo').html('<i class="mdi mdi-content-save"></i> Guardar');

        $('#txtSKUElementoDemo_i').removeAttr("disabled");
        $('#txtNombreElementoDemo_i').removeAttr("disabled");
        $('#txtObservacionElementoDemo_i').removeAttr("disabled");
        $('#txtPrecioReposicionElementoDemo_i').removeAttr("disabled");
        
        $('#txtSKUElementoDemo_i').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-elemento-demo', 
        {         
            idElementoDemo : idElementoDemo
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionElementoDemo').text("Información del elemento de demo");
                    $('#btnEjecutarElementoDemo').addClass("d-none");
                    $('#formInformacionElementoDemo').attr('action', '');

                    $('#txtSKUElementoDemo_i').attr("disabled","disabled");
                    $('#txtNombreElementoDemo_i').attr("disabled","disabled");
                    $('#txtObservacionElementoDemo_i').attr("disabled","disabled");
                    $('#txtPrecioReposicionElementoDemo_i').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionElementoDemo').text("Actualizar elemento de demo");
                    $('#formInformacionElementoDemo').attr('action', baseUrl + '/actualizar-elemento-demo/' + idElementoDemo);
                    $('#btnEjecutarElementoDemo').removeClass("d-none");

                    $('#txtSKUElementoDemo_i').removeAttr("disabled");
                    $('#txtNombreElementoDemo_i').removeAttr("disabled");
                    $('#txtObservacionElementoDemo_i').removeAttr("disabled");
                    $('#txtPrecioReposicionElementoDemo_i').removeAttr("disabled");
                }

                $('#txtIDElementoDemo_i').val(response.idelementodemo);
                $('#txtSKUElementoDemo_i').val(response.sku);
                $('#txtNombreElementoDemo_i').val(response.detalle);
                $('#txtObservacionElementoDemo_i').val(response.observacion);
                $('#txtPrecioReposicionElementoDemo_i').val(response.precio);
            }
        }, 'json'); 
    }
});

/* ------------------------------- */
$(document).on('click', '.cambiar-estado-elemento-demo', function() {
    var idElementoDemo = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' el elemento seleccionado?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            
            var motivo = result.value;
            
            var parametros = {
                "idElementoDemo"    : idElementoDemo,
                "estado"            : estado,
                "motivo"            : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-elemento-demo',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
    
});
/* ------------------------------- */
function agregarElementoDemoKit(){
    var idElementoDemo = $("#cboElementoDemoKit").val();
    
    if(idElementoDemo == '')
    {
        Swal.fire({
            html: 'Debe seleccionar un ELEMENTO para agregarlo al formulario.',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else
        {
        var parametros = {
            "idElementoDemo"  : idElementoDemo
    	};
    
        $.ajax({
            url: baseUrl + '/obtener-nuevo-item-kit-demo',
            type: "POST",
            data: parametros,
            beforeSend: function() {
                Swal.fire({
                    html: 'Un momento por favor...',
                    heightAuto: true,
                    showConfirmButton: false
                });
            },
            success: function(response) {
                Swal.close();
                $('#ctnNuevosElementosKitDemo').append(response);
            }, 
            error: function(jqXHR, textStatus, errorThrown){
                //$.unblockUI({});
                Swal.close();
                alert('Ha ocurrido un error interno.');
                console.log(jqXHR );
                console.log(textStatus);
                console.log(errorThrown);
            }
        });
    }
};
/* ------------------------------- */

// $(document).on('click', '#btnNuevoKitDemo', function(e) {
    
//     var formulario = $(this).data('bs-target');
    
//     $(formulario + ' input[type=text]').val("");
//     $("#ctnNuevosElementosKitDemo").empty();
    
//     $.ajax({        
//         url: baseUrl + '/listado-nuevos-item-kit-demo',
//         type: "POST",
//         success: function(response) {
//             console.log(response);
//             $('#ctnNuevosElementosKitDemo').html(response);
//         }, 
//         error: function(jqXHR, textStatus, errorThrown){
//             //$.unblockUI({});
//             Swal.close();
//             alert('Ha ocurrido un error interno.');
//             console.log(jqXHR );
//             console.log(textStatus);
//             console.log(errorThrown);
//         }
//     });
// });

/* ------------------------------- */

$(document).on('click', '#btnNuevoKitDemo', function(e) {
    
    var formulario = $(this).data('bs-target');
    
    $(formulario + ' input[type=text]').val("");
    selectElementoDemo('cboElementoDemoKit', '', formulario.substring(1));
    $("#ctnNuevosElementosKitDemo").empty();
    
});

/* ------------------------------- */

$(document).on('click', '.datos-item-demo', function(e) {
    $('#btnEjecutarItemKitDemo').addClass("d-none");
    var idItemKitDemo = $(this).data('id');
    var accion = $(this).data('accion');
    var formulario = $(this).data('bs-target');
    //var formulario=$(this).closest('form').attr("id");
    
    $(formulario + ' input[type=text]').attr("disabled","disabled");
    $(formulario + ' input[type=date]').attr("disabled","disabled");
    $(formulario + ' textarea').attr("disabled","disabled");
    
    $(formulario + ' input[type=text]').val("");
    $(formulario + ' input[type=date]').val("");
    $(formulario + ' textarea').val("");
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
            
    if(accion == 'crear')
    {
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-item-kit-demo', 
        {         
            idItemKitDemo : idItemKitDemo
        }, 
        function(response) {
            Swal.close();
            if (response.descripcion === 0) {
                Swal.fire({
                    title: 'No se encontró la información solicitada',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionItemDemo').text("Ver información del item de kit demo");
                    $('#btnEjecutarItemKitDemo').addClass("d-none");
                    $('#formInformacionItemDemo').attr('action', '');

                    $(formulario + ' input[type=text]').attr("disabled","disabled");
                    $(formulario + ' input[type=date]').attr("disabled","disabled");
                    $(formulario + ' textarea').attr("disabled","disabled");
    
                }
                else
                {
                    $('#exampleinformacionItemDemo').text("Actualizar item de kit demo");
                    $('#formInformacionItemDemo').attr('action', baseUrl + '/actualizar-item-kit-demo/' + idItemKitDemo);
                    $('#btnEjecutarItemKitDemo').removeClass("d-none");

                    $(formulario + ' input[type=text]').removeAttr("disabled");
                    $(formulario + ' input[type=date]').removeAttr("disabled");
                    $(formulario + ' textarea').removeAttr("disabled");
                    
                    $('#txtSKUItemDemo_i').attr("disabled","disabled");
                    $('#txtNombreItemDemo_i').attr("disabled","disabled");
                }

                $('#txtIDItemKitDemo_i').val(response.iditemkitdemo);
                $('#txtCodigoKitDemo_i').val(response.codigo);
                $('#txtSKUItemDemo_i').val(response.sku);
                $('#txtNombreItemDemo_i').val(response.elemento);
                $('#txtSerieItemDemo_i').val(response.serie);
                $('#txtFechaCompraItemDemo_i').val(response.fechacompra);
                $('#txtDetalleItemDemo_i').val(response.detalle);
            }
        }, 'json'); 
    }
});

/* ------------------------------- */

$(document).on('change', '#txtUsuarioAsignacionURES', function() {
    var idUsuario = $(this).val();
    
    if(idUsuario != '')
    {
        var parametros = {
            "idUsuario"  : idUsuario
    	};
    	
        $.ajax({        
            url: baseUrl + '/obtener-datos-usuario',
            type: "POST",
            data: parametros,
            dataType: 'json',
            beforeSend: function() {
                Swal.fire({
                    html: 'Un momento por favor...',
                    heightAuto: true,
                    showConfirmButton: false
                });
            },
            success: function(response) {
                Swal.close();
                if (response.descripcion === 0 || response.descripcion === 2) 
                {
                    Swal.fire({
                        title: response.mensaje,
                        icon: 'warning',
                        showCancelButton: false,
                        confirmButtonColor: '#282E38',
                        confirmButtonText: 'Confirmar'
                    });
                    $('#txtUsuarioAsignacionURES').val('').trigger('change');
                    $('#txtNombreAsignadoURES').val('');
                    $('#txtApellidoAsignadoURES').val('');
                    $('#txtDocumentoAsignadoURES').val('');
                    $('#txtDireccionAsignadoURES').val('');
                    $('#txtAreaAsignadoURES').val('');
                    $('#txtCargoAsignadoURES').val('');
                }
                else 
                {
                    $('#txtNombreAsignadoURES').val(response.nombres);
                    $('#txtApellidoAsignadoURES').val(response.apellidos);
                    $('#txtDocumentoAsignadoURES').val(response.documento);
                    $('#txtDireccionAsignadoURES').val(response.direccion);
                    $('#txtAreaAsignadoURES').val(response.area);
                    $('#txtCargoAsignadoURES').val(response.cargo);
                }
                
                $('.validarNextTab').blur();
            }, 
            error: function(jqXHR, textStatus, errorThrown){
                //$.unblockUI({});
                Swal.close();
                // alert('Ha ocurrido un error interno.');
                // console.log(jqXHR );
                // console.log(textStatus);
                // console.log(errorThrown);
                Swal.fire({
                    title: 'Ha ocurrido un error interno',
                    text: errorThrown,
                    icon: 'error',
                    showCancelButton: false,
                    confirmButtonColor: '#E4002B',
                    confirmButtonText: 'Confirmar'
                });
            }
        });
    }
});

/* ------------------------------- */

$(document).on('change', '#txtTipoAsignacionURES', function(event) 
{
    $('.validarNextTab').blur();
});

/* ------------------------------- */

$(document).on('blur', '.validarNextTab', function(event) 
{
    var completo = true;
    
    $('.validarNextTab').each(function() {
        var valor = $(this).val(); // Obtener el texto del elemento
        if(valor == '')
        {
            completo = false;
        }
    });
    
    if($('#txtTipoAsignacionURES').val()=='' || $('#txtUsuarioAsignacionURES').val()=='')
    {
        completo = false;
    }
    
    
    if(completo)
    {
        $('#btnNextTabIngresarElementosAsignacion').removeAttr("disabled");
    }
    else
    {
        $('#btnNextTabIngresarElementosAsignacion').attr("disabled","disabled");
    }
});

/* ------------------------------- */

$(document).on('click', '#btnNuevaAsignacionURES', function(e) {
    
    var formulario = $(this).data('bs-target');
    
    $(formulario + ' #txtTipoAsignacionURES').val("");
    $(formulario + ' #txtObservacionAsignacionURES').val("");
    $(formulario + ' #txtUsuarioAsignacionURES').val("");
    $(formulario + ' #txtNombreAsignadoURES').val("");
    $(formulario + ' #txtApellidoAsignadoURES').val("");
    $(formulario + ' #txtDocumentoAsignadoURES').val("");
    $(formulario + ' #txtDireccionAsignadoURES').val("");
    $(formulario + ' #txtAreaAsignadoURES').val("");
    $(formulario + ' #txtCargoAsignadoURES').val("");
    
    $(formulario + ' #ctnElementosAsignacion').empty();
});

/* ------------------------------- */

function agregarItemAsignacion()
{
    var tipoElemento = $("#txtElementoNuevaAsignacion2").val();
    var itemElemento = $("#txtItem2").val();
    
    if(tipoElemento == '')
    {
        Swal.fire({
            html: 'Debe seleccionar el elemento a asignar',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else if(itemElemento == '')
    {
        Swal.fire({
            html: 'Debe seleccionar el item a asignar',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else
    {
        var parametros = {
            "tipoElemento" : tipoElemento,
            "itemElemento" : itemElemento
    	};
    	
        $.ajax({        
            url: baseUrl + '/obtener-elemento-a-asignar',
            type: "POST",
            data: parametros,
            beforeSend: function() {
                Swal.fire({
                    html: 'Un momento por favor...',
                    heightAuto: true,
                    showConfirmButton: false
                });
            },
            success: function(response) {
                Swal.close();
                $('#ctnElementosAsignacion').append(response);
            }, 
            error: function(jqXHR, textStatus, errorThrown){
                
                Swal.close();
                
                Swal.fire({
                    title: 'Ha ocurrido un error interno',
                    text: errorThrown,
                    icon: 'error',
                    showCancelButton: false,
                    confirmButtonColor: '#E4002B',
                    confirmButtonText: 'Confirmar'
                });
            }
        });
    }
}
