<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb_alias ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $breadcrumb_alias ?></h5>
                            <div class="d-flex">
								<?php
								if (in_array("CSVTAC", $permisos)) 
								{
								?>
								<button class="btn btn-success d-flex align-items-center mx-1" data-bs-toggle="modal" data-bs-target="#subirCSVTarjetaAcceso">
									<i class="mdi mdi-file-upload" style="font-size: 18px;"></i> Subir CSV
								</button>
								<?php
								}

								if (in_array("ADDTAC", $permisos)) 
								{
								?>
                                <button class="btn btn-primary d-flex align-items-center mx-1 datos-tarjeta-acceso" data-bs-toggle="modal" data-bs-target="#informacionTarjetaAcceso" data-id="0" data-accion="crear" id="crear-tarjeta-acceso">
									<i class="mdi mdi-plus-circle" style="font-size: 18px;"></i> Agregar
								</button>
								<?php
								}
								?>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblTarjetasAcceso" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								<thead>
									<tr>
										<th class="text-center align-middle">Código</th>
										<th class="text-center align-middle">Serie</th>
										<th class="text-center align-middle">Precio</th>
										<th class="text-center align-middle">Observación</th>
										<th class="text-center align-middle">Estado</th>
										<th class="text-center align-middle">Asignado</th>
										<th class="text-center align-middle">Acciones</th>
									</tr>
								</thead>
								<tbody>
									<?php 
									foreach($listaTarjetasAcceso as $items){ ?>
									<tr>
										<td class="text-center align-middle"><?= $items['IDTarjetaAcceso'] ?></td>
										<td class="text-center align-middle"><?= $items['Serie'] ?></td>
										<td class="text-center align-middle"><?= $items['PrecioCompra'] ?></td>
										<td class="text-center align-middle"><?= $items['Observacion'] ?></td>
										<td class="text-center align-middle">
										<?php
											if($items['Estado'] == 'A')
											{
											?>
											<span class="badge bg-success border-0">ACTIVO</span>
											<?php
											}
											else
											{
											?>
											<span class="badge bg-danger border-0">BAJA</span>
											<?php
											}
											?>
										</td>
										<td class="text-center align-middle">
											<?php
											if($items['UsuarioAsignado'] != '--')
											{
											?>
											<span class="badge <?= $items['EstadoAsignado'] == 'Activo' ? 'bg-light text-dark' : 'bg-danger color-white' ?> border-0"><?= $items['UsuarioAsignado'] ?></span>
											<?php
											}
											else
											{
											?>
											No asignado
											<?php
											}
											?>
										</td>
										<td class="text-center align-middle">
											<div class="dropdown d-inline-block">
												<button class="btn btn-soft-secondary btn-sm dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">
													<i class="ri-more-fill align-middle"></i>
												</button>
												<ul class="dropdown-menu dropdown-menu-end">
													<li>
														<a href="#!" class="dropdown-item datos-tarjeta-acceso" data-bs-toggle="modal" data-bs-target="#informacionTarjetaAcceso" data-id="<?= $items['IDTarjetaAcceso'] ?>" data-accion="ver" id="ver-tarjeta-acceso">
															<i class="ri-eye-fill align-bottom me-2 text-muted"></i> Ver
														</a>
													</li>
													<?php
													if (in_array("UPDTAC", $permisos)) 
													{
													?>
													<li>
														<a href="#!" class="dropdown-item edit-item-btn datos-tarjeta-acceso" data-bs-toggle="modal" data-bs-target="#informacionTarjetaAcceso" data-id="<?= $items['IDTarjetaAcceso'] ?>" data-accion="editar" id="editar-tarjeta-acceso">
															<i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Editar
														</a>
													</li>
													<?php
													}
													
													if (in_array("ADDITA", $permisos)) 
													{
													?>
													<li>
														<a class='dropdown-item edit-item-btn' style='cursor: pointer;' data-bs-toggle='modal' data-bs-target='#editarDireccionesTarjetaAcceso' data-id='<?= $items['IDTarjetaAcceso'] ?>' id='editar-direcciones-tarjeta-acceso'>
															<i class="mdi mdi-sign-direction align-bottom me-2 text-muted"></i> Direcciones
														</a>
													</li>
													<?php
													}
													
													if (in_array("ADUBTA", $permisos)) 
													{
													?>
													<li>
														<a href="<?= $baseUrl ?>/listar-ubicaciones-tarjeta-acceso/<?= $items['IDTarjetaAcceso'] ?>" class="dropdown-item">
															<i class="mdi mdi-access-point align-bottom me-2 text-muted"></i> Ubicaciones
														</a>
													</li>
													<?php
													}
													?>
												</ul>
											</div>
										</td>
									</tr>
									<?php } ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->
<!-- Modal Información Tarjeta de Acceso -->
<div class="modal fade" id="informacionTarjetaAcceso" tabindex="-1" role="dialog" aria-labelledby="exampleinformacionTarjetaAcceso" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleinformacionTarjetaAcceso">Agregar Tarjeta de Acceso</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formulario" id="formInformacionTarjetaAcceso" autocomplete="off" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" id="txtIDTarjetaAcceso_i" name="txtIDTarjetaAcceso_i">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtSerieTarjetaAcceso_i" class="form-label">Serie</label>
                            <div class="input-group">
                                <input type="number" class="form-control" aria-label="Serie" id="txtSerieTarjetaAcceso_i" name="txtSerieTarjetaAcceso_i">
                            </div>
                        </div>
						<div class="col-xxl-12 col-md-12 col-12 px-3">
							<div>
								<label for="txtPrecioCompra_i" class="form-label">Precio Compra</label>
								<input type="number" class="form-control" step="0.01" id="txtPrecioCompra_i" name="txtPrecioCompra_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtObservacionTarjetaAcceso_i" class="form-label">Observación</label>
								<textarea class="form-control" id="txtObservacionTarjetaAcceso_i" name="txtObservacionTarjetaAcceso_i" rows="3"></textarea>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" id="btnEjecutarTarjetaAcceso" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<!-- Modal Subir CSV -->
<div class="modal fade bd-example-modal-lg" id="subirCSVTarjetaAcceso" role="dialog" aria-labelledby="examplesubirCSVTarjetaAcceso" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="examplesubirCSVTarjetaAcceso">Subir CSV de Tarjetas de Acceso</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formulario" id="formSubirCSVTarjetasAcceso" autocomplete="off" action="<?= $baseUrl ?>/subir-csv-tarjeta-acceso" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
					<div class="col-12 mb-3">
						<h4>Consideraciones:</h4>
						<p>1.- Los valores de monedas deben ser enteros (no 3,999 para indicar 3999) y solo usar punto(.) para separar enteros de decimales (3999.99).</p>
						<p>2.- Evitar espacios en blanco al inicio y al final del campo</p>
						<p>3.- Información de columna [4TO XXX]: ACCESOS DE SEDE GERENS - 4TO PISO. Colocar 1 si la tarjeta tiene acceso a esa ubicación o dejar vacío si no lo tiene.</p>
						<p>4.- Información de columna [5TO XXX]: ACCESOS DE SEDE GERENS - 5TO PISO. Colocar 1 si la tarjeta tiene acceso a esa ubicación o dejar vacío si no lo tiene.</p>
						<p>5.- Información de columna [JP XXX]: ACCESOS DE SEDE JAVIER PRADO. Colocar 1 si la tarjeta tiene acceso a esa ubicación o dejar vacío si no lo tiene.</p>
					</div>
					<div class="col-12 mb-3 d-flex justify-content-end">
						
							<a class='btn btn-success border-0 texto-indicador' style="color: #FFF" href='<?= base_url().'/public/docs/Plantillas/plantilla csv tarjeta acceso.csv' ?>' download='Plantilla CSV Tarjeta Acceso'>Descargar Plantilla</a>
						
					</div>
					<div class="mb-3">
						<label for="fileCSVTarjetaAcceso" class="form-label">Seleccione CSV:</label>
						<input class="form-control" type="file" id="fileCSVTarjetaAcceso" name="fileCSVTarjetaAcceso">
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<!-- end main content-->
<!-- Modal Direcciones Tarjeta Usuario -->
<div class="modal fade" id="editarDireccionesTarjetaAcceso" tabindex="-1" role="dialog" aria-labelledby="exampleEditarDireccionesTarjetaAcceso" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleEditarDireccionesTarjetaAcceso">Editar Direcciones</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formEditarDireccionesTarjetaAcceso" class="formulario" autocomplete="off" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body d-flex justify-content-center">
					<input type="hidden" id="txtIDTarjetaAcceso" name="txtIDTarjetaAcceso">
					<div class="card text-dark col-10 bg-info" style="border: 1px solid #299CDB;">
						<div class="card-header" style="background-color: transparent; color: #FFF;">Direcciones</div>
						<div class="card-body" style="background-color: #FFF;" id="ctnDireccionesTarjetaAcceso">
							
					
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<!-- end main content-->
<?php $this->endSection(); ?>