<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb_alias ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1" id="lblSubtitulo"><?= $subtitulo ?></h5>
                            <div>
                                <?php
                                if(in_array("INFDES", $permisos))
                                {
                                ?>
                                <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#gestionInformacionDescuento" id="btnGestionDescuentoMensual">
									<i class="mdi mdi-swap-vertical-bold"></i> Información
								</button>
								<?php
                                }
								?>
                                <button class="btn btn-info" data-bs-toggle="modal" data-bs-target="#filtrosDescuentoMensual" id="btnFiltrosDescuentoMensual">
									<i class="mdi mdi-filter"></i> Filtrar
								</button>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblDescuentosMensual" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								<thead>
									<tr>
										<th class="text-center align-middle">Matrícula</th>
										<th class="text-center align-middle">Usuario</th>
										<th class="text-center align-middle">Periodo</th>
										<th class="text-center align-middle">Elemento</th>
										<th class="text-center align-middle">Monto Descuento Total</th>
										<th class="text-center align-middle">Cuotas</th>
										<th class="text-center align-middle">¿Cobrado?</th>
										<th class="text-center align-middle">Monto Cobrado</th>
										<th class="text-center align-middle">Fecha Cobro</th>
										<th class="text-center align-middle">Observación Cobro</th>
									</tr>
								</thead>
								<tbody>
									<?php 
									foreach($listadoMensual as $items){ ?>
									<tr>
										<td class="text-center align-middle"><?= $items['MatriculaUsuario'] ?></td>
										<td class="text-center align-middle"><?= $items['NombreUsuario'] ?></td>
										<td class="text-center align-middle"><?= $items['Periodo'] ?></td>
										<td class="text-center align-middle"><?= $items['Elemento'] ?></td>
										<td class="text-center align-middle">S/ <?= $items['TotalTrabajador'] ?></td>
										<td class="text-center align-middle"><?= $items['TotalCuotas'] ?></td>
										<td class="text-center align-middle">
											<?php
											if($items['Cobrado']=="Y")
											{
											?>
											<span class="badge bg-success border-0">SI</span>
											<?php
											}
											else
											{
											?>
											<span class="badge bg-danger border-0">NO</span>
											<?php
											}
											?>
										</td>
										<td class="text-center align-middle"><?= $items['MontoCobro'] != '' && $items['MontoCobro'] != null ? "S/ ".$items['MontoCobro'] : '<span class="badge bg-light border-0 text-dark">Sin información</span>' ?></td>
										<td class="text-center align-middle"><?= $items['FechaCobro'] != '' && $items['FechaCobro'] != null ? date("d-m-Y", strtotime($items['FechaCobro'])) : '<span class="badge bg-light border-0 text-dark">Sin información</span>' ?></td>
										<td class="text-center align-middle"><?= $items['ObservacionCobro'] != '' && $items['ObservacionCobro'] != null ? $items['ObservacionCobro'] : '<span class="badge bg-light border-0 text-dark">Sin información</span>' ?></td>
									</tr>
									<?php } ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->
<!-- Modal Filtro Descuento Mensual -->
<div class="modal fade" id="filtrosDescuentoMensual" tabindex="-1" role="dialog" aria-labelledby="examplefiltrosDescuentoMensual" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="examplefiltrosDescuentoMensual">Filtros de descuento mensual</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
				<div class="col-xxl-12 col-md-6 col-12 mb-3">
					<label for="txtMesDescuento" class="form-label">Mes</label>
					<select class="form-select" aria-label="Mes" id="txtMesDescuento" name="txtMesDescuento">
						<option value="01" <?= date("m") == '01' ? 'selected' : '' ?> >ENERO</option>
						<option value="02" <?= date("m") == '02' ? 'selected' : '' ?> >FEBRERO</option>
						<option value="03" <?= date("m") == '03' ? 'selected' : '' ?> >MARZO</option>
						<option value="04" <?= date("m") == '04' ? 'selected' : '' ?> >ABRIL</option>
						<option value="05" <?= date("m") == '05' ? 'selected' : '' ?> >MAYO</option>
						<option value="06" <?= date("m") == '06' ? 'selected' : '' ?> >JUNIO</option>
						<option value="07" <?= date("m") == '07' ? 'selected' : '' ?> >JULIO</option>
						<option value="08" <?= date("m") == '08' ? 'selected' : '' ?>  <?= date("m") == '01' ? 'selected' : '' ?> >AGOSTO</option>
						<option value="09" <?= date("m") == '09' ? 'selected' : '' ?> >SETIEMBRE</option>
						<option value="10" <?= date("m") == '10' ? 'selected' : '' ?> >OCTUBRE</option>
						<option value="11" <?= date("m") == '11' ? 'selected' : '' ?> >NOVIEMBRE</option>
						<option value="12" <?= date("m") == '12' ? 'selected' : '' ?> >DICIEMBRE</option>
					</select>
				</div>
				<div class="col-xxl-12 col-md-6 col-12 mb-3">
					<label for="txtAnioDescuento" class="form-label">Año</label>
					<select class="form-select" aria-label="Año" id="txtAnioDescuento" name="txtAnioDescuento">
					    <?php
					    $anioInicial = "2024";
					    $anioActual = date("Y");
					    for($i = $anioInicial; $i <= ($anioActual + 2); $i++)
					    {
					    ?>
					    <option value="<?= $i ?>" <?= $i == $anioActual ? 'selected' : '' ?> ><?= $i ?></option>
					    <?php
					    }
					    ?>
					</select>
				</div>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
				<button type="button" class="btn btn-success" onclick="return recargarTablaDescuentoMensual()"><i class="mdi mdi-filter"></i> Filtrar</button>
			</div>
		</div>
	</div>
</div>
<?php
if(in_array("INFDES", $permisos))
{
?>
<!-- Modal Gestión información -->
<div class="modal fade" id="gestionInformacionDescuento" tabindex="-1" role="dialog" aria-labelledby="examplegestionInformacionDescuento" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="examplegestionInformacionDescuento">Gestión de Información de descuento</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
				<div class="card-group">
                    <div class="card text-white bg-success">
                        <div class="card-header text-center d-flex justify-content-center align-items-center" style="background-color: transparent;">
                            <span class="mdi mdi-file-export-outline" style="font-size: 18px;"></span> Exportar
                        </div>
                        <div class="card-body text-black text-center" style="background-color: #FFF;">
                          <p class="card-text">Si desea descargar el CSV de la información del periodo filtrado, presione el botón inferior.<br><span class="mdi mdi-hand-pointing-down" style="font-size: 25px;"></span></p>
                        </div>
                        <div class="card-footer d-flex justify-content-center align-items-center" style="background-color: transparent;">
                            <label class="btn btn-warning m-0" onclick="return descargarDescuentosMensualPendiente();">Descargar</label>
                        </div>
                    </div>
                    <div class="card text-white bg-info">
                        <div class="card-header text-center d-flex justify-content-center align-items-center" style="background-color: transparent;">
                            <span class="mdi mdi-file-import-outline" style="font-size: 18px;"></span> Importar
                        </div>
                        <div class="card-body text-black text-center" style="background-color: #FFF;">
                          <p class="card-text">Si desea importar el CSV con la información del cobro realizado, presione el botón inferior.<br><span class="mdi mdi-hand-pointing-down" style="font-size: 25px;"></span></p>
                        </div>
                        <div class="card-footer d-flex justify-content-center align-items-center" style="background-color: transparent;">
                            <div class='m-0'>
                                <span class='btnFile_01'>
                                    <input type='file' class='btnFile' id='btnFile_01' name='txtImportarDescuentoCobrado' accept=".csv">
                                </span>
                                <label class='btn btn-warning m-0' for='btnFile_01'>Adjuntar</label>
                            </div>
                        </div>
                    </div>
                </div>
			</div>
		</div>
	</div>
</div>
<?php
}
?>
<?php $this->endSection(); ?>