<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb_alias ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $breadcrumb_alias ?></h5>
                            <div>
                                <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#agregarSeguro">
									<i class="mdi mdi-plus-circle"></i> Agregar Seguro
								</button>
								<a href="<?= $baseUrl.'/'.$previo ?>" class="btn px-2 py-0" style="border-radius: 45%; background-color: red;"><i class="mdi mdi-arrow-left-circle" style="font-size: 24px; color: #FFF"></i></a>
                            </div>
                        </div>
						<div class="card-body">
							<table id="example" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								<thead>
									<tr>
										<!--<th scope="col" style="width: 10px;">
											<div class="form-check">
												<input class="form-check-input fs-15" type="checkbox" id="checkAll" value="option">
											</div>
										</th>-->
										<th class="text-center align-middle">Código</th>
										<th class="text-center align-middle">Nro Seguro</th>
										<th class="text-center align-middle">Servicio</th>
										<th class="text-center align-middle">Plan</th>
										<th class="text-center align-middle">Costo</th>
										<th class="text-center align-middle">Inicio Contrato</th>
										<th class="text-center align-middle">Móviles Adquiridos</th>
										<th class="text-center align-middle">Estado</th>
										<th class="text-center align-middle">Acciones</th>
									</tr>
								</thead>
								<tbody>
									<?php 
									foreach($listaSeguros as $items){ ?>
									<tr>
										<td class="text-center align-middle"><?= $items['IDSeguro'] ?></td>
										<td class="text-center align-middle"><?= $items['NroSeguro'] ?></td>
										<td class="text-center align-middle"><?= $items['Servicio'] ?></td>
										<td class="text-center align-middle"><?= $items['Plan'] ?></td>
										<td class="text-center align-middle"><?= $items['CostoPlan'] ?></td>
										<td class="text-center align-middle"><?= date("d-m-Y", strtotime($items['InicioContrato'])) ?></td>
										<td class="text-center align-middle">
											<div class="float-right">
												<a href="<?= $baseUrl ?>/listado_moviles_seguro/<?= $items['IDSeguro'] ?>" class="px-2 py-2" style="border-radius: 45%; color: white; background-color: blue;"><?= $items['Total_asegurados'] < 10 ? '0'.$items['Total_asegurados'] : $items['Total_asegurados'] ?></a>
											</div>
										</td>
										<td class="text-center align-middle">
											
										</td>
										<td class="text-center align-middle">
											<div class="dropdown d-inline-block">
												<button class="btn btn-soft-secondary btn-sm dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">
													<i class="ri-more-fill align-middle"></i>
												</button>
												<ul class="dropdown-menu dropdown-menu-end">
													<li>
														<a href="#!" class="dropdown-item datos-seguro" data-bs-toggle="modal" data-bs-target="#informacionSeguro" data-id="<?= $items['IDSeguro'] ?>" data-accion="ver" id="ver-seguro">
															<i class="ri-eye-fill align-bottom me-2 text-muted"></i> Ver
														</a>
													</li>
													<li>
														<a href="#!" class="dropdown-item edit-item-btn datos-seguro" data-bs-toggle="modal" data-bs-target="#informacionSeguro" data-id="<?= $items['IDSeguro'] ?>" data-accion="editar" id="editar-seguro">
															<i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Editar
														</a>
													</li>
												</ul>
											</div>
										</td>
									</tr>
									<?php } ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->
<!-- Modal Añadir Seguro -->
<div class="modal fade" id="agregarSeguro" tabindex="-1" role="dialog" aria-labelledby="exampleagregarSeguro" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleagregarSeguro">Agregar Seguro</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formulario" autocomplete="off" action="<?= $baseUrl ?>/grabar-seguro" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" name="txtIdLinea" id="txtIdLinea" value="<?= $linea['IDLinea'] ?>">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtNumSeguro" class="form-label">Nro Seguro</label>
                            <div class="input-group">
                                <input type="text" class="form-control" aria-label="Número de seguro" id="txtNumSeguro" name="txtNumSeguro">
                            </div>
                        </div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtServicio" class="form-label">Servicio</label>
                            <div class="input-group">
                                <input type="text" class="form-control" aria-label="Servicio" id="txtServicio" name="txtServicio">
                            </div>
                        </div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtPlan" class="form-label">Plan</label>
                            <div class="input-group">
                                <input type="text" class="form-control" aria-label="Plan" id="txtPlan" name="txtPlan">
                            </div>
                        </div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtCostoPlan" class="form-label">Costo Plan</label>
                            <div class="input-group">
                                <input type="text" class="form-control" aria-label="Costo Plan" id="txtCostoPlan" name="txtCostoPlan">
                            </div>
                        </div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtInicioContrato" class="form-label">Inicio Contrato</label>
                            <div class="input-group">
                                <input type="date" class="form-control" aria-label="Inicio de contrato" id="txtInicioContrato" name="txtInicioContrato">
                            </div>
                        </div>
						<div class="col-xxl-12 col-md-6 col-12 mb-3">
							<label for="txtEstado" class="form-label">Estado</label>
                            <select class="form-select" aria-label="Estado" id="txtEstado" name="txtEstado">
                                <option selected="" value="">Seleccione una opción</option>
								<option value="ACTIVO">ACTIVO</option>
                                <option value="SUSPENDIDO">SUSPENDIDO</option>
                                <option value="BAJA">BAJA</option>
                            </select>
                        </div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Modal Información Seguro -->
<div class="modal fade" id="informacionSeguro" tabindex="-1" role="dialog" aria-labelledby="exampleinformacionSeguro" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleinformacionSeguro">Información Seguro</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formInformacionSeguro" class="formulario" autocomplete="off" action="" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" name="txtIdSeguro" id="txtIdSeguro" value="">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtNumSeguro_i" class="form-label">Nro Seguro</label>
                            <div class="input-group">
                                <input type="text" class="form-control" aria-label="Número de seguro" id="txtNumSeguro_i" name="txtNumSeguro_i">
                            </div>
                        </div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtServicio_i" class="form-label">Servicio</label>
                            <div class="input-group">
                                <input type="text" class="form-control" aria-label="Servicio" id="txtServicio_i" name="txtServicio_i">
                            </div>
                        </div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtPlan_i" class="form-label">Plan</label>
                            <div class="input-group">
                                <input type="text" class="form-control" aria-label="Plan" id="txtPlan_i" name="txtPlan_i">
                            </div>
                        </div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtCostoPlan_i" class="form-label">Costo Plan</label>
                            <div class="input-group">
                                <input type="text" class="form-control" aria-label="Costo Plan" id="txtCostoPlan_i" name="txtCostoPlan_i">
                            </div>
                        </div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtInicioContrato_i" class="form-label">Inicio Contrato</label>
                            <div class="input-group">
                                <input type="date" class="form-control" aria-label="Inicio de contrato" id="txtInicioContrato_i" name="txtInicioContrato_i">
                            </div>
                        </div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" id="btnEjecutarSeguro" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<?php $this->endSection(); ?>